/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise;

import com.sun.enterprise.repository.Configuration;
import com.sun.enterprise.repository.ConfigurationImpl;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.enterprise.repository.J2EEResourceFactory;
import com.sun.enterprise.util.Utility;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerConfiguration {
    private static Logger _logger = null;
    public static final String JNDI_NAME = "ServerConfiguration";
    private static final boolean debug = false;
    private static ServerConfiguration serverconfig;
    private Configuration config;
    private boolean remote = true;

    public static ServerConfiguration getConfiguration() {
        if (serverconfig == null) {
            serverconfig = new ServerConfiguration();
        }
        return serverconfig;
    }

    public static J2EEResourceFactory getJ2EEResourceFactory() {
        return new IASJ2EEResourceFactoryImpl();
    }

    private ServerConfiguration() {
        try {
            this.config = (Configuration)Utility.lookupObject(JNDI_NAME, Configuration.class);
        }
        catch (Exception exception) {
            try {
                this.config = new ConfigurationImpl();
                this.remote = false;
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String string) {
        String string2 = null;
        try {
            string2 = this.config.getProperty(string);
            return string2;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.getpropertry_exception", exception);
        }
        finally {
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String string, String string2) {
        String string3 = string2;
        try {
            string3 = this.config.getProperty(string);
            return string3;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.getpropertry_exception", exception);
        }
        finally {
            if (string3 != null) {
                return string3;
            }
            return string2;
        }
    }

    public void setProperty(String string, String string2) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot set properties n local mode");
            }
            this.config.setProperty(string, string2);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.setpropertry_exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string) {
        Object object = null;
        try {
            object = this.config.getObject(string);
            return object;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.getobject_exception", exception);
        }
        finally {
            return object;
        }
    }

    public void setObject(String string, Object object) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot set objects in local mode");
            }
            this.config.setObject(string, object);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.setobject_exception", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getKeys(String string) {
        String[] stringArray = null;
        try {
            stringArray = this.config.getKeys(string);
            return stringArray;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.getkey_exception", exception);
        }
        finally {
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String string) {
        Properties properties = new Properties();
        try {
            String[] stringArray = this.config.getKeys(string);
            for (int i = 0; i < stringArray.length; ++i) {
                properties.put(stringArray[i], this.getProperty(stringArray[i]));
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.get_put_key_exception", exception);
        }
        finally {
            return properties;
        }
    }

    public void removeProperty(String string) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot remove properties in local mode");
            }
            this.config.removeProperty(string);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.remove_property_exception", exception);
        }
    }

    public void removeObject(String string) {
        try {
            if (!this.remote) {
                throw new IllegalStateException("Cannot remove objects in local mode");
            }
            this.config.removeObject(string);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise.remove_object_exception", exception);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise");
        serverconfig = null;
    }
}

