/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.sun.ejb.sqlgen.DBMetaData;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Enumeration;
import java.util.Hashtable;

public final class SQLTypeMapper {
    private static final boolean debug = false;
    private Hashtable jdbcTypeTable = new Hashtable();
    private Hashtable sqlTypeTable;
    private Hashtable oracleTypeTable = new Hashtable();
    private Hashtable mssqlserverTypeTable = new Hashtable();
    private Hashtable cloudscapeTypeTable = new Hashtable();

    public SQLTypeMapper() {
        this.primeJDBCTypeTable();
        this.primeDBTypeTables();
    }

    String initializeMapping(DBMetaData dBMetaData) throws SQLException {
        Object object;
        String string = dBMetaData.dbName;
        String string2 = string.toLowerCase();
        if (string2.indexOf("oracle") != -1) {
            this.sqlTypeTable = this.oracleTypeTable;
        } else if (string2.indexOf("microsoft") != -1) {
            this.sqlTypeTable = this.mssqlserverTypeTable;
        } else if (string2.indexOf("cloudscape") != -1) {
            this.sqlTypeTable = this.cloudscapeTypeTable;
        } else {
            this.sqlTypeTable = dBMetaData.typeMapping;
            object = new Integer(12);
            String string3 = (String)this.sqlTypeTable.get(object);
            string3 = string3 + "(255)";
            this.sqlTypeTable.put(object, string3);
            object = new Integer(1);
            String string4 = (String)this.sqlTypeTable.get(object);
            string4 = string4 + "(4)";
            this.sqlTypeTable.put(object, string4);
            object = new Integer(2);
            String string5 = (String)this.sqlTypeTable.get(object);
            if (string5 == null || string5.equals("")) {
                string5 = "NUMERIC";
            }
            string5 = string5 + "(15,5)";
            this.sqlTypeTable.put(object, string5);
            object = new Integer(-5);
            String string6 = (String)this.sqlTypeTable.get(object);
            if (string6 == null || string6.equals("")) {
                string6 = "NUMERIC";
            }
            string6 = string6 + "(22,0)";
            this.sqlTypeTable.put(object, string6);
        }
        object = "Generating SQL for database: " + dBMetaData.dbName;
        return object;
    }

    public int getJDBCTypeFor(Class clazz) throws IllegalArgumentException {
        Integer n = (Integer)this.jdbcTypeTable.get(clazz);
        if (n != null) {
            return n;
        }
        return 2000;
    }

    public String getSQLTypeFor(Class clazz) throws IllegalArgumentException {
        int n = this.getJDBCTypeFor(clazz);
        String string = (String)this.sqlTypeTable.get(new Integer(n));
        if (string == null) {
            String string2 = "No SQL type found for Class " + clazz;
            throw new IllegalArgumentException(string2);
        }
        return string;
    }

    private void primeJDBCTypeTable() {
        this.jdbcTypeTable.put(String.class, new Integer(12));
        this.jdbcTypeTable.put(BigDecimal.class, new Integer(2));
        this.jdbcTypeTable.put(Boolean.class, new Integer(-7));
        this.jdbcTypeTable.put(Boolean.TYPE, new Integer(-7));
        this.jdbcTypeTable.put(Byte.class, new Integer(-6));
        this.jdbcTypeTable.put(Byte.TYPE, new Integer(-6));
        this.jdbcTypeTable.put(Character.class, new Integer(1));
        this.jdbcTypeTable.put(Character.TYPE, new Integer(1));
        this.jdbcTypeTable.put(Short.class, new Integer(5));
        this.jdbcTypeTable.put(Short.TYPE, new Integer(5));
        this.jdbcTypeTable.put(Integer.class, new Integer(4));
        this.jdbcTypeTable.put(Integer.TYPE, new Integer(4));
        this.jdbcTypeTable.put(Long.class, new Integer(-5));
        this.jdbcTypeTable.put(Long.TYPE, new Integer(-5));
        this.jdbcTypeTable.put(Float.class, new Integer(7));
        this.jdbcTypeTable.put(Float.TYPE, new Integer(7));
        this.jdbcTypeTable.put(Double.class, new Integer(8));
        this.jdbcTypeTable.put(Double.TYPE, new Integer(8));
        this.jdbcTypeTable.put([B.class, new Integer(-4));
        this.jdbcTypeTable.put(Date.class, new Integer(91));
        this.jdbcTypeTable.put(Time.class, new Integer(92));
        this.jdbcTypeTable.put(Timestamp.class, new Integer(93));
    }

    private void primeDBTypeTables() {
        this.oracleTypeTable.put(new Integer(12), "VARCHAR(255)");
        this.oracleTypeTable.put(new Integer(2), "NUMERIC(15,5)");
        this.oracleTypeTable.put(new Integer(-7), "SMALLINT");
        this.oracleTypeTable.put(new Integer(-6), "SMALLINT");
        this.oracleTypeTable.put(new Integer(1), "CHAR(4)");
        this.oracleTypeTable.put(new Integer(5), "SMALLINT");
        this.oracleTypeTable.put(new Integer(4), "INTEGER");
        this.oracleTypeTable.put(new Integer(-5), "NUMERIC(22,0)");
        this.oracleTypeTable.put(new Integer(7), "REAL");
        this.oracleTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        this.oracleTypeTable.put(new Integer(-4), "LONG RAW");
        this.oracleTypeTable.put(new Integer(91), "DATE");
        this.oracleTypeTable.put(new Integer(92), "TIME");
        this.oracleTypeTable.put(new Integer(93), "TIME");
        this.oracleTypeTable.put(new Integer(2000), "LONG RAW");
        this.mssqlserverTypeTable.put(new Integer(12), "VARCHAR(255)");
        this.mssqlserverTypeTable.put(new Integer(2), "NUMERIC(15,5)");
        this.mssqlserverTypeTable.put(new Integer(-7), "BIT");
        this.mssqlserverTypeTable.put(new Integer(-6), "TINYINT");
        this.mssqlserverTypeTable.put(new Integer(1), "CHAR(4)");
        this.mssqlserverTypeTable.put(new Integer(5), "SMALLINT");
        this.mssqlserverTypeTable.put(new Integer(4), "INTEGER");
        this.mssqlserverTypeTable.put(new Integer(-5), "NUMERIC(22,0)");
        this.mssqlserverTypeTable.put(new Integer(7), "REAL");
        this.mssqlserverTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        this.mssqlserverTypeTable.put(new Integer(-4), "IMAGE");
        this.mssqlserverTypeTable.put(new Integer(91), "DATETIME");
        this.mssqlserverTypeTable.put(new Integer(92), "DATETIME");
        this.mssqlserverTypeTable.put(new Integer(93), "DATETIME");
        this.mssqlserverTypeTable.put(new Integer(2000), "IMAGE");
        this.cloudscapeTypeTable.put(new Integer(12), "VARCHAR(255)");
        this.cloudscapeTypeTable.put(new Integer(2), "DECIMAL(15,5)");
        this.cloudscapeTypeTable.put(new Integer(-7), "BOOLEAN");
        this.cloudscapeTypeTable.put(new Integer(-6), "TINYINT");
        this.cloudscapeTypeTable.put(new Integer(1), "CHAR(4)");
        this.cloudscapeTypeTable.put(new Integer(5), "SMALLINT");
        this.cloudscapeTypeTable.put(new Integer(4), "INTEGER");
        this.cloudscapeTypeTable.put(new Integer(-5), "LONGINT");
        this.cloudscapeTypeTable.put(new Integer(7), "REAL");
        this.cloudscapeTypeTable.put(new Integer(8), "DOUBLE PRECISION");
        this.cloudscapeTypeTable.put(new Integer(-4), "LONG BIT VARYING");
        this.cloudscapeTypeTable.put(new Integer(91), "DATE");
        this.cloudscapeTypeTable.put(new Integer(92), "TIME");
        this.cloudscapeTypeTable.put(new Integer(93), "TIMESTAMP");
        this.cloudscapeTypeTable.put(new Integer(2000), "LONG BIT VARYING");
    }

    private void printTypeInfo() {
        try {
            Object object;
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            Field[] fieldArray = Types.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                object = fieldArray[i];
                hashtable.put(new Integer(((Field)object).getInt(null)), ((Field)object).getName());
            }
            System.err.println("Java type,\tSQL type");
            Enumeration enumeration = this.sqlTypeTable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                String string = (String)hashtable.get(object);
                String string2 = (String)this.sqlTypeTable.get(object);
                System.err.println(string + "\t" + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

