/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.sqlgen;

import com.sun.ejb.PMDeployer;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.ejbql.EjbQLDriver;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.sqlgen.DBInfo;
import com.sun.ejb.sqlgen.DBMetaData;
import com.sun.ejb.sqlgen.SQLTypeMapper;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.QueryDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.EJBException;

public final class SQLGenerator {
    private static final boolean debug = false;
    private PersistenceDescriptor pers;
    private String tableName;
    private String[] pkeyFieldNames;
    private String[] contMgFieldNames;
    private String[] contMgNoPkeyFieldNames;
    private String whereClause;
    private String createTableQuery;
    private String deleteTableQuery;
    private String loadRowQuery;
    private String storeRowQuery;
    private String createRowQuery;
    private String deleteRowQuery;
    private String findByPrimaryKeyQuery;
    private String findBySourceKeyQuery;
    private String findBySinkKeyQuery;
    private String nonPrimaryKeyFinderQuery;
    private Hashtable findQueryTable = new Hashtable();
    private SQLTypeMapper typeMapper;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SQLGenerator.class);
    private boolean isMSSqlServer = false;

    private SQLGenerator(PersistenceDescriptor persistenceDescriptor, String string, SQLTypeMapper sQLTypeMapper, DBMetaData dBMetaData) {
        String string2;
        int n;
        this.pers = persistenceDescriptor;
        this.typeMapper = sQLTypeMapper;
        PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getNonPkeyPersFieldInfo();
        PersistentFieldInfo[] persistentFieldInfoArray3 = persistenceDescriptor.getPkeyFieldInfo();
        String string3 = "Table";
        int n2 = dBMetaData.maxTableNameLength - 2;
        int n3 = dBMetaData.maxColumnNameLength - 2;
        if (dBMetaData.dbName.toLowerCase().indexOf("microsoft") != -1) {
            this.isMSSqlServer = true;
        }
        String string4 = string;
        String string5 = string4.substring(string4.lastIndexOf(".") + 1);
        this.tableName = string5 + string3;
        if (this.tableName.length() > n2) {
            this.tableName = this.tableName.substring(0, n2);
        }
        this.tableName = "\"" + this.tableName + "\"";
        persistenceDescriptor.setTableName(this.tableName);
        String[] stringArray = new String[persistentFieldInfoArray.length];
        for (n = 0; n < persistentFieldInfoArray.length; ++n) {
            string2 = persistentFieldInfoArray[n].name;
            if (string2.length() > n3) {
                Log.err.println(localStrings.getLocalString("ejb.sqlgen.fieldnamewillbetruncatedtomaxchars", "Warning: field name {0} will be truncated to {1} characters to get column name.", new Object[]{string2, new Integer(n3)}));
                string2 = string2.substring(0, n3);
            }
            stringArray[n] = string2 = "\"" + string2 + "\"";
            persistentFieldInfoArray[n].columnName = string2;
        }
        this.contMgFieldNames = stringArray;
        stringArray = new String[persistentFieldInfoArray2.length];
        for (n = 0; n < persistentFieldInfoArray2.length; ++n) {
            string2 = persistentFieldInfoArray2[n].name;
            if (string2.length() > n3) {
                string2 = string2.substring(0, n3);
            }
            stringArray[n] = string2 = "\"" + string2 + "\"";
            persistentFieldInfoArray2[n].columnName = string2;
        }
        this.contMgNoPkeyFieldNames = stringArray;
        stringArray = new String[persistentFieldInfoArray3.length];
        for (n = 0; n < persistentFieldInfoArray3.length; ++n) {
            string2 = persistentFieldInfoArray3[n].name;
            if (string2.length() > n3) {
                string2 = string2.substring(0, n3);
            }
            stringArray[n] = string2 = "\"" + string2 + "\"";
            persistentFieldInfoArray3[n].columnName = string2;
        }
        this.pkeyFieldNames = stringArray;
        try {
            this.generateWhereClause();
            this.generateCreateTableQuery();
            this.generateDeleteTableQuery();
            this.generateLoadRowQuery();
            this.generateStoreRowQuery();
            this.generateCreateRowQuery();
            this.generateDeleteRowQuery();
            this.generateFindByPrimaryKeyQuery();
            this.generateNonPrimaryKeyFinderQuery();
            if (persistenceDescriptor.getParentDescriptor() instanceof JoinObjectDescriptor) {
                this.generateFindBySourceSinkKeyQuery();
            }
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    public static void generateSQL(EjbBundleDescriptor ejbBundleDescriptor, ResourceReferenceDescriptor resourceReferenceDescriptor, boolean bl, DBInfo dBInfo) throws Exception {
        Object[] objectArray = ejbBundleDescriptor.getEjbs().toArray();
        boolean bl2 = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EjbCMPEntityDescriptor)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        if (resourceReferenceDescriptor == null || resourceReferenceDescriptor.getResourcePrincipal() == null) {
            throw new RuntimeException("No database specified for CMP EntityBeans' persistent state");
        }
        ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
        DBMetaData dBMetaData = dBInfo.getDBMetaData(resourceReferenceDescriptor.getJndiName(), resourcePrincipal.getName(), resourcePrincipal.getPassword());
        SQLTypeMapper sQLTypeMapper = new SQLTypeMapper();
        sQLTypeMapper.initializeMapping(dBMetaData);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EjbCMPEntityDescriptor)) continue;
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)objectArray[i];
            SQLGenerator.generateSQL(ejbCMPEntityDescriptor, bl, dBMetaData, sQLTypeMapper);
        }
        EjbQLDriver ejbQLDriver = new EjbQLDriver(ejbBundleDescriptor);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof EjbCMPEntityDescriptor)) continue;
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)objectArray[i];
            SQLGenerator.generateSQLForEjbQLQueries(ejbCMPEntityDescriptor.getPersistenceDescriptor(), ejbQLDriver);
        }
    }

    private static void generateSQL(EjbCMPEntityDescriptor ejbCMPEntityDescriptor, boolean bl, DBMetaData dBMetaData, SQLTypeMapper sQLTypeMapper) throws Exception {
        PersistenceDescriptor persistenceDescriptor = ejbCMPEntityDescriptor.getPersistenceDescriptor();
        String string = ejbCMPEntityDescriptor.getEjbClassName();
        EjbBundleDescriptor ejbBundleDescriptor = persistenceDescriptor.getEjbBundleDescriptor();
        PersistenceUtils.getPMDeployer(ejbBundleDescriptor).addForeignKeyFields(persistenceDescriptor);
        SQLGenerator sQLGenerator = new SQLGenerator(persistenceDescriptor, string, sQLTypeMapper, dBMetaData);
        sQLGenerator.storeIntoDescriptor(bl);
        SQLGenerator.generateJoinObjectSQL(persistenceDescriptor, sQLTypeMapper, dBMetaData, bl);
    }

    private static void generateJoinObjectSQL(PersistenceDescriptor persistenceDescriptor, SQLTypeMapper sQLTypeMapper, DBMetaData dBMetaData, boolean bl) {
        EjbBundleDescriptor ejbBundleDescriptor = persistenceDescriptor.getEjbBundleDescriptor();
        PMDeployer pMDeployer = PersistenceUtils.getPMDeployer(ejbBundleDescriptor);
        Vector vector = pMDeployer.addJoinObjectDescriptors(persistenceDescriptor);
        for (int i = 0; i < vector.size(); ++i) {
            JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)vector.elementAt(i);
            PersistenceDescriptor persistenceDescriptor2 = joinObjectDescriptor.getPersistenceDescriptor();
            SQLGenerator sQLGenerator = new SQLGenerator(persistenceDescriptor2, joinObjectDescriptor.getJoinObjectClass(), sQLTypeMapper, dBMetaData);
            sQLGenerator.storeIntoDescriptor(bl);
        }
    }

    private void storeIntoDescriptor(boolean bl) {
        Object object;
        Object object2;
        Iterator iterator = this.pers.getAllSqlStatementedMethods().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = this.pers.getSqlStatementFor((String)object2);
            if (!bl && object != null && !((String)object).equals("")) continue;
            if (((String)object2).equals("createRow")) {
                this.pers.setSqlStatementFor((String)object2, this.createRowQuery);
                continue;
            }
            if (((String)object2).equals("deleteRow")) {
                this.pers.setSqlStatementFor((String)object2, this.deleteRowQuery);
                continue;
            }
            if (((String)object2).equals("storeRow")) {
                this.pers.setSqlStatementFor((String)object2, this.storeRowQuery);
                continue;
            }
            if (((String)object2).equals("loadRow")) {
                this.pers.setSqlStatementFor((String)object2, this.loadRowQuery);
                continue;
            }
            if (((String)object2).equals("findByPrimaryKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findByPrimaryKeyQuery);
                continue;
            }
            if (((String)object2).equals("findBySourceKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findBySourceKeyQuery);
                continue;
            }
            if (((String)object2).equals("findBySinkKey")) {
                this.pers.setSqlStatementFor((String)object2, this.findBySinkKeyQuery);
                continue;
            }
            if (((String)object2).startsWith("createTable")) {
                this.pers.setSqlStatementFor((String)object2, this.createTableQuery);
                continue;
            }
            if (!((String)object2).startsWith("deleteTable")) continue;
            this.pers.setSqlStatementFor((String)object2, this.deleteTableQuery);
        }
        object2 = this.pers.getAllPossibleQueriedMethods().iterator();
        while (object2.hasNext()) {
            object = (Method)object2.next();
            QueryDescriptor queryDescriptor = this.pers.getQueryFor((Method)object);
            if (queryDescriptor == null) {
                queryDescriptor = new QueryDescriptor();
                queryDescriptor.setQueryMethod((Method)object);
                this.pers.setQueryFor((Method)object, queryDescriptor);
            }
            if (queryDescriptor.getIsEjbQl() || !bl && queryDescriptor.getSQL() != null && !queryDescriptor.getSQL().equals("")) continue;
            queryDescriptor.setSQL(this.nonPrimaryKeyFinderQuery);
        }
    }

    private void printQueries() {
        System.err.println("findByPrimaryKey query: " + this.findByPrimaryKeyQuery);
        System.err.println("loadRowQuery query: " + this.loadRowQuery);
        System.err.println("storeRowQuery query: " + this.storeRowQuery);
        System.err.println("deleteRowQuery query: " + this.deleteRowQuery);
        System.err.println("createRowQuery query: " + this.createRowQuery);
        System.err.println("Table Create query: " + this.createTableQuery);
        System.err.println("Table Remove query: " + this.deleteTableQuery);
        if (this.pers.getParentDescriptor() instanceof JoinObjectDescriptor) {
            System.err.println("findBySourceKey query: " + this.findBySourceKeyQuery);
            System.err.println("findBySinkKey query: " + this.findBySinkKeyQuery);
        }
    }

    private void generateWhereClause() {
        String string = " WHERE ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                string = string + " AND ";
            }
            string = string + this.pkeyFieldNames[i] + " = ? ";
        }
        this.whereClause = string;
    }

    private void generateCreateTableQuery() {
        String string = "CREATE TABLE " + this.tableName + " (";
        for (int i = 0; i < this.contMgFieldNames.length; ++i) {
            int n;
            if (i > 0) {
                string = string + " , ";
            }
            Class clazz = this.pers.getPersistentFieldInfo()[i].type;
            String string2 = this.typeMapper.getSQLTypeFor(clazz);
            string = string + this.contMgFieldNames[i] + " " + string2;
            if (clazz.isPrimitive()) {
                string = string + " NOT NULL";
                continue;
            }
            if (!this.isMSSqlServer || this.isPkeyField(this.contMgFieldNames[i]) || (n = this.typeMapper.getJDBCTypeFor(clazz)) == -7) continue;
            string = string + " NULL";
        }
        String string3 = "\"pk_" + this.tableName.substring(1, this.tableName.length() - 2) + "\"";
        string = string + ", CONSTRAINT " + string3 + " PRIMARY KEY (";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                string = string + " , ";
            }
            string = string + this.pkeyFieldNames[i];
        }
        this.createTableQuery = string = string + ") )";
    }

    private boolean isPkeyField(String string) {
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (!this.pkeyFieldNames[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void generateDeleteTableQuery() {
        this.deleteTableQuery = "DROP TABLE " + this.tableName;
    }

    private void generateNonPrimaryKeyFinderQuery() {
        this.nonPrimaryKeyFinderQuery = "SELECT ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " , ";
            }
            this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + this.pkeyFieldNames[i];
        }
        this.nonPrimaryKeyFinderQuery = this.nonPrimaryKeyFinderQuery + " FROM " + this.tableName;
    }

    private void generateFindByPrimaryKeyQuery() {
        this.findByPrimaryKeyQuery = "SELECT ";
        for (int i = 0; i < this.pkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " , ";
            }
            this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + this.pkeyFieldNames[i];
        }
        this.findByPrimaryKeyQuery = this.findByPrimaryKeyQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateFindBySourceSinkKeyQuery() {
        int n;
        JoinObjectDescriptor joinObjectDescriptor = (JoinObjectDescriptor)this.pers.getParentDescriptor();
        RelationshipDescriptor relationshipDescriptor = joinObjectDescriptor.getRelationshipDesc();
        RelationRoleDescriptor relationRoleDescriptor = relationshipDescriptor.getSource();
        RelationRoleDescriptor relationRoleDescriptor2 = relationshipDescriptor.getSink();
        PersistenceDescriptor persistenceDescriptor = relationRoleDescriptor.getPersistenceDescriptor();
        PersistenceDescriptor persistenceDescriptor2 = relationRoleDescriptor2.getPersistenceDescriptor();
        PersistentFieldInfo[] persistentFieldInfoArray = this.pers.getPersistentFieldInfo();
        this.findBySourceKeyQuery = "SELECT ";
        this.findBySinkKeyQuery = "SELECT ";
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < persistentFieldInfoArray.length; ++n) {
            if (persistentFieldInfoArray[n].relatedObj == persistenceDescriptor2) {
                if (n2 > 0) {
                    this.findBySourceKeyQuery = this.findBySourceKeyQuery + " , ";
                }
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + persistentFieldInfoArray[n].columnName;
                ++n2;
                continue;
            }
            if (n3 > 0) {
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + " , ";
            }
            this.findBySinkKeyQuery = this.findBySinkKeyQuery + persistentFieldInfoArray[n].columnName;
            ++n3;
        }
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " FROM " + this.tableName;
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " FROM " + this.tableName;
        n2 = 0;
        n3 = 0;
        this.findBySourceKeyQuery = this.findBySourceKeyQuery + " WHERE ";
        this.findBySinkKeyQuery = this.findBySinkKeyQuery + " WHERE ";
        for (n = 0; n < persistentFieldInfoArray.length; ++n) {
            if (persistentFieldInfoArray[n].relatedObj == persistenceDescriptor2) {
                if (n3 > 0) {
                    this.findBySinkKeyQuery = this.findBySinkKeyQuery + " AND ";
                }
                this.findBySinkKeyQuery = this.findBySinkKeyQuery + persistentFieldInfoArray[n].columnName + " = ? ";
                ++n3;
                continue;
            }
            if (n2 > 0) {
                this.findBySourceKeyQuery = this.findBySourceKeyQuery + " AND ";
            }
            this.findBySourceKeyQuery = this.findBySourceKeyQuery + persistentFieldInfoArray[n].columnName + " = ? ";
            ++n2;
        }
    }

    private void generateLoadRowQuery() {
        this.loadRowQuery = "SELECT ";
        for (int i = 0; i < this.contMgNoPkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.loadRowQuery = this.loadRowQuery + " , ";
            }
            this.loadRowQuery = this.loadRowQuery + this.contMgNoPkeyFieldNames[i];
        }
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.loadRowQuery = this.loadRowQuery + " * ";
        }
        this.loadRowQuery = this.loadRowQuery + " FROM " + this.tableName + this.whereClause;
    }

    private void generateStoreRowQuery() {
        if (this.contMgNoPkeyFieldNames.length == 0) {
            this.storeRowQuery = " ";
            return;
        }
        this.storeRowQuery = "UPDATE " + this.tableName + " SET ";
        for (int i = 0; i < this.contMgNoPkeyFieldNames.length; ++i) {
            if (i > 0) {
                this.storeRowQuery = this.storeRowQuery + " , ";
            }
            this.storeRowQuery = this.storeRowQuery + this.contMgNoPkeyFieldNames[i] + " = ? ";
        }
        this.storeRowQuery = this.storeRowQuery + this.whereClause;
    }

    private void generateCreateRowQuery() {
        int n;
        String string = "INSERT INTO " + this.tableName + " ( ";
        for (n = 0; n < this.contMgFieldNames.length; ++n) {
            if (n > 0) {
                string = string + " , ";
            }
            string = string + this.contMgFieldNames[n];
        }
        string = string + " ) VALUES ( ";
        for (n = 0; n < this.contMgFieldNames.length; ++n) {
            if (n > 0) {
                string = string + " , ";
            }
            string = string + " ? ";
        }
        this.createRowQuery = string = string + " )";
    }

    private void generateDeleteRowQuery() {
        this.deleteRowQuery = "DELETE FROM " + this.tableName + this.whereClause;
    }

    private static void generateSQLForEjbQLQueries(PersistenceDescriptor persistenceDescriptor, EjbQLDriver ejbQLDriver) throws Exception {
        Set set = persistenceDescriptor.getQueriedMethods();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            QueryDescriptor queryDescriptor = persistenceDescriptor.getQueryFor(method);
            if (!queryDescriptor.getIsEjbQl()) continue;
            String string = queryDescriptor.getQuery();
            EjbQLQuery ejbQLQuery = ejbQLDriver.parse(persistenceDescriptor, method, string);
            String string2 = ejbQLDriver.generateSql(ejbQLQuery);
            System.out.println("Generated sql = " + string2);
            queryDescriptor.setSQL(string2);
        }
    }
}

