/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi;

import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.AvailabilityService;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.EjbModule;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.spi.CheckpointPolicy;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.CheckpointDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class CheckpointPolicyImpl
implements CheckpointPolicy {
    private static boolean serverAvailabilityEnabled = false;
    private static boolean ejbContainerAvailabilityEnabled = false;
    private static String fileStore = null;
    private Set checkpointedMethodList = new HashSet();
    private StatefulSessionContainer sfsbContainer = null;
    private static Server sBean = null;
    private static EjbContainer ecBean = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private StatefulSessionContainer container = null;
    private EjbDescriptor ejbDescriptor = null;
    private ClassLoader loader = null;
    private boolean isCheckpointEnabled = false;

    public void initializeCheckpointPolicy(StatefulSessionContainer statefulSessionContainer) {
        int n;
        Serializable serializable;
        if (!ejbContainerAvailabilityEnabled) {
            this.isCheckpointEnabled = false;
            return;
        }
        this.container = statefulSessionContainer;
        this.ejbDescriptor = statefulSessionContainer.getEjbDescriptor();
        this.loader = statefulSessionContainer.getClassLoader();
        Class clazz = statefulSessionContainer.getLocalInterfaceClass();
        Class clazz2 = statefulSessionContainer.getRemoteInterfaceClass();
        Class clazz3 = statefulSessionContainer.getLocalHomeInterfaceClass();
        Class clazz4 = statefulSessionContainer.getRemoteHomeInterfaceClass();
        Application application = this.ejbDescriptor.getApplication();
        String string = application.getRegistrationName();
        _logger.finest("AppName = " + string);
        boolean bl = application.isVirtual();
        _logger.finest("isModule = " + bl);
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        Server server = null;
        Object var12_12 = null;
        try {
            server = (Server)configContext.getRootConfigBean();
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        Applications applications = server.getApplications();
        J2eeApplication[] j2eeApplicationArray = null;
        EjbModule[] ejbModuleArray = null;
        String string2 = null;
        String string3 = null;
        if (bl) {
            ejbModuleArray = applications.getEjbModule();
            serializable = null;
            for (n = 0; n < ejbModuleArray.length; ++n) {
                if (!ejbModuleArray[n].getName().equals(string)) continue;
                serializable = ejbModuleArray[n];
                _logger.finest("Matched module : " + ejbModuleArray[n].getName());
                break;
            }
            if (serializable != null) {
                string2 = ((EjbModule)serializable).getAvailabilityEnabled();
                _logger.finest("moduleAvailabilityEnabled = " + string2);
            }
            this.isCheckpointEnabled = string2 == null || string2.equals("") || string2.equals("null") ? ejbContainerAvailabilityEnabled : ejbContainerAvailabilityEnabled && new Boolean(string2) != false;
        } else {
            j2eeApplicationArray = applications.getJ2eeApplication();
            serializable = null;
            for (n = 0; n < j2eeApplicationArray.length; ++n) {
                if (!j2eeApplicationArray[n].getName().equals(string)) continue;
                serializable = j2eeApplicationArray[n];
                _logger.finest("Matched app : " + j2eeApplicationArray[n].getName());
                break;
            }
            if (serializable != null) {
                string3 = ((J2eeApplication)serializable).getAvailabilityEnabled();
                _logger.finest("j2eeAppAvailabilityEnabled = " + string3);
            }
            if (string3 == null || string3.equals("") || string3.equals("null")) {
                this.isCheckpointEnabled = ejbContainerAvailabilityEnabled;
            } else {
                boolean bl2 = this.isCheckpointEnabled = ejbContainerAvailabilityEnabled && new Boolean(string3) != false;
            }
        }
        if (!this.isCheckpointEnabled) {
            _logger.finest("Returning isCheckpointEnabled from .......1 " + this.isCheckpointEnabled);
            return;
        }
        serializable = this.ejbDescriptor.getEjbBundleDescriptor();
        String string4 = this.ejbDescriptor.getName();
        _logger.finest("ejbDescriptor.getName() +++++ " + string4);
        CheckpointDescriptor checkpointDescriptor = ((EjbBundleDescriptor)serializable).getCheckpointDescriptor(string4);
        String string5 = null;
        String string6 = null;
        if (checkpointDescriptor != null) {
            _logger.finest("ebd.getCheckpointedMethods +++++ " + checkpointDescriptor.checkpointedMethods);
            string5 = checkpointDescriptor.availabilityEnabled;
            _logger.finest("ejbAvailabilityEnabled = " + string5);
            string6 = checkpointDescriptor.checkpointedMethods;
        }
        if (string5 != null && !string5.equals("")) {
            boolean bl3 = this.isCheckpointEnabled = this.isCheckpointEnabled && new Boolean(string5) != false;
        }
        if (!this.isCheckpointEnabled) {
            _logger.finest("Returning isCheckpointEnabled from .......2 " + this.isCheckpointEnabled);
            return;
        }
        if (string6 != null && string6.length() != 0) {
            this.parseCheckpointedMethods(string6, clazz, clazz2, clazz3, clazz4, this.loader);
        }
    }

    private void parseCheckpointedMethods(String string, Class clazz, Class clazz2, Class clazz3, Class clazz4, ClassLoader classLoader) {
        if (string == null || string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        StringTokenizer stringTokenizer2 = null;
        while (stringTokenizer.hasMoreElements()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(40);
            int n2 = string2.indexOf(41);
            if (n == -1 && n2 != -1 || n != -1 && n2 == -1) {
                _logger.info("Malformed string in list of checkpointed methods : " + string2 + ". Method not enabled for checkpointing");
                return;
            }
            String string3 = null;
            String string4 = null;
            if (n == -1 && n2 == -1) {
                string3 = string2.trim();
                string4 = "";
            } else {
                string3 = string2.substring(0, n).trim();
                string4 = string2.substring(n + 1, n2);
            }
            _logger.finest("methodName = " + string3);
            _logger.finest("params = " + string4);
            stringTokenizer2 = new StringTokenizer(string4, ",");
            Class[] classArray = new Class[stringTokenizer2.countTokens()];
            int n3 = 0;
            Class<?> clazz5 = null;
            while (stringTokenizer2.hasMoreElements()) {
                object = null;
                try {
                    object = stringTokenizer2.nextToken().trim();
                    _logger.finest("paramClassName = " + (String)object);
                    clazz5 = this.resolvePrimitiveType((String)object);
                    if (clazz5 == null) {
                        String string5 = this.transformClassName((String)object);
                        _logger.finest("transformedClassName ============= " + string5);
                        if (string5 == null) {
                            _logger.info("Malformed string in list of checkpointed methods : " + string2 + ". Method not enabled for checkpointing");
                            break;
                        }
                        clazz5 = classLoader.loadClass(string5);
                    }
                    classArray[n3++] = clazz5;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    _logger.info("Unable to load class : " + (String)object + " while initializing checkpointing strategy. Method " + string2 + " not enabled for checkpointing");
                    break;
                }
            }
            stringTokenizer2 = null;
            object = null;
            boolean bl = false;
            _logger.finest("CREATE METHOD +++++++++ ");
            try {
                if (clazz3 != null) {
                    object = clazz3.getMethod(string3, classArray);
                }
                if (object != null) {
                    _logger.finest("LOCAL CREATE METHOD +++++++++ ");
                    this.checkpointedMethodList.add(object);
                    _logger.finest("aMethod = " + ((Method)object).toString());
                    object = null;
                    bl = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                if (clazz4 != null) {
                    object = clazz4.getMethod(string3, classArray);
                }
                if (object != null) {
                    _logger.finest("REMOTE CREATE METHOD +++++++++ ");
                    this.checkpointedMethodList.add(object);
                    _logger.finest("aMethod = " + ((Method)object).toString());
                    object = null;
                    bl = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            _logger.finest("BUSINESS METHOD +++++++++ ");
            try {
                if (clazz2 != null) {
                    object = clazz2.getMethod(string3, classArray);
                }
                if (object != null) {
                    _logger.finest("REMOTE BUSINESS METHOD +++++++++ ");
                    this.checkpointedMethodList.add(object);
                    object = null;
                    bl = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                if (clazz != null) {
                    object = clazz.getMethod(string3, classArray);
                }
                if (object != null) {
                    _logger.finest("LOCAL BUSINESS METHOD +++++++++ ");
                    this.checkpointedMethodList.add(object);
                    _logger.finest("aMethod = " + ((Method)object).toString());
                    object = null;
                    bl = true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (bl) continue;
            if (string3.startsWith("create")) {
                _logger.info("Method " + string2 + " not defined in the Home interface of the Bean");
                continue;
            }
            _logger.info("Method " + string2 + " not defined in the Remote/Local interface of the Bean");
        }
    }

    private Class resolvePrimitiveType(String string) {
        _logger.finest("In resolvePrimitiveType ++++++++++ ");
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        return null;
    }

    private String transformClassName(String string) {
        _logger.finest("In transformClassName  ++++++++++ ");
        int n = string.indexOf(91);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n).replaceAll("\\s", "");
        if (!Pattern.matches("(\\[\\])+", string3)) {
            return null;
        }
        String string4 = string3.replaceAll("]", "");
        if (string2.equals("int")) {
            return string4 + "I";
        }
        if (string2.equals("long")) {
            return string4 + "J";
        }
        if (string2.equals("double")) {
            return string4 + "D";
        }
        if (string2.equals("boolean")) {
            return string4 + "Z";
        }
        if (string2.equals("char")) {
            return string4 + "C";
        }
        if (string2.equals("short")) {
            return string4 + "S";
        }
        if (string2.equals("byte")) {
            return string4 + "B";
        }
        if (string2.equals("float")) {
            return string4 + "F";
        }
        return string4 + "L" + string2 + ";";
    }

    public static boolean getServerAvailabilityEnabled(Server server) {
        AvailabilityService availabilityService = server.getAvailabilityService();
        if (availabilityService == null) {
            _logger.finest("PE / SE installation of App Server . High Availability turned off.");
            return false;
        }
        _logger.finest("asBean = " + availabilityService.toString());
        boolean bl = availabilityService.isAvailabilityEnabled();
        _logger.finest("CheckpointingPolicyImpl : AvailabilityGloballyEnabled = " + bl);
        return bl;
    }

    public static boolean getEjbContainerAvailabilityEnabled(EjbContainer ejbContainer) {
        String string = ejbContainer.getAvailabilityEnabled();
        if (string == null || string.equals("") || string.equals("null")) {
            return serverAvailabilityEnabled;
        }
        _logger.finest("CheckpointingPolicyImpl : EjbContainerAvailabilityEnabled = " + string);
        return serverAvailabilityEnabled && new Boolean(string) != false;
    }

    public void setDescriptor(EjbDescriptor ejbDescriptor) {
        this.ejbDescriptor = ejbDescriptor;
    }

    public boolean doCheckpoint(int n, Method method) {
        return false;
    }

    public boolean isCheckpointRequired() {
        return this.isCheckpointEnabled;
    }

    public boolean isCheckpointRequired(Method method) {
        _logger.finest("isCheckpointRequired called with method = " + method.toString());
        return this.isCheckpointEnabled && this.checkpointedMethodList.contains(method);
    }

    public String getSessionStore() {
        return fileStore;
    }

    static {
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        Server server = null;
        EjbContainer ejbContainer = null;
        try {
            server = (Server)configContext.getRootConfigBean();
            ejbContainer = server.getEjbContainer();
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        serverAvailabilityEnabled = CheckpointPolicyImpl.getServerAvailabilityEnabled(server);
        fileStore = server.getSessionStore();
        _logger.finest("CheckPointmpl static serverAvailabilityEnabled " + serverAvailabilityEnabled);
        ejbContainerAvailabilityEnabled = CheckpointPolicyImpl.getEjbContainerAvailabilityEnabled(ejbContainer);
    }
}

