/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.spi;

import com.iplanet.ias.web.ServerConfigLookup;
import com.iplanet.ias.web.ShutdownCleanupCapable;
import com.sun.ejb.Container;
import com.sun.ejb.containers.SimpleSFSBUUIDUtilImpl;
import com.sun.ejb.containers.util.cache.PassivatedSessionInfo;
import com.sun.ejb.spi.SFSBBeanState;
import com.sun.ejb.spi.SFSBStoreManager;
import com.sun.ejb.spi.SFSBUUIDUtil;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseSFSBStoreManager
implements SFSBStoreManager,
ShutdownCleanupCapable {
    protected Container container = null;
    protected long containerID;
    protected String clusterID = null;
    protected int idleTimeoutInSeconds;
    protected String containerId = null;
    private int removalTimeoutInSeconds = 0;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected boolean debug = false;

    public void initSessionStore(String string, long l, int n) {
        _logger.entering("BaseSFSBStoreManager", "initSessionStore", new Object[]{string, new Long(l), new Integer(n)});
        this.clusterID = string;
        this.containerID = l;
        this.idleTimeoutInSeconds = n;
        _logger.exiting("HASFSBStoreManager", "initSessionStore");
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    public SFSBUUIDUtil getUUIDUtil() {
        return new SimpleSFSBUUIDUtilImpl();
    }

    public String getContainerID() {
        EjbDescriptor ejbDescriptor = this.getContainer().getEjbDescriptor();
        EjbDescriptor ejbDescriptor2 = this.container.getEjbDescriptor();
        String string = ejbDescriptor2.getName();
        String string2 = ejbDescriptor2.getEjbBundleDescriptor().getArchivist().getArchiveUri();
        Application application = ejbDescriptor2.getEjbBundleDescriptor().getApplication();
        String string3 = null;
        if (application.isVirtual()) {
            string3 = null;
            this.containerId = string + ":" + string2;
        } else {
            string3 = application.getRegistrationName();
            this.containerId = string + ":" + string2 + ":" + string3;
        }
        return this.containerId;
    }

    public String getClusterID() {
        if (this.clusterID == null || this.clusterID.equals("")) {
            ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
            this.clusterID = serverConfigLookup.getClusterIdFromConfig();
        }
        _logger.log(Level.FINEST, "Cluster Id in BaseSFSBStoreManager.getClusterID=" + this.clusterID);
        return this.clusterID;
    }

    public void removeExpired(ArrayList arrayList) {
        _logger.log(Level.FINE, "BaseSFSBStoreManager.removeExpired   victims length " + arrayList.size());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            PassivatedSessionInfo passivatedSessionInfo = (PassivatedSessionInfo)arrayList.get(i);
            this.remove(passivatedSessionInfo.key);
            if (!_logger.isLoggable(Level.FINE)) continue;
            _logger.log(Level.FINE, " Removed  passivated session: " + passivatedSessionInfo.key);
        }
    }

    public void setRemovalTimeoutInSeconds(int n) {
        this.removalTimeoutInSeconds = n;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.removalTimeoutInSeconds;
    }

    public void removeAll() {
    }

    public void shutdown() {
    }

    public void passivateSave(SFSBBeanState sFSBBeanState, boolean bl) throws Exception {
    }

    public int doShutdownCleanup() {
        return 0;
    }

    public void doCloseCachedConnection() {
    }

    public void putConnection(Connection connection) {
    }

    public void debug(String string) {
        System.out.println(string);
    }

    public String getMonitorAttributeValues() {
        return "";
    }
}

