/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.persistence;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.PMDeployer;
import com.sun.ejb.Partition;
import com.sun.ejb.PersistenceManager;
import com.sun.ejb.PersistenceUtils;
import com.sun.ejb.PersistentInstance;
import com.sun.ejb.PersistentState;
import com.sun.ejb.persistence.JDBCUtils;
import com.sun.ejb.persistence.PMDeployerImpl;
import com.sun.ejb.persistence.PartitionImpl;
import com.sun.ejb.persistence.RelationshipManager;
import com.sun.ejb.persistence.SQLEngine;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.JoinObjectDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.ResourcePrincipal;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final boolean debug = false;
    private Hashtable partitions = new Hashtable();
    private TransactionManager tm;
    protected RelationshipManager relationshipManager;
    private SQLEngine sqlEngine;
    private Partition noTxPartition;
    private long nextLong = 0L;
    private EjbBundleDescriptor ejbBundleDescriptor;

    public PersistenceManagerImpl(EjbBundleDescriptor ejbBundleDescriptor) {
        this.ejbBundleDescriptor = ejbBundleDescriptor;
        this.relationshipManager = new RelationshipManager(this);
        PMDeployer pMDeployer = PersistenceUtils.getPMDeployer(ejbBundleDescriptor);
        this.sqlEngine = new SQLEngine(this, (PMDeployerImpl)pMDeployer);
        this.noTxPartition = new PartitionImpl(this, this.relationshipManager, null);
    }

    public synchronized long getNextLong() {
        return this.nextLong++;
    }

    public SQLEngine getSQLEngine() {
        return this.sqlEngine;
    }

    public Partition getPartition(PersistentInstance persistentInstance) {
        try {
            Transaction transaction;
            if (this.tm == null) {
                this.tm = (TransactionManager)new InitialContext().lookup("java:pm/TransactionManager");
            }
            if ((transaction = this.tm.getTransaction()) != null) {
                PartitionImpl partitionImpl = (PartitionImpl)this.partitions.get(transaction);
                if (partitionImpl == null) {
                    partitionImpl = new PartitionImpl(this, this.relationshipManager, transaction);
                    this.partitions.put(transaction, partitionImpl);
                    transaction.registerSynchronization((Synchronization)partitionImpl);
                }
                return partitionImpl;
            }
            return this.noTxPartition;
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
            return null;
        }
    }

    void releasePartition(Partition partition) {
        this.partitions.remove(partition.getTransaction());
    }

    void resetFields(final PersistentState persistentState) {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        final PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                block12: for (int i = 0; i < persistentFieldInfoArray.length; ++i) {
                    try {
                        Field field = persistentFieldInfoArray[i].field;
                        Class<?> clazz = field.getType();
                        if (clazz.isPrimitive()) {
                            switch (persistentFieldInfoArray[i].jdbcType) {
                                case -7: {
                                    field.setBoolean(persistentState, false);
                                    continue block12;
                                }
                                case -6: {
                                    field.setByte(persistentState, (byte)0);
                                    continue block12;
                                }
                                case 5: {
                                    field.setShort(persistentState, (short)0);
                                    continue block12;
                                }
                                case 1: {
                                    field.setChar(persistentState, '\u0000');
                                    continue block12;
                                }
                                case 4: {
                                    field.setInt(persistentState, 0);
                                    continue block12;
                                }
                                case -5: {
                                    field.setLong(persistentState, 0L);
                                    continue block12;
                                }
                                case 7: {
                                    field.setFloat(persistentState, 0.0f);
                                    continue block12;
                                }
                                case 8: {
                                    field.setDouble(persistentState, 0.0);
                                    continue block12;
                                }
                                default: {
                                    throw new EJBException("ERROR initializing EJB field " + field);
                                }
                            }
                        }
                        field.set(persistentState, null);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        EJBUtils.throwEJBException(illegalAccessException);
                    }
                }
                return null;
            }
        });
    }

    void beforeCompletion(Transaction transaction, Collection collection) {
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                PersistentState persistentState = (PersistentState)iterator.next();
                int n = persistentState.__getStatus();
                if (n == 1) continue;
                Object object = this.getPrimaryKey(persistentState);
                switch (n) {
                    case 2: {
                        this.createRow(persistentState, object);
                        break;
                    }
                    case 3: {
                        this.removeRow(persistentState, object);
                        break;
                    }
                    case 4: {
                        this.storeRow(persistentState, object);
                    }
                }
                persistentState.__setStatus(1);
            }
        }
        catch (EJBException eJBException) {
            try {
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void loadRow(PersistentState persistentState, Object object) throws EJBException {
        block22: {
            int n;
            Connection connection = null;
            Statement statement = null;
            PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
            String string = persistenceDescriptor.getSqlStatementFor("loadRow");
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getNonPkeyPersFieldInfo();
            PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getPkeyFieldInfo();
            Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            statement = connection.prepareStatement(string);
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray2[0].jdbcType);
            } else {
                for (int i = 0; i < fieldArray.length; ++i) {
                    JDBCUtils.copyFieldToDB((PreparedStatement)statement, i + 1, fieldArray[i], object, persistentFieldInfoArray2[i].jdbcType);
                }
            }
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                throw new NoSuchEntityException("ERROR in SQL SELECT: No database row for EJB");
            }
            for (n = 0; n < persistentFieldInfoArray.length; ++n) {
                JDBCUtils.copyFieldFromDB(resultSet, n + 1, persistentFieldInfoArray[n].field, persistentState, persistentFieldInfoArray[n].jdbcType);
            }
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                persistentFieldInfoArray2[0].field.set(persistentState, object);
            } else {
                for (n = 0; n < persistentFieldInfoArray2.length; ++n) {
                    persistentFieldInfoArray2[n].field.set(persistentState, fieldArray[n].get(object));
                }
            }
            Object var13_14 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block22;
            }
            catch (Exception exception) {}
            break block22;
            {
                catch (Exception exception) {
                    EJBUtils.throwEJBException(exception);
                    Object var13_15 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block22;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean primaryKeyExists(Object object, PersistenceDescriptor persistenceDescriptor) throws EJBException {
        boolean bl;
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                String string = persistenceDescriptor.getSqlStatementFor("findByPrimaryKey");
                connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
                statement = connection.prepareStatement(string);
                PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
                Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
                if (persistenceDescriptor.primaryKeyIsOneField()) {
                    JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray[0].jdbcType);
                } else {
                    for (int i = 0; i < fieldArray.length; ++i) {
                        JDBCUtils.copyFieldToDB((PreparedStatement)statement, i + 1, fieldArray[i], object, persistentFieldInfoArray[i].jdbcType);
                    }
                }
                ResultSet resultSet = statement.executeQuery();
                bl = resultSet.next();
                Object var11_13 = null;
            }
            catch (Exception exception) {
                EJBUtils.throwEJBException(exception);
                boolean bl2 = false;
                Object var11_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection == null) return bl2;
                    connection.close();
                    return bl2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            if (statement != null) {
                statement.close();
            }
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return bl;
        }
        if (statement != null) {
            statement.close();
        }
        if (connection == null) return bl;
        connection.close();
        return bl;
    }

    Object getPrimaryKey(PersistentState persistentState) throws EJBException {
        PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
        Descriptor descriptor = persistenceDescriptor.getParentDescriptor();
        if (descriptor instanceof JoinObjectDescriptor) {
            return persistentState;
        }
        Object object = null;
        try {
            Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                object = persistentFieldInfoArray[0].field.get(persistentState);
            } else {
                Class<?> clazz = fieldArray[0].getDeclaringClass();
                object = clazz.newInstance();
                for (int i = 0; i < fieldArray.length; ++i) {
                    Object object2 = persistentFieldInfoArray[i].field.get(persistentState);
                    if (object2 == null) {
                        return null;
                    }
                    fieldArray[i].set(object, object2);
                }
            }
        }
        catch (Exception exception) {
            EJBUtils.throwEJBException(exception);
            return null;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void removeRow(PersistentState persistentState, Object object) throws EJBException {
        block18: {
            int n;
            PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
            String string = persistenceDescriptor.getSqlStatementFor("deleteRow");
            Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement(string);
            if (persistenceDescriptor.primaryKeyIsOneField()) {
                JDBCUtils.copyObjToDB(preparedStatement, 1, object, persistentFieldInfoArray[0].jdbcType);
            } else {
                for (n = 0; n < fieldArray.length; ++n) {
                    JDBCUtils.copyFieldToDB(preparedStatement, n + 1, fieldArray[n], object, persistentFieldInfoArray[n].jdbcType);
                }
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                throw new EJBException("ERROR in removeRow!! resultCount = " + n);
            }
            Object var11_11 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block18;
            }
            catch (Exception exception) {}
            break block18;
            {
                catch (Exception exception) {
                    EJBUtils.throwEJBException(exception);
                    Object var11_12 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block18;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void storeRow(PersistentState persistentState, Object object) throws EJBException {
        block24: {
            int n;
            Object object2;
            int n2 = persistentState.__getStatus();
            PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
            Descriptor descriptor = persistenceDescriptor.getParentDescriptor();
            if (descriptor instanceof EjbCMPEntityDescriptor) {
                object2 = (EjbCMPEntityDescriptor)descriptor;
                switch (n2) {
                    case 1: {
                        if (!((EjbCMPEntityDescriptor)object2).isEJB20()) break;
                        return;
                    }
                    case 2: {
                        this.createRow(persistentState, object);
                        return;
                    }
                    case 3: {
                        throw new EJBException("Internal Error: ejbStore called for deleted bean");
                    }
                }
            }
            object2 = persistenceDescriptor.getSqlStatementFor("storeRow");
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getNonPkeyPersFieldInfo();
            PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor.getPkeyFieldInfo();
            if (persistentFieldInfoArray.length == 0) {
                return;
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement((String)object2);
            int n3 = 1;
            for (n = 0; n < persistentFieldInfoArray.length; ++n) {
                JDBCUtils.copyFieldToDB(preparedStatement, n3++, persistentFieldInfoArray[n].field, persistentState, persistentFieldInfoArray[n].jdbcType);
            }
            for (n = 0; n < persistentFieldInfoArray2.length; ++n) {
                JDBCUtils.copyFieldToDB(preparedStatement, n3++, persistentFieldInfoArray2[n].field, persistentState, persistentFieldInfoArray2[n].jdbcType);
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                throw new EJBException("ERROR in storeRow!! resultCount = " + n);
            }
            Object var14_14 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block24;
            }
            catch (Exception exception) {}
            break block24;
            {
                catch (Exception exception) {
                    EJBUtils.throwEJBException(exception);
                    Object var14_15 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block24;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HashSet loadJoinObjects(PersistentState persistentState, Object object, PersistenceDescriptor persistenceDescriptor, CMRFieldInfo cMRFieldInfo, PartitionImpl partitionImpl) throws Exception {
        Serializable serializable;
        RelationRoleDescriptor relationRoleDescriptor = cMRFieldInfo.role;
        JoinObjectDescriptor joinObjectDescriptor = relationRoleDescriptor.getRelationshipDescriptor().getJoinDescriptor();
        PersistenceDescriptor persistenceDescriptor2 = joinObjectDescriptor.getPersistenceDescriptor();
        Connection connection = null;
        Statement statement = null;
        try {
            try {
                String string = relationRoleDescriptor.getRelationshipDescriptor().getSource() == relationRoleDescriptor ? persistenceDescriptor2.getSqlStatementFor("findBySourceKey") : persistenceDescriptor2.getSqlStatementFor("findBySinkKey");
                PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPkeyFieldInfo();
                Field[] fieldArray = persistenceDescriptor.getPkeyClassFields();
                connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
                statement = connection.prepareStatement(string);
                if (persistenceDescriptor.primaryKeyIsOneField()) {
                    JDBCUtils.copyObjToDB((PreparedStatement)statement, 1, object, persistentFieldInfoArray[0].jdbcType);
                } else {
                    for (int i = 0; i < fieldArray.length; ++i) {
                        JDBCUtils.copyFieldToDB((PreparedStatement)statement, i + 1, fieldArray[i], object, persistentFieldInfoArray[i].jdbcType);
                    }
                }
                ResultSet resultSet = statement.executeQuery();
                HashSet<PersistentState> hashSet = new HashSet<PersistentState>();
                while (resultSet.next()) {
                    serializable = persistenceDescriptor2.getPersistentClass();
                    PersistentState persistentState2 = (PersistentState)((Class)serializable).newInstance();
                    persistentState2.__setPersistenceDescriptor(persistenceDescriptor2);
                    PersistentFieldInfo[] persistentFieldInfoArray2 = persistenceDescriptor2.getPersistentFieldInfo();
                    int n = 1;
                    for (int i = 0; i < persistentFieldInfoArray2.length; ++i) {
                        PersistentFieldInfo persistentFieldInfo = persistentFieldInfoArray2[i];
                        if (persistentFieldInfo.relatedObj == relationRoleDescriptor.getPersistenceDescriptor()) {
                            Object object2 = object;
                            if (!persistenceDescriptor.primaryKeyIsOneField()) {
                                Field field = object.getClass().getField(persistentFieldInfo.relatedName);
                                object2 = field.get(object);
                            }
                            persistentFieldInfo.field.set(persistentState2, object2);
                            continue;
                        }
                        JDBCUtils.copyFieldFromDB(resultSet, n++, persistentFieldInfo.field, persistentState2, persistentFieldInfo.jdbcType);
                    }
                    persistentState2.__setStatus(1);
                    PersistentState persistentState3 = partitionImpl.addJoinObject(persistentState2, joinObjectDescriptor, relationRoleDescriptor);
                    if (persistentState3 == null) continue;
                    hashSet.add(persistentState3);
                }
                serializable = hashSet;
                Object var25_28 = null;
            }
            catch (Exception exception) {
                EJBUtils.throwEJBException(exception);
                HashSet hashSet2 = null;
                Object var25_29 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection == null) return hashSet2;
                    connection.close();
                    return hashSet2;
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return hashSet2;
            }
        }
        catch (Throwable throwable) {
            Object var25_30 = null;
            try {}
            catch (Exception exception2) {
                throw throwable;
            }
            if (statement != null) {
                statement.close();
            }
            if (connection == null) throw throwable;
            connection.close();
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return serializable;
        }
        if (statement != null) {
            statement.close();
        }
        if (connection == null) return serializable;
        connection.close();
        return serializable;
    }

    static Connection getConnection(PersistenceDescriptor persistenceDescriptor) {
        return PersistenceManagerImpl.getConnection(persistenceDescriptor.getEjbBundleDescriptor());
    }

    static Connection getConnection(EjbBundleDescriptor ejbBundleDescriptor) {
        try {
            ResourceReferenceDescriptor resourceReferenceDescriptor = ejbBundleDescriptor.getCMPResourceReference();
            DataSource dataSource = null;
            if (resourceReferenceDescriptor != null) {
                dataSource = resourceReferenceDescriptor.getPMJDBCDataSource();
            }
            if (dataSource == null) {
                throw new EJBException("Unable to get JDBC DataSource for CMP EntityBean state");
            }
            ResourcePrincipal resourcePrincipal = resourceReferenceDescriptor.getResourcePrincipal();
            Connection connection = dataSource.getConnection(resourcePrincipal.getName(), resourcePrincipal.getPassword());
            return connection;
        }
        catch (SQLException sQLException) {
            throw new EJBException((Exception)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createRow(PersistentState persistentState, Object object) throws EJBException {
        block16: {
            int n;
            PersistenceDescriptor persistenceDescriptor = persistentState.__getPersistenceDescriptor();
            String string = persistenceDescriptor.getSqlStatementFor("createRow");
            PersistentFieldInfo[] persistentFieldInfoArray = persistenceDescriptor.getPersistentFieldInfo();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            connection = PersistenceManagerImpl.getConnection(persistenceDescriptor);
            preparedStatement = connection.prepareStatement(string);
            for (n = 0; n < persistentFieldInfoArray.length; ++n) {
                JDBCUtils.copyFieldToDB(preparedStatement, n + 1, persistentFieldInfoArray[n].field, persistentState, persistentFieldInfoArray[n].jdbcType);
            }
            n = preparedStatement.executeUpdate();
            if (n != 1) {
                throw new EJBException("ERROR in createRow!! resultCount = " + n);
            }
            Object var10_10 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block16;
            }
            catch (Exception exception) {}
            break block16;
            {
                catch (Exception exception) {
                    EJBUtils.throwEJBException(exception);
                    Object var10_11 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block16;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

