/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Element;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.FromClause;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.NavigationOperator;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.PrintingVisitor;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.UnaryOperator;
import com.sun.ejb.ejbql.UnaryOperatorExpression;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.ejb.ejbql.parser.ParseException;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;

public class ValidatingVisitor
extends VisitorAdapter {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ValidatingVisitor.class);
    private EjbQLQuery query_;
    private List errors_;
    private PrintingVisitor printer_;
    private boolean foundTypeError_;
    private Vector ejbAbstractSchemaClasses_;

    public ValidatingVisitor(EjbQLQuery ejbQLQuery) {
        super(1);
        this.query_ = ejbQLQuery;
        this.printer_ = new PrintingVisitor(ejbQLQuery);
        this.ejbAbstractSchemaClasses_ = new Vector();
        this.init();
    }

    private void init() {
        EjbBundleDescriptor ejbBundleDescriptor = this.query_.getEjbBundleDescriptor();
        Set set = ejbBundleDescriptor.getEjbs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EjbCMPEntityDescriptor ejbCMPEntityDescriptor;
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            if (!(ejbDescriptor instanceof EjbCMPEntityDescriptor) || !(ejbCMPEntityDescriptor = (EjbCMPEntityDescriptor)ejbDescriptor).isEJB20()) continue;
            this.ejbAbstractSchemaClasses_.add(ejbCMPEntityDescriptor.getEjbClassName());
        }
    }

    public List validate(Element element) {
        this.errors_ = new Vector();
        this.foundTypeError_ = false;
        element.accept(this);
        return this.errors_;
    }

    public void visitQuery(EjbQLQuery ejbQLQuery) {
        super.visitQuery(ejbQLQuery);
    }

    public void visitSelectClause(SelectClause selectClause) {
        Object object;
        Object object2;
        Expression expression = selectClause.getExpression();
        if (this.query_.isFinderQuery()) {
            object2 = null;
            if (expression.isIdentificationVar()) {
                object2 = ((IdentificationVar)expression).getAbstractSchema();
            } else if (expression.isNavigationExpression()) {
                object = (NavigationExpression)expression;
                Object object3 = object2 = ((NavigationExpression)object).endsInCmrField() ? ((NavigationExpression)object).getAbstractSchema() : null;
            }
            if (object2 == null || !((AbstractSchemaName)object2).equals(this.query_.getAbstractSchema())) {
                object = localStrings.getLocalString("ValidatingVisitor.returntypemismatch", "");
                this.errors_.add(new ParseException((String)object));
                return;
            }
        }
        object2 = this.query_.getQueryMethodReturnType();
        object = this.query_.getQueryReturnType();
        this.validateReturnType((Class)object2, (String)object);
        super.visitSelectClause(selectClause);
    }

    public void visitFromClause(FromClause fromClause) {
        super.visitFromClause(fromClause);
    }

    private void validateReturnType(Class clazz, String string) {
        String string2;
        if (this.query_.queryMethodReturnsSingleValue() && !string.equals(string2 = clazz.getName())) {
            Object object;
            boolean bl = false;
            ClassLoader classLoader = this.query_.getEjbBundleClassLoader();
            try {
                object = classLoader.loadClass(string);
                bl = clazz.isAssignableFrom((Class<?>)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            if (!bl) {
                object = localStrings.getLocalString("ValidatingVisitor.selecttypemismatch", "");
                this.errors_.add(new ParseException((String)object));
            }
        }
    }

    public void visitNavigationExpression(NavigationExpression navigationExpression) {
        ListIterator listIterator = navigationExpression.getChildren(this.getTraversalType());
        IdentificationVar identificationVar = (IdentificationVar)listIterator.next();
        while (listIterator.hasNext()) {
            Expression expression;
            NavigationOperator navigationOperator = (NavigationOperator)listIterator.next();
            if (navigationOperator.operatesOn(expression = (Expression)listIterator.next())) continue;
            String string = this.printer_.printToString(navigationExpression);
            String string2 = localStrings.getLocalString("ValidatingVisitor.illegalnav", "", new Object[]{string});
            this.errors_.add(new ParseException(string2));
        }
    }

    public void visitOperatorExpression(OperatorExpression operatorExpression) {
        Object object;
        Object object2;
        Operator operator = operatorExpression.getOperator();
        ListIterator listIterator = operatorExpression.getChildren(this.getTraversalType());
        Vector vector = new Vector();
        while (listIterator.hasNext()) {
            vector.add(listIterator.next());
        }
        super.visitOperatorExpression(operatorExpression);
        if (operator.equals(UnaryOperator.IS_EMPTY)) {
            object2 = (UnaryOperatorExpression)operatorExpression;
            object = (NavigationExpression)((UnaryOperatorExpression)object2).getExpression();
            FromClause fromClause = this.query_.getFromClause();
            Iterator iterator = fromClause.getIdentVars();
            while (iterator.hasNext()) {
                IdentificationVar identificationVar = (IdentificationVar)iterator.next();
                if (!((NavigationExpression)object).equals(identificationVar.getExpression())) continue;
                String string = this.printer_.printToString((Element)object);
                String string2 = localStrings.getLocalString("ValidatingVisitor.isemptyerror", "", new Object[]{string});
                this.errors_.add(new ParseException(string2));
                break;
            }
        }
        if (!this.foundTypeError_ && !operator.operatesOn(vector)) {
            this.foundTypeError_ = true;
            object2 = this.printer_.printToString(operatorExpression);
            object = localStrings.getLocalString("ValidatingVisitor.invalidexprtype", "", new Object[]{object2});
            this.errors_.add(new ParseException((String)object));
        }
    }
}

