/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.Visitor;

public class StringLiteral
extends ExpressionBase
implements Literal {
    private String sqlLiteral_;
    private String javaLiteral_;

    public StringLiteral(String string) {
        this.sqlLiteral_ = string;
        this.javaLiteral_ = this.stripQuotes(string);
    }

    public Object getLiteral() {
        return this.javaLiteral_;
    }

    public String getJavaType() {
        return this.sqlLiteral_.getClass().getName();
    }

    public void accept(Visitor visitor) {
        visitor.visitLiteral(this);
    }

    public String toSql() {
        return this.sqlLiteral_;
    }

    public String toString() {
        return this.toSql();
    }

    private String stripQuotes(String string) {
        String string2 = string.substring(1, string.length() - 1);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = i + 1 < string2.length() ? (int)string2.charAt(i + 1) : 32;
            stringBuffer.append(c);
            if (string2.charAt(i) != '\'' || string2.charAt(i + 1) != '\'') continue;
            ++i;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)object;
            bl = this.sqlLiteral_.equals(stringLiteral.sqlLiteral_);
        }
        return bl;
    }
}

