/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.EjbQLQuery;
import com.sun.ejb.ejbql.Element;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.FromClause;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.NavigationOperator;
import com.sun.ejb.ejbql.Operator;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.RangeIdentificationVar;
import com.sun.ejb.ejbql.SelectClause;
import com.sun.ejb.ejbql.Symbol;
import com.sun.ejb.ejbql.UnaryOperator;
import com.sun.ejb.ejbql.VisitorAdapter;
import com.sun.ejb.ejbql.WhereClause;
import java.util.Iterator;
import java.util.ListIterator;

public class PrintingVisitor
extends VisitorAdapter {
    private StringBuffer printString_;
    private EjbQLQuery query_;
    private static final String SPACE = " ";

    public PrintingVisitor(EjbQLQuery ejbQLQuery) {
        super(1);
        this.query_ = ejbQLQuery;
    }

    public String printToString(Element element) {
        this.printString_ = new StringBuffer();
        element.accept(this);
        return this.printString_.toString();
    }

    public void visitSelectClause(SelectClause selectClause) {
        boolean bl;
        this.printString_.append("SELECT ");
        Expression expression = selectClause.getExpression();
        if (selectClause.isDistinct()) {
            this.printString_.append("DISTINCT ");
        }
        if (bl = expression.isIdentificationVar()) {
            this.printString_.append("OBJECT(");
        }
        super.visitSelectClause(selectClause);
        if (bl) {
            this.printString_.append(")");
        }
        this.printString_.append(SPACE);
    }

    public void visitFromClause(FromClause fromClause) {
        this.printString_.append("FROM ");
        ListIterator listIterator = fromClause.getChildren(this.getTraversalType());
        while (listIterator.hasNext()) {
            Expression expression;
            IdentificationVar identificationVar = (IdentificationVar)listIterator.next();
            if (identificationVar.isRangeIdentVar()) {
                expression = (RangeIdentificationVar)identificationVar;
                AbstractSchemaName abstractSchemaName = ((RangeIdentificationVar)expression).getAbstractSchema();
                this.printString_.append(abstractSchemaName + " AS ");
                this.printString_.append(SPACE + ((IdentificationVar)expression).getName() + SPACE);
            } else {
                this.printString_.append(" IN (");
                expression = identificationVar.getExpression();
                expression.accept(this);
                this.printString_.append(") AS " + identificationVar.getName() + SPACE);
            }
            if (!listIterator.hasNext()) continue;
            this.printString_.append(", ");
        }
    }

    public void visitWhereClause(WhereClause whereClause) {
        this.printString_.append("WHERE ");
        super.visitWhereClause(whereClause);
    }

    public void visitIdentificationVar(IdentificationVar identificationVar) {
        this.printString_.append(identificationVar.getName());
    }

    public void visitNavigationExpression(NavigationExpression navigationExpression) {
        ListIterator listIterator = navigationExpression.getChildren(this.getTraversalType());
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            expression.accept(this);
            if (!listIterator.hasNext()) continue;
            NavigationOperator navigationOperator = (NavigationOperator)listIterator.next();
            this.printString_.append(navigationOperator.getPrintString());
        }
        this.printString_.append(SPACE);
    }

    public void visitOperatorExpression(OperatorExpression operatorExpression) {
        Operator operator = operatorExpression.getOperator();
        Iterator iterator = operatorExpression.getPrintStrings();
        ListIterator listIterator = operatorExpression.getChildren(this.getTraversalType());
        this.printString_.append("(");
        if (operator.isFunction()) {
            String string = (String)iterator.next();
            this.printString_.append(string);
            this.printString_.append("(");
            while (listIterator.hasNext()) {
                Expression expression = (Expression)listIterator.next();
                expression.accept(this);
                if (!listIterator.hasNext()) continue;
                this.printString_.append(" , ");
            }
            this.printString_.append(") ");
        } else if (operator.isUnary()) {
            UnaryOperator unaryOperator = (UnaryOperator)operator;
            Expression expression = (Expression)listIterator.next();
            String string = (String)iterator.next();
            if (unaryOperator.isPreOperator()) {
                this.printString_.append(string + SPACE);
                expression.accept(this);
            } else {
                expression.accept(this);
                this.printString_.append(SPACE + string);
            }
        } else {
            while (listIterator.hasNext()) {
                Expression expression = (Expression)listIterator.next();
                expression.accept(this);
                if (!iterator.hasNext()) continue;
                this.printString_.append(SPACE + iterator.next() + SPACE);
            }
        }
        this.printString_.append(")");
    }

    public void visitLiteral(Literal literal) {
        this.printString_.append(literal.toString());
    }

    public void visitSymbol(Symbol symbol) {
        this.printString_.append(symbol.getName());
    }
}

