/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.OperatorBase;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.Vector;

public abstract class NaryOperator
extends OperatorBase {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(NaryOperator.class);
    public static final NaryOperator LIKE = new Like(false);
    public static final NaryOperator NOT_LIKE = new Like(true);
    public static final NaryOperator AND = new And();
    public static final NaryOperator OR = new Or();
    public static final NaryOperator LOCATE = new Locate();
    public static final NaryOperator SUBSTRING = new Substring();
    public static final NaryOperator STRING_AGGREGATOR = new StringAggregator();

    public boolean isNary() {
        return true;
    }

    public String getResultType(Vector vector) {
        if (!this.operatesOn(vector)) {
            String string = localStrings.getLocalString("NaryOperator.wrongexprtype", "Wrong expression type");
            throw new IllegalArgumentException(string);
        }
        return BOOLEAN_OBJECT_TYPE_NAME;
    }

    protected Iterator buildPrintStrings(String string, int n) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            vector.add(string);
        }
        return vector.iterator();
    }

    private static class StringAggregator
    extends NaryOperator {
        private StringAggregator() {
        }

        public boolean operatesOn(Vector vector) {
            boolean bl = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (StringAggregator.hasStringType(expression)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public String getResultType(Vector vector) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector vector) {
            return this.buildPrintStrings("", 1);
        }
    }

    private static class Substring
    extends NaryOperator {
        private Substring() {
        }

        public boolean operatesOn(Vector vector) {
            Expression expression = (Expression)vector.elementAt(0);
            Expression expression2 = (Expression)vector.elementAt(1);
            Expression expression3 = (Expression)vector.elementAt(2);
            return Substring.hasStringType(expression) && expression2.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME) && expression3.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME);
        }

        public String getResultType(Vector vector) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector vector) {
            return this.buildPrintStrings("SUBSTRING", 1);
        }
    }

    private static class Locate
    extends NaryOperator {
        private Locate() {
        }

        public boolean operatesOn(Vector vector) {
            boolean bl = false;
            Expression expression = (Expression)vector.elementAt(0);
            Expression expression2 = (Expression)vector.elementAt(1);
            boolean bl2 = bl = Locate.hasStringType(expression) && Locate.hasStringType(expression2);
            if (bl && vector.size() == 3) {
                Expression expression3 = (Expression)vector.elementAt(2);
                bl = expression3.getJavaType().equals(INTEGER_PRIMITIVE_TYPE_NAME);
            }
            return bl;
        }

        public String getResultType(Vector vector) {
            return INTEGER_PRIMITIVE_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public Iterator getPrintStrings(Vector vector) {
            return this.buildPrintStrings("LOCATE", 1);
        }
    }

    private static class Like
    extends NaryOperator {
        private boolean not_;

        public Like(boolean bl) {
            this.not_ = bl;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpression) {
            visitor.visitLikeExpression(operatorExpression);
        }

        public boolean operatesOn(Vector vector) {
            boolean bl = true;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (Like.hasStringType(expression)) continue;
                bl = false;
                break;
            }
            return bl;
        }

        public Iterator getPrintStrings(Vector vector) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(this.not_ ? "NOT LIKE" : "LIKE");
            if (vector.size() == 3) {
                vector2.add("ESCAPE");
            }
            return vector2.iterator();
        }
    }

    private static class Or
    extends NaryOperator {
        private Or() {
        }

        public boolean operatesOn(Vector vector) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (Or.hasBooleanType(expression)) continue;
                return false;
            }
            return true;
        }

        public Iterator getPrintStrings(Vector vector) {
            return this.buildPrintStrings("OR", vector.size() - 1);
        }
    }

    private static class And
    extends NaryOperator {
        private And() {
        }

        public boolean operatesOn(Vector vector) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (And.hasBooleanType(expression)) continue;
                return false;
            }
            return true;
        }

        public Iterator getPrintStrings(Vector vector) {
            return this.buildPrintStrings("AND", vector.size() - 1);
        }
    }
}

