/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.ExpressionBase;
import com.sun.ejb.ejbql.Literal;
import com.sun.ejb.ejbql.Visitor;
import com.sun.ejb.ejbql.parser.ParseException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class InputParam
extends ExpressionBase
implements Literal {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InputParam.class);
    private Integer paramIndex_;
    private Class paramClass_;
    private String javaType_;
    private boolean remoteInterface_;
    private boolean localInterface_;

    public InputParam(Integer n, Method method) throws ParseException {
        this.paramIndex_ = n;
        try {
            Class<?>[] classArray = method.getParameterTypes();
            this.paramClass_ = classArray[n - 1];
            this.remoteInterface_ = EJBObject.class.isAssignableFrom(this.paramClass_);
            this.localInterface_ = EJBLocalObject.class.isAssignableFrom(this.paramClass_);
            this.javaType_ = this.paramClass_.getName();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            String string = localStrings.getLocalString("InputParam.noparam", "", new Object[]{method, n});
            throw new ParseException(string);
        }
    }

    public Object getLiteral() {
        throw new IllegalStateException("getLiteral not applicable");
    }

    public boolean isInputParam() {
        return true;
    }

    public boolean isRemoteInterface() {
        return this.remoteInterface_;
    }

    public boolean isLocalInterface() {
        return this.localInterface_;
    }

    public Integer getParamIndex() {
        return this.paramIndex_;
    }

    public Class getParamClass() {
        return this.paramClass_;
    }

    public String getJavaType() {
        return this.javaType_;
    }

    public void accept(Visitor visitor) {
        visitor.visitLiteral(this);
    }

    public String toSql() {
        return "?";
    }

    public String toString() {
        return "?" + this.paramIndex_;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof InputParam) {
            InputParam inputParam = (InputParam)object;
            bl = this.paramIndex_.equals(inputParam.paramIndex_);
        }
        return bl;
    }
}

