/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbql;

import com.sun.ejb.ejbql.AbstractSchemaName;
import com.sun.ejb.ejbql.Expression;
import com.sun.ejb.ejbql.IdentificationVar;
import com.sun.ejb.ejbql.InputParam;
import com.sun.ejb.ejbql.NavigationExpression;
import com.sun.ejb.ejbql.OperatorBase;
import com.sun.ejb.ejbql.OperatorExpression;
import com.sun.ejb.ejbql.Visitor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.Vector;

public abstract class BinaryOperator
extends OperatorBase {
    private static final boolean debug = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BinaryOperator.class);
    public static final BinaryOperator IN_STRINGS = new InStrings(false);
    public static final BinaryOperator NOT_IN_STRINGS = new InStrings(true);
    public static final BinaryOperator EQUAL = new Equal(false);
    public static final BinaryOperator NOT_EQUAL = new Equal(true);
    public static final BinaryOperator GREATER_THAN = new GreaterThan();
    public static final BinaryOperator GREATER_THAN_OR_EQUAL = new GreaterThanOrEqual();
    public static final BinaryOperator LESS_THAN_OR_EQUAL = new LessThanOrEqual();
    public static final BinaryOperator LESS_THAN = new LessThan();
    public static final BinaryOperator ADD = new Add();
    public static final BinaryOperator SUBTRACT = new Subtract();
    public static final BinaryOperator MULTIPLY = new Multiply();
    public static final BinaryOperator DIVIDE = new Divide();
    public static final BinaryOperator CONCAT = new Concat();
    public static final BinaryOperator MEMBER_OF = new MemberOf(false);
    public static final BinaryOperator NOT_MEMBER_OF = new MemberOf(true);
    public static final BinaryOperator SELECT_FIELD = new SelectField();

    public boolean isBinary() {
        return true;
    }

    public boolean operatesOn(Vector vector) {
        if (vector.size() != 2) {
            String string = localStrings.getLocalString("BinaryOperator.arity", "Wrong arity");
            throw new IllegalArgumentException(string);
        }
        return this.operatesOn((Expression)vector.firstElement(), (Expression)vector.lastElement());
    }

    public abstract boolean operatesOn(Expression var1, Expression var2);

    public String getResultType(Vector vector) {
        if (!this.operatesOn(vector)) {
            String string = localStrings.getLocalString("BinaryOperator.exprtype", "Wrong expression type");
            throw new IllegalArgumentException(string);
        }
        return this.getResultType((Expression)vector.firstElement(), (Expression)vector.lastElement());
    }

    public String getResultType(Expression expression, Expression expression2) {
        return BOOLEAN_OBJECT_TYPE_NAME;
    }

    protected String getBinaryPromotionType(Expression expression, Expression expression2) {
        if (BinaryOperator.hasDoubleType(expression) || BinaryOperator.hasDoubleType(expression2)) {
            return DOUBLE_PRIMITIVE_TYPE_NAME;
        }
        if (BinaryOperator.hasFloatType(expression) || BinaryOperator.hasFloatType(expression2)) {
            return FLOAT_PRIMITIVE_TYPE_NAME;
        }
        if (BinaryOperator.hasLongType(expression) || BinaryOperator.hasLongType(expression2)) {
            return LONG_PRIMITIVE_TYPE_NAME;
        }
        return INTEGER_PRIMITIVE_TYPE_NAME;
    }

    public Iterator getPrintStrings(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.add(this.doGetPrintString());
        return vector2.iterator();
    }

    protected abstract String doGetPrintString();

    private static boolean validInputParamComparison(InputParam inputParam, AbstractSchemaName abstractSchemaName) {
        Class<?> clazz;
        String string;
        boolean bl = false;
        EjbCMPEntityDescriptor ejbCMPEntityDescriptor = abstractSchemaName.getEjbDescriptor();
        Class clazz2 = inputParam.getParamClass();
        ClassLoader classLoader = clazz2.getClassLoader();
        if (ejbCMPEntityDescriptor.isLocalInterfacesSupported()) {
            string = ejbCMPEntityDescriptor.getLocalClassName();
            try {
                clazz = classLoader.loadClass(string);
                bl = clazz.isAssignableFrom(clazz2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (!bl && ejbCMPEntityDescriptor.isRemoteInterfacesSupported()) {
            string = ejbCMPEntityDescriptor.getRemoteClassName();
            try {
                clazz = classLoader.loadClass(string);
                bl = clazz.isAssignableFrom(clazz2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static AbstractSchemaName getAbstractSchema(Expression expression) {
        AbstractSchemaName abstractSchemaName = null;
        if (expression.isNavigationExpression()) {
            NavigationExpression navigationExpression = (NavigationExpression)expression;
            abstractSchemaName = navigationExpression.endsInCmrField() ? navigationExpression.getAbstractSchema() : null;
        } else if (expression.isIdentificationVar()) {
            IdentificationVar identificationVar = (IdentificationVar)expression;
            abstractSchemaName = identificationVar.getAbstractSchema();
        }
        return abstractSchemaName;
    }

    private static boolean equalityComparable(Expression expression, Expression expression2) {
        boolean bl = BinaryOperator.hasNumericType(expression);
        boolean bl2 = BinaryOperator.hasNumericType(expression2);
        if (bl || bl2) {
            return bl && bl2;
        }
        boolean bl3 = BinaryOperator.hasBooleanType(expression);
        boolean bl4 = BinaryOperator.hasBooleanType(expression2);
        if (bl3 || bl4) {
            return bl3 && bl4;
        }
        boolean bl5 = BinaryOperator.hasStringType(expression);
        boolean bl6 = BinaryOperator.hasStringType(expression2);
        if (bl5 || bl6) {
            return bl5 && bl6;
        }
        AbstractSchemaName abstractSchemaName = BinaryOperator.getAbstractSchema(expression);
        if (abstractSchemaName != null) {
            if (expression2.isInputParam()) {
                InputParam inputParam = (InputParam)expression2;
                return BinaryOperator.validInputParamComparison(inputParam, abstractSchemaName);
            }
            AbstractSchemaName abstractSchemaName2 = BinaryOperator.getAbstractSchema(expression2);
            return abstractSchemaName2 != null && abstractSchemaName.equals(abstractSchemaName2);
        }
        return false;
    }

    private static boolean scalarOperable(Expression expression, Expression expression2) {
        return BinaryOperator.hasNumericType(expression) && BinaryOperator.hasNumericType(expression2);
    }

    private static class SelectField
    extends BinaryOperator {
        private SelectField() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return false;
        }

        public String doGetPrintString() {
            return "SELECT SINGLE FIELD";
        }
    }

    private static class MemberOf
    extends BinaryOperator {
        private boolean not_;

        public MemberOf(boolean bl) {
            this.not_ = bl;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpression) {
            visitor.visitMemberOfExpression(operatorExpression);
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            boolean bl = false;
            NavigationExpression navigationExpression = (NavigationExpression)expression2;
            AbstractSchemaName abstractSchemaName = navigationExpression.getAbstractSchema();
            if (expression.isInputParam()) {
                InputParam inputParam = (InputParam)expression;
                bl = BinaryOperator.validInputParamComparison(inputParam, abstractSchemaName);
            } else {
                AbstractSchemaName abstractSchemaName2 = expression.isIdentificationVar() ? ((IdentificationVar)expression).getAbstractSchema() : ((NavigationExpression)expression).getAbstractSchema();
                bl = abstractSchemaName2.equals(abstractSchemaName);
            }
            return bl;
        }

        public String doGetPrintString() {
            return this.not_ ? "NOT MEMBER_OF" : "MEMBER_OF";
        }
    }

    private static class Concat
    extends BinaryOperator {
        private Concat() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return Concat.hasStringType(expression) && Concat.hasStringType(expression2);
        }

        public String getResultType(Expression expression, Expression expression2) {
            return STRING_TYPE_NAME;
        }

        public boolean isFunction() {
            return true;
        }

        public String doGetPrintString() {
            return "CONCAT";
        }
    }

    private static class Divide
    extends BinaryOperator {
        private Divide() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String getResultType(Expression expression, Expression expression2) {
            return this.getBinaryPromotionType(expression, expression2);
        }

        public String doGetPrintString() {
            return "/";
        }
    }

    private static class Multiply
    extends BinaryOperator {
        private Multiply() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String getResultType(Expression expression, Expression expression2) {
            return this.getBinaryPromotionType(expression, expression2);
        }

        public String doGetPrintString() {
            return "*";
        }
    }

    private static class Subtract
    extends BinaryOperator {
        private Subtract() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String getResultType(Expression expression, Expression expression2) {
            return this.getBinaryPromotionType(expression, expression2);
        }

        public String doGetPrintString() {
            return "-";
        }
    }

    private static class Add
    extends BinaryOperator {
        private Add() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String getResultType(Expression expression, Expression expression2) {
            return this.getBinaryPromotionType(expression, expression2);
        }

        public String doGetPrintString() {
            return "+";
        }
    }

    private static class LessThanOrEqual
    extends BinaryOperator {
        private LessThanOrEqual() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String doGetPrintString() {
            return "<=";
        }
    }

    private static class LessThan
    extends BinaryOperator {
        private LessThan() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String doGetPrintString() {
            return "<";
        }
    }

    private static class GreaterThanOrEqual
    extends BinaryOperator {
        private GreaterThanOrEqual() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String doGetPrintString() {
            return ">=";
        }
    }

    private static class GreaterThan
    extends BinaryOperator {
        private GreaterThan() {
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.scalarOperable(expression, expression2);
        }

        public String doGetPrintString() {
            return ">";
        }
    }

    private static class Equal
    extends BinaryOperator {
        private boolean not_;

        public Equal(boolean bl) {
            this.not_ = bl;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpression) {
            visitor.visitComparisonExpression(operatorExpression);
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return BinaryOperator.equalityComparable(expression, expression2);
        }

        public String doGetPrintString() {
            return this.not_ ? "<>" : "=";
        }
    }

    private static class InStrings
    extends BinaryOperator {
        private boolean not_;

        public InStrings(boolean bl) {
            this.not_ = bl;
        }

        public void acceptOperatorExpression(Visitor visitor, OperatorExpression operatorExpression) {
            visitor.visitInExpression(operatorExpression);
        }

        public boolean operatesOn(Expression expression, Expression expression2) {
            return InStrings.hasStringType(expression) && InStrings.hasStringType(expression2);
        }

        public String doGetPrintString() {
            return this.not_ ? "NOT IN" : "IN";
        }
    }
}

