/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.pool;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import java.util.logging.Level;

public class NonBlockingPool
extends AbstractPool {
    private String poolName;
    private TimerTask poolTimerTask;
    protected boolean addedResizeTask = false;
    protected boolean addedIdleBeanWork = false;
    protected boolean inResizing = false;
    private boolean maintainSteadySize = false;
    private int resizeTaskCount;
    private int timerTaskCount;

    protected NonBlockingPool() {
    }

    public NonBlockingPool(String string, ObjectFactory objectFactory, int n, int n2, int n3, int n4) {
        this.poolName = string;
        this.initializePool(objectFactory, n, n2, n3, n4);
    }

    protected void initializePool(ObjectFactory objectFactory, int n, int n2, int n3, int n4) {
        block5: {
            this.list = new ArrayList();
            this.factory = objectFactory;
            this.steadyPoolSize = n <= 0 ? 0 : n;
            this.resizeQuantity = n2 <= 0 ? 0 : n2;
            this.maxPoolSize = n3 <= 0 ? Integer.MAX_VALUE : n3;
            this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
            int n5 = this.idleTimeoutInSeconds = n4 <= 0 ? 0 : n4;
            if (n > 0) {
                this.preload(n);
            }
            this.containerClassLoader = this.getClass().getClassLoader();
            boolean bl = this.maintainSteadySize = this.steadyPoolSize > 0;
            if (this.idleTimeoutInSeconds > 0 && this.resizeQuantity > 0) {
                try {
                    this.poolTimerTask = new PoolResizeTimerTask();
                    ContainerFactoryImpl.getTimer().scheduleAtFixedRate(this.poolTimerTask, n4 * 1000, (long)(n4 * 1000));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                    }
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block5;
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Could not add" + " PoolTimerTask. Continuing anyway...", throwable);
                }
            }
        }
    }

    public void setContainerClassLoader(ClassLoader classLoader) {
        this.containerClassLoader = classLoader;
    }

    public Object getObject(boolean bl, Object object) throws PoolException {
        return this.getObject(object);
    }

    public Object getObject(long l, Object object) throws PoolException {
        return this.getObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getObject(Object object) {
        Object var3_3;
        boolean bl;
        block13: {
            bl = false;
            var3_3 = null;
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            int n = this.list.size();
            if (n > this.steadyPoolSize) {
                ++this.poolSuccess;
                // MONITOREXIT : arrayList
                return this.list.remove(n - 1);
            }
            if (n > 0) {
                ++this.poolSuccess;
                if (this.maintainSteadySize && !this.addedResizeTask) {
                    this.addedResizeTask = true;
                    bl = true;
                    var3_3 = this.list.remove(n - 1);
                    break block13;
                } else {
                    // MONITOREXIT : arrayList
                    return this.list.remove(n - 1);
                }
            }
            if (this.maintainSteadySize && !this.addedResizeTask) {
                this.addedResizeTask = true;
                bl = true;
            }
            ++this.createdCount;
        }
        // MONITOREXIT : arrayList
        if (bl) {
            this.addResizeTaskForImmediateExecution();
        }
        if (var3_3 != null) {
            return var3_3;
        }
        try {
            return this.factory.create(object);
        }
        catch (RuntimeException runtimeException) {
            ArrayList arrayList = this.list;
            // MONITORENTER : arrayList
            --this.createdCount;
            // MONITOREXIT : arrayList
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResizeTaskForImmediateExecution() {
        block6: {
            try {
                ReSizeWork reSizeWork = new ReSizeWork();
                ContainerWorkPool.addLast(reSizeWork);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Added PoolResizeTimerTask...");
                }
                ++this.resizeTaskCount;
            }
            catch (Exception exception) {
                ArrayList arrayList = this.list;
                synchronized (arrayList) {
                    this.addedResizeTask = false;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block6;
                _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Cannot perform " + " pool resize task", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.list.size() < this.maxPoolSize) {
                this.list.add(object);
                return;
            }
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(Object object) {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ++this.destroyedCount;
        }
        try {
            this.factory.destroy(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload(int n) {
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        try {
            for (n2 = 0; n2 < n; ++n2) {
                arrayList.add(this.factory.create(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((n2 = arrayList.size()) == 0) {
            return;
        }
        ArrayList arrayList2 = this.list;
        synchronized (arrayList2) {
            for (int i = 0; i < n2; ++i) {
                this.list.add(arrayList.get(i));
            }
            this.createdCount += n2;
        }
    }

    public void prepopulate(int n) {
        this.steadyPoolSize = n <= 0 ? 0 : n;
        int n2 = this.steadyPoolSize = this.steadyPoolSize > this.maxPoolSize ? this.maxPoolSize : this.steadyPoolSize;
        if (this.steadyPoolSize > 0) {
            this.preload(this.steadyPoolSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            if (this.poolTimerTask != null) {
                try {
                    this.poolTimerTask.cancel();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Cancelled pool timer task " + " at: " + new Date());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Destroying " + this.list.size() + " beans from the pool...");
            }
            Object[] objectArray = this.list.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    ++this.destroyedCount;
                    try {
                        this.factory.destroy(objectArray[i]);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Error while destroying: " + throwable);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Pool-" + this.poolName + "]: Pool closed....");
            }
            this.list.clear();
        }
        this.list = null;
        this.factory = null;
        this.poolTimerTask = null;
        this.containerClassLoader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(int n) {
        int n2;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.list;
        synchronized (arrayList2) {
            n2 = this.list.size();
            for (int i = 0; i < n && n2 > 0; ++i) {
                arrayList.add(this.list.remove(--n2));
                ++this.destroyedCount;
            }
        }
        int n3 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                this.factory.destroy(arrayList.get(n2));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void removeIdleObjects() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void doResize() {
        final Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        final ClassLoader classLoader2 = this.containerClassLoader;
        long l = 0L;
        boolean bl = false;
        try {
            block36: {
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            thread.setContextClassLoader(classLoader2);
                            return null;
                        }
                    });
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize started at: " + new Date() + " steadyPoolSize ::" + this.steadyPoolSize + " resizeQuantity ::" + this.resizeQuantity + " maxPoolSize ::" + this.maxPoolSize);
                    }
                    l = System.currentTimeMillis();
                    ArrayList arrayList = new ArrayList();
                    int n = 0;
                    ArrayList arrayList2 = this.list;
                    // MONITORENTER : arrayList2
                    if (this.inResizing) {
                        // MONITOREXIT : arrayList2
                        Object var18_12 = null;
                        if (bl) {
                            ArrayList arrayList3 = this.list;
                            // MONITORENTER : arrayList3
                            this.inResizing = false;
                            // MONITOREXIT : arrayList3
                        }
                        AccessController.doPrivileged(new PrivilegedAction(thread, classLoader){
                            private final /* synthetic */ Thread val$currentThread;
                            private final /* synthetic */ ClassLoader val$previousClassLoader;
                            {
                                this.val$currentThread = thread;
                                this.val$previousClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                        return;
                    }
                    bl = true;
                    this.inResizing = true;
                    int n2 = this.list.size();
                    if (n2 > this.steadyPoolSize) {
                        EJBContextImpl eJBContextImpl;
                        if (this.idleTimeoutInSeconds <= 0 || this.resizeQuantity <= 0) {
                            // MONITOREXIT : arrayList2
                            Object var18_13 = null;
                            if (bl) {
                                ArrayList arrayList4 = this.list;
                                // MONITORENTER : arrayList4
                                this.inResizing = false;
                                // MONITOREXIT : arrayList4
                            }
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        int n3 = n2 > this.steadyPoolSize + this.resizeQuantity ? this.resizeQuantity : n2 - this.steadyPoolSize;
                        long l2 = System.currentTimeMillis() - (long)(this.idleTimeoutInSeconds * 1000);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize:: reducing " + " pool size by: " + n3);
                        }
                        for (int i = 0; i < n3 && (eJBContextImpl = (EJBContextImpl)this.list.get(0)).getLastTimeUsed() <= l2; ++this.destroyedCount, ++i) {
                            arrayList.add(this.list.remove(0));
                        }
                    } else if (n2 < this.steadyPoolSize) {
                        if (!this.maintainSteadySize) {
                            // MONITOREXIT : arrayList2
                            Object var18_14 = null;
                            if (bl) {
                                ArrayList arrayList5 = this.list;
                                // MONITORENTER : arrayList5
                                this.inResizing = false;
                                // MONITOREXIT : arrayList5
                            }
                            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        n = n2 + this.resizeQuantity > this.maxPoolSize ? this.maxPoolSize - n2 : (this.resizeQuantity <= 0 ? this.steadyPoolSize - n2 : this.resizeQuantity);
                    }
                    // MONITOREXIT : arrayList2
                    if (arrayList.size() > 0) {
                        int n4 = arrayList.size();
                        for (n2 = 0; n2 < n4; ++n2) {
                            try {
                                this.factory.destroy(arrayList.get(n2));
                                continue;
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (n <= 0) break block36;
                    this.preload(n);
                }
                catch (Throwable throwable) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "[Pool-" + this.poolName + "]: Exception during reSize", throwable);
                    }
                    Object var18_16 = null;
                    if (bl) {
                        ArrayList arrayList = this.list;
                        // MONITORENTER : arrayList
                        this.inResizing = false;
                        // MONITOREXIT : arrayList
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                }
            }
            Object var18_15 = null;
            if (bl) {
                ArrayList arrayList = this.list;
                // MONITORENTER : arrayList
                this.inResizing = false;
                // MONITOREXIT : arrayList
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            if (bl) {
                ArrayList arrayList = this.list;
                // MONITORENTER : arrayList
                this.inResizing = false;
                // MONITOREXIT : arrayList
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        long l3 = System.currentTimeMillis();
        if (!_logger.isLoggable(Level.FINE)) return;
        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize completed at: " + new Date() + "; after reSize: " + this.getAllAttrValues());
        _logger.log(Level.FINE, "[Pool-" + this.poolName + "]: Resize took: " + (double)(l3 - l) / 1000.0 + " seconds.");
    }

    public String getAllAttrValues() {
        StringBuffer stringBuffer = new StringBuffer("[Pool-" + this.poolName + "] ");
        stringBuffer.append("CC=").append(this.createdCount).append("; ").append("DC=").append(this.destroyedCount).append("; ").append("CS=").append(this.list.size()).append("; ").append("SS=").append(this.steadyPoolSize).append("; ").append("MS=").append(this.maxPoolSize).append(";");
        return stringBuffer.toString();
    }

    private class PoolResizeTimerTask
    extends TimerTask {
        Object lock;

        PoolResizeTimerTask() {
        }

        PoolResizeTimerTask(Object object) {
            this.lock = object;
        }

        public void run() {
            block3: {
                try {
                    if (NonBlockingPool.this.addedIdleBeanWork) {
                        return;
                    }
                    IdleBeanWork idleBeanWork = new IdleBeanWork();
                    ContainerWorkPool.addLast(idleBeanWork);
                    NonBlockingPool.this.addedIdleBeanWork = true;
                }
                catch (Exception exception) {
                    if (!AbstractPool._logger.isLoggable(Level.WARNING)) break block3;
                    AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Cannot perform " + " pool idle bean cleanup", exception);
                }
            }
        }
    }

    private class IdleBeanWork
    implements Servicable {
        private IdleBeanWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                NonBlockingPool.this.doResize();
            }
            catch (Exception exception) {
            }
            finally {
                NonBlockingPool.this.addedIdleBeanWork = false;
            }
        }
    }

    private class ReSizeWork
    implements Servicable {
        private ReSizeWork() {
        }

        public void prolog() {
        }

        public void service() {
            this.run();
        }

        public void epilog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ArrayList arrayList;
            try {
                try {
                    NonBlockingPool.this.doResize();
                }
                catch (Exception exception) {
                    if (AbstractPool._logger.isLoggable(Level.WARNING)) {
                        AbstractPool._logger.log(Level.WARNING, "[Pool-" + NonBlockingPool.this.poolName + "]: Exception during reSize", exception);
                    }
                    Object var3_2 = null;
                    ArrayList arrayList3 = NonBlockingPool.this.list;
                    synchronized (arrayList3) {
                        NonBlockingPool.this.addedResizeTask = false;
                        return;
                    }
                }
                Object var3_1 = null;
                arrayList = NonBlockingPool.this.list;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ArrayList arrayList2 = NonBlockingPool.this.list;
                synchronized (arrayList2) {
                    NonBlockingPool.this.addedResizeTask = false;
                    throw throwable;
                }
            }
            synchronized (arrayList) {
                NonBlockingPool.this.addedResizeTask = false;
                return;
            }
        }
    }
}

