/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.PassivatedSessionInfo;
import com.sun.ejb.spi.SFSBStoreManager;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PassivatedBeansCache {
    StatefulSessionContainer container;
    PassivatedSessionInfo[] buckets;
    Object[] bucketLocks;
    IdleBeanCleanerTimerTask idleBeanCleanerTimerTask;
    boolean addedIdleBeanWork;
    int removalTimeoutInSeconds;
    ClassLoader loader;
    String cacheName;
    SFSBStoreManager cacheStore;
    private int _bucketMask;
    int size;
    Object sizeLock;
    private Object numExpiredLock;
    private int numExpiredSessionsRemoved;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    PassivatedBeansCache(String string, StatefulSessionContainer statefulSessionContainer, int n) {
        block4: {
            this.size = 0;
            this.sizeLock = new Object();
            this.numExpiredLock = new Object();
            this.cacheName = "PassivatedBeansCache::" + string;
            this.container = statefulSessionContainer;
            this.removalTimeoutInSeconds = n;
            if (n > 0) {
                try {
                    this.idleBeanCleanerTimerTask = new IdleBeanCleanerTimerTask();
                    ContainerFactoryImpl.getTimer().scheduleAtFixedRate((TimerTask)this.idleBeanCleanerTimerTask, n * 1000, (long)(n * 1000));
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + string + "]: IdleBeanCleanerTimer Task created");
                    }
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block4;
                    _logger.log(Level.WARNING, "[" + string + "]: Could not add" + " PoolTimerTask. Continuing anyway...", throwable);
                }
            }
        }
        this.loader = this.getClass().getClassLoader();
    }

    void setSessionCacheStore(SFSBStoreManager sFSBStoreManager) {
        this.cacheStore = sFSBStoreManager;
    }

    private int hash(Object object) {
        int n = object.hashCode();
        return n - (n << 7);
    }

    protected final int getIndex(Object object) {
        return this.getIndex(new Long(this.hash(object)));
    }

    public void init(int n) {
        this._bucketMask = 1;
        while (this._bucketMask < n) {
            this._bucketMask <<= 1;
        }
        this.bucketLocks = new Object[this._bucketMask];
        this.buckets = new PassivatedSessionInfo[this._bucketMask];
        for (int i = 0; i < this._bucketMask; ++i) {
            this.bucketLocks[i] = new Object();
        }
        --this._bucketMask;
    }

    public int getSize() {
        return this.size;
    }

    protected int getIndex(Long l) {
        return (int)l.longValue() & this._bucketMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, int n) {
        int n2 = this.getIndex(object);
        PassivatedSessionInfo passivatedSessionInfo = new PassivatedSessionInfo(object, n);
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            passivatedSessionInfo.next = this.buckets[n2];
            this.buckets[n2] = passivatedSessionInfo;
        }
        object2 = this.sizeLock;
        synchronized (object2) {
            ++this.size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassivatedSessionInfo get(Object object) {
        int n = this.getIndex(object);
        Object object2 = this.bucketLocks[n];
        synchronized (object2) {
            PassivatedSessionInfo passivatedSessionInfo = this.buckets[n];
            while (passivatedSessionInfo != null) {
                if (object.equals(passivatedSessionInfo.key)) {
                    return passivatedSessionInfo;
                }
                passivatedSessionInfo = passivatedSessionInfo.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassivatedSessionInfo remove(Object object) {
        int n = this.getIndex(object);
        PassivatedSessionInfo passivatedSessionInfo = null;
        PassivatedSessionInfo passivatedSessionInfo2 = null;
        Object object2 = this.bucketLocks[n];
        synchronized (object2) {
            passivatedSessionInfo2 = this.buckets[n];
            while (passivatedSessionInfo2 != null) {
                if (object.equals(passivatedSessionInfo2.key)) {
                    if (passivatedSessionInfo == null) {
                        this.buckets[n] = passivatedSessionInfo2.next;
                    } else {
                        passivatedSessionInfo.next = passivatedSessionInfo2.next;
                    }
                    passivatedSessionInfo2.next = null;
                    break;
                }
                passivatedSessionInfo = passivatedSessionInfo2;
                passivatedSessionInfo2 = passivatedSessionInfo2.next;
            }
        }
        if (passivatedSessionInfo2 != null) {
            object2 = this.sizeLock;
            synchronized (object2) {
                --this.size;
            }
        }
        return passivatedSessionInfo2;
    }

    public void cancelTimerTasks() {
        try {
            this.idleBeanCleanerTimerTask.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        for (int i = 0; i <= this._bucketMask; ++i) {
            PassivatedSessionInfo passivatedSessionInfo = null;
            Object object = this.bucketLocks[i];
            synchronized (object) {
                passivatedSessionInfo = this.buckets[i];
                while (passivatedSessionInfo != null) {
                    this.cacheStore.remove(passivatedSessionInfo.key);
                    passivatedSessionInfo = passivatedSessionInfo.next;
                }
                this.buckets[i] = null;
                continue;
            }
        }
        this.container = null;
        this.buckets = null;
        this.bucketLocks = null;
        this.idleBeanCleanerTimerTask = null;
        this.loader = null;
        this.cacheStore = null;
        this.sizeLock = null;
        this.numExpiredLock = null;
    }

    public int getNumExpiredSessionsRemoved() {
        return this.numExpiredSessionsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementExpiredSessionsRemoved() {
        Object object = this.numExpiredLock;
        synchronized (object) {
            ++this.numExpiredSessionsRemoved;
        }
    }

    private class ASyncPassivator
    implements Servicable {
        private ASyncPassivator() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            ClassLoader classLoader2 = PassivatedBeansCache.this.loader;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Removal Work started");
            }
            try {
                try {
                    thread.setContextClassLoader(PassivatedBeansCache.this.loader);
                    ArrayList<PassivatedSessionInfo> arrayList = new ArrayList<PassivatedSessionInfo>();
                    int n = (int)(System.currentTimeMillis() / 1000L) - PassivatedBeansCache.this.removalTimeoutInSeconds;
                    for (int i = 0; i <= PassivatedBeansCache.this._bucketMask; ++i) {
                        PassivatedSessionInfo passivatedSessionInfo = null;
                        PassivatedSessionInfo passivatedSessionInfo2 = null;
                        Object object = PassivatedBeansCache.this.bucketLocks[i];
                        synchronized (object) {
                            passivatedSessionInfo2 = PassivatedBeansCache.this.buckets[i];
                            while (passivatedSessionInfo2 != null) {
                                if (passivatedSessionInfo2.lastAccessedAt <= n) {
                                    PassivatedSessionInfo passivatedSessionInfo3 = passivatedSessionInfo2;
                                    if (passivatedSessionInfo == null) {
                                        PassivatedBeansCache.this.buckets[i] = passivatedSessionInfo2.next;
                                        passivatedSessionInfo2 = PassivatedBeansCache.this.buckets[i];
                                    } else {
                                        passivatedSessionInfo2 = passivatedSessionInfo.next = passivatedSessionInfo2.next;
                                    }
                                    passivatedSessionInfo3.next = null;
                                    arrayList.add(passivatedSessionInfo3);
                                    continue;
                                }
                                passivatedSessionInfo = passivatedSessionInfo2;
                                passivatedSessionInfo2 = passivatedSessionInfo2.next;
                            }
                            continue;
                        }
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Total victims selected for removal =  " + arrayList.size());
                    }
                    Object object = PassivatedBeansCache.this.sizeLock;
                    synchronized (object) {
                        PassivatedBeansCache.this.size -= arrayList.size();
                    }
                    object = PassivatedBeansCache.this.numExpiredLock;
                    synchronized (object) {
                        PassivatedBeansCache.this.numExpiredSessionsRemoved += arrayList.size();
                    }
                    _logger.log(Level.FINE, "cacheStore = " + PassivatedBeansCache.this.cacheStore + "   removeExpired is going to be called");
                    PassivatedBeansCache.this.cacheStore.setRemovalTimeoutInSeconds(PassivatedBeansCache.this.removalTimeoutInSeconds);
                    PassivatedBeansCache.this.cacheStore.removeExpired(arrayList);
                }
                catch (Throwable throwable) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "[" + PassivatedBeansCache.this.cacheName + "]: Timer task got Exception:", throwable);
                    }
                    Object var15_17 = null;
                    thread.setContextClassLoader(classLoader);
                    PassivatedBeansCache.this.addedIdleBeanWork = false;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Timer Task completed");
                    }
                }
                Object var15_16 = null;
                thread.setContextClassLoader(classLoader);
                PassivatedBeansCache.this.addedIdleBeanWork = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Timer Task completed");
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                thread.setContextClassLoader(classLoader);
                PassivatedBeansCache.this.addedIdleBeanWork = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Timer Task completed");
                }
                throw throwable;
            }
        }
    }

    private class IdleBeanCleanerTimerTask
    extends TimerTask {
        Object lock;

        IdleBeanCleanerTimerTask() {
        }

        IdleBeanCleanerTimerTask(Object object) {
            this.lock = object;
        }

        public void run() {
            block5: {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: IdleBeanCleanerTimer Task started");
                }
                if (PassivatedBeansCache.this.addedIdleBeanWork) {
                    return;
                }
                try {
                    ASyncPassivator aSyncPassivator = new ASyncPassivator();
                    ContainerWorkPool.addLast(aSyncPassivator);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "[" + PassivatedBeansCache.this.cacheName + "]: Removal Work added");
                    }
                    PassivatedBeansCache.this.addedIdleBeanWork = true;
                }
                catch (Exception exception) {
                    if (!_logger.isLoggable(Level.WARNING)) break block5;
                    _logger.log(Level.WARNING, "Cannot perform idle bean cleanup", exception);
                }
            }
        }
    }
}

