/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import java.util.Properties;

public class NRUSessionCache
extends LruSessionCache {
    protected boolean doOrdering = false;
    protected int orderingThreshold = 0;

    public NRUSessionCache(String string, StatefulSessionContainer statefulSessionContainer, int n, int n2) {
        super("NRU-" + string, statefulSessionContainer, n, n2);
    }

    public void init(int n, float f, Properties properties) {
        super.init(n, f, properties);
        this.orderingThreshold = (int)(0.75 * (double)this.threshold);
    }

    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem cacheItem) {
        BaseCache.CacheItem cacheItem2 = super.itemAdded(cacheItem);
        this.doOrdering = this.entryCount >= this.orderingThreshold;
        return cacheItem2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        NRUSessionCache nRUSessionCache = this;
        synchronized (nRUSessionCache) {
            if (lruCacheItem.isTrimmed) {
                lruCacheItem.isTrimmed = false;
                BaseCache.CacheItem cacheItem2 = super.itemAdded(cacheItem);
                if (cacheItem2 != null) {
                    this.trimItem(cacheItem2);
                }
            } else if (this.doOrdering) {
                super.itemAccessed(cacheItem);
            }
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem cacheItem, int n) {
    }

    protected void itemRemoved(BaseCache.CacheItem cacheItem) {
        super.itemRemoved(cacheItem);
        this.doOrdering = this.entryCount >= this.orderingThreshold;
    }

    public void trimTimedoutItems(int n) {
        if (this.doOrdering) {
            super.trimTimedoutItems(n);
        } else {
            this.trimUnSortedTimedoutItems(n);
        }
    }
}

