/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.ejb.containers.util.cache.PassivatedBeansCache;
import com.sun.ejb.containers.util.cache.PassivatedSessionInfo;
import com.sun.ejb.spi.SFSBBeanState;
import com.sun.ejb.spi.SFSBStoreManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TimerTask;
import java.util.logging.Level;
import javax.ejb.EJBException;

public class LruSessionCache
extends LruCache {
    protected static final int IN_CACHE = 0;
    protected static final int ALIVE = 1;
    protected static final int PASSIVATED = 2;
    protected PassivatedBeansCache passivatedSessions;
    protected Object activatedLock;
    protected int numActivated;
    protected SFSBStoreManager cacheStore;
    protected int cacheIdleTimeoutInSeconds;
    protected int removalTimeoutInSeconds;
    protected StatefulSessionContainer container;
    protected IdleBeanCleanerTimerTask idleBeanCleanerTimerTask;
    protected Object idleBeanCleanerTimerTaskLock;
    protected boolean addedIdleBeanCleanerTimerTask;
    protected Object loadCountLock;
    protected int loadFromBackupCount;
    protected boolean removeIfIdle;
    public int passivationCount;
    protected Object passivationCountLock;
    private Object numPassLock;
    private int numPassivations;
    private int numPassivationSuccess;
    private int numPassivationErrors;
    private int numVictimsAccessed;

    public void destroy() {
        this.cacheStore = null;
        this.container = null;
        this.idleBeanCleanerTimerTask = null;
        super.destroy();
    }

    public LruSessionCache(String string, StatefulSessionContainer statefulSessionContainer, int n, int n2) {
        block3: {
            this.activatedLock = new Object();
            this.idleBeanCleanerTimerTaskLock = new Object();
            this.addedIdleBeanCleanerTimerTask = false;
            this.loadCountLock = new Object();
            this.removeIfIdle = false;
            this.passivationCount = 0;
            this.passivationCountLock = new Object();
            this.numPassLock = new Object();
            this.numVictimsAccessed = 0;
            super.setCacheName(string);
            this.container = statefulSessionContainer;
            this.cacheIdleTimeoutInSeconds = n <= 0 ? 0 : n;
            this.removalTimeoutInSeconds = n2 <= 0 ? 0 : n2;
            this.passivatedSessions = new PassivatedBeansCache(string, statefulSessionContainer, this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds ? 0 : this.removalTimeoutInSeconds);
            this.passivatedSessions.init(8192);
            if (this.cacheIdleTimeoutInSeconds > 0) {
                this.timeout = this.cacheIdleTimeoutInSeconds * 1000;
                try {
                    this.idleBeanCleanerTimerTask = new IdleBeanCleanerTimerTask(this.idleBeanCleanerTimerTaskLock);
                    ContainerFactoryImpl.getTimer().scheduleAtFixedRate((TimerTask)this.idleBeanCleanerTimerTask, this.cacheIdleTimeoutInSeconds * 1000, (long)(this.cacheIdleTimeoutInSeconds * 1000));
                }
                catch (Throwable throwable) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "[LruSessionCache]: Could not add PoolTimerTask. Continuing anyway...", throwable);
                }
            }
        }
        this.removeIfIdle = this.removalTimeoutInSeconds <= this.cacheIdleTimeoutInSeconds;
    }

    public void setSessionCacheStore(SFSBStoreManager sFSBStoreManager) {
        this.cacheStore = sFSBStoreManager;
        this.passivatedSessions.setSessionCacheStore(sFSBStoreManager);
    }

    public void cancelTimerTasks() {
        try {
            this.idleBeanCleanerTimerTask.cancel();
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[LruSessionCache] cancelTimerTasks():  Exception when cancelling CacheIdleCleanerTask", exception);
        }
        try {
            this.passivatedSessions.cancelTimerTasks();
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[LruSessionCache] cancelTimerTasks():  Exception when cancelling IdlePassivatedBeansTask", exception);
        }
    }

    protected void trimItem(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        if (this.removeIfIdle) {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)cacheItem.value;
            long l = System.currentTimeMillis() - (long)(this.removalTimeoutInSeconds * 1000);
            if (sessionContextImpl.getLastTimeUsed() <= l) {
                this.container.passivateEJB(sessionContextImpl);
                return;
            }
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheListener cacheListener = (CacheListener)this.listeners.get(i);
            cacheListener.trimEvent(lruCacheItem.key, lruCacheItem.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (lruCacheItem.isTrimmed) {
                lruCacheItem.isTrimmed = false;
                ++this.numVictimsAccessed;
                BaseCache.CacheItem cacheItem2 = super.itemAdded(cacheItem);
                if (cacheItem2 != null) {
                    this.trimItem(cacheItem2);
                }
            } else {
                super.itemAccessed(cacheItem);
            }
        }
    }

    protected Object loadFromBackup(PassivatedSessionInfo passivatedSessionInfo, Object object, StatefulSessionContainer statefulSessionContainer, EJBLocalRemoteObject eJBLocalRemoteObject) {
        try {
            SFSBBeanState sFSBBeanState = this.loadState(object);
            _logger.finest("LruSessionCache.loadFromBackup beanState :=>" + sFSBBeanState);
            if (sFSBBeanState == null) {
                _logger.log(Level.INFO, ": No Bean found for  BACKUPSTORE FOR Key : <" + object + ">");
                return null;
            }
            if (sFSBBeanState.getState() == null) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.cacheName + ": Cannot load from " + " BACKUPSTORE FOR Key: <" + object + ">");
                }
                return null;
            }
            this.incrementLoadFromBackupCount();
            return EJBUtils.deserializeObject(sFSBBeanState.getState(), statefulSessionContainer.getClassLoader());
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, this.cacheName + ": Exception while " + " loading from backup session: <" + object + ">", exception);
            }
            return null;
        }
        catch (Error error) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, this.cacheName + ": Error while " + " loading from backup session: <" + object + ">", error);
            }
            return null;
        }
    }

    public int getLoadFromBackupCount() {
        return this.loadFromBackupCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLoadFromBackupCount() {
        Object object = this.loadCountLock;
        synchronized (object) {
            ++this.loadFromBackupCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionContextImpl lookupEJB(Object object, StatefulSessionContainer statefulSessionContainer, EJBLocalRemoteObject eJBLocalRemoteObject) {
        int n = this.hash(object);
        int n2 = this.getIndex(n);
        Object object2 = null;
        BaseCache.CacheItem cacheItem = null;
        PassivatedSessionInfo passivatedSessionInfo = null;
        Object object3 = this.bucketLocks[n2];
        synchronized (object3) {
            cacheItem = this.buckets[n2];
            while (!(cacheItem == null || n == cacheItem.hashCode && cacheItem.key.equals(object))) {
                cacheItem = cacheItem.next;
            }
            if (cacheItem != null) {
                object2 = cacheItem.getValue();
                this.itemAccessed(cacheItem);
            } else {
                passivatedSessionInfo = this.passivatedSessions.get(object);
            }
        }
        if (cacheItem != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
            if (passivatedSessionInfo != null) {
                object3 = passivatedSessionInfo;
                synchronized (object3) {
                    object2 = this.loadFromBackup(passivatedSessionInfo, object, statefulSessionContainer, eJBLocalRemoteObject);
                    if (object2 == null) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.WARNING, "[" + this.cacheName + ".1]: Invalid sessionID: " + object);
                        }
                        return null;
                    }
                }
            } else {
                object2 = this.loadFromBackup(passivatedSessionInfo, object, statefulSessionContainer, eJBLocalRemoteObject);
                if (object2 == null) {
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, "[" + this.cacheName + ".1]: Invalid sessionID: " + object);
                    }
                    return null;
                }
            }
            boolean bl = false;
            BaseCache.CacheItem cacheItem2 = null;
            Object object4 = this.bucketLocks[n2];
            synchronized (object4) {
                cacheItem = this.buckets[n2];
                while (!(cacheItem == null || n == cacheItem.hashCode && cacheItem.key.equals(object))) {
                    cacheItem = cacheItem.next;
                }
                if (cacheItem != null) {
                    object2 = cacheItem.getValue();
                } else {
                    BaseCache.CacheItem cacheItem3 = this.createItem(n, object, object2, -1);
                    cacheItem3.next = this.buckets[n2];
                    this.buckets[n2] = cacheItem3;
                    bl = true;
                    cacheItem2 = this.itemAdded(cacheItem3);
                }
            }
            if (bl) {
                try {
                    if (cacheItem2 != null) {
                        this.trimItem(cacheItem2);
                    }
                    statefulSessionContainer.activateEJB((SessionContextImpl)object2, object, eJBLocalRemoteObject);
                    this.incrementEntryCount();
                }
                catch (EJBException eJBException) {
                    this.remove(object);
                    return null;
                }
            }
        }
        return (SessionContextImpl)object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        int n = this.hash(object);
        int n2 = this.getIndex(n);
        BaseCache.CacheItem cacheItem = null;
        BaseCache.CacheItem cacheItem2 = null;
        PassivatedSessionInfo passivatedSessionInfo = null;
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheItem2 = this.buckets[n2];
            while (cacheItem2 != null) {
                if (n == cacheItem2.hashCode && object.equals(cacheItem2.key)) {
                    if (cacheItem == null) {
                        this.buckets[n2] = cacheItem2.next;
                    } else {
                        cacheItem.next = cacheItem2.next;
                    }
                    cacheItem2.next = null;
                    this.itemRemoved(cacheItem2);
                    break;
                }
                cacheItem = cacheItem2;
                cacheItem2 = cacheItem2.next;
            }
            if (cacheItem2 == null) {
                passivatedSessionInfo = this.passivatedSessions.remove(object);
            }
        }
        if (cacheItem2 != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        try {
            this.removeState(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _logger.finest("Unable to remove stateful session bean from store : " + exception);
        }
        return null;
    }

    public void removePassivatedEJB(Object object) {
        try {
            this.remove(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean passivateEJB(SessionContextImpl sessionContextImpl, Object object) {
        try {
            Object object2;
            int n = this.hash(object);
            int n2 = this.getIndex(n);
            Object var5_6 = null;
            boolean bl = false;
            BaseCache.CacheItem cacheItem = null;
            BaseCache.CacheItem cacheItem2 = null;
            Object object3 = this.bucketLocks[n2];
            synchronized (object3) {
                cacheItem2 = this.buckets[n2];
                while (cacheItem2 != null) {
                    if (cacheItem2.value == sessionContextImpl) {
                        object2 = (LruCache.LruCacheItem)cacheItem2;
                        if (((LruCache.LruCacheItem)object2).isTrimmed) break;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": session accessed after marked for passivation: " + object);
                        }
                        return false;
                    }
                    cacheItem = cacheItem2;
                    cacheItem2 = cacheItem2.next;
                }
                if (cacheItem2 == null) {
                    return this.passivatedSessions.get(object) != null;
                }
                if (this.removeIfIdle) {
                    long l = System.currentTimeMillis() - (long)(this.removalTimeoutInSeconds * 1000);
                    if (sessionContextImpl.getLastTimeUsed() <= l) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.cacheName + ": Removing session " + " instead of passivating for key: " + object);
                        }
                        if (cacheItem == null) {
                            this.buckets[n2] = cacheItem2.next;
                        } else {
                            cacheItem.next = cacheItem2.next;
                        }
                        cacheItem2.next = null;
                        bl = true;
                        this.passivatedSessions.incrementExpiredSessionsRemoved();
                    }
                }
            }
            if (bl) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
                return true;
            }
            try {
                this.incrementNumPassivations();
                object3 = EJBUtils.serializeObject(sessionContextImpl);
                _logger.log(Level.FINE, "LruSessionCache.passivateEJB    beankey=" + object + "         ctx= " + sessionContextImpl + "         ctx.isNew()=" + sessionContextImpl.isNew());
                object2 = new SFSBBeanState(object, sessionContextImpl.getLastTimeUsed(), sessionContextImpl.isNew(), (byte[])object3);
                this.saveState((SFSBBeanState)object2);
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.cacheName + ": ERROR While passivating " + " key: " + object, exception);
                }
                this.incrementNumPassivationErrors();
                return false;
            }
            object3 = this.bucketLocks[n2];
            synchronized (object3) {
                cacheItem = null;
                cacheItem2 = this.buckets[n2];
                while (cacheItem2 != null) {
                    if (cacheItem2.value == sessionContextImpl) {
                        object2 = (LruCache.LruCacheItem)cacheItem2;
                        if (!((LruCache.LruCacheItem)object2).isTrimmed) {
                            return false;
                        }
                        if (cacheItem == null) {
                            this.buckets[n2] = cacheItem2.next;
                        } else {
                            cacheItem.next = cacheItem2.next;
                        }
                        cacheItem2.next = null;
                        break;
                    }
                    cacheItem = cacheItem2;
                    cacheItem2 = cacheItem2.next;
                }
                this.passivatedSessions.put(object, (int)(sessionContextImpl.getLastTimeUsed() / 1000L));
                this.incrementNumPassivationSuccess();
            }
            if (cacheItem2 != null) {
                this.decrementEntryCount();
                this.incrementRemovalCount();
            }
            return true;
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[" + this.cacheName + "]: passivateEJB(), Exception caught -> ", exception);
            return false;
        }
    }

    public boolean checkpointEJB(SessionContextImpl sessionContextImpl, Object object, boolean bl) {
        _logger.finest("LRUSessionCache.checkpointEJB called");
        try {
            byte[] byArray = EJBUtils.serializeObject(sessionContextImpl);
            SFSBBeanState sFSBBeanState = new SFSBBeanState(object, sessionContextImpl.getLastTimeUsed(), bl, byArray);
            this.saveState(sFSBBeanState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            _logger.log(Level.SEVERE, this.cacheName + ": ERROR While checkpointing " + " key:" + object, exception);
            return false;
        }
        return true;
    }

    private void saveState(SFSBBeanState sFSBBeanState) throws Exception {
        this.cacheStore.passivateSave(sFSBBeanState);
    }

    private synchronized SFSBBeanState loadState(Object object) throws Exception {
        return this.cacheStore.getState(object);
    }

    private synchronized void removeState(Object object) throws Exception {
        this.cacheStore.remove(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedVictims(ArrayList arrayList) {
        int n = arrayList.size();
        Object object = this;
        synchronized (object) {
            this.trimCount += n;
        }
        object = null;
        for (int i = 0; i < n; ++i) {
            object = (BaseCache.CacheItem)arrayList.get(i);
            this.trimItem((BaseCache.CacheItem)object);
        }
    }

    public void undeploy(StatefulSessionContainer statefulSessionContainer) {
        this.cancelTimerTasks();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)enumeration.nextElement();
            try {
                statefulSessionContainer.undeploy(sessionContextImpl);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.WARNING)) continue;
                _logger.log(Level.WARNING, "[" + this.cacheName + "]: Error while " + " undeploying SessionCache...", exception);
            }
        }
        this.passivatedSessions.undeploy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimTimedoutItems(int n) {
        int n2 = 0;
        long l = System.currentTimeMillis();
        long l2 = l - (long)(this.cacheIdleTimeoutInSeconds * 1000);
        ArrayList<LruCache.LruCacheItem> arrayList = new ArrayList<LruCache.LruCacheItem>();
        LruSessionCache lruSessionCache = this;
        synchronized (lruSessionCache) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask started...");
            }
            if (this.tail == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing 0 idle beans");
                }
                this.head = null;
                return;
            }
            LruCache.LruCacheItem lruCacheItem = this.tail;
            while (true) {
                EJBContextImpl eJBContextImpl;
                if ((eJBContextImpl = (EJBContextImpl)lruCacheItem.value) != null) {
                    if (eJBContextImpl.getLastTimeUsed() > l2 || !this.container.canPassivateEJB(eJBContextImpl)) break;
                    lruCacheItem.isTrimmed = true;
                    arrayList.add(lruCacheItem);
                }
                if (lruCacheItem == this.head && lruCacheItem.lPrev != null) {
                    _logger.log(Level.WARNING, "[" + this.cacheName + "]: TrimTimedoutBeans(), resetting head.lPrev");
                    lruCacheItem.lPrev = null;
                }
                if ((lruCacheItem = lruCacheItem.lPrev) == null) break;
                lruCacheItem.lNext.lPrev = null;
                lruCacheItem.lNext.lNext = null;
                lruCacheItem.lNext = null;
            }
            if (lruCacheItem == this.tail) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing 0 idle beans");
                }
                return;
            }
            if (lruCacheItem == null) {
                this.head = null;
            }
            this.tail = lruCacheItem;
            n2 = arrayList.size();
            this.listSize -= n2;
            this.trimCount += n2;
        }
        for (int i = 0; i < n2; ++i) {
            this.trimItem((LruCache.LruCacheItem)arrayList.get(i));
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing " + n2 + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimUnSortedTimedoutItems(int n) {
        int n2 = this.buckets.length;
        long l = System.currentTimeMillis() - this.timeout;
        ArrayList<LruCache.LruCacheItem> arrayList = new ArrayList<LruCache.LruCacheItem>();
        int n3 = 0;
        int n4 = 0;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask started...");
        }
        for (int i = 0; i < n2; ++i) {
            if (this.buckets[i] == null) continue;
            Object object = this.bucketLocks[i];
            synchronized (object) {
                BaseCache.CacheItem cacheItem = this.buckets[i];
                while (cacheItem != null) {
                    SessionContextImpl sessionContextImpl = (SessionContextImpl)cacheItem.value;
                    if (sessionContextImpl != null && sessionContextImpl.getLastTimeUsed() <= l && this.container.canPassivateEJB(sessionContextImpl)) {
                        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
                        LruSessionCache lruSessionCache = this;
                        synchronized (lruSessionCache) {
                            if (!lruCacheItem.isTrimmed) {
                                this.itemRemoved(lruCacheItem);
                                lruCacheItem.isTrimmed = true;
                                arrayList.add(lruCacheItem);
                            }
                        }
                    }
                    cacheItem = cacheItem.next;
                }
            }
            n3 = arrayList.size();
            if (n3 < this.container.getPassivationBatchCount()) continue;
            this.trimSelectedVictims(arrayList);
            n4 += n3;
            arrayList.clear();
        }
        n3 = arrayList.size();
        if (n3 > 0) {
            this.trimSelectedVictims(arrayList);
            n4 += n3;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "[" + this.cacheName + "]: IdleBeanCleanerTask " + " finished after removing " + n4 + " idle beans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivations() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivationSuccess() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivationSuccess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumPassivationErrors() {
        Object object = this.numPassLock;
        synchronized (object) {
            ++this.numPassivationErrors;
        }
    }

    public int getNumPassivations() {
        return this.numPassivations;
    }

    public int getNumPassivationErrors() {
        return this.numPassivationErrors;
    }

    public int getNumPassivationSuccess() {
        return this.numPassivationSuccess;
    }

    public int getExpiredSessionsRemoved() {
        return this.passivatedSessions.getNumExpiredSessionsRemoved();
    }

    public int getNumExpiredSessionsRemoved() {
        return this.passivatedSessions.getNumExpiredSessionsRemoved();
    }

    public int getNumVictimsAccessed() {
        return this.numVictimsAccessed;
    }

    private class IdleBeanPassivatorTask
    implements Servicable {
        private IdleBeanPassivatorTask() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        public void run() {
            block2: {
                try {
                    LruSessionCache.this.trimTimedoutItems(Integer.MAX_VALUE);
                }
                catch (Exception exception) {
                    if (!LruCache._logger.isLoggable(Level.WARNING)) break block2;
                    LruCache._logger.log(Level.WARNING, "[" + LruSessionCache.this.cacheName + "]: Exception while " + "removing idle beans", exception);
                }
            }
        }
    }

    private class IdleBeanCleanerTimerTask
    extends TimerTask {
        Object lock;

        IdleBeanCleanerTimerTask() {
        }

        IdleBeanCleanerTimerTask(Object object) {
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            Object object2 = this.lock;
            synchronized (object2) {
                if (LruSessionCache.this.addedIdleBeanCleanerTimerTask) {
                    return;
                }
                LruSessionCache.this.addedIdleBeanCleanerTimerTask = true;
            }
            try {
                try {
                    object2 = new IdleBeanPassivatorTask();
                    ContainerWorkPool.addLast(object2);
                }
                catch (Exception exception) {
                    if (LruCache._logger.isLoggable(Level.WARNING)) {
                        LruCache._logger.log(Level.WARNING, LruSessionCache.this.cacheName + ":Cannot add idle bean passivation task", exception);
                    }
                    Object var4_4 = null;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                        return;
                    }
                }
                Object var4_3 = null;
                object = this.lock;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Object object4 = this.lock;
                synchronized (object4) {
                    LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                    throw throwable;
                }
            }
            synchronized (object) {
                LruSessionCache.this.addedIdleBeanCleanerTimerTask = false;
                return;
            }
        }
    }
}

