/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.EJBObjectCache;
import com.sun.ejb.containers.util.cache.EJBObjectCacheListener;
import com.sun.ejb.containers.util.cache.LruCache;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class FIFOEJBObjectCache
extends LruCache
implements EJBObjectCache {
    protected int maxCacheSize;
    protected String name;
    protected EJBObjectCacheListener listener;
    protected Object refCountLock = new Object();
    protected int totalRefCount = 0;
    protected static boolean _printRefCount = false;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");

    public FIFOEJBObjectCache(String string) {
        this.name = string;
    }

    public FIFOEJBObjectCache(String string, long l) {
        super(l);
        this.name = string;
    }

    public void init(int n, int n2, long l, float f, Properties properties) {
        super.init(n, f, properties);
        this.timeout = l;
        this.maxCacheSize = n;
    }

    public void setEJBObjectCacheListener(EJBObjectCacheListener eJBObjectCacheListener) {
        this.listener = eJBObjectCacheListener;
    }

    public Object get(Object object) {
        int n = this.hash(object);
        return this.internalGet(n, object, false);
    }

    public Object get(Object object, boolean bl) {
        int n = this.hash(object);
        return this.internalGet(n, object, bl);
    }

    public Object put(Object object, Object object2) {
        int n = this.hash(object);
        return this.internalPut(n, object, object2, -1, false);
    }

    public Object put(Object object, Object object2, boolean bl) {
        int n = this.hash(object);
        return this.internalPut(n, object, object2, -1, bl);
    }

    public Object remove(Object object) {
        return this.internalRemove(object, true);
    }

    public Object remove(Object object, boolean bl) {
        return this.internalRemove(object, bl);
    }

    protected boolean isThresholdReached() {
        return this.listSize > this.maxCacheSize;
    }

    protected void itemAccessed(BaseCache.CacheItem cacheItem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRemoved(BaseCache.CacheItem cacheItem) {
        LruCache.LruCacheItem lruCacheItem = (LruCache.LruCacheItem)cacheItem;
        FIFOEJBObjectCache fIFOEJBObjectCache = this;
        synchronized (fIFOEJBObjectCache) {
            if (lruCacheItem.isTrimmed) {
                return;
            }
            LruCache.LruCacheItem lruCacheItem2 = lruCacheItem.lPrev;
            LruCache.LruCacheItem lruCacheItem3 = lruCacheItem.lNext;
            lruCacheItem.isTrimmed = true;
            if (lruCacheItem2 != null) {
                lruCacheItem2.lNext = lruCacheItem3;
            } else {
                this.head = lruCacheItem3;
            }
            if (lruCacheItem3 != null) {
                lruCacheItem3.lPrev = lruCacheItem2;
            } else {
                this.tail = lruCacheItem2;
            }
            --this.listSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalGet(int n, Object object, boolean bl) {
        int n2 = this.getIndex(n);
        Object object2 = null;
        BaseCache.CacheItem cacheItem = null;
        Object object3 = this.bucketLocks[n2];
        synchronized (object3) {
            cacheItem = this.buckets[n2];
            while (!(cacheItem == null || n == cacheItem.hashCode && this.eq(object, cacheItem.key))) {
                cacheItem = cacheItem.next;
            }
            if (cacheItem != null) {
                object2 = cacheItem.getValue();
                if (bl) {
                    EJBObjectCacheItem eJBObjectCacheItem = (EJBObjectCacheItem)cacheItem;
                    ++eJBObjectCacheItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                    if (!eJBObjectCacheItem.isTrimmed) {
                        this.itemRemoved(eJBObjectCacheItem);
                    }
                }
            }
        }
        if (cacheItem != null) {
            this.incrementHitCount();
        } else {
            this.incrementMissCount();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalPut(int n, Object object, Object object2, int n2, boolean bl) {
        int n3 = this.getIndex(n);
        BaseCache.CacheItem cacheItem = null;
        BaseCache.CacheItem cacheItem2 = null;
        EJBObjectCacheItem eJBObjectCacheItem = null;
        Object object3 = null;
        boolean bl2 = false;
        Object object4 = this.bucketLocks[n3];
        synchronized (object4) {
            BaseCache.CacheItem cacheItem3 = this.buckets[n3];
            while (cacheItem3 != null) {
                if (n == cacheItem3.hashCode && this.eq(object, cacheItem3.key)) {
                    cacheItem = cacheItem3;
                    break;
                }
                cacheItem3 = cacheItem3.next;
            }
            if (cacheItem == null) {
                eJBObjectCacheItem = (EJBObjectCacheItem)this.createItem(n, object, object2, n2);
                eJBObjectCacheItem.isTrimmed = bl;
                eJBObjectCacheItem.next = this.buckets[n3];
                this.buckets[n3] = eJBObjectCacheItem;
                if (bl) {
                    ++eJBObjectCacheItem.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                } else {
                    cacheItem2 = this.itemAdded(eJBObjectCacheItem);
                }
            } else {
                object3 = cacheItem.getValue();
                if (bl) {
                    EJBObjectCacheItem eJBObjectCacheItem2 = (EJBObjectCacheItem)cacheItem;
                    ++eJBObjectCacheItem2.refCount;
                    if (_printRefCount) {
                        this.incrementReferenceCount();
                    }
                }
            }
        }
        if (eJBObjectCacheItem != null) {
            this.incrementEntryCount();
            if (cacheItem2 != null && this.listener != null) {
                this.listener.handleOverflow(cacheItem2.key);
            }
        }
        return object3;
    }

    public void print() {
        System.out.println("EJBObjectCache:: size: " + this.getEntryCount() + "; listSize: " + this.listSize);
        LruCache.LruCacheItem lruCacheItem = this.head;
        while (lruCacheItem != null) {
            System.out.print("(" + lruCacheItem.key + ", " + lruCacheItem.value + ") ");
            lruCacheItem = lruCacheItem.lNext;
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object internalRemove(Object object, boolean bl) {
        int n = this.hash(object);
        int n2 = this.getIndex(n);
        BaseCache.CacheItem cacheItem = null;
        BaseCache.CacheItem cacheItem2 = null;
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheItem2 = this.buckets[n2];
            while (cacheItem2 != null) {
                if (n == cacheItem2.hashCode && object.equals(cacheItem2.key)) {
                    EJBObjectCacheItem eJBObjectCacheItem = (EJBObjectCacheItem)cacheItem2;
                    if (bl && eJBObjectCacheItem.refCount > 0) {
                        --eJBObjectCacheItem.refCount;
                        if (_printRefCount) {
                            this.decrementReferenceCount();
                        }
                    }
                    if (eJBObjectCacheItem.refCount > 0) {
                        return null;
                    }
                    if (cacheItem == null) {
                        this.buckets[n2] = cacheItem2.next;
                    } else {
                        cacheItem.next = cacheItem2.next;
                    }
                    cacheItem2.next = null;
                    this.itemRemoved(cacheItem2);
                    break;
                }
                cacheItem = cacheItem2;
                cacheItem2 = cacheItem2.next;
            }
        }
        if (cacheItem2 != null) {
            this.decrementEntryCount();
            this.incrementRemovalCount();
            this.incrementHitCount();
            return cacheItem2.value;
        }
        this.incrementMissCount();
        return null;
    }

    protected void trimItem(BaseCache.CacheItem cacheItem) {
    }

    protected BaseCache.CacheItem createItem(int n, Object object, Object object2, int n2) {
        return new EJBObjectCacheItem(n, object, object2, n2);
    }

    public Map getStats() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(totalRef=").append(this.totalRefCount).append("; ");
        stringBuffer.append("listSize=").append(this.listSize).append("; curSize/totSize=").append(this.getEntryCount()).append("/").append(this.maxEntries).append("; trim=").append(this.trimCount).append("; remove=").append(this.removalCount).append("; hit/miss=").append(this.hitCount).append("/").append(this.missCount).append(")");
        hashMap.put("[" + this.name + "]", stringBuffer.toString());
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimExpiredEntries(int n) {
        int n2;
        LruCache.LruCacheItem lruCacheItem;
        LruCache.LruCacheItem lruCacheItem2 = null;
        long l = System.currentTimeMillis();
        Object object = this;
        synchronized (object) {
            lruCacheItem = this.tail;
            for (n2 = 0; lruCacheItem != null && n2 < n && this.timeout != -1L && lruCacheItem.lastAccessed + this.timeout <= l; ++n2) {
                lruCacheItem.isTrimmed = true;
                lruCacheItem2 = lruCacheItem;
                lruCacheItem = lruCacheItem.lPrev;
            }
            if (lruCacheItem != this.tail) {
                lruCacheItem2.lPrev = null;
                if (lruCacheItem != null) {
                    lruCacheItem.lNext = null;
                } else {
                    this.head = null;
                }
                lruCacheItem2 = this.tail;
                this.tail = lruCacheItem;
            }
            this.listSize -= n2;
            this.trimCount += n2;
        }
        if (n2 > 0) {
            object = new ArrayList(n2);
            lruCacheItem = lruCacheItem2;
            while (lruCacheItem != null) {
                ((ArrayList)object).add(lruCacheItem.key);
                lruCacheItem = lruCacheItem.lPrev;
            }
            if (this.listener != null) {
                this.listener.handleBatchOverflow((ArrayList)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount() {
        Object object = this.refCountLock;
        synchronized (object) {
            --this.totalRefCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementReferenceCount(int n) {
        Object object = this.refCountLock;
        synchronized (object) {
            this.totalRefCount -= n;
        }
    }

    static void unitTest_1() throws Exception {
        String string;
        int n;
        Object object;
        int n2;
        FIFOEJBObjectCache fIFOEJBObjectCache = new FIFOEJBObjectCache("UnitTestCache");
        fIFOEJBObjectCache.init(512, null);
        int n3 = 14;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add("K_" + n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = (String)arrayList.get(n2);
            fIFOEJBObjectCache.put(object, object, n2 % 2 == 0);
        }
        System.out.println("****  Only odd numbered keys must be printed  ****");
        fIFOEJBObjectCache.print();
        System.out.println("**************************************************");
        for (n2 = 0; n2 < n3; ++n2) {
            object = (String)arrayList.get(n2);
            fIFOEJBObjectCache.get(object, n2 % 2 == 1);
        }
        System.out.println("****  NONE SHOULD BE PRINTED ****");
        fIFOEJBObjectCache.print();
        System.out.println("**************************************************");
        fIFOEJBObjectCache.put((Object)"K__15", (Object)"K__15", true);
        fIFOEJBObjectCache.put((Object)"K__16", (Object)"K__15", true);
        fIFOEJBObjectCache.get("K__16", true);
        fIFOEJBObjectCache.put("K__17", "K__17");
        System.out.println("****  Only K__17 must be printed ****");
        fIFOEJBObjectCache.print();
        System.out.println("**************************************************");
        for (n2 = 0; n2 < n3; ++n2) {
            object = (String)arrayList.get(n2);
            if (fIFOEJBObjectCache.remove(object) != null) continue;
            throw new RuntimeException("Remove must have returned null!!");
        }
        Object object2 = fIFOEJBObjectCache.remove("K__15");
        object = fIFOEJBObjectCache.remove("K__16");
        Object object3 = fIFOEJBObjectCache.remove("K__16");
        Object object4 = fIFOEJBObjectCache.remove("K__17");
        if (object2 == null) {
            System.out.println("** FAILED for K_15");
        }
        if (object != null) {
            System.out.println("** FAILED for K_16_1");
        }
        if (object3 == null) {
            System.out.println("** FAILED for K_16_2");
        }
        if (object4 == null) {
            System.out.println("** FAILED for K_17");
        }
        for (n = 0; n < n3; n += 2) {
            string = (String)arrayList.get(n);
            fIFOEJBObjectCache.put((Object)string, (Object)string, n % 4 == 0);
        }
        fIFOEJBObjectCache.print();
        for (n = 0; n < n3; n += 2) {
            string = (String)arrayList.get(n);
            fIFOEJBObjectCache.get(string, true);
        }
        fIFOEJBObjectCache.print();
        for (n = 1; n < n3; n += 2) {
            string = (String)arrayList.get(n);
            fIFOEJBObjectCache.put((Object)string, (Object)string, n % 9 == 0);
        }
        fIFOEJBObjectCache.print();
    }

    public static void main(String[] stringArray) throws Exception {
        FIFOEJBObjectCache.unitTest_1();
    }

    static {
        try {
            Properties properties = System.getProperties();
            _printRefCount = Boolean.valueOf(properties.getProperty("cache.printrefcount"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static class EJBObjectCacheItem
    extends LruCache.LruCacheItem {
        protected int refCount;

        protected EJBObjectCacheItem(int n, Object object, Object object2, int n2) {
            super(n, object, object2, n2);
        }
    }
}

