/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class LongHashMap {
    protected static final int DEFAULT_CAPACITY = 128;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static boolean debug = false;
    protected transient Entry[] table;
    protected float loadFactor;
    protected transient int size;
    protected int bucketmask;
    protected int capacity;
    protected int threshold;

    public LongHashMap() {
        this(128, 0.75f);
    }

    public LongHashMap(int n) {
        this(n, 0.75f);
    }

    public LongHashMap(int n, float f) {
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.table = new Entry[this.capacity];
        this.bucketmask = this.capacity - 1;
    }

    public boolean contains(long l) {
        int n = (int)l & this.bucketmask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(long l) {
        int n = (int)l & this.bucketmask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(long l, Object object) {
        int n = (int)l & this.bucketmask;
        Entry entry = this.table[n];
        while (entry != null) {
            if (entry.key == l) {
                Object object2 = entry.value;
                entry.value = object;
                return object2;
            }
            entry = entry.next;
        }
        this.table[n] = new Entry(l, object, this.table[n]);
        if (this.size++ >= this.threshold) {
            int n2 = 2 * this.capacity;
            Entry[] entryArray = new Entry[n2];
            this.transfer(entryArray);
            this.table = entryArray;
            this.capacity = n2;
            this.threshold = (int)((float)n2 * this.loadFactor);
            this.bucketmask = this.capacity - 1;
        }
        return null;
    }

    private void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        int n2 = n - 1;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n3 = (int)entry2.key & n2;
                entry2.next = entryArray[n3];
                entryArray[n3] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    public Object remove(long l) {
        Entry entry;
        int n = (int)l & this.bucketmask;
        Entry entry2 = entry = this.table[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.key == l) {
                --this.size;
                if (entry == entry2) {
                    this.table[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    public Enumeration elements() {
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < this.capacity; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                vector.addElement(entry.value);
                entry = entry.next;
            }
        }
        return vector.elements();
    }

    public Iterator values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.capacity; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                arrayList.add(entry.value);
                entry = entry.next;
            }
        }
        return arrayList.iterator();
    }

    public Iterator keys() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int i = 0; i < this.capacity; ++i) {
            Entry entry = this.table[i];
            while (entry != null) {
                arrayList.add(new Long(entry.key));
                entry = entry.next;
            }
        }
        return arrayList.iterator();
    }

    static class Entry {
        final long key;
        Object value;
        Entry next;

        Entry(long l, Object object, Entry entry) {
            this.key = l;
            this.value = object;
            this.next = entry;
        }

        public int hashCode() {
            return (int)this.key;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

