/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Counter;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.ejb.containers.util.cache.MonitorableCache;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class StatefulCacheMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static Object[][] attrNameTypeArray = new Object[][]{{"max-beans-in-cache", Counter.INTEGER}, {"total-beans-in-cache", Counter.INTEGER}, {"resize-quantity", Counter.INTEGER}, {"idle-timeout-in-seconds", Counter.INTEGER}, {"cache-hits", Counter.INTEGER}, {"cache-misses", Counter.INTEGER}, {"num-passivations", Counter.INTEGER}, {"num-passivation-errors", Counter.INTEGER}, {"num-passivation-success", Counter.INTEGER}, {"num-expired-sessions-removed", Counter.INTEGER}};
    MonitorableCache cache;
    StatefulSessionStore sfStore;
    private static Map attrNameTypeMap = StatefulCacheMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo = StatefulCacheMonitorMBean.createMBeanInfo(attrNameTypeMap);

    public StatefulCacheMonitorMBean(MonitorableCache monitorableCache, StatefulSessionStore statefulSessionStore) {
        this.cache = monitorableCache;
        this.sfStore = statefulSessionStore;
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        if (string.equals("max-beans-in-cache")) {
            return new Integer(this.cache.getMaxCacheSize());
        }
        if (string.equals("total-beans-in-cache")) {
            return new Integer(this.cache.getCurrentSize());
        }
        if (string.equals("resize-quantity")) {
            return new Integer(this.cache.getResizeQuantity());
        }
        if (string.equals("idle-timeout-in-seconds")) {
            return new Integer(this.cache.getIdleTimeoutInSeconds());
        }
        if (string.equals("cache-hits")) {
            return new Integer(this.cache.getCacheHits());
        }
        if (string.equals("cache-misses")) {
            return new Integer(this.cache.getCacheMisses());
        }
        if (string.equals("num-passivations")) {
            return new Integer(this.sfStore.getNumPassivations());
        }
        if (string.equals("num-passivation-errors")) {
            return new Integer(this.sfStore.getNumPassivationErrors());
        }
        if (string.equals("num-passivation-success")) {
            return new Integer(this.sfStore.getNumPassivationSuccess());
        }
        if (string.equals("num-expired-sessions-removed")) {
            return new Integer(this.sfStore.getExpiredSessionsRemoved());
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute");
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "ejb.new_attribute_exception", exception);
            }
        }
        return attributeList;
    }

    public void startMonitoring() {
    }

    public void stopMonitoring() {
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }
}

