/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.monitor;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.types.Counter;
import com.iplanet.ias.admin.monitor.types.MonitoredAttributeType;
import com.iplanet.ias.admin.monitor.types.StringMonitoredAttributeType;
import com.sun.logging.LogDomains;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class MethodMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private String methodName;
    private boolean monitorOn = false;
    private ThreadLocal excTimeLocal = new ThreadLocal();
    private Object counterLock = new Object();
    private int totalSuccess = 0;
    private int totalError = 0;
    private int totalInvocation = 0;
    private long excTime = -1L;
    private static Object[][] attrNameTypeArray = new Object[][]{{"method-name", StringMonitoredAttributeType.DEFAULT}, {"total-num-calls", Counter.INTEGER}, {"total-num-errors", Counter.LONG}, {"total-num-success", Counter.INTEGER}, {"execution-time-millis", Counter.LONG}};
    private static Map attrNameTypeMap = MethodMonitorMBean.createAttrNameTypeMap(attrNameTypeArray);
    private static MBeanInfo mBeanInfo = MethodMonitorMBean.createMBeanInfo(attrNameTypeMap);

    public MethodMonitorMBean(String string) {
        this.methodName = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke() {
        if (this.monitorOn) {
            this.excTimeLocal.set(new Long(System.currentTimeMillis()));
            Object object = this.counterLock;
            synchronized (object) {
                ++this.totalInvocation;
            }
        }
    }

    public void postInvoke(boolean bl) {
        if (bl) {
            this.postInvoke(null);
        } else {
            this.postInvoke(new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(Throwable throwable) {
        if (this.monitorOn) {
            Long l = (Long)this.excTimeLocal.get();
            Object object = this.counterLock;
            synchronized (object) {
                if (throwable == null) {
                    ++this.totalSuccess;
                    if (l != null) {
                        this.excTime = System.currentTimeMillis() - l;
                    }
                } else {
                    ++this.totalError;
                }
            }
            this.excTimeLocal.set(null);
        }
    }

    public Object getAttribute(String string) throws AttributeNotFoundException {
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        if (string.equals("method-name")) {
            return this.methodName;
        }
        if (string.equals("total-num-calls")) {
            return new Integer(this.totalInvocation);
        }
        if (string.equals("total-num-success")) {
            return new Integer(this.totalSuccess);
        }
        if (string.equals("total-num-errors")) {
            return new Integer(this.totalError);
        }
        if (string.equals("execution-time-millis")) {
            return new Long(this.excTime);
        }
        throw new AttributeNotFoundException("Cannot find " + string + " attribute");
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"));
        }
        AttributeList attributeList = new AttributeList();
        if (stringArray.length == 0) {
            return attributeList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "ejb.getattribute_exception", exception);
            }
        }
        return attributeList;
    }

    public void startMonitoring() {
        this.monitorOn = true;
        this.totalSuccess = 0;
        this.totalError = 0;
        this.totalInvocation = 0;
        this.excTime = 0L;
    }

    public void stopMonitoring() {
        this.totalSuccess = 0;
        this.totalError = 0;
        this.totalInvocation = 0;
        this.excTime = -1L;
        this.monitorOn = false;
    }

    public MBeanInfo getMBeanInfo() {
        return mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String string) {
        MonitoredAttributeType monitoredAttributeType = null;
        if (attrNameTypeMap != null && string != null) {
            monitoredAttributeType = (MonitoredAttributeType)attrNameTypeMap.get(string);
        }
        return monitoredAttributeType;
    }
}

