/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.deployment.BeanCacheDescriptor;
import com.iplanet.ias.deployment.BeanPoolDescriptor;
import com.iplanet.ias.deployment.IASEjbExtraDescriptors;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.monitor.EJBGenericMonitorMBean;
import com.sun.ejb.containers.monitor.PoolMonitorMBean;
import com.sun.ejb.containers.util.pool.AbstractPool;
import com.sun.ejb.containers.util.pool.NonBlockingPool;
import com.sun.ejb.containers.util.pool.ObjectFactory;
import com.sun.ejb.containers.util.pool.PoolException;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.rmi.PortableRemoteObject;
import javax.transaction.Transaction;

public final class StatelessSessionContainer
extends BaseContainer
implements ObjectFactory {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StatelessSessionContainer.class);
    private static final int POOLED = 1;
    private static final int INVOKING = 2;
    private static final int DESTROYED = 3;
    private static final int LOW_WATER_MARK = 100;
    private static final byte[] statelessInstanceKey = new byte[]{0, 0, 0, 1};
    private Method ejbCreateMethod = null;
    private Method homeCreateMethod = null;
    private Method localHomeCreateMethod = null;
    private EJBLocalObjectImpl theEJBLocalObject = null;
    private EJBObjectImpl theEJBObject = null;
    private EJBObject theEJBStub = null;
    private boolean isPoolClosed = false;
    protected AbstractPool pool;
    private IASEjbExtraDescriptors iased = null;
    private BeanCacheDescriptor beanCacheDes = null;
    private BeanPoolDescriptor beanPoolDes = null;
    private Server svr = null;
    private EjbContainer ejbContainer = null;
    private boolean isPoolInitializing = false;
    private PoolProperties poolProp = null;

    StatelessSessionContainer(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws Exception {
        super(ejbDescriptor, classLoader);
        try {
            this.ejbCreateMethod = this.ejbClass.getMethod("ejbCreate", null);
            if (this.isLocal) {
                this.localHomeCreateMethod = this.localHomeIntf.getMethod("create", null);
            }
            if (this.isRemote) {
                this.homeCreateMethod = this.homeIntf.getMethod("create", null);
            }
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.get_ejbcreate_method_exception", this.logParams);
                _logger.log(Level.SEVERE, "", exception);
            }
            _logger.log(Level.FINE, "Some exception occurred while looking up create method ", exception);
            throw exception;
        }
        EjbSessionDescriptor ejbSessionDescriptor = (EjbSessionDescriptor)ejbDescriptor;
        this.iased = ejbSessionDescriptor.getIASEjbExtraDescriptors();
        if (this.iased != null) {
            this.beanPoolDes = this.iased.getBeanPool();
        }
        try {
            ServerContext serverContext = ApplicationServer.getServerContext();
            this.svr = ServerBeansFactory.getServerBean(serverContext.getConfigContext());
        }
        catch (ConfigException configException) {
            configException.printStackTrace();
        }
        this.ejbContainer = this.svr.getEjbContainer();
        super.setMonitorOn(this.ejbContainer.isMonitoringEnabled());
    }

    public String getMonitorAttributeValues() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("STATELESS ").append(this.ejbDescriptor.getJndiName()).append(this.pool.getAllAttrValues());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected void initializeHome() throws Exception {
        Object object;
        super.initializeHome();
        if (this.isRemote) {
            this.theEJBObject = (EJBObjectImpl)this.ejbObjectClass.newInstance();
            this.theEJBObject.setContainer(this);
            object = this.protocolMgr.createReference((Remote)((Object)this.theEJBObject), this.ejbDescriptor.getUniqueId(), statelessInstanceKey, this.ejbObjectTieClass);
            this.theEJBStub = (EJBObject)PortableRemoteObject.narrow((Object)object, (Class)this.remoteIntf);
            this.theEJBObject.setStub(this.theEJBStub);
        }
        if (this.isLocal) {
            this.theEJBLocalObject = (EJBLocalObjectImpl)this.localEjbObjectClass.newInstance();
            this.theEJBLocalObject.setContainer(this);
        }
        object = new SessionContextFactory(this);
        this.poolProp = new PoolProperties();
        this.pool = new NonBlockingPool(this.ejbDescriptor.getJndiName(), (ObjectFactory)object, 0, this.poolProp.poolResizeQuantity, this.poolProp.maxPoolSize, this.poolProp.poolIdleTimeoutInSeconds);
        this.registerChildMonitorMBean(MonitoredObjectType.BEAN_POOL.getTypeName(), MonitoredObjectType.BEAN_POOL, new PoolMonitorMBean(this.pool));
    }

    public void onReady() {
        final Thread thread = Thread.currentThread();
        final ClassLoader classLoader = thread.getContextClassLoader();
        final ClassLoader classLoader2 = this.loader;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thread.setContextClassLoader(classLoader2);
                return null;
            }
        });
        this.isPoolInitializing = true;
        ((NonBlockingPool)this.pool).prepopulate(this.poolProp.steadyPoolSize);
        this.isPoolInitializing = false;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                thread.setContextClassLoader(classLoader);
                return null;
            }
        });
    }

    protected EJBGenericMonitorMBean createEJBMonitorMBean() {
        return new EJBGenericMonitorMBean(this, MonitoredObjectType.STATELESS_BEAN);
    }

    public EJBObject createEJBObject() throws CreateException, RemoteException {
        this.authorizeRemoteMethod(14);
        return this.theEJBObject;
    }

    public EJBLocalObject createEJBLocalObject() throws CreateException {
        this.authorizeLocalMethod(15);
        return this.theEJBLocalObject;
    }

    void removeBean(EJBLocalRemoteObject eJBLocalRemoteObject, Method method, boolean bl) throws RemoveException, EJBException {
    }

    void forceDestroyBean(EJBContextImpl eJBContextImpl) {
        if (eJBContextImpl.getState() == 3) {
            return;
        }
        eJBContextImpl.setState(3);
        this.pool.destroyObject(eJBContextImpl);
    }

    EJBObject getEJBObject(byte[] byArray) {
        return this.theEJBObject;
    }

    EJBLocalObjectImpl getEJBLocalObject(Object object) {
        return this.theEJBLocalObject;
    }

    public ComponentContext getContext(Invocation invocation) {
        try {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)this.pool.getObject(null);
            sessionContextImpl.setState(2);
            return sessionContextImpl;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SessionContextImpl createStatelessEJB() throws CreateException {
        SessionContextImpl sessionContextImpl;
        block11: {
            ComponentInvocation componentInvocation = null;
            try {
                try {
                    SessionBean sessionBean = (SessionBean)this.ejbClass.newInstance();
                    sessionContextImpl = new SessionContextImpl((EnterpriseBean)sessionBean, this);
                    componentInvocation = new ComponentInvocation(sessionBean, this);
                    this.invocationManager.preInvoke(componentInvocation);
                    sessionBean.setSessionContext((SessionContext)sessionContextImpl);
                    if (this.isRemote) {
                        sessionContextImpl.setEJBObjectImpl(this.theEJBObject);
                        sessionContextImpl.setEJBStub(this.theEJBStub);
                    }
                    if (this.isLocal) {
                        sessionContextImpl.setEJBLocalObjectImpl(this.theEJBLocalObject);
                    }
                    sessionContextImpl.setInstanceKey(statelessInstanceKey);
                    this.ejbCreateMethod.invoke((Object)sessionBean, null);
                    sessionContextImpl.setState(1);
                    ++this.numCreated;
                    if (this.debugMonitorFlag) {
                        this.timeLastCreated = System.currentTimeMillis();
                    }
                }
                catch (Exception exception) {
                    if (!this.isPoolInitializing) {
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, "ejb.stateless_ejbcreate_exception", exception.toString());
                        }
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, "Exception occurred while creating stateless ejb", exception);
                        }
                    }
                    throw new CreateException("Could not create stateless EJB: " + exception);
                }
                Object var5_5 = null;
                if (componentInvocation == null) break block11;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (componentInvocation != null) {
                    this.invocationManager.postInvoke(componentInvocation);
                }
                throw throwable;
            }
            this.invocationManager.postInvoke(componentInvocation);
        }
        sessionContextImpl.touch();
        return sessionContextImpl;
    }

    public void releaseContext(Invocation invocation) {
        SessionContextImpl sessionContextImpl = (SessionContextImpl)invocation.context;
        if (sessionContextImpl.getState() == 3) {
            return;
        }
        sessionContextImpl.setState(1);
        sessionContextImpl.setTransaction(null);
        sessionContextImpl.touch();
        this.pool.returnObject(sessionContextImpl);
    }

    boolean isIdentical(EJBObjectImpl eJBObjectImpl, EJBObject eJBObject) throws RemoteException {
        if (eJBObject == eJBObjectImpl) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical((Remote)eJBObjectImpl.getStub(), (Remote)eJBObject);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.ejb_getstub_exception", this.logParams);
                _logger.log(Level.SEVERE, "", exception);
            }
            _logger.log(Level.FINE, "Exception occurred while getting stub for the ejb", exception);
            throw new RemoteException("Error during isIdentical.", exception);
        }
    }

    void checkExists(EJBLocalRemoteObject eJBLocalRemoteObject) {
    }

    void afterBegin(EJBContextImpl eJBContextImpl) {
    }

    void beforeCompletion(EJBContextImpl eJBContextImpl) {
    }

    void afterCompletion(EJBContextImpl eJBContextImpl, int n) {
    }

    public boolean passivateEJB(ComponentContext componentContext) {
        return false;
    }

    public void activateEJB(Object object, Object object2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        this.undeployed = true;
        try {
            if (this.isRemote) {
                this.protocolMgr.destroyReference((Remote)((Object)this.theEJBObject), this.ejbDescriptor.getUniqueId());
            }
            this.isPoolClosed = true;
            this.pool.close();
            Object var2_1 = null;
            super.undeploy();
            this.ejbCreateMethod = null;
            this.homeCreateMethod = null;
            this.localHomeCreateMethod = null;
            this.theEJBLocalObject = null;
            this.theEJBObject = null;
            this.theEJBStub = null;
            this.pool = null;
            this.iased = null;
            this.beanCacheDes = null;
            this.beanPoolDes = null;
            this.svr = null;
            this.ejbContainer = null;
            this.poolProp = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.undeploy();
            this.ejbCreateMethod = null;
            this.homeCreateMethod = null;
            this.localHomeCreateMethod = null;
            this.theEJBLocalObject = null;
            this.theEJBObject = null;
            this.theEJBStub = null;
            this.pool = null;
            this.iased = null;
            this.beanCacheDes = null;
            this.beanPoolDes = null;
            this.svr = null;
            this.ejbContainer = null;
            this.poolProp = null;
            throw throwable;
        }
    }

    public Object create(Object object) throws PoolException {
        try {
            return this.createStatelessEJB();
        }
        catch (CreateException createException) {
            throw new EJBException((Exception)((Object)createException));
        }
    }

    public void destroy(Object object) {
        try {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)object;
            SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
            sessionContextImpl.setState(3);
            sessionContextImpl.setTransaction(null);
            sessionContextImpl.deleteAllReferences();
            this.transactionManager.componentDestroyed(sessionBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        _logger.log(Level.FINE, " Loading StatelessSessionContainer...");
    }

    private class PoolProperties {
        int maxPoolSize;
        int poolIdleTimeoutInSeconds;
        int poolResizeQuantity;
        int steadyPoolSize;

        public PoolProperties() {
            this.maxPoolSize = new Integer(StatelessSessionContainer.this.ejbContainer.getMaxPoolSize());
            this.poolIdleTimeoutInSeconds = new Integer(StatelessSessionContainer.this.ejbContainer.getPoolIdleTimeoutInSeconds());
            this.poolResizeQuantity = new Integer(StatelessSessionContainer.this.ejbContainer.getPoolResizeQuantity());
            this.steadyPoolSize = new Integer(StatelessSessionContainer.this.ejbContainer.getSteadyPoolSize());
            if (StatelessSessionContainer.this.beanPoolDes != null) {
                int n = 0;
                n = StatelessSessionContainer.this.beanPoolDes.getMaxPoolSize();
                if (n != -1) {
                    this.maxPoolSize = n;
                }
                if ((n = StatelessSessionContainer.this.beanPoolDes.getPoolIdleTimeoutInSeconds()) != -1) {
                    this.poolIdleTimeoutInSeconds = n;
                }
                if ((n = StatelessSessionContainer.this.beanPoolDes.getPoolResizeQuantity()) != -1) {
                    this.poolResizeQuantity = n;
                }
                if ((n = StatelessSessionContainer.this.beanPoolDes.getSteadyPoolSize()) != -1) {
                    this.steadyPoolSize = n;
                }
            }
        }
    }

    private class SessionContextFactory
    implements ObjectFactory {
        private StatelessSessionContainer sessionContainer;

        public SessionContextFactory(StatelessSessionContainer statelessSessionContainer2) {
            this.sessionContainer = statelessSessionContainer2;
        }

        public Object create(Object object) {
            try {
                return StatelessSessionContainer.this.createStatelessEJB();
            }
            catch (CreateException createException) {
                throw new EJBException((Exception)((Object)createException));
            }
        }

        public void destroy(Object object) {
            SessionContextImpl sessionContextImpl = (SessionContextImpl)object;
            SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
            if (sessionContextImpl.getState() != 3) {
                sessionContextImpl.setState(3);
                try {
                    sessionBean.ejbRemove();
                }
                catch (Exception exception) {}
            } else {
                Transaction transaction = sessionContextImpl.getTransaction();
                try {
                    if (transaction != null && transaction.getStatus() != 6) {
                        transaction.setRollbackOnly();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            StatelessSessionContainer.this.transactionManager.componentDestroyed(sessionBean);
            sessionContextImpl.setTransaction(null);
            ++StatelessSessionContainer.this.numDestroyed;
            if (StatelessSessionContainer.this.debugMonitorFlag) {
                StatelessSessionContainer.this.timeLastDestroyed = System.currentTimeMillis();
            }
            sessionContextImpl.deleteAllReferences();
            sessionContextImpl = null;
        }
    }
}

