/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.EjbContainer;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.deployment.BeanCacheDescriptor;
import com.iplanet.ias.deployment.IASEjbExtraDescriptors;
import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.SFSBStoreManagerFactory;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.monitor.StatefulCacheMonitorMBean;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.containers.util.cache.FIFOSessionCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.containers.util.cache.MonitorableCache;
import com.sun.ejb.containers.util.cache.NRUSessionCache;
import com.sun.ejb.containers.util.cache.UnBoundedSessionCache;
import com.sun.ejb.spi.SFSBStoreManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StatefulSessionStore
implements MonitorableCache {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private final boolean debug = false;
    private int bucketMask;
    private SFSBStoreManager cacheStore;
    private String passivationDirectoryName;
    LruSessionCache sessionCache;
    boolean addedIdleBeanWork = false;
    private int numPassivations;
    private int _maxBaseCacheSize = 4096;
    private int cacheSize = 0;
    private int numPassivationSucess;
    private int numPassivationErrors;
    CacheProperties cacheProp;
    private int numActivated;
    private long timeLastActivated;
    private EjbDescriptor desc;
    private boolean debugMonitorFlag = false;
    protected int numExpiredSessionsRemoved;

    protected StatefulSessionStore(StatefulSessionContainer statefulSessionContainer, EjbDescriptor ejbDescriptor) {
        this.desc = ejbDescriptor;
        ServerContext serverContext = ApplicationServer.getServerContext();
        InstanceEnvironment instanceEnvironment = serverContext.getInstanceEnvironment();
        Application application = ejbDescriptor.getApplication();
        String string = null;
        string = application.isVirtual() ? instanceEnvironment.getModulePassivatedEjbPath() : instanceEnvironment.getApplicationPassivatedEjbPath();
        this.passivationDirectoryName = string + File.separator + application.getRegistrationName() + File.separator + ejbDescriptor.getEjbClassName();
        _logger.log(Level.INFO, "[StatefulSessionStore] Passivation Directory: " + this.passivationDirectoryName);
        if (!statefulSessionContainer.getSFSBConfigReader().getAvailabilityEnabled()) {
            _logger.log(Level.INFO, " [StatefulSessionStore] Non-Availability mode deleting beans from " + this.passivationDirectoryName);
            String string2 = this.renamePassivationDir(this.passivationDirectoryName);
            if (string2 != null) {
                this.deleteFilesInDirEvent(string2);
            }
        }
        this.createCache(statefulSessionContainer, ejbDescriptor);
    }

    private void createCache(StatefulSessionContainer statefulSessionContainer, EjbDescriptor ejbDescriptor) {
        Object object;
        BeanCacheDescriptor beanCacheDescriptor = null;
        Server server = null;
        IASEjbExtraDescriptors iASEjbExtraDescriptors = ejbDescriptor.getIASEjbExtraDescriptors();
        if (iASEjbExtraDescriptors != null) {
            beanCacheDescriptor = iASEjbExtraDescriptors.getBeanCache();
        }
        EjbContainer ejbContainer = null;
        try {
            object = ApplicationServer.getServerContext();
            server = ServerBeansFactory.getServerBean(object.getConfigContext());
            ejbContainer = server.getEjbContainer();
        }
        catch (ConfigException configException) {
            _logger.log(Level.INFO, "", configException);
        }
        statefulSessionContainer.setMonitorOn(ejbContainer.isMonitoringEnabled());
        this.cacheProp = new CacheProperties(ejbContainer, beanCacheDescriptor);
        this.cacheSize = this.cacheProp.maxCacheSize;
        object = ejbDescriptor.getEjbClassName();
        this.sessionCache = this.cacheProp.maxCacheSize <= 0 ? new UnBoundedSessionCache((String)object, statefulSessionContainer, this.cacheProp.cacheIdleTimeoutInSeconds, this.cacheProp.removalTimeoutInSeconds) : (this.cacheProp.victimSelectionPolicy.equalsIgnoreCase("lru") ? new LruSessionCache((String)object, statefulSessionContainer, this.cacheProp.cacheIdleTimeoutInSeconds, this.cacheProp.removalTimeoutInSeconds) : (this.cacheProp.victimSelectionPolicy.equalsIgnoreCase("fifo") ? new FIFOSessionCache((String)object, statefulSessionContainer, this.cacheProp.cacheIdleTimeoutInSeconds, this.cacheProp.removalTimeoutInSeconds) : new NRUSessionCache((String)object, statefulSessionContainer, this.cacheProp.cacheIdleTimeoutInSeconds, this.cacheProp.removalTimeoutInSeconds)));
        float f = (float)(1.0 - 1.0 * (double)this.cacheProp.numberOfVictimsToSelect / (double)this.cacheProp.maxCacheSize);
        if (f < 0.0f || f > 1.0f) {
            f = 0.75f;
        }
        if (this.cacheProp.maxCacheSize <= 0) {
            this.sessionCache.init(16384, f, null);
        } else {
            this.sessionCache.init(this.cacheProp.maxCacheSize, f, null);
        }
        SFSBStoreManagerFactory sFSBStoreManagerFactory = SFSBStoreManagerFactory.getInstance(statefulSessionContainer);
        this.cacheStore = sFSBStoreManagerFactory.getSFSBStoreManager(this, ejbDescriptor, this.cacheProp.removalTimeoutInSeconds);
        this.cacheStore.setContainer(statefulSessionContainer);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("max-beans-in-cache", new Integer(this.cacheProp.maxCacheSize));
        hashMap.put("cache-resize-quantity", new Integer(this.cacheProp.numberOfVictimsToSelect));
        hashMap.put("resize-quantity", new Integer(this.cacheProp.numberOfVictimsToSelect));
        hashMap.put("idle-timeout-in-seconds", new Integer(this.cacheProp.cacheIdleTimeoutInSeconds));
        statefulSessionContainer.registerChildMonitorMBean(MonitoredObjectType.BEAN_CACHE.getTypeName(), MonitoredObjectType.BEAN_CACHE, new StatefulCacheMonitorMBean(this, this));
        this.sessionCache.setSessionCacheStore(this.cacheStore);
        this.sessionCache.addCacheListener(statefulSessionContainer);
        if (this.cacheProp.numberOfVictimsToSelect > 8) {
            statefulSessionContainer.passivationBatchCount = this.cacheProp.numberOfVictimsToSelect;
        }
    }

    BaseCache getSessionCache() {
        return this.sessionCache;
    }

    public SFSBStoreManager getSFSBStoreManager() {
        _logger.log(Level.INFO, "StatefulSessionStore.-getSFSBStoreManager   :" + this.cacheStore);
        return this.cacheStore;
    }

    public String getMonitorAttributeValues() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ SFCache (").append(this.desc.getJndiName()).append(") ");
        Map map = this.sessionCache.getStats();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string).append("=").append(map.get(string)).append("; ");
        }
        if (this.cacheProp.maxCacheSize > 0) {
            stringBuffer.append("; loadFromBackup=").append(this.sessionCache.getLoadFromBackupCount());
            stringBuffer.append("; passivationCount=").append(this.sessionCache.getNumPassivations());
            stringBuffer.append("; victimsAccessed=").append(this.sessionCache.getNumVictimsAccessed());
        }
        return stringBuffer.toString();
    }

    void storeEJB(Object object, SessionContextImpl sessionContextImpl) {
        this.sessionCache.put(object, sessionContextImpl);
    }

    void deleteEJB(Object object) {
        this.sessionCache.remove(object);
    }

    void removePassivatedEJB(Object object) {
        try {
            this.sessionCache.removePassivatedEJB(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    SessionContextImpl lookupEJB(Object object, StatefulSessionContainer statefulSessionContainer, EJBLocalRemoteObject eJBLocalRemoteObject) {
        return this.sessionCache.lookupEJB(object, statefulSessionContainer, eJBLocalRemoteObject);
    }

    Iterator listActiveEJBs() {
        ArrayList arrayList = new ArrayList();
        return arrayList.iterator();
    }

    public void undeploy(StatefulSessionContainer statefulSessionContainer) {
        if (this.sessionCache != null) {
            this.sessionCache.undeploy(statefulSessionContainer);
            this.sessionCache.destroy();
        }
        if (this.cacheStore != null) {
            this.cacheStore.deleteBeansForThisContainer();
        }
        this.cacheStore = null;
        this.sessionCache = null;
        this.desc = null;
    }

    Enumeration elements() {
        return new Vector().elements();
    }

    boolean passivateEJB(SessionContextImpl sessionContextImpl, Object object) {
        return this.sessionCache.passivateEJB(sessionContextImpl, object);
    }

    boolean checkpointEJB(SessionContextImpl sessionContextImpl, Object object, boolean bl) {
        _logger.log(Level.FINEST, "StatefulSessionStore.checkpointEJB called..........................");
        return this.sessionCache.checkpointEJB(sessionContextImpl, object, bl);
    }

    boolean isPassivationEnabled() {
        return true;
    }

    private void deleteFilesInDir(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File file = new File(string);
                    _logger.log(Level.INFO, "Preparing to delete passivated stateful session bean files in " + file.toString());
                    if (!file.isDirectory()) {
                        _logger.log(Level.WARNING, "deleteFilesIndir:: " + file.toString() + " is not a directory (continuing anyway...)");
                        return null;
                    }
                    File[] fileArray = file.listFiles();
                    boolean bl = false;
                    for (int i = 0; i < fileArray.length; ++i) {
                        bl = fileArray[i].delete();
                        if (bl) continue;
                        _logger.log(Level.SEVERE, "Could not delete file : " + fileArray[i]);
                    }
                    file.delete();
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "ejb.delete_passivated_sfsb_exception", exception);
                }
                return null;
            }
        });
    }

    private void deleteFilesInDirEvent(String string) {
        block2: {
            try {
                DeletePassivatedBeans deletePassivatedBeans = new DeletePassivatedBeans();
                deletePassivatedBeans.setfileToDeleteDir(string);
                ContainerWorkPool.addLast(deletePassivatedBeans);
            }
            catch (Exception exception) {
                if (!_logger.isLoggable(Level.WARNING)) break block2;
                _logger.log(Level.WARNING, "Cannot perform passivated bean store cleanup", exception);
            }
        }
    }

    private String renamePassivationDir(String string) {
        try {
            File file;
            String string2 = string;
            if (string2 != null && (file = new File(string2)).exists()) {
                if (file.isDirectory()) {
                    _logger.log(Level.INFO, "Preparing to rename passivated  stateful session bean files in " + file.toString());
                } else {
                    _logger.log(Level.WARNING, "renamePassivatedDir:: " + file.toString() + " is not a directory (still renaming it)");
                }
                String string3 = string2 + System.currentTimeMillis();
                File file2 = new File(string3);
                _logger.log(Level.INFO, "renamePassivatedDir:: renaming " + file.toString() + " to " + file2);
                boolean bl = file.renameTo(file2);
                _logger.log(Level.INFO, "renamePassivatedDir:: rename status: " + bl);
                return string3;
            }
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "renamePassivatedDir:: Exception  while renaming directory", throwable);
        }
        return null;
    }

    public int getNumPassivations() {
        return this.sessionCache.getNumPassivations();
    }

    public int getNumPassivationErrors() {
        return this.sessionCache.getNumPassivationErrors();
    }

    public int getNumPassivationSuccess() {
        return this.sessionCache.getNumPassivationSuccess();
    }

    public int getExpiredSessionsRemoved() {
        return this.sessionCache.getExpiredSessionsRemoved();
    }

    public int getNumExpiredSessionsRemoved() {
        return this.sessionCache.getNumExpiredSessionsRemoved();
    }

    public int getMaxCacheSize() {
        return this.cacheProp.maxCacheSize;
    }

    public int getCurrentSize() {
        return this.sessionCache.getEntryCount();
    }

    public int getResizeQuantity() {
        return this.cacheProp.numberOfVictimsToSelect;
    }

    public boolean isCacheOverflowAllowed() {
        return true;
    }

    public int getIdleTimeoutInSeconds() {
        return this.cacheProp.cacheIdleTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.cacheProp.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
        return this.cacheProp.victimSelectionPolicy;
    }

    public int getCacheHits() {
        Integer n = (Integer)this.sessionCache.getStatByName("cache.BaseCache.stat_hitCount");
        return n;
    }

    public int getCacheMisses() {
        Integer n = (Integer)this.sessionCache.getStatByName("cache.BaseCache.stat_missCount");
        return n;
    }

    public int getVictimCount() {
        return this.sessionCache.getNumPassivations();
    }

    private class DeletePassivatedBeans
    implements Servicable {
        private String fileToDeleteInDir;

        private DeletePassivatedBeans() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        public void run() {
            try {
                if (this.fileToDeleteInDir == null) {
                    return;
                }
                StatefulSessionStore.this.deleteFilesInDir(this.fileToDeleteInDir);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void setfileToDeleteDir(String string) {
            this.fileToDeleteInDir = string;
        }
    }

    private class CacheProperties {
        int maxCacheSize;
        int numberOfVictimsToSelect;
        boolean isCacheOverflowAllowed;
        int cacheIdleTimeoutInSeconds;
        String victimSelectionPolicy;
        int removalTimeoutInSeconds;

        public CacheProperties(EjbContainer ejbContainer, BeanCacheDescriptor beanCacheDescriptor) {
            this.numberOfVictimsToSelect = new Integer(ejbContainer.getCacheResizeQuantity());
            this.isCacheOverflowAllowed = true;
            this.maxCacheSize = new Integer(ejbContainer.getMaxCacheSize());
            this.cacheIdleTimeoutInSeconds = new Integer(ejbContainer.getCacheIdleTimeoutInSeconds());
            this.victimSelectionPolicy = ejbContainer.getVictimSelectionPolicy();
            this.removalTimeoutInSeconds = new Integer(ejbContainer.getRemovalTimeoutInSeconds());
            if (beanCacheDescriptor != null) {
                int n = 0;
                n = beanCacheDescriptor.getResizeQuantity();
                if (n != -1) {
                    this.numberOfVictimsToSelect = n;
                }
                if ((n = beanCacheDescriptor.getMaxCacheSize()) != -1) {
                    this.maxCacheSize = n;
                }
                if (beanCacheDescriptor.isIsCacheOverflowAllowed() != null) {
                    this.isCacheOverflowAllowed = beanCacheDescriptor.isIsCacheOverflowAllowed();
                }
                if ((n = beanCacheDescriptor.getCacheIdleTimeoutInSeconds()) != -1) {
                    this.cacheIdleTimeoutInSeconds = n;
                }
                if (beanCacheDescriptor.getVictimSelectionPolicy() != null) {
                    this.victimSelectionPolicy = beanCacheDescriptor.getVictimSelectionPolicy();
                }
                if ((n = beanCacheDescriptor.getRemovalTimeoutInSeconds()) != -1) {
                    this.removalTimeoutInSeconds = n;
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CacheProperties");
            stringBuffer.append(": max: ").append(this.maxCacheSize).append("; victims: ").append(this.numberOfVictimsToSelect).append("; overflow: ").append(this.isCacheOverflowAllowed ? "allowed" : "not-allowed").append("; idleTimeout: ").append(this.cacheIdleTimeoutInSeconds).append("; idleTimeout: ").append(this.victimSelectionPolicy);
            return stringBuffer.toString();
        }
    }
}

