/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.util.threadpool.Servicable;
import com.sun.appserv.util.cache.CacheListener;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.SFSBConfigReader;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.ejb.containers.monitor.EJBGenericMonitorMBean;
import com.sun.ejb.containers.util.ContainerWorkPool;
import com.sun.ejb.containers.util.cache.BaseCache;
import com.sun.ejb.spi.CheckpointPolicy;
import com.sun.ejb.spi.CheckpointPolicyImpl;
import com.sun.ejb.spi.SFSBUUIDUtil;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.NotSerializableException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.rmi.PortableRemoteObject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public final class StatefulSessionContainer
extends BaseContainer
implements CacheListener {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    static final int PASSIVE = 1;
    static final int READY = 2;
    static final int INVOKING = 3;
    static final int INCOMPLETE_TX = 4;
    static final int DESTROYED = 5;
    public static final int MIN_PASSIVATION_BATCH_COUNT = 8;
    private SFSBUUIDUtil uuidGenerator = null;
    private CheckpointPolicy checkpointPolicy = null;
    private SFSBConfigReader sfsbConfigReader = null;
    private StatefulSessionStore statefulBeanStore;
    protected ArrayList passivationCandidates = new ArrayList();
    Object asyncTaskSemaphore = new Object();
    BaseCache sessionBeanCache;
    int asyncTaskCount = 0;
    int asyncCummTaskCount = 0;
    int passivationBatchCount = 8;
    int containerTrimCount = 0;
    boolean requiresPassivation;

    protected StatefulSessionContainer(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws Exception {
        super(ejbDescriptor, classLoader);
        this.checkpointPolicy = new CheckpointPolicyImpl();
        this.checkpointPolicy.initializeCheckpointPolicy(this);
        this.sfsbConfigReader = new SFSBConfigReader(this.checkpointPolicy);
        this.statefulBeanStore = new StatefulSessionStore(this, ejbDescriptor);
        this.sessionBeanCache = this.statefulBeanStore.getSessionCache();
        this.uuidGenerator = this.statefulBeanStore.getSFSBStoreManager().getUUIDUtil();
    }

    protected EJBGenericMonitorMBean createEJBMonitorMBean() {
        return new EJBGenericMonitorMBean(this, MonitoredObjectType.STATEFUL_BEAN);
    }

    public CheckpointPolicy getCheckpointPolicy() {
        return this.checkpointPolicy;
    }

    public SFSBConfigReader getSFSBConfigReader() {
        return this.sfsbConfigReader;
    }

    public String getMonitorAttributeValues() {
        StringBuffer stringBuffer = new StringBuffer(this.statefulBeanStore.getMonitorAttributeValues());
        stringBuffer.append(" { asyncTaskCount=").append(this.asyncTaskCount).append("; asyncCummTaskCount=").append(this.asyncCummTaskCount).append("; passivationBatchCount=").append(this.passivationBatchCount).append("; passivationQSz=").append(this.passivationCandidates.size()).append("; trimEventCount=").append(this.containerTrimCount).append(" }").append("\n").append(this.statefulBeanStore.getSFSBStoreManager().getMonitorAttributeValues());
        return stringBuffer.toString();
    }

    boolean isIdentical(EJBObjectImpl eJBObjectImpl, EJBObject eJBObject) throws RemoteException {
        if (eJBObject == eJBObjectImpl) {
            return true;
        }
        try {
            return this.protocolMgr.isIdentical((Remote)eJBObjectImpl.getStub(), (Remote)eJBObject);
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.ejb_getstub_exception", exception.toString());
            }
            _logger.log(Level.FINE, "Some exception occurred while getting stub for ejb", exception);
            throw new RemoteException("Error during isIdentical.", exception);
        }
    }

    EJBObject createEJBObject() throws CreateException, RemoteException {
        try {
            SessionContextImpl sessionContextImpl = this.createBeanInstance();
            EJBObjectImpl eJBObjectImpl = this.createEJBObject(sessionContextImpl);
            sessionContextImpl.setState(2);
            ++this.numCreated;
            if (this.debugMonitorFlag) {
                this.timeLastCreated = System.currentTimeMillis();
            }
            return eJBObjectImpl;
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.create_ejbobject_exception", exception.toString());
            }
            _logger.log(Level.FINE, "Some exception occurred while creating ejbObject", exception);
            if (exception instanceof EJBException) {
                throw (EJBException)((Object)exception);
            }
            throw new CreateException("ERROR creating stateful SessionBean: " + exception);
        }
    }

    EJBLocalObject createEJBLocalObject() throws CreateException {
        try {
            SessionContextImpl sessionContextImpl = this.createBeanInstance();
            EJBLocalObjectImpl eJBLocalObjectImpl = this.createEJBLocalObject(sessionContextImpl);
            sessionContextImpl.setState(2);
            ++this.numCreated;
            if (this.debugMonitorFlag) {
                this.timeLastCreated = System.currentTimeMillis();
            }
            return eJBLocalObjectImpl;
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.create_ejblocalobject_exception", exception.toString());
            }
            _logger.log(Level.FINE, "Some exception occurred while creating ejbLocalObject", exception);
            if (exception instanceof EJBException) {
                throw (EJBException)((Object)exception);
            }
            throw new CreateException("ERROR creating stateful SessionBean: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionContextImpl createBeanInstance() throws Exception {
        SessionContextImpl sessionContextImpl;
        block2: {
            ComponentInvocation componentInvocation = null;
            try {
                SessionBean sessionBean = (SessionBean)this.ejbClass.newInstance();
                SessionContextImpl sessionContextImpl2 = new SessionContextImpl((EnterpriseBean)sessionBean, this);
                componentInvocation = new ComponentInvocation(sessionBean, this);
                this.invocationManager.preInvoke(componentInvocation);
                sessionBean.setSessionContext((SessionContext)sessionContextImpl2);
                sessionContextImpl2.touch();
                Object object = this.uuidGenerator.createSessionKey(sessionBean);
                this.sessionBeanCache.put(object, sessionContextImpl2);
                sessionContextImpl2.setInstanceKey(object);
                sessionContextImpl2.setNew(true);
                sessionContextImpl = sessionContextImpl2;
                Object var7_6 = null;
                if (componentInvocation == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (componentInvocation == null) break block3;
                    this.invocationManager.postInvoke(componentInvocation);
                }
                throw throwable;
            }
            this.invocationManager.postInvoke(componentInvocation);
        }
        return sessionContextImpl;
    }

    private EJBLocalObjectImpl createEJBLocalObject(SessionContextImpl sessionContextImpl) throws Exception {
        if (sessionContextImpl.getEJBLocalObjectImpl() != null) {
            return sessionContextImpl.getEJBLocalObjectImpl();
        }
        EJBLocalObjectImpl eJBLocalObjectImpl = (EJBLocalObjectImpl)this.localEjbObjectClass.newInstance();
        eJBLocalObjectImpl.setContainer(this);
        sessionContextImpl.setEJBLocalObjectImpl(eJBLocalObjectImpl);
        eJBLocalObjectImpl.setContext(sessionContextImpl);
        eJBLocalObjectImpl.setKey(sessionContextImpl.getInstanceKey());
        if (this.isRemote) {
            this.createEJBObject(sessionContextImpl);
        }
        return eJBLocalObjectImpl;
    }

    private EJBObjectImpl createEJBObject(SessionContextImpl sessionContextImpl) throws Exception {
        if (sessionContextImpl.getEJBObjectImpl() != null) {
            return sessionContextImpl.getEJBObjectImpl();
        }
        EJBObjectImpl eJBObjectImpl = (EJBObjectImpl)this.ejbObjectClass.newInstance();
        eJBObjectImpl.setContainer(this);
        sessionContextImpl.setEJBObjectImpl(eJBObjectImpl);
        eJBObjectImpl.setContext(sessionContextImpl);
        Object object = sessionContextImpl.getInstanceKey();
        eJBObjectImpl.setKey(object);
        byte[] byArray = this.uuidGenerator.keyToByteArray(object);
        _logger.finest("Container.createEJBObject-SessionContextImpl " + eJBObjectImpl);
        Object object2 = this.protocolMgr.createReference((Remote)((Object)eJBObjectImpl), this.ejbDescriptor.getUniqueId(), byArray, this.ejbObjectTieClass);
        EJBObject eJBObject = null;
        if (this.ejbObjectStubClass == null) {
            eJBObject = (EJBObject)PortableRemoteObject.narrow((Object)object2, (Class)this.remoteIntf);
            this.ejbObjectStubClass = eJBObject.getClass();
        } else {
            eJBObject = (EJBObject)this.protocolMgr.createStub(object2, this.ejbObjectStubClass);
        }
        sessionContextImpl.setEJBStub(eJBObject);
        eJBObjectImpl.setStub(eJBObject);
        if (this.isLocal) {
            this.createEJBLocalObject(sessionContextImpl);
        }
        return eJBObjectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeBean(EJBLocalRemoteObject eJBLocalRemoteObject, Method method, boolean bl) throws RemoveException, EJBException {
        Invocation invocation;
        block12: {
            invocation = new Invocation();
            invocation.ejbObject = eJBLocalRemoteObject;
            invocation.isLocal = bl;
            invocation.method = method;
            try {
                try {
                    this.preInvoke(invocation);
                    this.removeBean(invocation);
                }
                catch (Exception exception) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "ejb.preinvoke_exception", exception);
                    }
                    invocation.exception = exception;
                    Object var7_6 = null;
                    if (AppVerification.doInstrument()) {
                        AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, invocation.exception);
                    }
                    this.postInvoke(invocation);
                    break block12;
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (AppVerification.doInstrument()) {
                    AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, invocation.exception);
                }
                this.postInvoke(invocation);
                throw throwable;
            }
            if (AppVerification.doInstrument()) {
                AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, this.ejbRemoveMethod, invocation.exception);
            }
            this.postInvoke(invocation);
        }
        if (invocation.exception == null) {
            return;
        }
        if (invocation.exception instanceof RemoveException) {
            throw (RemoveException)invocation.exception;
        }
        if (invocation.exception instanceof RuntimeException) {
            throw (RuntimeException)invocation.exception;
        }
        if (invocation.exception instanceof Exception) {
            throw new EJBException((Exception)invocation.exception);
        }
        throw new EJBException(invocation.exception.getMessage());
    }

    private void removeBean(Invocation invocation) throws RemoveException {
        SessionContextImpl sessionContextImpl = null;
        boolean bl = false;
        try {
            sessionContextImpl = (SessionContextImpl)invocation.context;
            Transaction transaction = sessionContextImpl.getTransaction();
            if (transaction != null && transaction.getStatus() != 6) {
                bl = true;
                throw new RemoveException("Cannot remove EJB: transaction in progress");
            }
            SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
            sessionBean.ejbRemove();
            this.forceDestroyBean(sessionContextImpl);
        }
        catch (EJBException eJBException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.removebean_ejbexception", eJBException.toString());
            }
            _logger.log(Level.FINE, "EJBException in removing bean", eJBException);
            throw eJBException;
        }
        catch (RemoveException removeException) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.remove_exception", removeException.toString());
            }
            _logger.log(Level.FINE, "Remove exception occurred while removing bean", removeException);
            throw removeException;
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.removebean_generic_exception", exception.toString());
            }
            _logger.log(Level.FINE, "Some exception while removing bean", exception);
            throw new EJBException(exception);
        }
        finally {
            if (!bl) {
                this.forceDestroyBean(sessionContextImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceDestroyBean(EJBContextImpl eJBContextImpl) {
        SessionContextImpl sessionContextImpl;
        SessionContextImpl sessionContextImpl2 = sessionContextImpl = (SessionContextImpl)eJBContextImpl;
        synchronized (sessionContextImpl2) {
            EJBLocalRemoteObject eJBLocalRemoteObject;
            if (sessionContextImpl.getState() == 5) {
                return;
            }
            sessionContextImpl.setState(5);
            Transaction transaction = sessionContextImpl.getTransaction();
            try {
                if (transaction != null && transaction.getStatus() != 6) {
                    transaction.setRollbackOnly();
                }
            }
            catch (SystemException systemException) {
                throw new EJBException((Exception)((Object)systemException));
            }
            catch (IllegalStateException illegalStateException) {
                throw new EJBException((Exception)illegalStateException);
            }
            Object object = sessionContextImpl.getInstanceKey();
            this.sessionBeanCache.remove(object);
            if (this.isRemote) {
                eJBLocalRemoteObject = sessionContextImpl.getEJBObjectImpl();
                eJBLocalRemoteObject.clearContext();
                eJBLocalRemoteObject.setRemoved(true);
                sessionContextImpl.setEJBObjectImpl(null);
                this.protocolMgr.destroyReference((Remote)((Object)eJBLocalRemoteObject), this.ejbDescriptor.getUniqueId());
            }
            if (this.isLocal) {
                eJBLocalRemoteObject = sessionContextImpl.getEJBLocalObjectImpl();
                eJBLocalRemoteObject.clearContext();
                eJBLocalRemoteObject.setRemoved(true);
                sessionContextImpl.setEJBLocalObjectImpl(null);
            }
            this.transactionManager.componentDestroyed(sessionContextImpl.getEJB());
            ++this.numDestroyed;
            if (this.debugMonitorFlag) {
                this.timeLastDestroyed = System.currentTimeMillis();
            }
            sessionContextImpl.cacheEntry = null;
        }
    }

    Enumeration listActiveEJBs() {
        return new Vector().elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedoutBean(EJBContextImpl eJBContextImpl) {
        EJBContextImpl eJBContextImpl2 = eJBContextImpl;
        synchronized (eJBContextImpl2) {
            if (eJBContextImpl.getState() != 3) {
                try {
                    SessionBean sessionBean = (SessionBean)eJBContextImpl.getEJB();
                    sessionBean.ejbRemove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.forceDestroyBean(eJBContextImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBObject getEJBObject(byte[] byArray) {
        Object object = this.uuidGenerator.byteArrayToKey(byArray, 0, -1);
        SessionContextImpl sessionContextImpl = this.statefulBeanStore.lookupEJB(object, this, null);
        if (sessionContextImpl == null) {
            throw new NoSuchObjectLocalException("Invalid Session Key ( " + object + ")");
        }
        SessionContextImpl sessionContextImpl2 = sessionContextImpl;
        synchronized (sessionContextImpl2) {
            if (sessionContextImpl.getState() == 1 && ((sessionContextImpl = this.statefulBeanStore.lookupEJB(object, this, null)) == null || sessionContextImpl.getEJBObjectImpl() == null)) {
                throw new NoSuchObjectLocalException("The EJB does not exist for key = " + object + ".");
            }
            return sessionContextImpl.getEJBObjectImpl();
        }
    }

    EJBLocalObjectImpl getEJBLocalObject(Object object) {
        SessionContextImpl sessionContextImpl = this.statefulBeanStore.lookupEJB(object, this, null);
        if (sessionContextImpl == null || sessionContextImpl.getState() == 5) {
            try {
                EJBLocalObjectImpl eJBLocalObjectImpl = (EJBLocalObjectImpl)this.localEjbObjectClass.newInstance();
                eJBLocalObjectImpl.setContainer(this);
                eJBLocalObjectImpl.setKey(object);
                eJBLocalObjectImpl.setRemoved(true);
                return eJBLocalObjectImpl;
            }
            catch (Exception exception) {
                throw new EJBException(exception);
            }
        }
        return sessionContextImpl.getEJBLocalObjectImpl();
    }

    void checkExists(EJBLocalRemoteObject eJBLocalRemoteObject) {
        if (eJBLocalRemoteObject.isRemoved()) {
            throw new NoSuchObjectLocalException("Bean has been removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentContext getContext(Invocation invocation) {
        EJBLocalRemoteObject eJBLocalRemoteObject = invocation.ejbObject;
        SessionContextImpl sessionContextImpl = eJBLocalRemoteObject.getContext();
        Object object = eJBLocalRemoteObject.getKey();
        if (sessionContextImpl == null) {
            sessionContextImpl = this.statefulBeanStore.lookupEJB(object, this, eJBLocalRemoteObject);
        }
        if (sessionContextImpl == null || sessionContextImpl.getState() == 5) {
            throw new NoSuchObjectLocalException("The EJB does not exist.");
        }
        SessionContextImpl sessionContextImpl2 = sessionContextImpl;
        synchronized (sessionContextImpl2) {
            if (sessionContextImpl.getState() == 1) {
                sessionContextImpl = this.statefulBeanStore.lookupEJB(object, this, eJBLocalRemoteObject);
            }
            SessionContextImpl sessionContextImpl3 = sessionContextImpl;
            synchronized (sessionContextImpl3) {
                if (sessionContextImpl.getState() == 5) {
                    throw new NoSuchObjectLocalException("The EJB does not exist.");
                }
                if (sessionContextImpl.getState() == 3) {
                    throw new EJBException("SessionBean is executing another request");
                }
                sessionContextImpl.setState(3);
            }
        }
        sessionContextImpl.touch();
        return sessionContextImpl;
    }

    public void releaseContext(Invocation invocation) {
        SessionContextImpl sessionContextImpl = (SessionContextImpl)invocation.context;
        if (sessionContextImpl.getState() == 5) {
            return;
        }
        Transaction transaction = sessionContextImpl.getTransaction();
        try {
            if (transaction == null || transaction.getStatus() == 6) {
                int n;
                if (sessionContextImpl.getState() != 2) {
                    sessionContextImpl.setState(2);
                    if (sessionContextImpl.isAfterCompletionDelayed()) {
                        this.callEjbAfterCompletion(sessionContextImpl, sessionContextImpl.getCompletedTxStatus());
                        if (sessionContextImpl.isPendingCheckpoint() && this.checkpointPolicy.isCheckpointRequired()) {
                            this.doCheckpoint(sessionContextImpl);
                            sessionContextImpl.setPendingCheckpoint(false);
                        }
                    }
                }
                _logger.finest("Inside StatefulSessionContainer.releaseContext : just before checkpointing ++++++ ejbContext = " + sessionContextImpl);
                if (invocation.invocationInfo.isCreateHomeFinder) {
                    this.doPostInvokeCheckpoint(sessionContextImpl, invocation);
                }
                if ((n = invocation.invocationInfo.txAttr) == 7 || n == 1) {
                    this.doPostInvokeCheckpoint(sessionContextImpl, invocation);
                }
                if (n == 4 && !sessionContextImpl.isUsingClientTx()) {
                    this.doPostInvokeCheckpoint(sessionContextImpl, invocation);
                }
                if (n == 2) {
                    this.doPostInvokeCheckpointBMT(sessionContextImpl, invocation);
                }
            } else {
                sessionContextImpl.setState(4);
            }
        }
        catch (SystemException systemException) {
            throw new EJBException((Exception)((Object)systemException));
        }
    }

    void afterBegin(EJBContextImpl eJBContextImpl) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean enterpriseBean = eJBContextImpl.getEJB();
        if (enterpriseBean instanceof SessionSynchronization) {
            SessionSynchronization sessionSynchronization = (SessionSynchronization)enterpriseBean;
            try {
                sessionSynchronization.afterBegin();
            }
            catch (Exception exception) {
                this.forceDestroyBean(eJBContextImpl);
                throw new EJBException("Error during SessionSynchronization.afterBegin(), EJB instance discarded");
            }
        }
    }

    void beforeCompletion(EJBContextImpl eJBContextImpl) {
        if (this.isBeanManagedTran) {
            return;
        }
        EnterpriseBean enterpriseBean = eJBContextImpl.getEJB();
        if (!(enterpriseBean instanceof SessionSynchronization)) {
            return;
        }
        ComponentInvocation componentInvocation = new ComponentInvocation(enterpriseBean, this);
        this.invocationManager.preInvoke(componentInvocation);
        try {
            this.transactionManager.enlistComponentResources();
            ((SessionSynchronization)enterpriseBean).beforeCompletion();
        }
        catch (Exception exception) {
            try {
                this.forceDestroyBean(eJBContextImpl);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new EJBException("Error during SessionSynchronization.beforeCompletion, EJB instance discarded");
        }
        finally {
            this.invocationManager.postInvoke(componentInvocation);
        }
    }

    void afterCompletion(EJBContextImpl eJBContextImpl, int n) {
        if (eJBContextImpl.getState() == 5) {
            return;
        }
        SessionContextImpl sessionContextImpl = (SessionContextImpl)eJBContextImpl;
        EnterpriseBean enterpriseBean = sessionContextImpl.getEJB();
        boolean bl = n == 3 || n == 6;
        sessionContextImpl.setTransaction(null);
        sessionContextImpl.setUsingClientTx(false);
        if (!this.isBeanManagedTran && enterpriseBean instanceof SessionSynchronization) {
            if (sessionContextImpl.getState() == 3 && !sessionContextImpl.isTxCompleting()) {
                sessionContextImpl.setAfterCompletionDelayed(true);
                sessionContextImpl.setCompletedTxStatus(bl);
                sessionContextImpl.setPendingCheckpoint(true);
                return;
            }
            this.callEjbAfterCompletion(sessionContextImpl, bl);
        }
        if (this.isBeanManagedTran && sessionContextImpl.getState() == 3) {
            sessionContextImpl.setPendingCheckpoint(true);
            return;
        }
        _logger.finest("Inside StatefulSessionContainer.afterCompletion +++++++ : sc.getState ====== " + sessionContextImpl.getState());
        sessionContextImpl.setState(2);
        _logger.finest("doCheckpoint in afterCompletion  committed=" + bl);
        if (this.checkpointPolicy.isCheckpointRequired()) {
            this.doCheckpoint(sessionContextImpl);
        }
    }

    private void doPostInvokeCheckpointBMT(EJBContextImpl eJBContextImpl, Invocation invocation) {
        _logger.finest("Inside StatefulSessionContainer.doPostInvokeCheckpoint +++++ ejbContext " + eJBContextImpl);
        SessionContextImpl sessionContextImpl = (SessionContextImpl)eJBContextImpl;
        if (sessionContextImpl.isPendingCheckpoint() && this.checkpointPolicy.isCheckpointRequired()) {
            _logger.finest("In StatefulSessionContainer.doPostInvokeCheckpoint ++++++ checkpoint required for BMT ");
            sessionContextImpl.setPendingCheckpoint(false);
            this.doCheckpoint(sessionContextImpl);
        } else if (this.checkpointPolicy.isCheckpointRequired(invocation.method)) {
            _logger.finest("In StatefulSessionContainer.doPostInvokeCheckpoint ++++++ checkpoint required for BMT method");
            this.doCheckpoint(sessionContextImpl);
        }
    }

    private void doPostInvokeCheckpoint(EJBContextImpl eJBContextImpl, Invocation invocation) {
        SessionContextImpl sessionContextImpl = (SessionContextImpl)eJBContextImpl;
        Method method = invocation.method;
        if (this.checkpointPolicy.isCheckpointRequired(method)) {
            _logger.finest("In StatefulSessionContainer.doPostInvokeCheckpoint ++++++ checkpoint required at EOM ");
            this.doCheckpoint(sessionContextImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callEjbAfterCompletion(SessionContextImpl sessionContextImpl, boolean bl) {
        EnterpriseBean enterpriseBean = sessionContextImpl.getEJB();
        ComponentInvocation componentInvocation = new ComponentInvocation(enterpriseBean, this);
        this.invocationManager.preInvoke(componentInvocation);
        try {
            ((SessionSynchronization)enterpriseBean).afterCompletion(bl);
            sessionContextImpl.setAfterCompletionDelayed(false);
            sessionContextImpl.setTxCompleting(false);
        }
        catch (Exception exception) {
            try {
                this.forceDestroyBean(sessionContextImpl);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.aftercompletion_exception", exception.toString());
            }
        }
        finally {
            this.invocationManager.postInvoke(componentInvocation);
        }
    }

    public final boolean canPassivateEJB(ComponentContext componentContext) {
        SessionContextImpl sessionContextImpl = (SessionContextImpl)componentContext;
        return sessionContextImpl.getState() == 2;
    }

    public final int getPassivationBatchCount() {
        return this.passivationBatchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean passivateEJB(ComponentContext componentContext) {
        SessionContextImpl sessionContextImpl = (SessionContextImpl)componentContext;
        boolean bl = false;
        try {
            if (this.undeployed) {
                return false;
            }
            if (sessionContextImpl.getState() == 5) {
                return false;
            }
            SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
            ComponentInvocation componentInvocation = new ComponentInvocation(sessionBean, this);
            this.invocationManager.preInvoke(componentInvocation);
            bl = false;
            SessionContextImpl sessionContextImpl2 = sessionContextImpl;
            synchronized (sessionContextImpl2) {
                try {
                    if (sessionContextImpl.getState() == 2) {
                        EJBLocalRemoteObject eJBLocalRemoteObject;
                        sessionContextImpl.setState(1);
                        sessionBean.ejbPassivate();
                        this.transactionManager.componentDestroyed(sessionBean);
                        if (this.isRemote) {
                            eJBLocalRemoteObject = sessionContextImpl.getEJBObjectImpl();
                            eJBLocalRemoteObject.clearContext();
                            sessionContextImpl.setEJBObjectImpl(null);
                            this.protocolMgr.destroyReference((Remote)((Object)eJBLocalRemoteObject), this.ejbDescriptor.getUniqueId());
                        }
                        if (this.isLocal) {
                            eJBLocalRemoteObject = sessionContextImpl.getEJBLocalObjectImpl();
                            eJBLocalRemoteObject.clearContext();
                            sessionContextImpl.setEJBLocalObjectImpl(null);
                        }
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    try {
                        this.forceDestroyBean(sessionContextImpl);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                finally {
                    this.invocationManager.postInvoke(componentInvocation);
                }
                _logger.log(Level.FINE, "StatefulSessionContainer.passivateEJB(), success = " + bl);
                if (bl) {
                    boolean bl2 = this.statefulBeanStore.passivateEJB(sessionContextImpl, sessionContextImpl.getInstanceKey());
                    if (!bl2) {
                        _logger.log(Level.WARNING, "StatefulSessionContainer.passivateEJB(), passivation failed, hence reactivating  the bean ");
                        this.activateEJB(sessionContextImpl, sessionContextImpl.getInstanceKey(), null);
                    } else {
                        _logger.log(Level.FINE, "Passivated session bean successfully ");
                    }
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "StatefulSessionContainer.passivateEJB(), exception caught -> ", exception);
        }
        return bl;
    }

    public void activateEJB(SessionContextImpl sessionContextImpl, Object object, EJBLocalRemoteObject eJBLocalRemoteObject) {
        SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
        ComponentInvocation componentInvocation = new ComponentInvocation(sessionBean, this);
        this.invocationManager.preInvoke(componentInvocation);
        try {
            sessionContextImpl.touch();
            sessionContextImpl.setContainer(this);
            sessionContextImpl.setState(2);
            sessionContextImpl.setInstanceKey(object);
            sessionContextImpl.setNew(false);
            if (eJBLocalRemoteObject == null) {
                if (this.isRemote) {
                    this.createEJBObject(sessionContextImpl);
                }
                if (this.isLocal) {
                    this.createEJBLocalObject(sessionContextImpl);
                }
            } else if (eJBLocalRemoteObject instanceof EJBObjectImpl) {
                sessionContextImpl.setEJBObjectImpl((EJBObjectImpl)eJBLocalRemoteObject);
                eJBLocalRemoteObject.setContext(sessionContextImpl);
                eJBLocalRemoteObject.setKey(object);
                if (this.isLocal) {
                    this.createEJBLocalObject(sessionContextImpl);
                }
            } else if (eJBLocalRemoteObject instanceof EJBLocalObjectImpl) {
                sessionContextImpl.setEJBLocalObjectImpl((EJBLocalObjectImpl)eJBLocalRemoteObject);
                eJBLocalRemoteObject.setContext(sessionContextImpl);
                eJBLocalRemoteObject.setKey(object);
                if (this.isRemote) {
                    this.createEJBObject(sessionContextImpl);
                }
            }
            sessionBean.ejbActivate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "error in StatefulContainer.activateEJB() for key: " + object, exception);
            }
            throw new EJBException("Unable to activate EJB for key: " + object);
        }
        finally {
            this.invocationManager.postInvoke(componentInvocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        this.undeployed = true;
        try {
            this.statefulBeanStore.undeploy(this);
            Object var2_1 = null;
            super.undeploy();
            this.statefulBeanStore = null;
            this.passivationCandidates = null;
            this.asyncTaskSemaphore = null;
            this.sessionBeanCache = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.undeploy();
            this.statefulBeanStore = null;
            this.passivationCandidates = null;
            this.asyncTaskSemaphore = null;
            this.sessionBeanCache = null;
            throw throwable;
        }
    }

    public void undeploy(SessionContextImpl sessionContextImpl) {
        if (sessionContextImpl.getContainer() == this) {
            this.protocolMgr.destroyReference((Remote)((Object)sessionContextImpl.getEJBObjectImpl()), this.ejbDescriptor.getUniqueId());
            this.sessionBeanCache.remove(sessionContextImpl.getInstanceKey());
            this.transactionManager.componentDestroyed(sessionContextImpl.getEJB());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimEvent(Object object, Object object2) {
        block9: {
            boolean bl = false;
            Object object3 = this.asyncTaskSemaphore;
            synchronized (object3) {
                ++this.containerTrimCount;
                this.passivationCandidates.add(object2);
                int n = this.passivationCandidates.size() / this.passivationBatchCount;
                boolean bl2 = bl = this.asyncTaskCount < n;
                if (!bl) {
                    return;
                }
                ++this.asyncTaskCount;
                ++this.asyncCummTaskCount;
            }
            try {
                object3 = new ASyncPassivator();
                ContainerWorkPool.addLast(object3);
            }
            catch (Exception exception) {
                Object object4 = this.asyncTaskSemaphore;
                synchronized (object4) {
                    --this.asyncTaskCount;
                }
                if (!_logger.isLoggable(Level.WARNING)) break block9;
                _logger.log(Level.WARNING, "Cannot add  idle bean cleanup", exception);
            }
        }
    }

    private void doCheckpointInternal(SessionContextImpl sessionContextImpl) throws Exception {
        boolean bl = false;
        _logger.finest("before calling doCheckpointInternal in createEJb");
        bl = this.statefulBeanStore.checkpointEJB(sessionContextImpl, sessionContextImpl.getInstanceKey(), sessionContextImpl.isNew());
        _logger.finest(" after calling checkpoint in createEjb       " + bl);
        if (!bl) {
            _logger.log(Level.WARNING, " StatefulSessionContainer.checkpointEJB=" + bl + " checkpoint call failed on " + "bean instance = " + sessionContextImpl.getInstanceKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCheckpoint(ComponentContext componentContext) {
        _logger.finest("StatefulSessionContainer.doCheckpointNew +++++++ ");
        SessionContextImpl sessionContextImpl = (SessionContextImpl)componentContext;
        boolean bl = false;
        SessionBean sessionBean = (SessionBean)sessionContextImpl.getEJB();
        ComponentInvocation componentInvocation = new ComponentInvocation(sessionBean, this);
        this.invocationManager.preInvoke(componentInvocation);
        SessionContextImpl sessionContextImpl2 = sessionContextImpl;
        synchronized (sessionContextImpl2) {
            try {
                sessionContextImpl.setState(1);
                sessionBean.ejbPassivate();
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, "StatefulSessionContainer.doCheckpointNew : Exception while passivating Session bean " + sessionContextImpl + " before checkpointing ... destroying bean instance. Nested Exception is ...");
                this.forceDestroyBean(sessionContextImpl);
                return;
            }
            try {
                this.doCheckpointInternal(sessionContextImpl);
            }
            catch (NotSerializableException notSerializableException) {
                _logger.log(Level.INFO, "StatefulSessionContainer.doCheckpointNew : Bean state is not serializable even after invoking ejbPassivate(). Nested exception is ...");
                notSerializableException.printStackTrace();
                this.forceDestroyBean(sessionContextImpl);
                return;
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, "StatefulSessionContainer.doCheckpointNew : Exception while checkpointing Session Bean " + sessionContextImpl + " Nested Exception is ...");
            }
            finally {
                sessionContextImpl.setNew(false);
            }
            try {
                sessionContextImpl.setState(2);
                sessionBean.ejbActivate();
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, "StatefulSessionContainer.doCheckpointNew : Exception while activating Session bean " + sessionContextImpl + " after checkpointing ... destroying bean instance. Nested Exception is ...");
                this.forceDestroyBean(sessionContextImpl);
            }
            finally {
                this.invocationManager.postInvoke(componentInvocation);
            }
        }
    }

    public void onShutdown() {
        _logger.log(Level.INFO, "BaseContainer.onShutdown  =========================" + this.statefulBeanStore);
        if (this.statefulBeanStore != null) {
            this.statefulBeanStore.getSFSBStoreManager().shutdown();
        }
    }

    private class ASyncPassivator
    implements Servicable {
        private ASyncPassivator() {
        }

        public void prolog() {
        }

        public void epilog() {
        }

        public void service() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ClassLoader classLoader;
            Thread thread;
            block14: {
                Object object;
                thread = Thread.currentThread();
                classLoader = thread.getContextClassLoader();
                ClassLoader classLoader2 = StatefulSessionContainer.this.loader;
                boolean bl = false;
                try {
                    try {
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                thread.setContextClassLoader(((ASyncPassivator)this).StatefulSessionContainer.this.loader);
                                return null;
                            }
                        });
                        ComponentContext componentContext = null;
                        while (true) {
                            Object object2 = StatefulSessionContainer.this.asyncTaskSemaphore;
                            synchronized (object2) {
                                int n = StatefulSessionContainer.this.passivationCandidates.size();
                                if (n <= 0) break;
                                componentContext = (ComponentContext)StatefulSessionContainer.this.passivationCandidates.remove(n - 1);
                            }
                            StatefulSessionContainer.this.passivateEJB(componentContext);
                        }
                        {
                        }
                        Object var10_9 = null;
                        if (bl) break block14;
                        object = StatefulSessionContainer.this.asyncTaskSemaphore;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var10_10 = null;
                        if (!bl) {
                            Object object3 = StatefulSessionContainer.this.asyncTaskSemaphore;
                            synchronized (object3) {
                                --StatefulSessionContainer.this.asyncTaskCount;
                            }
                        }
                        AccessController.doPrivileged(new PrivilegedAction(this, thread, classLoader){
                            private final /* synthetic */ Thread val$currentThread;
                            private final /* synthetic */ ClassLoader val$previousClassLoader;
                            private final /* synthetic */ ASyncPassivator this$1;
                            {
                                this.this$1 = aSyncPassivator;
                                this.val$currentThread = thread;
                                this.val$previousClassLoader = classLoader;
                            }

                            public Object run() {
                                this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                                return null;
                            }
                        });
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (!bl) {
                        Object object4 = StatefulSessionContainer.this.asyncTaskSemaphore;
                        synchronized (object4) {
                            --StatefulSessionContainer.this.asyncTaskCount;
                        }
                    }
                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                synchronized (object) {
                    --StatefulSessionContainer.this.asyncTaskCount;
                }
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        }
    }

    class PassivateRunner
    implements Runnable {
        private ComponentContext ctx;

        PassivateRunner(ComponentContext componentContext) {
            this.ctx = componentContext;
        }

        public void run() {
            if (this.ctx != null) {
                Thread thread = Thread.currentThread();
                ClassLoader classLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(StatefulSessionContainer.this.loader);
                StatefulSessionContainer.this.passivateEJB(this.ctx);
                thread.setContextClassLoader(classLoader);
            }
        }
    }
}

