/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionFileCacheStore {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private File dir;
    private int passivationTimeoutInSeconds;
    private boolean debug = false;
    private Object[] locks;
    private int maxLocks;
    protected ClassLoader containerClassLoader;
    protected StatefulSessionStore sessionStore;

    private void removeFile(File file, boolean bl) {
        final File file2 = file;
        final boolean bl2 = bl;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (bl2) {
                    file2.deleteOnExit();
                } else {
                    file2.delete();
                }
                return null;
            }
        });
    }

    public void undeploy() {
        this.dir = null;
        this.locks = null;
        this.containerClassLoader = null;
        this.sessionStore = null;
    }

    public SessionFileCacheStore(String string, int n) {
        try {
            this.passivationTimeoutInSeconds = n;
            this.dir = new File(string);
            this.dir.mkdirs();
            this.maxLocks = 64;
            this.locks = new Object[this.maxLocks];
            for (int i = 0; i < this.maxLocks; ++i) {
                this.locks[i] = new Object();
            }
            this.containerClassLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.sessionfile_cachestore_exception", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] loadState(Object object) throws Exception {
        byte[] byArray2;
        String string = "" + object;
        File file = new File(this.dir, string);
        if (!file.exists()) return null;
        int n2 = (int)file.length();
        byte[] byArray = new byte[n2];
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            int n3 = 0;
            for (int i = n2; i > 0; n3 += n, i -= n) {
                n = bufferedInputStream.read(byArray, n3, i);
            }
            try {
                bufferedInputStream.close();
                bufferedInputStream = null;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "[SessionFileCacheStore] loadState(): Exception - ", exception);
            }
            this.removeFile(file, false);
            byArray2 = byArray;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return byArray2;
        }
        if (bufferedInputStream == null) return byArray2;
        bufferedInputStream.close();
        return byArray2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveState(Object var1_1, byte[] var2_2) throws Exception {
        var3_3 = null;
        var4_4 = null;
        var5_5 = "" + var1_1;
        try {
            block16: {
                var3_3 = new File(this.dir, var5_5);
                if (!var3_3.getName().equals("null")) break block16;
                var9_6 = null;
                ** GOTO lbl44
            }
            while (var4_4 == null) {
                try {
                    var4_4 = new BufferedOutputStream(new FileOutputStream(var3_3));
                }
                catch (FileNotFoundException var6_12) {
                    var4_4 = null;
                    if (SessionFileCacheStore._logger.isLoggable(Level.FINE)) {
                        SessionFileCacheStore._logger.log(Level.FINE, "[SessionFileCacheStore] saveState(): BufferedOutputStream equals NULL, retrying.");
                    }
                    if (SessionFileCacheStore._logger.isLoggable(Level.FINEST)) {
                        SessionFileCacheStore._logger.log(Level.FINEST, "[SessionFileCacheStore] saveState(): BufferedOutputStream equals NULL, Exception: = ", var6_12);
                    }
                    Thread.sleep(1000L);
                }
            }
            var4_4.write(var2_2, 0, var2_2.length);
            ** GOTO lbl51
        }
        catch (Exception var6_13) {
            try {
                if (var3_3 == null) throw var6_13;
                this.removeFile(var3_3, false);
                throw var6_13;
            }
            catch (Exception var7_14) {
                SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception when deleting file from disk - ", var7_14);
            }
            throw var6_13;
        }
        {
            catch (Throwable var8_15) {
                var9_8 = null;
                try {
                    if (var4_4 == null) throw var8_15;
                    var4_4.close();
                    throw var8_15;
                }
                catch (IOException var10_11) {
                    SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var10_11);
                }
                throw var8_15;
            }
lbl44:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [7 : 201->214)] { 
lbl45:
            // 1 sources

            if (var4_4 == null) return;
            var4_4.close();
            return;
lbl48:
            // 1 sources

            catch (IOException var10_9) {
                SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var10_9);
            }
            return;
lbl51:
            // 1 sources

            var9_7 = null;
            try {}
            catch (IOException var10_10) {}
            SessionFileCacheStore._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var10_10);
            return;
            if (var4_4 == null) return;
            var4_4.close();
            return;
        }
    }

    public void cancelTimerTasks() {
    }

    public void removeState(Object object) {
        try {
            this.removeFile(new File(this.dir, "" + object), false);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[SessionFileCacheStore] removeState(): Exception when deleting file from disk - ", exception);
        }
    }

    protected void setSessionStore(StatefulSessionStore statefulSessionStore) {
        this.sessionStore = statefulSessionStore;
    }
}

