/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.instance.InstanceEnvironment;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.iplanet.ias.web.ServerConfigLookup;
import com.sun.ejb.containers.SFSBFileStoreManager;
import com.sun.ejb.containers.SessionFileCacheStoreAdapter;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.ejb.spi.SFSBStoreManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFSBStoreManagerFactory {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static SFSBStoreManager storeManager = null;
    private static SFSBStoreManagerFactory storeMangerFactory = new SFSBStoreManagerFactory();
    private boolean checkpointEnabled = false;
    private String checkpointStore = "hadb";
    private String directoryforFile = null;
    private static StatefulSessionContainer container = null;
    private final String EE_EJB_PACKAGE = "com.sun.appserv.ee.ejb.sfsb";
    private final String EE_SFSBStoreManager = "HASFSBStoreManager";
    protected final String EJB_AVAILABILITY = "/server/availability-service/persistence-store/property[@name='ejb-availability']";

    private String getEjbAvailabilityType() {
        ServerConfigLookup serverConfigLookup = new ServerConfigLookup();
        String string = serverConfigLookup.getServerConfigValue("/server/availability-service/persistence-store/property[@name='ejb-availability']", "hadb");
        _logger.log(Level.INFO, " EJB AVAILABILITY TYPE=" + string);
        if (string == null || string.equals("")) {
            string = "hadb";
        }
        return string;
    }

    private SFSBStoreManagerFactory() {
    }

    public static SFSBStoreManagerFactory getInstance() {
        _logger.entering("SFSBStoreManagerFactory", "getInstance");
        return storeMangerFactory;
    }

    public static SFSBStoreManagerFactory getInstance(StatefulSessionContainer statefulSessionContainer) {
        _logger.entering("SFSBStoreManagerFactory", "getInstance", statefulSessionContainer);
        container = statefulSessionContainer;
        return storeMangerFactory;
    }

    public SFSBStoreManager getSFSBStoreManager(StatefulSessionStore statefulSessionStore, EjbDescriptor ejbDescriptor, int n) {
        _logger.entering("SFSBStoreManagerFactory", "getInstance", new Object[]{statefulSessionStore, ejbDescriptor, new Integer(n)});
        SFSBStoreManager sFSBStoreManager = null;
        this.checkpointEnabled = false;
        this.checkpointStore = "hadb";
        if (container != null) {
            this.checkpointStore = container.getSFSBConfigReader().getSFSBPersistenceType();
            this.checkpointEnabled = container.getSFSBConfigReader().getAvailabilityEnabled();
        } else {
            _logger.log(Level.INFO, " Container is null so defaulting to memory check the proper usage of getInstance");
        }
        _logger.log(Level.FINEST, "checkpointStore=" + this.checkpointStore + "   checkpointEnabled=" + this.checkpointEnabled);
        sFSBStoreManager = this.createSessionFileCacheStoreAdapter(statefulSessionStore, ejbDescriptor, 300);
        if (this.checkpointEnabled) {
            SFSBStoreManager sFSBStoreManager2 = null;
            if (this.checkpointStore.equalsIgnoreCase("file")) {
                this.directoryforFile = this.getPassivationDirectory(ejbDescriptor);
                sFSBStoreManager2 = this.createSFSBFileStoreManager(this.directoryforFile);
            } else if (this.checkpointStore.equalsIgnoreCase("ha")) {
                sFSBStoreManager2 = this.createHASFSBStoreManager();
            }
            if (sFSBStoreManager2 != null) {
                sFSBStoreManager = sFSBStoreManager2;
            }
        }
        sFSBStoreManager.initSessionStore("", ejbDescriptor.getUniqueId(), n);
        _logger.exiting("SFSBStoreManagerFactory", "getInstance", sFSBStoreManager);
        return sFSBStoreManager;
    }

    private SFSBStoreManager createHASFSBStoreManager() {
        _logger.entering("SFSBStoreManagerFactory", "createHASFSBStoreManager");
        SFSBStoreManager sFSBStoreManager = null;
        Object var2_2 = null;
        try {
            var2_2 = Class.forName("com.sun.appserv.ee.ejb.sfsb.HASFSBStoreManager").newInstance();
            sFSBStoreManager = var2_2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            _logger.log(Level.WARNING, "[SFSBStoreManagerFactory] com.sun.appserv.ee.ejb.sfsb.HASFSBStoreManager not in the classpath");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        _logger.exiting("SFSBStoreManagerFactory", "createHASFSBStoreManager", sFSBStoreManager);
        return sFSBStoreManager;
    }

    private SFSBStoreManager createSFSBFileStoreManager(String string) {
        _logger.entering("SFSBStoreManagerFactory", "createSFSBFileStoreManager");
        return new SFSBFileStoreManager(string);
    }

    private SFSBStoreManager createSessionFileCacheStoreAdapter(StatefulSessionStore statefulSessionStore, EjbDescriptor ejbDescriptor, int n) {
        _logger.entering("SFSBStoreManagerFactory", "createSessionFileCacheStoreAdapter");
        SessionFileCacheStoreAdapter sessionFileCacheStoreAdapter = new SessionFileCacheStoreAdapter(this.getPassivationDirectory(ejbDescriptor), n);
        _logger.exiting("SFSBStoreManagerFactory", "createSessionFileCacheStoreAdapter", sessionFileCacheStoreAdapter);
        return sessionFileCacheStoreAdapter;
    }

    private String getPassivationDirectory(EjbDescriptor ejbDescriptor) {
        _logger.entering("SFSBStoreManagerFactory", "getPassivationDirectory", ejbDescriptor);
        ServerContext serverContext = ApplicationServer.getServerContext();
        InstanceEnvironment instanceEnvironment = serverContext.getInstanceEnvironment();
        Application application = ejbDescriptor.getApplication();
        String string = null;
        string = application.isVirtual() ? instanceEnvironment.getModulePassivatedEjbPath() : instanceEnvironment.getApplicationPassivatedEjbPath();
        String string2 = string + File.separator + application.getRegistrationName() + File.separator + ejbDescriptor.getEjbClassName();
        _logger.exiting("SFSBStoreManagerFactory", "getPassivationDirectory", string2);
        return string2;
    }
}

