/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.SimpleSFSBUUIDUtilImpl;
import com.sun.ejb.containers.StatefulSessionStore;
import com.sun.ejb.spi.BaseSFSBStoreManager;
import com.sun.ejb.spi.SFSBBeanState;
import com.sun.ejb.spi.SFSBUUIDUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;

public class SFSBFileStoreManager
extends BaseSFSBStoreManager {
    private File dir;
    private Object[] locks;
    private int maxLocks;
    protected ClassLoader containerClassLoader;
    protected StatefulSessionStore sessionStore;
    protected SFSBUUIDUtil uuidUtil = null;

    private void removeFile(File file, boolean bl) {
        _logger.entering("SFSBFileStoreManager", "removeFile", new Object[]{file, new Boolean(bl)});
        final File file2 = file;
        final boolean bl2 = bl;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (bl2) {
                    file2.deleteOnExit();
                } else {
                    file2.delete();
                }
                return null;
            }
        });
    }

    public void undeploy() {
        this.dir = null;
        this.locks = null;
        this.containerClassLoader = null;
        this.sessionStore = null;
    }

    public SFSBFileStoreManager(String string) {
        _logger.entering("SFSBFileStoreManager", "<init>", string);
        try {
            this.dir = new File(string);
            this.dir.mkdirs();
            this.maxLocks = 64;
            this.locks = new Object[this.maxLocks];
            for (int i = 0; i < this.maxLocks; ++i) {
                this.locks[i] = new Object();
            }
            this.containerClassLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.sessionfile_cachestore_exception", exception);
        }
        this.uuidUtil = new SimpleSFSBUUIDUtilImpl();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SFSBBeanState getState(Object object) throws Exception {
        SFSBBeanState sFSBBeanState2;
        _logger.entering("SFSBFileStoreManager", "getState", object);
        String string = "" + object;
        long l = 0L;
        BufferedInputStream bufferedInputStream = null;
        ObjectInputStream objectInputStream = null;
        File file = new File(this.dir, string);
        _logger.log(Level.FINE, " in load state fileName=" + this.dir + string);
        if (!file.exists()) {
            _logger.log(Level.INFO, "file does not exist: " + file);
            return null;
        }
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        objectInputStream = new ObjectInputStream(bufferedInputStream);
        try {
            try {
                SFSBBeanState sFSBBeanState = (SFSBBeanState)objectInputStream.readObject();
                try {
                    objectInputStream.close();
                    bufferedInputStream.close();
                    bufferedInputStream = null;
                }
                catch (Exception exception) {
                    _logger.log(Level.INFO, "[SessionFileCacheStore] loadState(): Exception in closing the BufferedInputStream- ", exception);
                }
                sFSBBeanState2 = sFSBBeanState;
                Object var11_11 = null;
            }
            catch (Exception exception) {
                _logger.log(Level.INFO, "exception in load state");
                throw exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (bufferedInputStream == null) throw throwable;
                bufferedInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return sFSBBeanState2;
        }
        if (bufferedInputStream == null) return sFSBBeanState2;
        bufferedInputStream.close();
        return sFSBBeanState2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passivateSave(SFSBBeanState var1_1) throws Exception {
        SFSBFileStoreManager._logger.entering("SFSBFileStoreManager", "passivateSave", var1_1);
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = var1_1.getId();
        var6_6 = "" + var5_5;
        var7_7 = var1_1.getState();
        try {
            block14: {
                var2_2 = new File(this.dir, var6_6);
                if (!var2_2.getName().equals("null")) break block14;
                var11_8 = null;
                ** GOTO lbl42
            }
            SFSBFileStoreManager._logger.log(Level.FINE, "SFSBFileStoreManager.passivateSave before writing to bufferoutputstream file=" + var2_2);
            var3_3 = new BufferedOutputStream(new FileOutputStream(var2_2));
            var4_4 = new ObjectOutputStream(var3_3);
            var4_4.writeObject(var1_1);
            ** GOTO lbl52
        }
        catch (Exception var8_14) {
            try {
                if (var2_2 == null) throw var8_14;
                this.removeFile(var2_2, false);
                throw var8_14;
            }
            catch (Exception var9_15) {
                SFSBFileStoreManager._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception when deleting file from disk - ", var9_15);
            }
            throw var8_14;
        }
        {
            catch (Throwable var10_16) {
                var11_10 = null;
                try {
                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var2_2.exists() == false) throw var10_16;
                    var2_2.setLastModified(var1_1.getLastAccess());
                    throw var10_16;
                }
                catch (IOException var12_13) {
                    SFSBFileStoreManager._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var12_13);
                }
                throw var10_16;
            }
lbl42:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [6 : 191->218)] { 
lbl43:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            if (var2_2.exists() == false) return;
            var2_2.setLastModified(var1_1.getLastAccess());
            return;
lbl49:
            // 1 sources

            catch (IOException var12_11) {
                SFSBFileStoreManager._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var12_11);
            }
            return;
lbl52:
            // 1 sources

            var11_9 = null;
            try {}
            catch (IOException var12_12) {}
            SFSBFileStoreManager._logger.log(Level.WARNING, "[SessionFileCacheStore] saveState(): Exception on closing file - ", var12_12);
            return;
            if (var3_3 != null) {
                var3_3.close();
            }
            if (var2_2.exists() == false) return;
            var2_2.setLastModified(var1_1.getLastAccess());
            return;
        }
    }

    public void checkpointSave(SFSBBeanState[] sFSBBeanStateArray, boolean bl) throws Exception {
        for (int i = 0; i < Array.getLength(sFSBBeanStateArray); ++i) {
            this.passivateSave(sFSBBeanStateArray[i]);
        }
    }

    public void cancelTimerTasks() {
    }

    public void remove(Object object) {
        try {
            this.removeFile(new File(this.dir, "" + object), false);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "[SessionFileCacheStore] removeState(): Exception when deleting file from disk - ", exception);
        }
    }

    protected void setSessionStore(StatefulSessionStore statefulSessionStore) {
        this.sessionStore = statefulSessionStore;
    }

    public void removeAll() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Object object;
                    File file = SFSBFileStoreManager.this.dir;
                    _logger.log(Level.FINEST, " SFSBFileStoreManager.remove : Preparing to delete passivated stateful session bean files in " + file.toString());
                    if (file.isDirectory()) {
                        object = file.listFiles();
                        boolean bl = false;
                        for (int i = 0; i < ((File[])object).length; ++i) {
                            _logger.log(Level.FINEST, " SFSBFileStoreManager.remove : deleting file " + object[i]);
                            bl = ((File)object[i]).delete();
                            if (bl) continue;
                            _logger.log(Level.SEVERE, "SFSBFileStoreManager.remove :  Could not delete file : " + object[i]);
                        }
                    }
                    object = file.getParentFile();
                    file.delete();
                    if (object != null && ((File)object).list().length == 0) {
                        ((File)object).delete();
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "ejb.delete_passivated_sfsb_exception", exception);
                }
                return null;
            }
        });
    }

    public void removeExpired(ArrayList arrayList) {
        super.removeExpired(arrayList);
        try {
            long l = System.currentTimeMillis();
            long l2 = this.getRemovalTimeoutInSeconds() * 1000;
            long l3 = l - l2;
            File file = this.dir;
            _logger.log(Level.FINE, "SFSBFileStoreManager.removeExpired   victims length " + arrayList.size() + "          file.isDirectory()=" + file.isDirectory());
            _logger.log(Level.FINE, " SFSBFileStoreManager.removeExpired : Preparing to delete timedout stateful session bean files in " + file.toString());
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                boolean bl = false;
                _logger.log(Level.FINE, " SFSBFileStoreManager.removeExpired : Preparing to delete timedout stateful session bean in dir  " + fileArray.length);
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].lastModified() >= l3) continue;
                    _logger.log(Level.FINE, "1.  SFSBFileStoreManager.removeExpired : removing the  file " + fileArray[i] + "          last modified :" + fileArray[i].lastModified() + "      relevantTime=" + l3);
                    fileArray[i].delete();
                }
            } else if (file.lastModified() < l3) {
                _logger.log(Level.FINE, "2.  SFSBFileStoreManager.removeExpired : removing the  file " + file + "          last modified :" + file.lastModified() + "      relevantTime=" + l3);
                file.delete();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.delete_passivated_sfsb_exception", exception);
        }
    }

    public void shutdown() {
    }

    public void passivateSave(SFSBBeanState sFSBBeanState, boolean bl) {
        try {
            this.passivateSave(sFSBBeanState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteBeansForThisContainer() {
        this.removeAll();
    }

    public SFSBUUIDUtil getUUIDUtil() {
        return this.uuidUtil;
    }
}

