/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.config.ConfigBean;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.ejb.spi.CheckpointPolicy;
import com.sun.ejb.spi.CheckpointPolicyImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFSBConfigReader {
    private String sfsbPersistenceType = null;
    private String defaultStorePoolJndiName = null;
    private String sfsbStorePoolJndiName = null;
    private String fileStoreDirectory = null;
    private CheckpointPolicy checkpointPolicy = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static String STORE_POOL_JNDI_NAME_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='store-pool-jndi-name']";
    private static String SFSB_STORE_POOL_JNDI_NAME_XPATH_STRING = "/server/availability-service/persistence-store/property[@name='sfsb-store-pool-jndi-name']";
    private static String SESSION_STORE_XPATH_STRING = "/server[@session-store]";

    public String getSFSBConfigValue(String string, String string2) {
        _logger.finest("in getSFSBConfigValue:xpath=" + string + " defaultValue= " + string2);
        ServerContext serverContext = ApplicationServer.getServerContext();
        ConfigContext configContext = serverContext.getConfigContext();
        ConfigBean configBean = null;
        String string3 = null;
        String string4 = string2;
        try {
            configBean = configContext.exactLookup(string);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        if (configBean != null) {
            string3 = configBean.getAttributeValue("value");
        }
        if (string3 != null) {
            // empty if block
        }
        return string3;
    }

    public SFSBConfigReader(CheckpointPolicy checkpointPolicy) {
        this.checkpointPolicy = checkpointPolicy;
        this.defaultStorePoolJndiName = this.getSFSBConfigValue(STORE_POOL_JNDI_NAME_XPATH_STRING, null);
        this.sfsbStorePoolJndiName = this.getSFSBConfigValue(SFSB_STORE_POOL_JNDI_NAME_XPATH_STRING, null);
        this.fileStoreDirectory = this.getFileStoreDirectory();
        if (!(this.defaultStorePoolJndiName != null && this.defaultStorePoolJndiName.trim().length() >= 1 || this.sfsbStorePoolJndiName != null && this.sfsbStorePoolJndiName.trim().length() >= 1)) {
            this.sfsbPersistenceType = "file";
            this.defaultStorePoolJndiName = null;
            this.sfsbStorePoolJndiName = null;
        } else {
            this.sfsbPersistenceType = "ha";
        }
        _logger.log(Level.FINEST, "Inside SFSBConfigReader : ++++++ persistenceType = " + this.sfsbPersistenceType);
    }

    public String getDefaultStorePoolJndiName() {
        return this.defaultStorePoolJndiName;
    }

    public String getSFSBStorePoolJndiName() {
        if (this.sfsbStorePoolJndiName == null) {
            return this.defaultStorePoolJndiName;
        }
        return this.sfsbStorePoolJndiName;
    }

    public String getFileStoreDirectory() {
        return ((CheckpointPolicyImpl)this.checkpointPolicy).getSessionStore();
    }

    public String getSFSBPersistenceType() {
        return this.sfsbPersistenceType;
    }

    public boolean getAvailabilityEnabled() {
        return this.checkpointPolicy.isCheckpointRequired();
    }
}

