/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.ejb.containers.ReadOnlyBeanLocalNotifierImpl;
import com.iplanet.ias.ejb.containers.ReadOnlyBeanNotifierImpl;
import com.sun.appserv.util.cache.ReadOnlyBeanCache;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.ejb.containers.ReadOnlyEJBHomeImpl;
import com.sun.ejb.containers.ReadOnlyEJBLocalHomeImpl;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;

public class ReadOnlyBeanContainer
extends EntityContainer {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private long refreshPeriodInMSecs = 600000L;
    private ReadOnlyBeanCache robCache = new ReadOnlyBeanCache();

    protected ReadOnlyBeanContainer(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws Exception {
        super(ejbDescriptor, classLoader);
        this.containerFactory = (ContainerFactoryImpl)this.theSwitch.getContainerFactory();
        EjbEntityDescriptor ejbEntityDescriptor = (EjbEntityDescriptor)ejbDescriptor;
        this.refreshPeriodInMSecs = ejbEntityDescriptor.getIASEjbExtraDescriptors().getRefreshPeriodInSeconds() * 1000;
        this.robCache.init(8192, null);
    }

    protected void callEJBStore(EntityBean entityBean, EntityContextImpl entityContextImpl) {
    }

    protected void callEJBLoad(EntityBean entityBean, EntityContextImpl entityContextImpl) throws Exception {
        boolean bl = entityContextImpl.toRefresh;
        if (bl || this.transactionManager.getStatus() != 6) {
            this.callLoad(entityBean, entityContextImpl);
            return;
        }
        if (this.refreshPeriodInMSecs <= 0L) {
            return;
        }
        long l = entityContextImpl.lastRefreshedAt;
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 >= this.refreshPeriodInMSecs) {
            this.callLoad(entityBean, entityContextImpl);
            return;
        }
    }

    protected void callLoad(EntityBean entityBean, EntityContextImpl entityContextImpl) {
        try {
            entityBean.ejbLoad();
            entityContextImpl.lastRefreshedAt = System.currentTimeMillis();
            if (!entityContextImpl.isRemoved) {
                entityContextImpl.toRefresh = false;
            }
            return;
        }
        catch (Exception exception) {
            _logger.log(Level.FINE, "Exception in callLoad()", exception);
            return;
        }
    }

    protected void callEJBRemove(EntityBean entityBean, EntityContextImpl entityContextImpl) throws Exception {
        Object object = entityContextImpl.getPrimaryKey();
        this.robCache.removeAllContexts(object);
    }

    public void undeploy() {
        super.undeploy();
        this.robCache = null;
    }

    void preInvokeNoTx(Invocation invocation) {
        EntityContextImpl entityContextImpl = (EntityContextImpl)invocation.context;
        if (entityContextImpl.getState() == 5) {
            return;
        }
        if (!invocation.invocationInfo.isCreateHomeFinder) {
            EntityBean entityBean = (EntityBean)entityContextImpl.getEJB();
            try {
                this.callEJBLoad(entityBean, entityContextImpl);
            }
            catch (NoSuchEntityException noSuchEntityException) {
                _logger.log(Level.FINE, "Exception in preInvokeNoTx()", noSuchEntityException);
                this.forceDestroyBean(entityContextImpl);
                throw new NoSuchObjectLocalException("NoSuchEntityException thrown by ejbLoad, EJB instance discarded");
            }
            catch (Exception exception) {
                this.forceDestroyBean(entityContextImpl);
                throw new EJBException(exception);
            }
            entityContextImpl.setNewlyActivated(false);
        }
    }

    protected void afterNewlyActivated(EntityContextImpl entityContextImpl) {
        this.robCache.add(entityContextImpl.getPrimaryKey(), entityContextImpl);
    }

    protected void addPooledEJB(EntityContextImpl entityContextImpl) {
        try {
            Object object = entityContextImpl.getPrimaryKey();
            this.robCache.remove(object, (Object)entityContextImpl);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.addPooledEJB", exception);
            }
            _logger.log(Level.FINE, "Error in addPooledEJB", exception);
            throw new EJBException(exception);
        }
        finally {
            super.addPooledEJB(entityContextImpl);
        }
    }

    protected void forceDestroyBean(EJBContextImpl eJBContextImpl) {
        EntityContextImpl entityContextImpl = (EntityContextImpl)eJBContextImpl;
        try {
            this.robCache.remove(entityContextImpl.getPrimaryKey(), (Object)entityContextImpl);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "ejb.forceDestroyBean", exception);
            }
            _logger.log(Level.FINE, "Error in forceDestroyBean", exception);
            throw new EJBException(exception);
        }
        finally {
            super.forceDestroyBean(entityContextImpl);
        }
    }

    protected void initializeHome() throws Exception {
        super.initializeHome();
        if (this.isRemote) {
            ReadOnlyBeanNotifierImpl readOnlyBeanNotifierImpl = new ReadOnlyBeanNotifierImpl();
            readOnlyBeanNotifierImpl.setReadOnlyBeanContainer(this);
            ((ReadOnlyEJBHomeImpl)this.ejbHome).setReadOnlyBeanNotifier(readOnlyBeanNotifierImpl);
        } else if (this.isLocal) {
            ReadOnlyBeanLocalNotifierImpl readOnlyBeanLocalNotifierImpl = new ReadOnlyBeanLocalNotifierImpl();
            readOnlyBeanLocalNotifierImpl.setReadOnlyBeanContainer(this);
            ((ReadOnlyEJBLocalHomeImpl)this.ejbHome).setReadOnlyBeanLocalNotifier(readOnlyBeanLocalNotifierImpl);
        }
    }

    public void setRefreshFlag(Object object) {
        this.robCache.refreshAllContexts(object);
    }
}

