/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.ElementProperty;
import com.iplanet.ias.config.serverbeans.MdbContainer;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.deployment.BeanPoolDescriptor;
import com.iplanet.ias.deployment.DefaultResourcePrincipalDescriptor;
import com.iplanet.ias.deployment.MdbConnectionFactoryDescriptor;
import com.iplanet.ias.jms.IASJmsUtil;
import com.iplanet.ias.jms.JmsProviderLifecycle;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.ejb.containers.MessageBeanContainer;
import com.sun.ejb.containers.MessageBeanHelper;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.jms.ConnectionFactoryWrapperStandalone;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.resource.ExternalNameNotFoundException;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;

public abstract class MessageBeanHelperBase
implements MessageBeanHelper {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb.mdb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(MessageBeanHelperBase.class);
    private static final int DEFAULT_MAX_MESSAGES = 1;
    protected static final int POINT_TO_POINT = 0;
    protected static final int PUB_SUB = 1;
    private ConnectionFactory connectionFactory_;
    private Connection connection_;
    private Destination msgBeanDestination_;
    private EjbMessageBeanDescriptor descriptor_;
    private int msgStyle_;
    private static final int DEFAULT_RESIZE_QUANTITY = 1;
    private static final int DEFAULT_STEADY_SIZE = 10;
    private static final int DEFAULT_MAX_POOL_SIZE = 60;
    private static final int DEFAULT_IDLE_TIMEOUT = 600;
    private static final int MIN_IDLE_TIMEOUT = 1;
    private static final String propName_reconnect_delay_in_seconds = "reconnect-delay-in-seconds";
    private static final String propName_reconnect_max_retries = "reconnect-max-retries";
    private static final String propName_reconnect_enabled = "reconnect-enabled";
    private static final int DEFAULT_RECONNECT_DELAY = 0;
    private static final int DEFAULT_RECONNECT_RETRIES = 60;
    private static final String propName_cmt_max_runtime_exceptions = "cmt-max-runtime-exceptions";
    private static final int DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS = 1;
    protected int cmtMaxRuntimeExceptions;
    private int reconnectDelayInSeconds;
    private int reconnectMaxRetries;
    private boolean reconnectEnabled;
    private static final boolean debug = true;
    private static final String propName_queue_connection_factory_jndi_name = "queue-connection-factory-jndi-name";
    private static final String propName_topic_connection_factory_jndi_name = "topic-connection-factory-jndi-name";
    private String defaultQueueCFJndiName;
    private String defaultTopicCFJndiName;
    protected String appEJBName_;
    private static final int INITIALIZE = 1;
    private static final int CONNECTED = 2;
    private static final int STARTED = 3;
    private static final int CLOSE = 4;
    private int connectionState_;
    private boolean reconnecting;
    private Object destroyConnectionLock_;
    private MessageBeanContainer container_;
    private boolean poolMonitorRegistered_;

    public MessageBeanHelperBase(EjbMessageBeanDescriptor ejbMessageBeanDescriptor, int n) {
        ElementProperty[] elementPropertyArray;
        MdbContainer mdbContainer;
        block20: {
            this.cmtMaxRuntimeExceptions = 1;
            this.reconnectDelayInSeconds = 0;
            this.reconnectMaxRetries = 60;
            this.reconnectEnabled = true;
            this.defaultQueueCFJndiName = null;
            this.defaultTopicCFJndiName = null;
            this.connectionState_ = 1;
            this.reconnecting = false;
            this.destroyConnectionLock_ = new Object();
            this.poolMonitorRegistered_ = false;
            this.connectionFactory_ = null;
            this.connection_ = null;
            this.descriptor_ = ejbMessageBeanDescriptor;
            this.msgStyle_ = n;
            this.appEJBName_ = this.getDescriptor().getApplication().getRegistrationName() + ":" + this.getDescriptor().getName();
            mdbContainer = null;
            try {
                elementPropertyArray = ApplicationServer.getServerContext();
                mdbContainer = ServerBeansFactory.getServerBean(elementPropertyArray.getConfigContext()).getMdbContainer();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                if (!_logger.isLoggable(Level.FINE)) break block20;
                _logger.log(Level.FINE, exception.getClass().getName(), exception);
            }
        }
        if (mdbContainer != null && (elementPropertyArray = mdbContainer.getElementProperty()) != null) {
            for (int i = 0; i < elementPropertyArray.length; ++i) {
                String string;
                ElementProperty elementProperty = elementPropertyArray[i];
                if (elementProperty == null || (string = elementProperty.getName()) == null) continue;
                try {
                    if (string.equals(propName_reconnect_enabled)) {
                        if (elementProperty.getValue() == null) continue;
                        this.reconnectEnabled = Boolean.valueOf(elementProperty.getValue());
                        continue;
                    }
                    if (string.equals(propName_reconnect_delay_in_seconds)) {
                        try {
                            this.reconnectDelayInSeconds = Integer.parseInt(elementProperty.getValue());
                        }
                        catch (Exception exception) {
                            _logger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                        }
                        continue;
                    }
                    if (string.equals(propName_reconnect_max_retries)) {
                        try {
                            this.reconnectMaxRetries = Integer.parseInt(elementProperty.getValue());
                        }
                        catch (Exception exception) {
                            _logger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                        }
                        continue;
                    }
                    if (string.equals(propName_queue_connection_factory_jndi_name)) {
                        this.defaultQueueCFJndiName = elementProperty.getValue();
                        continue;
                    }
                    if (string.equals(propName_topic_connection_factory_jndi_name)) {
                        this.defaultTopicCFJndiName = elementProperty.getValue();
                        continue;
                    }
                    if (!string.equals(propName_cmt_max_runtime_exceptions)) continue;
                    try {
                        this.cmtMaxRuntimeExceptions = Integer.parseInt(elementProperty.getValue());
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                    }
                    continue;
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "containers.mdb.config_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, exception.getClass().getName(), exception);
                }
            }
        }
        if (this.reconnectDelayInSeconds < 0) {
            this.reconnectDelayInSeconds = 0;
        }
        if (this.reconnectMaxRetries < 0) {
            this.reconnectMaxRetries = 60;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.appEJBName_ + ":" + propName_reconnect_delay_in_seconds + "=" + this.reconnectDelayInSeconds + ", " + propName_reconnect_max_retries + "=" + this.reconnectMaxRetries + ", " + propName_reconnect_enabled + "=" + this.reconnectEnabled);
        }
    }

    protected abstract void doSetup(MessageBeanContainer var1) throws Exception;

    protected abstract void doClose();

    public EjbMessageBeanDescriptor getDescriptor() {
        return this.descriptor_;
    }

    public synchronized void start() throws Exception {
        if (this.connection_ == null) {
            String string = localStrings.getLocalString("containers.mdb.no_connection", this.appEJBName_ + ": No connection available on starting connection", new Object[]{this.appEJBName_});
            throw new JMSException(string);
        }
        this.connection_.start();
        this.connectionState_ = 3;
    }

    public synchronized void close() {
        if (this.connectionState_ != 4 && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "containers.mdb.container_connection_closing", this.appEJBName_);
        }
        this.connectionState_ = 4;
        this.reconnecting = false;
        this.closeConnection();
    }

    private synchronized void closeConnection() {
        block7: {
            block6: {
                this.doClose();
                if (this.connection_ != null) {
                    try {
                        this.connection_.close();
                        this.connection_ = null;
                        _logger.log(Level.INFO, "containers.mdb.container_connection_closed", this.appEJBName_);
                    }
                    catch (Exception exception) {
                        _logger.log(Level.WARNING, "containers.mdb.close_container_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                        if (!_logger.isLoggable(Level.FINE)) break block6;
                        _logger.log(Level.FINE, exception.getClass().getName(), exception);
                    }
                }
            }
            if (this.poolMonitorRegistered_) {
                try {
                    this.container_.unregisterPoolMonitorMBean();
                    this.poolMonitorRegistered_ = false;
                }
                catch (Exception exception) {
                    _logger.log(Level.WARNING, "containers.mdb.close_container_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                    if (!_logger.isLoggable(Level.FINE)) break block7;
                    _logger.log(Level.FINE, exception.getClass().getName(), exception);
                }
            }
        }
    }

    public int getConnectionState() {
        return this.connectionState_;
    }

    public synchronized void setup(MessageBeanContainer messageBeanContainer) throws Exception {
        block19: {
            if (this.connectionState_ == 4) {
                String string = localStrings.getLocalString("containers.mdb.connection_closed", this.appEJBName_ + ": Message-driven bean container connection closed", new Object[]{this.appEJBName_});
                throw new JMSException(string);
            }
            this.container_ = messageBeanContainer;
            String string = null;
            try {
                Object object;
                Object object2;
                InitialContext initialContext = new InitialContext();
                String string2 = this.getDescriptor().getJndiName();
                try {
                    this.msgBeanDestination_ = (Destination)initialContext.lookup(string2);
                    if (this.isQueue()) {
                        object2 = (Queue)this.msgBeanDestination_;
                        string = object2.getQueueName();
                    } else {
                        object2 = (Topic)this.msgBeanDestination_;
                        string = object2.getTopicName();
                    }
                }
                catch (NameNotFoundException nameNotFoundException) {
                    String string3 = localStrings.getLocalString("msgbean.dest.notfound", this.appEJBName_ + ": Message-driven bean destination " + string2 + " not found", new Object[]{this.appEJBName_, string2});
                    _logger.log(Level.SEVERE, "containers.mdb.dest_notfound", new Object[]{this.appEJBName_, string2});
                    _logger.log(Level.SEVERE, nameNotFoundException.getClass().getName(), nameNotFoundException);
                    throw new JMSException(string3);
                }
                catch (ClassCastException classCastException) {
                    String string4 = "javax.jms." + (this.isQueue() ? "Queue" : "Topic");
                    String string5 = localStrings.getLocalString("msgbean.desttype.mismatch", "Message-bean destination type mismatch. Destination {0} is not of type {1}", new Object[]{string2, string4});
                    _logger.log(Level.SEVERE, "containers.mdb.desttype_mismatch", new Object[]{this.appEJBName_, string2, string4});
                    _logger.log(Level.SEVERE, classCastException.getClass().getName(), classCastException);
                    throw new JMSException(string5);
                }
                object2 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                MdbConnectionFactoryDescriptor mdbConnectionFactoryDescriptor = this.descriptor_.getIASEjbExtraDescriptors().getMdbConnectionFactory();
                if (mdbConnectionFactoryDescriptor != null && (object2 = mdbConnectionFactoryDescriptor.getJndiName()) != null) {
                    object = mdbConnectionFactoryDescriptor.getDefaultResourcePrincipal();
                    if (object != null) {
                        string6 = ((DefaultResourcePrincipalDescriptor)object).getName();
                        string7 = ((DefaultResourcePrincipalDescriptor)object).getPassword();
                        if (string7 == null || string6 != null && string6.equals("")) {
                            string6 = null;
                        }
                    }
                    string8 = this.checkConnectionFactoryObject(initialContext, (String)object2, false);
                } else {
                    object2 = this.isQueue() ? this.defaultQueueCFJndiName : this.defaultTopicCFJndiName;
                    string8 = this.checkConnectionFactoryObject(initialContext, (String)object2, true);
                }
                object = JmsWrapperFactory.getFactoryForContainer();
                if (this.isQueue()) {
                    this.connectionFactory_ = ((JmsWrapperFactory)object).createQueueConnectionFactoryWrapper(string8);
                    this.connection_ = string6 == null ? ((QueueConnectionFactory)this.connectionFactory_).createQueueConnection() : ((QueueConnectionFactory)this.connectionFactory_).createQueueConnection(string6, string7);
                } else {
                    this.connectionFactory_ = ((JmsWrapperFactory)object).createTopicConnectionFactoryWrapper(string8);
                    this.connection_ = string6 == null ? ((TopicConnectionFactory)this.connectionFactory_).createTopicConnection() : ((TopicConnectionFactory)this.connectionFactory_).createTopicConnection(string6, string7);
                }
                this.connection_.setExceptionListener((ExceptionListener)new CnxExceptionListener());
                this.doSetup(messageBeanContainer);
                _logger.log(Level.INFO, "containers.mdb.listen_dest", new Object[]{this.appEJBName_, string});
                this.connectionState_ = 2;
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "containers.mdb.setup_container_exception", new Object[]{this.appEJBName_, exception.getMessage()});
                try {
                    if (this.connection_ != null) {
                        this.connection_.close();
                        this.connection_ = null;
                    }
                }
                catch (Throwable throwable) {
                    _logger.log(Level.FINE, "Exception in setup()", throwable);
                }
                throw exception;
            }
            try {
                messageBeanContainer.registerPoolMonitorMBean(this.getPool());
                this.poolMonitorRegistered_ = true;
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "containers.mdb.register_pool_monitor", new Object[]{this.appEJBName_, exception.getMessage()});
                if (!_logger.isLoggable(Level.FINE)) break block19;
                _logger.log(Level.FINE, exception.getClass().getName(), exception);
            }
        }
    }

    private void closeConsumer() {
        try {
            ConnectionConsumer connectionConsumer = this.getConnectionConsumer();
            if (connectionConsumer != null) {
                connectionConsumer.close();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "containers.mdb.consumer_close_exception", new Object[]{this.appEJBName_, exception.toString()});
            _logger.log(Level.SEVERE, exception.getClass().getName(), exception);
        }
    }

    protected ConnectionConsumer getConnectionConsumer() {
        return null;
    }

    private String checkConnectionFactoryObject(Context context, String string, boolean bl) throws Exception {
        String string2 = null;
        ConnectionFactory connectionFactory = null;
        boolean bl2 = false;
        try {
            if (string == null) {
                throw new NameNotFoundException("null");
            }
            connectionFactory = (ConnectionFactory)context.lookup(string);
            if (this.isQueue()) {
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)connectionFactory;
            } else {
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)connectionFactory;
            }
            if (!(connectionFactory instanceof ConnectionFactoryWrapperStandalone)) {
                context.rebind(IASJmsUtil.getXAConnectionFactoryName(string), IASJmsUtil.wrapJMSConnectionFactoryObject(connectionFactory));
                _logger.log(Level.INFO, "containers.mdb.use_external_connfactory", new Object[]{this.appEJBName_, connectionFactory.getClass().getName()});
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            bl2 = true;
            if (!bl || nameNotFoundException instanceof ExternalNameNotFoundException) {
                String string3 = localStrings.getLocalString("msgbean.cnxfactory.notfound", "Message-bean connection factory {0} not found", new Object[]{string});
                _logger.log(Level.SEVERE, "containers.mdb.connfactory_notfound", new Object[]{this.appEJBName_, string, nameNotFoundException.getMessage()});
                _logger.log(Level.SEVERE, nameNotFoundException.getClass().getName(), nameNotFoundException);
                throw new JMSException(string3);
            }
        }
        catch (ClassCastException classCastException) {
            String string4 = "javax.jms." + (this.isQueue() ? "Queue" : "Topic") + "ConnectionFactory";
            String string5 = localStrings.getLocalString("msgbean.connectionfactory.type.mismatch", "Message-bean connection factory type mismatch. Connection factory {0} is not of type {1}", new Object[]{string, string4});
            _logger.log(Level.SEVERE, "containers.mdb.connfactory_type_mismatch", new Object[]{this.appEJBName_, string, string4});
            _logger.log(Level.SEVERE, classCastException.getClass().getName(), classCastException);
            throw new JMSException(string5);
        }
        if (bl && bl2) {
            if (string != null) {
                _logger.log(Level.WARNING, "containers.mdb.connfactory_notfound_use_default", new Object[]{this.appEJBName_, string});
            } else {
                _logger.log(Level.WARNING, "containers.mdb.connfactory_nospec_use_default", new Object[]{this.appEJBName_});
            }
            string2 = this.isQueue() ? "MDB_CONTAINER_QUEUE_CF__jmsxa_default" : "MDB_CONTAINER_TOPIC_CF__jmsxa_default";
        } else {
            string2 = IASJmsUtil.getXAConnectionFactoryName(string);
        }
        context.lookup(string2);
        return string2;
    }

    public Session createSession(Connection connection) throws Exception {
        if (this.isQueue()) {
            int n = this.descriptor_.getJmsAcknowledgeMode();
            return ((QueueConnection)connection).createQueueSession(false, n);
        }
        int n = this.descriptor_.getJmsAcknowledgeMode();
        return ((TopicConnection)connection).createTopicSession(false, n);
    }

    public Session createSession() throws Exception {
        return this.isQueue() ? this.createQueueSession() : this.createTopicSession();
    }

    protected int getMaxServerSessionMessages() {
        int n = 1;
        int n2 = this.descriptor_.getIASEjbExtraDescriptors().getJmsMaxMessagesLoad();
        if (n2 > 0) {
            n = n2;
        } else {
            _logger.log(Level.WARNING, "containers.mdb.invalid_maxmsg", new Object[]{this.appEJBName_, new Integer(n2)});
        }
        return n;
    }

    protected BeanPoolDescriptor getBeanPoolDescriptor() throws ConfigException {
        BeanPoolDescriptor beanPoolDescriptor = this.descriptor_.getIASEjbExtraDescriptors().getBeanPool();
        if (beanPoolDescriptor == null) {
            beanPoolDescriptor = new BeanPoolDescriptor();
        }
        ServerContext serverContext = ApplicationServer.getServerContext();
        MdbContainer mdbContainer = ServerBeansFactory.getServerBean(serverContext.getConfigContext()).getMdbContainer();
        int n = beanPoolDescriptor.getMaxPoolSize();
        if (n < 0) {
            n = MessageBeanHelperBase.stringToInt(mdbContainer.getMaxPoolSize(), this.appEJBName_, _logger);
        }
        n = this.validateValue(n, 1, -1, 60, "max-pool-size", this.appEJBName_, _logger);
        beanPoolDescriptor.setMaxPoolSize(n);
        int n2 = beanPoolDescriptor.getSteadyPoolSize();
        if (n2 < 0) {
            n2 = MessageBeanHelperBase.stringToInt(mdbContainer.getSteadyPoolSize(), this.appEJBName_, _logger);
        }
        n2 = this.validateValue(n2, 0, n, 10, "steady-pool-size", this.appEJBName_, _logger);
        beanPoolDescriptor.setSteadyPoolSize(n2);
        n2 = beanPoolDescriptor.getPoolResizeQuantity();
        if (n2 < 0) {
            n2 = MessageBeanHelperBase.stringToInt(mdbContainer.getPoolResizeQuantity(), this.appEJBName_, _logger);
        }
        n2 = this.validateValue(n2, 1, n, 1, "pool-resize-quantity", this.appEJBName_, _logger);
        beanPoolDescriptor.setPoolResizeQuantity(n2);
        n2 = beanPoolDescriptor.getPoolIdleTimeoutInSeconds();
        if (n2 <= 0) {
            n2 = MessageBeanHelperBase.stringToInt(mdbContainer.getIdleTimeoutInSeconds(), this.appEJBName_, _logger);
        }
        n2 = this.validateValue(n2, 1, -1, 600, "idle-timeout-in-seconds", this.appEJBName_, _logger);
        beanPoolDescriptor.setPoolIdleTimeoutInSeconds(n2);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.appEJBName_ + ": Setting message-driven bean pool max-pool-size=" + beanPoolDescriptor.getMaxPoolSize() + ", steady-pool-size=" + beanPoolDescriptor.getSteadyPoolSize() + ", pool-resize-quantity=" + beanPoolDescriptor.getPoolResizeQuantity() + ", idle-timeout-in-seconds=" + beanPoolDescriptor.getPoolIdleTimeoutInSeconds());
        }
        return beanPoolDescriptor;
    }

    protected boolean isQueue() {
        return this.msgStyle_ == 0;
    }

    protected QueueConnectionFactory getQueueConnectionFactory() throws Exception {
        return (QueueConnectionFactory)this.connectionFactory_;
    }

    protected TopicConnectionFactory getTopicConnectionFactory() throws Exception {
        return (TopicConnectionFactory)this.connectionFactory_;
    }

    protected QueueConnection getQueueConnection() {
        return (QueueConnection)this.connection_;
    }

    protected TopicConnection getTopicConnection() {
        return (TopicConnection)this.connection_;
    }

    protected QueueSession createQueueSession() throws Exception {
        int n = this.descriptor_.getJmsAcknowledgeMode();
        return this.getQueueConnection().createQueueSession(false, n);
    }

    protected TopicSession createTopicSession() throws Exception {
        int n = this.descriptor_.getJmsAcknowledgeMode();
        return this.getTopicConnection().createTopicSession(false, n);
    }

    protected Destination getDestination() {
        return this.msgBeanDestination_;
    }

    protected Queue getQueueDestination() {
        return (Queue)this.getDestination();
    }

    protected Topic getTopicDestination() {
        return (Topic)this.getDestination();
    }

    public Object getPool() {
        return null;
    }

    private void onException(JMSException jMSException) {
        if (JmsProviderLifecycle.isShutdown()) {
            _logger.log(Level.FINE, "containers.mdb.conn_exception_onshutdown", new Object[]{this.appEJBName_, jMSException.getMessage()});
            return;
        }
        _logger.log(Level.FINE, "containers.mdb.connection_exception", new Object[]{this.appEJBName_, this.connection_, this.getDescriptor(), jMSException.getMessage()});
        _logger.log(Level.FINE, ((Object)((Object)jMSException)).getClass().getName(), jMSException);
        if (this.reconnectEnabled && !this.reconnecting && this.connectionState_ != 4) {
            this.reconnecting = true;
            class ReconnectingThread
            extends Thread {
                ReconnectingThread() {
                }

                public void run() {
                    MessageBeanHelperBase.this.closeConnection();
                    MessageBeanHelperBase.this.reconnect();
                }
            }
            ReconnectingThread reconnectingThread = new ReconnectingThread();
            reconnectingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnection() {
        Object object = this.destroyConnectionLock_;
        synchronized (object) {
            if (this.connectionState_ == 4) {
                return;
            }
            this.connectionState_ = 4;
        }
        class DestroyConnectionThread
        extends Thread {
            DestroyConnectionThread() {
            }

            public void run() {
                MessageBeanHelperBase.this.closeConsumer();
                MessageBeanHelperBase.this.close();
            }
        }
        object = new DestroyConnectionThread();
        ((Thread)object).start();
    }

    private void reconnect() {
        int n = 0;
        boolean bl = true;
        while (this.reconnecting) {
            ++n;
            try {
                if (this.connectionState_ == 4) {
                    return;
                }
                if (n == 1) {
                    _logger.log(Level.FINE, "containers.mdb.reconnecting", this.appEJBName_);
                }
                _logger.log(Level.FINE, this.appEJBName_ + ": retry connecting " + n);
                Thread.sleep(this.reconnectDelayInSeconds * 1000);
                this.setup(this.container_);
                this.reconnecting = false;
                _logger.log(Level.FINE, "containers.mdb.reconnected", this.appEJBName_);
            }
            catch (Exception exception) {
                if (this.reconnectMaxRetries == 0) {
                    if (n != Integer.MAX_VALUE) continue;
                    n = 0;
                    continue;
                }
                if (n != this.reconnectMaxRetries) continue;
                this.reconnecting = false;
                _logger.log(Level.SEVERE, "containers.mdb.reconnection_exception", new Object[]{this.appEJBName_, new Integer(this.reconnectMaxRetries)});
                _logger.log(Level.SEVERE, exception.getClass().getName(), exception);
            }
        }
        if (this.connectionState_ == 2 && !this.reconnecting) {
            try {
                this.start();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "containers.mdb.start_connection_error", new Object[]{this.appEJBName_, exception.getMessage()});
                _logger.log(Level.SEVERE, exception.getClass().getName(), exception);
                this.close();
            }
        }
    }

    protected static int stringToInt(String string, String string2, Logger logger) {
        int n;
        block2: {
            n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, string2 + ":" + exception.getMessage());
                if (!logger.isLoggable(Level.FINE)) break block2;
                logger.log(Level.FINE, exception.getClass().getName(), exception);
            }
        }
        return n;
    }

    protected int validateValue(int n, int n2, int n3, int n4, String string, String string2, Logger logger) {
        if (n < n2) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{string2, new Integer(n), string, new Integer(n2)});
            n = n4;
        }
        if (n3 >= 0 && n > n3) {
            _logger.log(Level.WARNING, "containers.mdb.invalid_value", new Object[]{string2, new Integer(n), string, new Integer(n3)});
            n = n3;
        }
        return n;
    }

    private class CnxExceptionListener
    implements ExceptionListener {
        private CnxExceptionListener() {
        }

        public void onException(JMSException jMSException) {
            MessageBeanHelperBase.this.onException(jMSException);
        }
    }
}

