/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public abstract class EJBLocalObjectImpl
extends EJBLocalRemoteObject
implements EJBLocalObject {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EJBLocalObjectImpl.class);

    public EJBLocalHome getEJBLocalHome() throws EJBException {
        this.container.authorizeLocalMethod(10);
        this.container.checkExists(this);
        return this.container.getEJBLocalHome();
    }

    public void remove() throws RemoveException, EJBException {
        this.container.authorizeLocalMethod(12);
        Method method = null;
        try {
            method = EJBLocalObject.class.getMethod("remove", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _logger.log(Level.FINE, "Exception in method remove()", noSuchMethodException);
        }
        this.container.removeBean(this, method, true);
    }

    public Object getPrimaryKey() throws EJBException {
        if (this.container instanceof EntityContainer) {
            this.container.authorizeLocalMethod(11);
            this.container.checkExists(this);
            return this.primaryKey;
        }
        throw new EJBException(localStrings.getLocalString("containers.invalid_operation", "Invalid operation for Session EJBs."));
    }

    public boolean isIdentical(EJBLocalObject eJBLocalObject) throws EJBException {
        this.container.authorizeLocalMethod(13);
        this.container.checkExists(this);
        return this == eJBLocalObject;
    }

    public SerializableLocalObject getSerializableObject() {
        SerializableLocalObject serializableLocalObject = new SerializableLocalObject();
        if (this.container.getEjbDescriptor() == null) {
            _logger.log(Level.WARNING, "EJBLocalObjectImpl:Could not get SerializableLocalObject for Local", new OBJECT_NOT_EXIST("Ejb container is no longer valid"));
            return null;
        }
        serializableLocalObject.containerId = this.container.getEjbDescriptor().getUniqueId();
        serializableLocalObject.primaryKey = this.primaryKey;
        EjbDescriptor ejbDescriptor = this.container.getEjbDescriptor();
        serializableLocalObject.ejbName = ejbDescriptor.getName();
        serializableLocalObject.jarName = ejbDescriptor.getEjbBundleDescriptor().getArchivist().getArchiveUri();
        Application application = ejbDescriptor.getEjbBundleDescriptor().getApplication();
        serializableLocalObject.appName = application.isVirtual() ? null : application.getRegistrationName();
        return serializableLocalObject;
    }

    public static EJBLocalObjectImpl getLocalObject(SerializableLocalObject serializableLocalObject, boolean bl) throws Exception {
        EJBLocalObjectImpl eJBLocalObjectImpl;
        _logger.log(Level.FINEST, "Coming to getLocalObject failStatefulSession =" + bl);
        long l = EJBUtils.getEjbId(serializableLocalObject.appName, serializableLocalObject.jarName, serializableLocalObject.ejbName);
        BaseContainer baseContainer = (BaseContainer)Switch.getSwitch().getContainerFactory().getContainer(l);
        if (bl && baseContainer instanceof StatefulSessionContainer) {
            ClassLoader classLoader = baseContainer.getClassLoader();
            EjbDescriptor ejbDescriptor = baseContainer.getEjbDescriptor();
            String string = ejbDescriptor.getEJBLocalObjectImplClassName();
            Class<?> clazz = classLoader.loadClass(string);
            eJBLocalObjectImpl = (EJBLocalObjectImpl)clazz.newInstance();
            eJBLocalObjectImpl.setContainer(baseContainer);
            eJBLocalObjectImpl.setRemoved(true);
        } else {
            _logger.log(Level.FINEST, "REACHED HERE ++++++++++++++++++++ failStateful = false");
            eJBLocalObjectImpl = baseContainer.getEJBLocalObject(serializableLocalObject.primaryKey);
        }
        return eJBLocalObjectImpl;
    }

    public static final class SerializableLocalObject
    implements Serializable {
        long containerId;
        Object primaryKey;
        String appName;
        String jarName;
        String ejbName;
    }
}

