/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EntityContainer;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import org.omg.CORBA.OBJECT_NOT_EXIST;

public abstract class EJBLocalHomeImpl
implements EJBLocalHome {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private BaseContainer container;

    final void setContainer(BaseContainer baseContainer) {
        this.container = baseContainer;
    }

    protected final BaseContainer getContainer() {
        return this.container;
    }

    protected final EJBLocalObject createEJBLocalObject() throws CreateException {
        return this.container.createEJBLocalObject();
    }

    public final void remove(Object object) throws RemoveException, EJBException {
        if (!(this.container instanceof EntityContainer)) {
            throw new RemoveException("Invalid remove operation.");
        }
        this.container.authorizeLocalMethod(4);
        Method method = null;
        try {
            method = EJBLocalHome.class.getMethod("remove", Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _logger.log(Level.FINE, "Exception in method remove()", noSuchMethodException);
        }
        ((EntityContainer)this.container).removeBean(object, method, true);
    }

    public SerializableLocalHome getSerializableObject() {
        SerializableLocalHome serializableLocalHome = new SerializableLocalHome();
        EjbDescriptor ejbDescriptor = this.container.getEjbDescriptor();
        if (ejbDescriptor == null) {
            _logger.log(Level.WARNING, "EJBLocalHomeImpl:Could not get SerializableLocalObject for LocalHome", new OBJECT_NOT_EXIST("Ejb container is no longer valid"));
            return null;
        }
        serializableLocalHome.ejbName = ejbDescriptor.getName();
        serializableLocalHome.jarName = ejbDescriptor.getEjbBundleDescriptor().getArchivist().getArchiveUri();
        Application application = ejbDescriptor.getEjbBundleDescriptor().getApplication();
        serializableLocalHome.appName = application.isVirtual() ? null : application.getRegistrationName();
        return serializableLocalHome;
    }

    public static EJBLocalHomeImpl getLocalHome(SerializableLocalHome serializableLocalHome) throws Exception {
        long l = EJBUtils.getEjbId(serializableLocalHome.appName, serializableLocalHome.jarName, serializableLocalHome.ejbName);
        BaseContainer baseContainer = (BaseContainer)Switch.getSwitch().getContainerFactory().getContainer(l);
        return (EJBLocalHomeImpl)baseContainer.getEJBLocalHome();
    }

    public static final class SerializableLocalHome
    implements Serializable {
        String appName;
        String jarName;
        String ejbName;
    }
}

