/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

final class ContainerSynchronization
implements Synchronization {
    private static Logger _logger = null;
    private Vector beans = new Vector();
    private Vector pmSyncs = new Vector();
    private Transaction tx;
    private ContainerFactoryImpl containerFactory;
    static boolean flag;

    ContainerSynchronization(Transaction transaction, ContainerFactoryImpl containerFactoryImpl) {
        this.tx = transaction;
        this.containerFactory = containerFactoryImpl;
    }

    Vector getBeanList() {
        return this.beans;
    }

    void addBean(EJBContextImpl eJBContextImpl) {
        if (this.beans.contains(eJBContextImpl)) {
            return;
        }
        this.beans.add(eJBContextImpl);
    }

    void removeBean(EntityContextImpl entityContextImpl) {
        this.beans.remove(entityContextImpl);
        flag = true;
    }

    void addPMSynchronization(Synchronization synchronization) {
        this.pmSyncs.add(synchronization);
    }

    public void beforeCompletion() {
        EJBContextImpl eJBContextImpl;
        int n;
        for (n = 0; n < this.beans.size(); ++n) {
            eJBContextImpl = (EJBContextImpl)this.beans.elementAt(n);
            BaseContainer baseContainer = (BaseContainer)eJBContextImpl.getContainer();
            try {
                baseContainer.beforeCompletion(eJBContextImpl);
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", exception);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                return;
            }
        }
        for (n = 0; n < this.pmSyncs.size(); ++n) {
            eJBContextImpl = (Synchronization)this.pmSyncs.elementAt(n);
            try {
                eJBContextImpl.beforeCompletion();
                continue;
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", exception);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public void afterCompletion(int n) {
        Object object;
        int n2;
        for (n2 = 0; n2 < this.pmSyncs.size(); ++n2) {
            object = (Synchronization)this.pmSyncs.elementAt(n2);
            try {
                object.afterCompletion(n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n2 = 0; n2 < this.beans.size(); ++n2) {
            object = (EJBContextImpl)this.beans.elementAt(n2);
            BaseContainer baseContainer = (BaseContainer)((EJBContextImpl)object).getContainer();
            try {
                baseContainer.afterCompletion((EJBContextImpl)object, n);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.containerFactory.removeContainerSync(this.tx);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
        flag = false;
    }
}

