/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.iplanet.ias.admin.monitor.BaseMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.MonitoringHelper;
import com.iplanet.ias.util.io.FileUtils;
import com.sun.ejb.ComponentContext;
import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.ejb.InvocationInfo;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBHomeImpl;
import com.sun.ejb.containers.EJBLocalHomeImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.ejb.containers.EJBLocalRemoteObject;
import com.sun.ejb.containers.EJBObjectImpl;
import com.sun.ejb.containers.PreInvokeException;
import com.sun.ejb.containers.SafeProperties;
import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.monitor.EJBGenericMonitorMBean;
import com.sun.ejb.containers.monitor.MethodMonitorMBean;
import com.sun.ejb.portable.EJBMetaDataImpl;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.AccessLocalException;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.EnterpriseBean;
import javax.ejb.FinderException;
import javax.ejb.Handle;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.jms.Message;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;

public abstract class BaseContainer
implements Container {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    protected static final boolean debug = true;
    protected Object[] logParams = null;
    private static final int EJB_INTF_METHODS_LENGTH = 16;
    static final int EJBHome_remove_Handle = 0;
    static final int EJBHome_remove_Pkey = 1;
    static final int EJBHome_getEJBMetaData = 2;
    static final int EJBHome_getHomeHandle = 3;
    static final int EJBLocalHome_remove_Pkey = 4;
    static final int EJBObject_getEJBHome = 5;
    static final int EJBObject_getPrimaryKey = 6;
    static final int EJBObject_remove = 7;
    static final int EJBObject_getHandle = 8;
    static final int EJBObject_isIdentical = 9;
    static final int EJBLocalObject_getEJBLocalHome = 10;
    static final int EJBLocalObject_getPrimaryKey = 11;
    static final int EJBLocalObject_remove = 12;
    static final int EJBLocalObject_isIdentical = 13;
    static final int EJBHome_create = 14;
    static final int EJBLocalHome_create = 15;
    private static final String USER_TX = "java:comp/UserTransaction";
    protected ClassLoader loader = null;
    protected Class ejbClass = null;
    protected Method ejbPassivateMethod = null;
    protected Method ejbActivateMethod = null;
    protected Method ejbRemoveMethod = null;
    protected boolean isRemote = false;
    protected Class ejbObjectClass = null;
    protected Class ejbObjectTieClass = null;
    protected Class ejbObjectStubClass = null;
    protected Class remoteIntf = null;
    protected Class homeIntf = null;
    protected boolean isLocal = false;
    protected Class localEjbObjectClass = null;
    protected Class localHomeIntf = null;
    protected Class localIntf = null;
    protected EJBLocalHome ejbLocalHome;
    protected EJBMetaData metadata = null;
    protected EJBHome ejbHome;
    protected EJBHome ejbHomeStub;
    protected ProtocolManager protocolMgr = null;
    protected J2EETransactionManager transactionManager;
    protected NamingManager namingManager;
    protected SecurityManager securityManager;
    protected ContainerFactoryImpl containerFactory;
    InvocationManager invocationManager;
    Switch theSwitch;
    protected boolean isSession;
    protected boolean isStatelessSession;
    protected boolean isMessageDriven;
    protected boolean isEntity;
    protected EjbDescriptor ejbDescriptor;
    protected String componentId;
    protected HashMap methodTable;
    protected HashMap invocationInfoMap = new HashMap();
    protected Method[] ejbIntfMethods;
    protected boolean[] uncheckedEjbIntfMethods;
    protected Properties envProps;
    protected boolean undeployed = false;
    boolean isBeanManagedTran = false;
    protected HashMap methodMBeanTable;
    protected boolean monitorOn = false;
    protected EJBGenericMonitorMBean ejbMBean;
    protected int numCreated;
    protected int numDestroyed;
    protected int numPassivated;
    protected int numActivated;
    protected long timeLastCreated;
    protected long timeLastDestroyed;
    protected long timeLastPassivated;
    protected long timeLastActivated;
    protected boolean debugMonitorFlag = false;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(BaseContainer.class);

    protected BaseContainer(EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws Exception {
        try {
            Object object;
            this.loader = classLoader;
            this.ejbDescriptor = ejbDescriptor;
            this.logParams = new Object[1];
            this.logParams[0] = ejbDescriptor.getName();
            this.theSwitch = Switch.getSwitch();
            this.protocolMgr = this.theSwitch.getProtocolManager();
            this.invocationManager = this.theSwitch.getInvocationManager();
            this.namingManager = this.theSwitch.getNamingManager();
            this.transactionManager = this.theSwitch.getTransactionManager();
            this.containerFactory = (ContainerFactoryImpl)this.theSwitch.getContainerFactory();
            this.theSwitch.setDescriptorFor(this, this.ejbDescriptor);
            this.ejbClass = classLoader.loadClass(this.ejbDescriptor.getEjbImplClassName());
            if (this.ejbDescriptor.getType().equals("Message-driven")) {
                this.isMessageDriven = true;
                object = (EjbMessageBeanDescriptor)this.ejbDescriptor;
                this.isBeanManagedTran = ((EjbDescriptor)object).getTransactionType().equals("Bean");
            } else {
                if (this.ejbDescriptor.isRemoteInterfacesSupported()) {
                    this.isRemote = true;
                    object = this.ejbDescriptor.getEJBObjectImplClassName();
                    this.ejbObjectClass = classLoader.loadClass((String)object);
                    this.homeIntf = classLoader.loadClass(this.ejbDescriptor.getHomeClassName());
                    this.remoteIntf = classLoader.loadClass(this.ejbDescriptor.getRemoteClassName());
                }
                if (this.ejbDescriptor.isLocalInterfacesSupported()) {
                    this.isLocal = true;
                    object = this.ejbDescriptor.getEJBLocalObjectImplClassName();
                    this.localEjbObjectClass = classLoader.loadClass((String)object);
                    this.localHomeIntf = classLoader.loadClass(this.ejbDescriptor.getLocalHomeClassName());
                    this.localIntf = classLoader.loadClass(this.ejbDescriptor.getLocalClassName());
                }
                this.ejbPassivateMethod = this.ejbClass.getMethod("ejbPassivate", null);
                this.ejbActivateMethod = this.ejbClass.getMethod("ejbActivate", null);
                this.ejbRemoveMethod = this.ejbClass.getMethod("ejbRemove", null);
                if (this.ejbDescriptor.getType().equals(EjbEntityDescriptor.TYPE)) {
                    this.isEntity = true;
                } else {
                    this.isSession = true;
                    object = (EjbSessionDescriptor)this.ejbDescriptor;
                    this.isStatelessSession = ((EjbSessionDescriptor)object).isStateless();
                    this.isBeanManagedTran = ((EjbDescriptor)object).getTransactionType().equals("Bean");
                }
            }
            this.initializeMethodTable();
            this.methodMBeanTable = new HashMap();
            this.setupEnvironment();
            this.ejbMBean = this.createEJBMonitorMBean();
            this.registerEJBMonitorMBean(this.ejbMBean.getMonitoredObjectType(), this.ejbMBean);
            Vector vector = this.ejbDescriptor.getMethods();
            for (int i = 0; i < vector.size(); ++i) {
                Method method = (Method)vector.elementAt(i);
                object = new MethodMonitorMBean(method.toString());
                this.methodMBeanTable.put(method, object);
                try {
                    this.ejbMBean.addChild(method.getName() + i, MonitoredObjectType.BEAN_METHOD, (BaseMonitorMBean)object);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.basecontainer_exception", this.logParams);
            _logger.log(Level.SEVERE, "", exception);
            throw exception;
        }
    }

    final boolean isBeanManagedTx() {
        return this.isBeanManagedTran;
    }

    public final ClassLoader getClassLoader() {
        return this.loader;
    }

    public final EjbDescriptor getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public final EJBMetaData getEJBMetaData() {
        return this.metadata;
    }

    public final Class getEjbObjectTieClass() {
        return this.ejbObjectTieClass;
    }

    final UserTransaction getUserTransaction() {
        if ((this.isSession || this.isMessageDriven) && this.isBeanManagedTran) {
            try {
                UserTransaction userTransaction = (UserTransaction)this.namingManager.getInitialContext().lookup(USER_TX);
                return userTransaction;
            }
            catch (Exception exception) {
                _logger.log(Level.FINER, "ejb.user_transaction_exception", exception);
                throw new EJBException("Unable to lookup UserTransaction", exception);
            }
        }
        throw new IllegalStateException("ERROR: only SessionBeans with bean-managed transactions can obtain UserTransaction");
    }

    public final EJBHome getEJBHomeStub() {
        return this.ejbHomeStub;
    }

    public final EJBHome getEJBHome() {
        return this.ejbHome;
    }

    public final EJBLocalHome getEJBLocalHome() {
        return this.ejbLocalHome;
    }

    public final SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public final void setSecurityManager(SecurityManager securityManager) throws Exception {
        this.securityManager = securityManager;
        this.initializeEjbInterfaceMethods();
        this.initializeInvocationInfoMap();
    }

    final Properties getEnvironmentProperties() {
        return this.envProps;
    }

    public Class getLocalHomeInterfaceClass() {
        return this.localHomeIntf;
    }

    public Class getRemoteHomeInterfaceClass() {
        return this.homeIntf;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteIntf;
    }

    public Class getLocalInterfaceClass() {
        return this.localIntf;
    }

    void initializeHome() throws Exception {
        Object object;
        Serializable serializable;
        Object object2;
        String string = this.ejbDescriptor.getEjbImplClassName();
        int n = string.lastIndexOf(".");
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n) + ".";
        }
        if (this.isRemote) {
            object2 = this.ejbDescriptor.getRemoteHomeImplClassName();
            serializable = this.loader.loadClass((String)object2);
            object = (EJBHomeImpl)((Object)((Class)serializable).newInstance());
            ((EJBHomeImpl)((Object)object)).setContainer(this);
            this.ejbHome = object;
            Object object3 = this.protocolMgr.createReference((Remote)this.ejbHome, this.ejbDescriptor.getUniqueId(), ContainerFactoryImpl.homeInstanceKey);
            this.ejbHomeStub = (EJBHome)PortableRemoteObject.narrow((Object)object3, (Class)this.homeIntf);
            this.namingManager.publishObject(this.ejbDescriptor.getJndiName(), (Object)this.ejbHomeStub, false);
            EJBObjectImpl eJBObjectImpl = (EJBObjectImpl)this.ejbObjectClass.newInstance();
            PortableRemoteObject.exportObject((Remote)((Object)eJBObjectImpl));
            this.ejbObjectTieClass = Util.getTie((Remote)((Object)eJBObjectImpl)).getClass();
        }
        if (this.isLocal) {
            object2 = this.ejbDescriptor.getLocalHomeImplClassName();
            serializable = this.loader.loadClass((String)object2);
            object = (EJBLocalHomeImpl)((Class)serializable).newInstance();
            ((EJBLocalHomeImpl)object).setContainer(this);
            this.ejbLocalHome = object;
            this.theSwitch.addLocalHome(this.ejbDescriptor.getLocalJndiName(), this.ejbLocalHome);
        }
        object2 = null;
        if (this.isEntity) {
            serializable = (EjbEntityDescriptor)this.ejbDescriptor;
            object2 = this.loader.loadClass(((EjbEntityDescriptor)serializable).getPrimaryKeyClassName());
        }
        this.metadata = new EJBMetaDataImpl(this.ejbHomeStub, this.homeIntf, this.remoteIntf, (Class)object2, this.isSession, this.isStatelessSession);
    }

    public void preInvoke(Invocation invocation) {
        if (this.undeployed) {
            throw new EJBException("ERROR: Attempt to invoke on undeployed object");
        }
        try {
            MethodMonitorMBean methodMonitorMBean;
            ComponentContext componentContext;
            if (!this.securityManager.authorize(invocation)) {
                throw new AccessLocalException("Client not authorized for this invocation.");
            }
            Method method = invocation.method;
            if (method != null) {
                invocation.invocationInfo = (InvocationInfo)this.invocationInfoMap.get(method);
            }
            invocation.context = componentContext = this.getContext(invocation);
            invocation.ejb = componentContext.getEJB();
            invocation.instance = invocation.ejb;
            invocation.container = this;
            this.invocationManager.preInvoke(invocation);
            this.preInvokeTx(invocation);
            if (this.monitorOn && (methodMonitorMBean = (MethodMonitorMBean)this.methodMBeanTable.get(invocation.method)) != null) {
                methodMonitorMBean.preInvoke();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.preinvoke_exception", this.logParams);
            _logger.log(Level.SEVERE, "", exception);
            EJBException eJBException = exception instanceof EJBException ? (EJBException)exception : new EJBException(exception);
            throw new PreInvokeException(eJBException);
        }
    }

    public void postInvoke(Invocation invocation) {
        MethodMonitorMBean methodMonitorMBean;
        if (this.monitorOn && (methodMonitorMBean = (MethodMonitorMBean)this.methodMBeanTable.get(invocation.method)) != null) {
            methodMonitorMBean.postInvoke(invocation.exception);
        }
        if (invocation.ejb != null) {
            this.invocationManager.postInvoke(invocation);
            try {
                this.postInvokeTx(invocation);
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "ejb.postinvoketx_exception", exception);
                invocation.exception = exception instanceof EJBException ? (EJBException)exception : new EJBException(exception);
            }
            this.releaseContext(invocation);
        }
        if (invocation.exception != null) {
            _logger.log(Level.FINE, "ejb.some_unmapped_exception", invocation.exception);
            if (invocation.exception instanceof PreInvokeException) {
                invocation.exception = ((PreInvokeException)((Object)invocation.exception)).exception;
            }
            if (!invocation.isLocal) {
                _logger.log(Level.FINE, "ejb.some_remote_mapped_exception", this.logParams);
                _logger.log(Level.FINE, "", invocation.exception.toString());
                invocation.exception = this.protocolMgr.mapException(invocation.exception);
            }
            _logger.log(Level.FINE, "ejb.some_app_and_sys_exception", this.logParams);
            _logger.log(Level.FINE, "", invocation.exception.toString());
        }
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().doInstrumentForEjb(this.ejbDescriptor, invocation.method, invocation.exception);
        }
    }

    void authorizeLocalMethod(int n) {
        if (this.uncheckedEjbIntfMethods[n]) {
            return;
        }
        Invocation invocation = new Invocation();
        invocation.method = this.ejbIntfMethods[n];
        if (!this.securityManager.authorize(invocation)) {
            throw new AccessLocalException("Client is not authorized for this invocation.");
        }
    }

    void authorizeRemoteMethod(int n) throws RemoteException {
        if (this.uncheckedEjbIntfMethods[n]) {
            return;
        }
        Invocation invocation = new Invocation();
        invocation.method = this.ejbIntfMethods[n];
        if (!this.securityManager.authorize(invocation)) {
            AccessException accessException = new AccessException("Client is not authorized for this invocation.");
            Throwable throwable = this.protocolMgr.mapException(accessException);
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof RemoteException) {
                throw (RemoteException)throwable;
            }
            throw accessException;
        }
    }

    private void initializeEjbInterfaceMethods() throws Exception {
        this.ejbIntfMethods = new Method[16];
        if (this.isRemote) {
            this.ejbIntfMethods[0] = this.homeIntf.getMethod("remove", Handle.class);
            this.ejbIntfMethods[1] = this.homeIntf.getMethod("remove", Object.class);
            this.ejbIntfMethods[2] = this.homeIntf.getMethod("getEJBMetaData", null);
            this.ejbIntfMethods[3] = this.homeIntf.getMethod("getHomeHandle", null);
            this.ejbIntfMethods[5] = this.remoteIntf.getMethod("getEJBHome", null);
            this.ejbIntfMethods[6] = this.remoteIntf.getMethod("getPrimaryKey", null);
            this.ejbIntfMethods[7] = this.remoteIntf.getMethod("remove", null);
            this.ejbIntfMethods[8] = this.remoteIntf.getMethod("getHandle", null);
            this.ejbIntfMethods[9] = this.remoteIntf.getMethod("isIdentical", EJBObject.class);
            if (this.isStatelessSession) {
                this.ejbIntfMethods[14] = this.homeIntf.getMethod("create", null);
            }
        }
        if (this.isLocal) {
            this.ejbIntfMethods[4] = this.localHomeIntf.getMethod("remove", Object.class);
            this.ejbIntfMethods[10] = this.localIntf.getMethod("getEJBLocalHome", null);
            this.ejbIntfMethods[11] = this.localIntf.getMethod("getPrimaryKey", null);
            this.ejbIntfMethods[12] = this.localIntf.getMethod("remove", null);
            this.ejbIntfMethods[13] = this.localIntf.getMethod("isIdentical", EJBLocalObject.class);
            if (this.isStatelessSession) {
                this.ejbIntfMethods[15] = this.localHomeIntf.getMethod("create", null);
            }
        }
        this.uncheckedEjbIntfMethods = new boolean[16];
        for (int i = 0; i < this.ejbIntfMethods.length; ++i) {
            if (this.ejbIntfMethods[i] == null) continue;
            this.uncheckedEjbIntfMethods[i] = this.securityManager.isUnchecked(this.ejbIntfMethods[i]);
        }
    }

    protected abstract EJBGenericMonitorMBean createEJBMonitorMBean();

    abstract EJBObject createEJBObject() throws CreateException, RemoteException;

    EJBLocalObject createEJBLocalObject() throws CreateException {
        throw new EJBException("Internal ERROR: BaseContainer.createEJBLocalObject called");
    }

    abstract EJBObject getEJBObject(byte[] var1);

    EJBLocalObjectImpl getEJBLocalObject(Object object) {
        throw new EJBException("Internal ERROR: BaseContainer.getEJBLocalObject called");
    }

    void checkExists(EJBLocalRemoteObject eJBLocalRemoteObject) {
        throw new EJBException("Internal ERROR: BaseContainer.checkExists called");
    }

    protected abstract ComponentContext getContext(Invocation var1) throws EJBException;

    protected abstract void releaseContext(Invocation var1) throws EJBException;

    abstract boolean passivateEJB(ComponentContext var1);

    abstract void forceDestroyBean(EJBContextImpl var1) throws EJBException;

    abstract void removeBean(EJBLocalRemoteObject var1, Method var2, boolean var3) throws RemoveException, EJBException;

    public void removeBeanUnchecked(Object object) {
        throw new EJBException("removeBeanUnchecked only works for EntityContainer");
    }

    public void removeBeanUnchecked(EJBLocalObject eJBLocalObject) {
        throw new EJBException("removeBeanUnchecked only works for EntityContainer");
    }

    public EJBLocalObject getEJBLocalObjectForPrimaryKey(Object object, EJBContext eJBContext) {
        throw new EJBException("getEJBLocalObjectForPrimaryKey(pkey, ctx) only works for EntityContainer");
    }

    public EJBLocalObject getEJBLocalObjectForPrimaryKey(Object object) {
        throw new EJBException("getEJBLocalObjectForPrimaryKey only works for EntityContainer");
    }

    public EJBObject getEJBObjectForPrimaryKey(Object object) {
        throw new EJBException("getEJBObjectForPrimaryKey only works for EntityContainer");
    }

    boolean isIdentical(EJBObjectImpl eJBObjectImpl, EJBObject eJBObject) throws RemoteException {
        throw new EJBException("Internal ERROR: BaseContainer.isIdentical called");
    }

    Enumeration listActiveEJBs() {
        return null;
    }

    final int getTxAttr(Invocation invocation) throws EJBException {
        if (invocation.transactionAttribute != 0) {
            return invocation.transactionAttribute;
        }
        Integer n = (Integer)this.methodTable.get(invocation.method);
        if (n != null) {
            invocation.transactionAttribute = n;
            return invocation.transactionAttribute;
        }
        throw new EJBException("Transaction Attribute not found for method " + invocation.method);
    }

    final boolean isBusinessMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (this.isRemote && (clazz == this.homeIntf || clazz.isAssignableFrom(this.homeIntf) || clazz == EJBObject.class)) {
            return false;
        }
        return !this.isLocal || clazz != this.localHomeIntf && !clazz.isAssignableFrom(this.localHomeIntf) && clazz != EJBLocalObject.class;
    }

    final boolean isHomeFinder(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (this.isMessageDriven || this.isSession) {
            return false;
        }
        if (this.isRemote && clazz.isAssignableFrom(this.homeIntf) && clazz != EJBHome.class && !method.getName().startsWith("create")) {
            return true;
        }
        return this.isLocal && clazz.isAssignableFrom(this.localHomeIntf) && clazz != EJBLocalHome.class && !method.getName().startsWith("create");
    }

    final boolean isCreateHomeFinder(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (this.isMessageDriven) {
            return false;
        }
        if (this.isRemote && clazz.isAssignableFrom(this.homeIntf) && clazz != EJBHome.class) {
            return true;
        }
        return this.isLocal && clazz.isAssignableFrom(this.localHomeIntf) && clazz != EJBLocalHome.class;
    }

    private void initializeInvocationInfoMap() {
        Iterator iterator = this.methodTable.keySet().iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (method == null) continue;
            Integer n = (Integer)this.methodTable.get(method);
            int n2 = n;
            InvocationInfo invocationInfo = new InvocationInfo(method);
            invocationInfo.txAttr = n2;
            invocationInfo.isBusinessMethod = this.isBusinessMethod(method);
            invocationInfo.isCreateHomeFinder = this.isCreateHomeFinder(method);
            invocationInfo.isHomeFinder = this.isHomeFinder(method);
            invocationInfo.startsWithCreate = method.getName().startsWith("create");
            invocationInfo.startsWithFind = method.getName().startsWith("find");
            invocationInfo.startsWithFindByPrimaryKey = method.getName().startsWith("findByPrimaryKey");
            invocationInfo.isExcludedMethod = this.securityManager.isExcluded(method);
            invocationInfo.isUncheckedMethod = this.securityManager.isUnchecked(method);
            this.invocationInfoMap.put(method, invocationInfo);
        }
    }

    private void initializeMethodTable() throws Exception {
        this.methodTable = new HashMap();
        if (this.isMessageDriven) {
            Class[] classArray = new Class[]{Message.class};
            Method method = this.ejbClass.getMethod("onMessage", classArray);
            Integer n = new Integer(this.findTxAttr(method));
            this.methodTable.put(method, n);
        } else {
            Method method;
            int n;
            Integer n2;
            Method[] methodArray;
            if (this.isRemote) {
                methodArray = this.remoteIntf.getMethods();
                n2 = null;
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    n2 = new Integer(this.findTxAttr(method));
                    this.methodTable.put(method, n2);
                }
                methodArray = this.homeIntf.getMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    n2 = new Integer(this.findTxAttr(method));
                    this.methodTable.put(method, n2);
                }
            }
            if (this.isLocal) {
                methodArray = this.localIntf.getMethods();
                n2 = null;
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    n2 = new Integer(this.findTxAttr(method));
                    this.methodTable.put(method, n2);
                }
                methodArray = this.localHomeIntf.getMethods();
                for (n = 0; n < methodArray.length; ++n) {
                    method = methodArray[n];
                    n2 = new Integer(this.findTxAttr(method));
                    this.methodTable.put(method, n2);
                }
            }
        }
    }

    private int findTxAttr(Method method) {
        Object object;
        int n = -1;
        if (this.isBeanManagedTran) {
            return 2;
        }
        ContainerTransaction containerTransaction = this.ejbDescriptor.getContainerTransactionFor(method);
        if (containerTransaction != null) {
            object = containerTransaction.getTransactionAttribute();
            if (((String)object).equals(ContainerTransaction.NOT_SUPPORTED)) {
                n = 1;
            } else if (((String)object).equals(ContainerTransaction.SUPPORTS)) {
                n = 4;
            } else if (((String)object).equals(ContainerTransaction.REQUIRED)) {
                n = 3;
            } else if (((String)object).equals(ContainerTransaction.REQUIRES_NEW)) {
                n = 5;
            } else if (((String)object).equals(ContainerTransaction.MANDATORY)) {
                n = 6;
            } else if (((String)object).equals(ContainerTransaction.NEVER)) {
                n = 7;
            }
        }
        if (n == -1) {
            throw new EJBException("Transaction Attribute not found for method " + method);
        }
        if (this.isEntity && ((EjbEntityDescriptor)this.ejbDescriptor).getPersistenceType().equals(EjbEntityDescriptor.CONTAINER_PERSISTENCE) && ((EjbCMPEntityDescriptor)(object = (EjbCMPEntityDescriptor)this.ejbDescriptor)).isEJB20() && n != 3 && n != 5 && n != 6) {
            throw new EJBException("Transaction attribute for EJB2.0 CMP EntityBeans must be Required/RequiresNew/Mandatory");
        }
        return n;
    }

    public void postCreate(Invocation invocation, Object object) throws CreateException {
        throw new EJBException("Internal error");
    }

    public Object postFind(Invocation invocation, Object object, Object[] objectArray) throws FinderException {
        throw new EJBException("Internal error");
    }

    private void setupEnvironment() throws NamingException {
        this.componentId = this.namingManager.bindObjects(this.ejbDescriptor);
        Set set = this.ejbDescriptor.getEnvironmentProperties();
        SafeProperties safeProperties = new SafeProperties();
        safeProperties.copy(set);
        this.envProps = safeProperties;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void doAfterApplicationDeploy() {
        _logger.log(Level.FINE, "Application deployment successful : " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy() {
        final Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    thread.setContextClassLoader(BaseContainer.this.loader);
                    return null;
                }
            });
            this.theSwitch.removeDescriptorFor(this);
            this.securityManager.destroy();
            if (!this.isMessageDriven) {
                try {
                    if (this.isLocal) {
                        this.theSwitch.removeLocalHome(this.ejbDescriptor.getLocalJndiName());
                    }
                    if (this.isRemote) {
                        this.namingManager.unpublishObject(this.ejbDescriptor.getJndiName());
                        this.protocolMgr.destroyReference((Remote)this.ejbHome, this.ejbDescriptor.getUniqueId());
                    }
                }
                catch (Exception exception) {
                    _logger.log(Level.FINE, "ejb.undeploy_exception", this.logParams);
                    _logger.log(Level.FINE, "", exception);
                }
            }
            try {
                this.unregisterEJBMonitorMBean();
            }
            catch (Exception exception) {
                _logger.log(Level.WARNING, "ejb.unregister_monitormbean_exception", exception);
            }
            this.containerFactory.removeContainer(this.ejbDescriptor.getUniqueId());
        }
        catch (Throwable throwable) {
            AccessController.doPrivileged(new PrivilegedAction(thread, classLoader){
                private final /* synthetic */ Thread val$currentThread;
                private final /* synthetic */ ClassLoader val$previousClassLoader;
                {
                    this.val$currentThread = thread;
                    this.val$previousClassLoader = classLoader;
                }

                public Object run() {
                    this.val$currentThread.setContextClassLoader(this.val$previousClassLoader);
                    return null;
                }
            });
            throw throwable;
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        _logger.log(Level.FINE, "**** [BaseContainer]: Successfully Undeployed " + this.ejbDescriptor.getJndiName() + " ...");
        this.ejbDescriptor = null;
        if (this.methodTable != null) {
            this.methodTable.clear();
        }
        if (this.invocationInfoMap != null) {
            this.invocationInfoMap.clear();
        }
        if (this.methodMBeanTable != null) {
            this.methodMBeanTable.clear();
        }
        this.loader = null;
        this.ejbClass = null;
        this.ejbPassivateMethod = null;
        this.ejbActivateMethod = null;
        this.ejbRemoveMethod = null;
        this.ejbObjectClass = null;
        this.ejbObjectTieClass = null;
        this.ejbObjectStubClass = null;
        this.remoteIntf = null;
        this.homeIntf = null;
        this.localEjbObjectClass = null;
        this.localHomeIntf = null;
        this.localIntf = null;
        this.ejbLocalHome = null;
        this.metadata = null;
        this.ejbHome = null;
        this.ejbHomeStub = null;
        this.methodTable = null;
        this.invocationInfoMap = null;
        this.ejbIntfMethods = null;
        this.envProps = null;
        this.methodMBeanTable = null;
        this.ejbMBean = null;
        this.uncheckedEjbIntfMethods = null;
    }

    public void onReady() {
    }

    public void onShutdown() {
    }

    public void onTermination() {
    }

    protected final void preInvokeTx(Invocation invocation) throws Exception {
        Method method = invocation.method;
        if (this.isMessageDriven) {
            invocation.invocationInfo = (InvocationInfo)this.invocationInfoMap.get(method);
        }
        InvocationInfo invocationInfo = invocation.invocationInfo;
        int n = this.transactionManager.getStatus();
        if (this.isSession && !invocationInfo.isBusinessMethod) {
            if (n != 6) {
                try {
                    invocation.clientTx = this.transactionManager.suspend();
                }
                catch (SystemException systemException) {
                    _logger.log(Level.FINER, "ejb.preInvokeTx_exception", systemException);
                    throw new EJBException((Exception)((Object)systemException));
                }
            }
            return;
        }
        boolean bl = false;
        if (!invocation.isLocal) {
            bl = this.transactionManager.isNullTransaction();
        }
        int n2 = this.getTxAttr(invocation);
        EJBContextImpl eJBContextImpl = (EJBContextImpl)invocation.context;
        EnterpriseBean enterpriseBean = eJBContextImpl.getEJB();
        Transaction transaction = eJBContextImpl.getTransaction();
        switch (n2) {
            case 2: {
                if (n != 6) {
                    invocation.clientTx = this.transactionManager.suspend();
                }
                if (!this.isSession || this.isStatelessSession || transaction == null || transaction.getStatus() == 6) break;
                this.transactionManager.resume(transaction);
                this.transactionManager.enlistComponentResources();
                break;
            }
            case 1: {
                if (n != 6) {
                    invocation.clientTx = this.transactionManager.suspend();
                }
                this.checkUnfinishedTx(transaction, invocation);
                if (!this.isEntity) break;
                this.preInvokeNoTx(invocation);
                break;
            }
            case 6: {
                if (bl || n == 6) {
                    throw new TransactionRequiredLocalException();
                }
                this.useClientTx(transaction, invocation);
                break;
            }
            case 3: {
                if (bl) {
                    throw new TransactionRequiredLocalException();
                }
                if (n == 6) {
                    invocation.clientTx = null;
                    this.startNewTx(transaction, invocation);
                    break;
                }
                invocation.clientTx = this.transactionManager.getTransaction();
                this.useClientTx(transaction, invocation);
                break;
            }
            case 5: {
                if (n != 6) {
                    invocation.clientTx = this.transactionManager.suspend();
                }
                this.startNewTx(transaction, invocation);
                break;
            }
            case 4: {
                if (bl) {
                    throw new TransactionRequiredLocalException();
                }
                if (n != 6) {
                    if (eJBContextImpl instanceof SessionContextImpl) {
                        ((SessionContextImpl)eJBContextImpl).setUsingClientTx(true);
                    }
                    this.useClientTx(transaction, invocation);
                    break;
                }
                if (eJBContextImpl instanceof SessionContextImpl) {
                    ((SessionContextImpl)eJBContextImpl).setUsingClientTx(false);
                }
                this.checkUnfinishedTx(transaction, invocation);
                if (!this.isEntity) break;
                this.preInvokeNoTx(invocation);
                break;
            }
            case 7: {
                if (bl || n != 6) {
                    throw new EJBException("EJB cannot be invoked in global transaction");
                }
                this.checkUnfinishedTx(transaction, invocation);
                if (!this.isEntity) break;
                this.preInvokeNoTx(invocation);
                break;
            }
            default: {
                throw new EJBException("Bad transaction attribute");
            }
        }
    }

    private void checkUnfinishedTx(Transaction transaction, Invocation invocation) {
        try {
            if (!this.isMessageDriven && !this.isStatelessSession && transaction != null && transaction.getStatus() != 6) {
                throw new IllegalStateException("Bean is associated with a different unfinished transaction");
            }
        }
        catch (SystemException systemException) {
            _logger.log(Level.FINER, "ejb.checkUnfinishedTx_exception", systemException);
            throw new EJBException((Exception)((Object)systemException));
        }
    }

    private void startNewTx(Transaction transaction, Invocation invocation) throws Exception {
        this.checkUnfinishedTx(transaction, invocation);
        this.transactionManager.begin();
        EJBContextImpl eJBContextImpl = (EJBContextImpl)invocation.context;
        Transaction transaction2 = this.transactionManager.getTransaction();
        eJBContextImpl.setTransaction(transaction2);
        this.transactionManager.enlistComponentResources();
        Method method = invocation.method;
        if (!invocation.invocationInfo.isHomeFinder) {
            this.containerFactory.getContainerSync(transaction2).addBean(eJBContextImpl);
        }
        this.afterBegin(eJBContextImpl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void useClientTx(Transaction transaction, Invocation invocation) {
        Transaction transaction2;
        int n = -1;
        int n2 = -1;
        try {
            transaction2 = this.transactionManager.getTransaction();
            n = transaction2.getStatus();
            if (transaction != null) {
                n2 = transaction.getStatus();
            }
        }
        catch (Exception exception) {
            _logger.log(Level.FINER, "ejb.useClientTx_exception", exception);
            try {
                this.transactionManager.setRollbackOnly();
                throw new TransactionRolledbackLocalException("", exception);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new TransactionRolledbackLocalException("", exception);
        }
        if (n == 1 || n == 4 || n == 9) {
            throw new TransactionRolledbackLocalException("Client's transaction aborted");
        }
        if (transaction == null || n2 == 6) {
            EJBContextImpl eJBContextImpl = (EJBContextImpl)invocation.context;
            eJBContextImpl.setTransaction(transaction2);
            try {
                this.transactionManager.enlistComponentResources();
                if (this.isStatelessSession || this.isMessageDriven) return;
                Method method = invocation.method;
                if (!invocation.invocationInfo.isHomeFinder) {
                    this.containerFactory.getContainerSync(transaction2).addBean(eJBContextImpl);
                }
                this.afterBegin(eJBContextImpl);
                return;
            }
            catch (Exception exception) {
                _logger.log(Level.FINER, "ejb.useClientTx_exception", exception);
                try {
                    this.transactionManager.setRollbackOnly();
                    throw new TransactionRolledbackLocalException("", exception);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                throw new TransactionRolledbackLocalException("", exception);
            }
        }
        if (!transaction.equals(transaction2)) {
            if (!this.isSession) return;
            throw new IllegalStateException("EJB is already associated with an incomplete transaction");
        }
        try {
            this.transactionManager.enlistComponentResources();
            return;
        }
        catch (Exception exception) {
            _logger.log(Level.FINER, "ejb.useClientTx_exception", exception);
            try {
                this.transactionManager.setRollbackOnly();
                throw new TransactionRolledbackLocalException("", exception);
            }
            catch (Exception exception4) {
                // empty catch block
            }
            throw new TransactionRolledbackLocalException("", exception);
        }
    }

    public final void postInvokeTx(Invocation invocation) throws Exception {
        Method method = invocation.method;
        InvocationInfo invocationInfo = invocation.invocationInfo;
        Throwable throwable = invocation.exception;
        if (this.isSession && !invocationInfo.isBusinessMethod) {
            if (invocation.clientTx != null) {
                this.transactionManager.resume(invocation.clientTx);
            }
            if (throwable != null && throwable instanceof PreInvokeException) {
                invocation.exception = ((PreInvokeException)((Object)throwable)).exception;
            }
            return;
        }
        EJBContextImpl eJBContextImpl = (EJBContextImpl)invocation.context;
        int n = this.transactionManager.getStatus();
        int n2 = invocation.invocationInfo.txAttr;
        EnterpriseBean enterpriseBean = eJBContextImpl.getEJB();
        Throwable throwable2 = throwable;
        switch (n2) {
            case 2: {
                throwable2 = this.checkExceptionBeanMgTx(eJBContextImpl, throwable, n);
                if (invocation.clientTx == null) break;
                this.transactionManager.resume(invocation.clientTx);
                break;
            }
            case 1: 
            case 7: {
                if (throwable != null) {
                    throwable2 = this.checkExceptionNoTx(eJBContextImpl, throwable);
                }
                if (this.isEntity) {
                    this.postInvokeNoTx(invocation);
                }
                if (invocation.clientTx == null) break;
                this.transactionManager.resume(invocation.clientTx);
                break;
            }
            case 6: {
                if (throwable == null) break;
                throwable2 = this.checkExceptionClientTx(eJBContextImpl, throwable);
                break;
            }
            case 3: {
                if (invocation.clientTx == null) {
                    throwable2 = this.completeNewTx(eJBContextImpl, throwable);
                    break;
                }
                if (throwable == null) break;
                throwable2 = this.checkExceptionClientTx(eJBContextImpl, throwable);
                break;
            }
            case 5: {
                throwable2 = this.completeNewTx(eJBContextImpl, throwable);
                if (invocation.clientTx == null) break;
                this.transactionManager.resume(invocation.clientTx);
                break;
            }
            case 4: {
                if (n != 6) {
                    if (throwable == null) break;
                    throwable2 = this.checkExceptionClientTx(eJBContextImpl, throwable);
                    break;
                }
                if (throwable != null) {
                    throwable2 = this.checkExceptionNoTx(eJBContextImpl, throwable);
                }
                if (!this.isEntity) break;
                this.postInvokeNoTx(invocation);
                break;
            }
        }
        invocation.exception = throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable checkExceptionBeanMgTx(EJBContextImpl eJBContextImpl, Throwable throwable, int n) throws Exception {
        Throwable throwable2 = throwable;
        if (throwable != null && throwable instanceof PreInvokeException) {
            throwable2 = ((PreInvokeException)((Object)throwable)).exception;
        } else if (n == 6) {
            if (throwable != null) {
                throwable2 = this.checkExceptionNoTx(eJBContextImpl, throwable);
            }
        } else if (this.isSession && !this.isStatelessSession) {
            if (!this.isSystemUncheckedException(throwable)) {
                this.transactionManager.suspend();
            } else {
                try {
                    this.forceDestroyBean(eJBContextImpl);
                }
                finally {
                    this.transactionManager.rollback();
                }
                throwable2 = this.processSystemException(throwable);
            }
        } else if (this.isStatelessSession) {
            try {
                this.forceDestroyBean(eJBContextImpl);
            }
            finally {
                this.transactionManager.rollback();
            }
            throwable2 = new EJBException("Stateless SessionBean method returned without completing transaction");
            _logger.log(Level.SEVERE, "ejb.incomplete_sessionbean_txn_exception", this.logParams);
            _logger.log(Level.SEVERE, "", throwable2);
        } else {
            try {
                this.forceDestroyBean(eJBContextImpl);
            }
            finally {
                this.transactionManager.rollback();
            }
            throwable2 = new EJBException("MessageDrivenBean method returned without completing transaction");
            _logger.log(Level.SEVERE, "ejb.incomplete_msgdrivenbean_txn_exception", this.logParams);
            _logger.log(Level.SEVERE, "", throwable2.toString());
        }
        return throwable2;
    }

    private Throwable checkExceptionNoTx(EJBContextImpl eJBContextImpl, Throwable throwable) throws Exception {
        if (throwable instanceof PreInvokeException) {
            return ((PreInvokeException)((Object)throwable)).exception;
        }
        Throwable throwable2 = throwable;
        if (this.isSystemUncheckedException(throwable)) {
            throwable2 = this.processSystemException(throwable);
            this.forceDestroyBean(eJBContextImpl);
        }
        return throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable checkExceptionClientTx(EJBContextImpl eJBContextImpl, Throwable throwable) throws Exception {
        if (throwable instanceof PreInvokeException) {
            return ((PreInvokeException)((Object)throwable)).exception;
        }
        Throwable throwable2 = throwable;
        if (this.isSystemUncheckedException(throwable)) {
            try {
                this.forceDestroyBean(eJBContextImpl);
            }
            finally {
                this.transactionManager.setRollbackOnly();
            }
            throwable2 = throwable instanceof Exception ? new TransactionRolledbackLocalException("Exception thrown from bean", (Exception)throwable) : new TransactionRolledbackLocalException("Exception thrown from bean: " + throwable.toString());
        }
        return throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable completeNewTx(EJBContextImpl eJBContextImpl, Throwable throwable) throws Exception {
        int n;
        Throwable throwable2 = throwable;
        if (throwable instanceof PreInvokeException) {
            throwable2 = ((PreInvokeException)((Object)throwable)).exception;
        }
        if ((n = this.transactionManager.getStatus()) == 6) {
            return throwable2;
        }
        if (this.isSession && !this.isStatelessSession) {
            ((SessionContextImpl)eJBContextImpl).setTxCompleting(true);
        }
        if (throwable2 != null && this.isSystemUncheckedException(throwable2)) {
            try {
                this.forceDestroyBean(eJBContextImpl);
            }
            finally {
                this.transactionManager.rollback();
            }
            throwable2 = this.processSystemException(throwable2);
        } else {
            try {
                if (n == 1) {
                    this.transactionManager.rollback();
                } else {
                    this.transactionManager.commit();
                }
            }
            catch (RollbackException rollbackException) {
                _logger.log(Level.FINE, "ejb.transaction_abort_exception", rollbackException);
                throwable2 = new EJBException("Transaction aborted (possibly due to transaction time out).", (Exception)((Object)rollbackException));
            }
            catch (Exception exception) {
                _logger.log(Level.FINE, "ejb.cmt_exception", exception);
                throwable2 = new EJBException("Unable to complete container-managed transaction.", exception);
            }
        }
        return throwable2;
    }

    public final void doAfterBegin(ComponentInvocation componentInvocation) {
        Invocation invocation = (Invocation)componentInvocation;
        try {
            EJBContextImpl eJBContextImpl = (EJBContextImpl)invocation.context;
            Transaction transaction = this.transactionManager.getTransaction();
            eJBContextImpl.setTransaction(transaction);
            this.containerFactory.getContainerSync(transaction).addBean(eJBContextImpl);
        }
        catch (SystemException systemException) {
            throw new EJBException((Exception)((Object)systemException));
        }
        catch (RollbackException rollbackException) {
            throw new EJBException((Exception)((Object)rollbackException));
        }
        catch (IllegalStateException illegalStateException) {
            throw new EJBException((Exception)illegalStateException);
        }
    }

    abstract void afterBegin(EJBContextImpl var1);

    abstract void beforeCompletion(EJBContextImpl var1);

    abstract void afterCompletion(EJBContextImpl var1, int var2);

    void preInvokeNoTx(Invocation invocation) {
        throw new EJBException("Internal Error: BaseContainer.preInvokeNoTx called");
    }

    void postInvokeNoTx(Invocation invocation) {
        throw new EJBException("Internal Error: BaseContainer.postInvokeNoTx called");
    }

    private Throwable processSystemException(Throwable throwable) {
        if (throwable instanceof EJBException) {
            return throwable;
        }
        NoSuchObjectLocalException noSuchObjectLocalException = throwable instanceof NoSuchEntityException ? new NoSuchObjectLocalException("NoSuchEntityException thrown by EJB method.") : (throwable instanceof Exception ? new EJBException((Exception)throwable) : new EJBException(throwable.getMessage()));
        return noSuchObjectLocalException;
    }

    private boolean isSystemUncheckedException(Throwable throwable) {
        return throwable != null && (throwable instanceof RuntimeException || throwable instanceof Error || throwable instanceof RemoteException);
    }

    private void registerEJBMonitorMBean(MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) throws Exception {
        ObjectName objectName = null;
        Application application = this.ejbDescriptor.getApplication();
        String string = application.getRegistrationName();
        String string2 = this.ejbDescriptor.getName();
        if (!application.isVirtual()) {
            String string3 = this.ejbDescriptor.getEjbBundleDescriptor().getArchivist().getArchiveUri();
            String string4 = FileUtils.makeFriendlyFilename(string3);
            try {
                objectName = MonitoringHelper.registerEJBMonitoringMBean(string, string4, string2, monitoredObjectType, baseMonitorMBean);
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "ejb.register_MonitoringMBean_exception", throwable);
            }
        } else {
            try {
                objectName = MonitoringHelper.registerEJBMonitoringMBean(string, string2, monitoredObjectType, baseMonitorMBean);
            }
            catch (Throwable throwable) {
                _logger.log(Level.SEVERE, "ejb.register_MonitoringMBean_exception", throwable);
            }
        }
        if (_logger.isLoggable(Level.FINE) && objectName != null) {
            _logger.log(Level.FINE, "[BaseContainer] Registered EJB [" + string2 + "] with MBeanServer under name [" + objectName.getCanonicalName() + "]");
        }
    }

    protected void unregisterEJBMonitorMBean() throws Exception {
        Application application = this.ejbDescriptor.getApplication();
        String string = application.getRegistrationName();
        String string2 = this.ejbDescriptor.getName();
        if (!application.isVirtual()) {
            String string3 = this.ejbDescriptor.getEjbBundleDescriptor().getArchivist().getArchiveUri();
            String string4 = FileUtils.makeFriendlyFilename(string3);
            MonitoringHelper.unregisterEJBMonitoringMBean(string, string4, string2);
        } else {
            MonitoringHelper.unregisterEJBMonitoringMBean(string, string2);
        }
    }

    protected void registerChildMonitorMBean(String string, MonitoredObjectType monitoredObjectType, BaseMonitorMBean baseMonitorMBean) {
        try {
            this.ejbMBean.addChild(string, monitoredObjectType, baseMonitorMBean);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "ejb.register_ChildMonitorMBean_exception", exception);
        }
    }

    protected void unregisterChildMonitorMBean(String string, MonitoredObjectType monitoredObjectType) {
        try {
            this.ejbMBean.removeChild(monitoredObjectType, string);
        }
        catch (Exception exception) {
            _logger.log(Level.WARNING, "ejb.unregister_ChildMonitorMBean_exception", this.logParams);
            _logger.log(Level.WARNING, "", exception.toString());
            _logger.log(Level.FINE, "ejb.unregister_ChildMonitorMBean_exception", this.logParams);
            _logger.log(Level.FINE, "", exception);
        }
    }

    public void setMonitorOn(boolean bl) {
        this.monitorOn = bl;
    }

    public boolean getDebugMonitorFlag() {
        return this.debugMonitorFlag;
    }

    public void setDebugMonitorFlag(boolean bl) {
        this.debugMonitorFlag = bl;
    }
}

