/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.ejb.codegen.InvalidHome;
import com.sun.ejb.codegen.MethodNotFound;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EntityBean;
import javax.ejb.SessionBean;
import sun.rmi.rmic.IndentingWriter;

public class HomeGenerator
extends Generator {
    private static Logger _logger = null;
    private static LocalStringManagerImpl localStrings;
    public static String LOCAL_SUFFIX;
    public static String REMOTE_SUFFIX;
    private Method[] factoryMethods;
    private Method[] allbeanMethods;
    private Class homeInterface;
    private Class bean;
    private String homeImpl;
    private EjbDescriptor dd;
    private boolean isLocal = false;
    private static int CREATE;
    private static int FINDER;
    private static int OTHER;
    private boolean isReadOnlyBean = false;

    public String getGeneratedClass() {
        String string = this.getPackageName(this.bean.getName());
        if (string != null) {
            return string + "." + this.homeImpl;
        }
        return this.homeImpl;
    }

    public static String getDefaultRemoteHomeImplClassName(EjbDescriptor ejbDescriptor) {
        return ejbDescriptor.getEjbImplClassName() + REMOTE_SUFFIX;
    }

    public HomeGenerator(DeploymentContext deploymentContext, EjbDescriptor ejbDescriptor, boolean bl, Vector vector) throws GeneratorException {
        String string;
        this.dd = ejbDescriptor;
        this.isLocal = bl;
        ClassLoader classLoader = deploymentContext.getClassLoader();
        if (bl) {
            string = ejbDescriptor.getLocalHomeClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_LOCALHOME;
        } else {
            string = ejbDescriptor.getHomeClassName();
            this.ejbClassSymbol = MethodDescriptor.EJB_HOME;
        }
        try {
            this.homeInterface = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidHome(localStrings.getLocalString("generator.invalid_home", "Could not find home class {0}", new Object[]{string}));
        }
        try {
            this.bean = classLoader.loadClass(ejbDescriptor.getEjbImplClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            _logger.log(Level.FINE, "ejb.classnotfound_exception", classNotFoundException);
            throw new InvalidBean(localStrings.getLocalString("generator.bean_class_not_found", "Bean class {0} not found ", new Object[]{ejbDescriptor.getEjbImplClassName()}));
        }
        if (!SessionBean.class.isAssignableFrom(this.bean) && !EntityBean.class.isAssignableFrom(this.bean)) {
            throw new InvalidBean(localStrings.getLocalString("generator.invalid_bean", "Bean {0} is neither {1} nor {2}.", new Object[]{ejbDescriptor.getName(), "an EntityBean", "a SessionBean"}));
        }
        this.factoryMethods = this.removeDups(this.homeInterface.getMethods());
        this.factoryMethods = this.removeEJBHomeMethods(this.factoryMethods);
        this.allbeanMethods = this.removeDups(this.bean.getMethods());
        String string2 = bl ? LOCAL_SUFFIX : REMOTE_SUFFIX;
        String string3 = this.getUniqueClassName(deploymentContext, this.bean.getName(), string2, vector);
        this.homeImpl = this.getBaseName(string3);
        if (ejbDescriptor instanceof EjbEntityDescriptor && ((EjbEntityDescriptor)ejbDescriptor).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
            this.isReadOnlyBean = true;
        }
    }

    private Method[] removeEJBHomeMethods(Method[] methodArray) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (this.isEJBHomeMethod(methodArray[i])) continue;
            arrayList.add(methodArray[i]);
        }
        Method[] methodArray2 = new Method[arrayList.size()];
        return arrayList.toArray(methodArray2);
    }

    private boolean compare(Method method, Method method2) {
        Class<?>[] classArray;
        if (method.getName().startsWith("create") && !method2.getName().startsWith("ejbCreate")) {
            return false;
        }
        if (method.getName().startsWith("find") && !method2.getName().startsWith("ejbFind")) {
            return false;
        }
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (classArray2[i] == classArray[i]) continue;
            return false;
        }
        return true;
    }

    private Method getBeanMethod(Method method) {
        for (int i = 0; i < this.allbeanMethods.length; ++i) {
            if (!this.isInitializeMethod(this.allbeanMethods[i]) || !this.compare(method, this.allbeanMethods[i])) continue;
            return this.allbeanMethods[i];
        }
        return null;
    }

    private void printFactoryMethodImpl(IndentingWriter indentingWriter, Method method, int n, String string) throws IOException {
        String string2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.dd instanceof EjbSessionDescriptor) {
            if (((EjbSessionDescriptor)this.dd).isStateless()) {
                bl = true;
            }
        } else if (this.dd instanceof EjbEntityDescriptor) {
            bl2 = true;
            if (((EjbEntityDescriptor)this.dd).getIASEjbExtraDescriptors().isIsReadOnlyBean()) {
                bl3 = true;
            }
        }
        indentingWriter.pln("");
        indentingWriter.p("public ");
        indentingWriter.p(this.printType(method.getReturnType()) + " ");
        indentingWriter.p(method.getName() + "(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(this.printType(classArray[i]) + " param" + i);
        }
        indentingWriter.p(")");
        Class<?>[] classArray2 = method.getExceptionTypes();
        if (classArray2.length != 0) {
            indentingWriter.p(" throws ");
        }
        for (int i = 0; i < classArray2.length; ++i) {
            if (i != 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(classArray2[i].getName());
        }
        indentingWriter.plnI(" {");
        String string3 = this.isLocal ? "com.sun.ejb.containers.EJBLocalObjectImpl" : "com.sun.ejb.containers.EJBObjectImpl";
        if (n == CREATE) {
            if (!bl2) {
                indentingWriter.pln(string3 + " ejbObject = (" + string3 + ") this.createEJB" + (this.isLocal ? "LocalObject();" : "Object();"));
            }
        } else if (!this.isReturnTypeVoid(method)) {
            string2 = this.printType(method.getReturnType());
            indentingWriter.p(string2 + " ejbObject = ");
            if (this.isReturnTypePrimitive(method)) {
                if (this.isReturnTypeBoolean(method)) {
                    indentingWriter.p("false");
                } else {
                    indentingWriter.p("0");
                }
            } else {
                indentingWriter.p("null");
            }
            indentingWriter.pln(";");
        }
        if (!bl) {
            if (bl3 && this.isCreateMethod(method)) {
                indentingWriter.pln("throw new javax.ejb.CreateException (\"Create method is not allowed for a Read-Only Bean\");");
                indentingWriter.pOln("}");
                return;
            }
            if (bl3 && this.isCreateMethod(method)) {
                indentingWriter.pln("throw new javax.ejb.CreateException (\"Remove method is not allowed for a Read-Only Bean\");");
                indentingWriter.pOln("}");
                return;
            }
            indentingWriter.pln("com.sun.ejb.Invocation i = new com.sun.ejb.Invocation();");
            if (this.isLocal) {
                indentingWriter.pln("i.isLocal = true;");
                indentingWriter.pln("i.transactionAttribute = com.sun.ejb.Container." + this.getTxAttribute(this.dd, method) + ";");
                indentingWriter.pln("i.securityPermissions = com.sun.ejb.Container." + this.getSecurityAttribute(this.dd, method) + ";");
            }
            if (n == CREATE && !bl2) {
                indentingWriter.pln("i.ejbObject = ejbObject;");
            }
            indentingWriter.pln("i.method = " + string + ";");
            indentingWriter.pln("try {");
            indentingWriter.pln("\tthis.getContainer().preInvoke(i);");
            indentingWriter.pln("\t" + this.bean.getName() + " ejb = (" + this.bean.getName() + ") i.ejb;");
            if (n == CREATE) {
                int n2;
                string2 = method.getName().substring("create".length());
                if (bl2) {
                    indentingWriter.p("\tjava.lang.Object primaryKey = ");
                    indentingWriter.p("ejb.ejbCreate" + string2 + "(");
                } else {
                    indentingWriter.p("\tejb.ejbCreate" + string2 + "(");
                }
                for (n2 = 0; n2 < classArray.length; ++n2) {
                    if (n2 != 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p("param" + n2);
                }
                indentingWriter.pln(");");
                if (bl2) {
                    indentingWriter.pln("\tthis.getContainer().postCreate(i, primaryKey);");
                    indentingWriter.p("\tejb.ejbPostCreate" + string2 + "(");
                    for (n2 = 0; n2 < classArray.length; ++n2) {
                        if (n2 != 0) {
                            indentingWriter.p(", ");
                        }
                        indentingWriter.p("param" + n2);
                    }
                    indentingWriter.pln(");");
                }
            } else if (n == FINDER) {
                string2 = method.getName().substring("find".length());
                indentingWriter.pln("\tjava.lang.Object primaryKeys = null;");
                indentingWriter.p("\tprimaryKeys = ejb.ejbFind" + string2 + "( ");
                for (int i = 0; i < classArray.length; ++i) {
                    if (i != 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p("param" + i);
                }
                indentingWriter.pln(");");
                indentingWriter.pln("\tejbObject = (" + method.getReturnType().getName() + ")this.getContainer().postFind(i, primaryKeys, null);");
            } else {
                string2 = method.getName();
                indentingWriter.p("\t");
                if (!this.isReturnTypeVoid(method)) {
                    indentingWriter.p("ejbObject = ");
                }
                indentingWriter.p("ejb.ejbHome");
                String string4 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                indentingWriter.p(string4 + "(");
                for (int i = 0; i < classArray.length; ++i) {
                    if (i != 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p("param" + i);
                }
                indentingWriter.pln(");");
            }
            indentingWriter.pln("} catch(Throwable c) {");
            indentingWriter.pln("\ti.exception = c;");
            indentingWriter.pln("} finally {");
            indentingWriter.pln("\tthis.getContainer().postInvoke(i);");
            indentingWriter.pln("}");
            indentingWriter.plnI("if (i.exception != null) {");
            indentingWriter.pln("if(i.exception instanceof java.lang.RuntimeException) {");
            indentingWriter.pln("\tthrow (java.lang.RuntimeException)i.exception; ");
            indentingWriter.p("} ");
            if (!this.isLocal) {
                indentingWriter.pln("else if (i.exception instanceof java.rmi.RemoteException) {");
                indentingWriter.pln("\tthrow (java.rmi.RemoteException)i.exception; ");
                indentingWriter.p("} ");
            }
            for (int i = 0; i < classArray2.length; ++i) {
                if (classArray2[i].getName().equals("java.rmi.RemoteException")) continue;
                indentingWriter.pln("else if (i.exception instanceof " + classArray2[i].getName() + ") {");
                indentingWriter.pln("\tthrow (" + classArray2[i].getName() + ")i.exception;");
                indentingWriter.p("} ");
            }
            if (this.isLocal) {
                indentingWriter.pln("else if (i.exception instanceof Exception) {");
                indentingWriter.pln("\tthrow new javax.ejb.EJBException(\"Unknown exception\", (Exception)i.exception);");
                indentingWriter.pln("}");
                indentingWriter.pln("else {");
                indentingWriter.pln("\tthrow new javax.ejb.EJBException(i.exception.getMessage());");
                indentingWriter.pln("}");
            } else {
                indentingWriter.pln("else {");
                indentingWriter.pln("\tthrow new java.rmi.RemoteException(\"Unknown exception\", i.exception);");
                indentingWriter.pln("}");
            }
            indentingWriter.pOln("}");
        }
        if (n == CREATE) {
            if (bl2) {
                indentingWriter.pln("return (" + method.getReturnType().getName() + ")" + "((" + string3 + ")i.ejbObject)" + (this.isLocal ? ";" : ".getStub();"));
            } else {
                indentingWriter.pln("return (" + method.getReturnType().getName() + ")ejbObject" + (this.isLocal ? ";" : ".getStub();"));
            }
        } else if (!this.isReturnTypeVoid(method)) {
            indentingWriter.pln("return ejbObject;");
        }
        indentingWriter.pOln("}");
    }

    public void generate(OutputStream outputStream) throws GeneratorException, IOException {
        IndentingWriter indentingWriter = new IndentingWriter(new OutputStreamWriter(outputStream));
        String string = this.getPackageName(this.bean.getName());
        if (string != null) {
            indentingWriter.pln("package " + string + ";");
        }
        if (this.isReadOnlyBean) {
            indentingWriter.plnI("public final class " + this.homeImpl + " extends com.sun.ejb.containers." + (this.isLocal ? "ReadOnlyEJBLocalHomeImpl" : "ReadOnlyEJBHomeImpl") + " implements " + this.homeInterface.getName() + " {");
        } else {
            indentingWriter.plnI("public final class " + this.homeImpl + " extends com.sun.ejb.containers." + (this.isLocal ? "EJBLocalHomeImpl" : "EJBHomeImpl") + " implements " + this.homeInterface.getName() + " {");
        }
        String[] stringArray = this.printStaticMethodInit(indentingWriter, this.homeInterface, this.factoryMethods);
        indentingWriter.plnI("public " + this.homeImpl + "() " + (this.isLocal ? "" : "throws java.rmi.RemoteException ") + "{");
        indentingWriter.pln("super();");
        indentingWriter.pOln("}");
        for (int i = 0; i < this.factoryMethods.length; ++i) {
            if (this.isCreateMethod(this.factoryMethods[i])) {
                Method method = this.getBeanMethod(this.factoryMethods[i]);
                if (method == null) {
                    throw new MethodNotFound("Could not find bean method for factory method: " + this.factoryMethods[i]);
                }
                this.printFactoryMethodImpl(indentingWriter, this.factoryMethods[i], CREATE, stringArray[i]);
                continue;
            }
            if (this.isFinderMethod(this.factoryMethods[i])) {
                this.printFactoryMethodImpl(indentingWriter, this.factoryMethods[i], FINDER, stringArray[i]);
                continue;
            }
            this.printFactoryMethodImpl(indentingWriter, this.factoryMethods[i], OTHER, stringArray[i]);
        }
        indentingWriter.pOln("}");
        indentingWriter.close();
    }

    private boolean isCreateMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("create");
    }

    private boolean isRemoveMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("remove");
    }

    private boolean isFinderMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("find");
    }

    private boolean isInitializeMethod(Method method) {
        return Modifier.isPublic(method.getModifiers()) && (method.getName().startsWith("ejbCreate") || method.getName().startsWith("ejbFind"));
    }

    private String getPrimitiveWrapper(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return "Boolean";
        }
        if (clazz == Byte.TYPE) {
            return "Byte";
        }
        if (clazz == Character.TYPE) {
            return "Character";
        }
        if (clazz == Short.TYPE) {
            return "Short";
        }
        if (clazz == Integer.TYPE) {
            return "Integer";
        }
        if (clazz == Long.TYPE) {
            return "Long";
        }
        if (clazz == Float.TYPE) {
            return "Float";
        }
        if (clazz == Double.TYPE) {
            return "Double";
        }
        throw new RuntimeException("Bad primitive class");
    }

    private boolean isEJBHomeMethod(Method method) {
        Class clazz = this.isLocal ? EJBLocalHome.class : EJBHome.class;
        Class clazz2 = clazz;
        return this.isEJBIntfMethod(clazz2, method);
    }

    private boolean isReturnTypeVoid(Method method) {
        String string = method.getReturnType().getName();
        return string.equals("void");
    }

    private boolean isReturnTypeBoolean(Method method) {
        String string = method.getReturnType().getName();
        return string.equals("boolean");
    }

    private boolean isReturnTypePrimitive(Method method) {
        return method.getReturnType().isPrimitive();
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
        localStrings = new LocalStringManagerImpl(HomeGenerator.class);
        LOCAL_SUFFIX = "_LocalHomeImpl";
        REMOTE_SUFFIX = "_RemoteHomeImpl";
        CREATE = 0;
        FINDER = 1;
        OTHER = 2;
    }
}

