/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.iplanet.ias.server.ApplicationRegistry;
import com.sun.ejb.EJBObjectInputStream;
import com.sun.ejb.EJBObjectOutputStream;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;

public class EJBUtils {
    private static Logger _logger = null;
    private static final boolean debug = false;

    public static void throwEJBException(Exception exception) throws EJBException {
        _logger.log(Level.SEVERE, "ejb.ejb_exception", exception.toString());
        if (exception instanceof EJBException) {
            throw (EJBException)((Object)exception);
        }
        if (exception instanceof IllegalArgumentException || exception instanceof IllegalStateException) {
            throw (RuntimeException)exception;
        }
        throw new EJBException(exception);
    }

    public static final byte[] serializeObject(Object object, boolean bl) throws IOException {
        final boolean bl2 = bl;
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new EJBObjectOutputStream(byteArrayOutputStream, bl2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public static final byte[] serializeObject(Object object) throws IOException {
        return EJBUtils.serializeObject(object, true);
    }

    public static final Object deserializeObject(byte[] byArray, ClassLoader classLoader) throws Exception {
        return EJBUtils.deserializeObject(byArray, classLoader, true, false);
    }

    public static final Object deserializeObject(byte[] byArray, ClassLoader classLoader, boolean bl) throws Exception {
        return EJBUtils.deserializeObject(byArray, classLoader, bl, false);
    }

    public static final Object deserializeObject(byte[] byArray, final ClassLoader classLoader, boolean bl, final boolean bl2) throws Exception {
        if (byArray == null) {
            return null;
        }
        final boolean bl3 = bl;
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        if (classLoader != null) {
            try {
                objectInputStream = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        EJBObjectInputStream eJBObjectInputStream = new EJBObjectInputStream(byteArrayInputStream, classLoader, bl3);
                        eJBObjectInputStream.failStatefulSession = bl2;
                        return eJBObjectInputStream;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
        }
        return objectInputStream.readObject();
    }

    public static long getEjbId(String string, String string2, String string3) {
        ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
        ClassLoader classLoader = string != null ? applicationRegistry.getClassLoaderForApplication(string) : applicationRegistry.getClassLoaderForModule(string2);
        Application application = applicationRegistry.getApplication(classLoader);
        EjbBundleDescriptor ejbBundleDescriptor = application.getEjbBundleByUri(string2);
        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(string3);
        return ejbDescriptor.getUniqueId();
    }

    public static final ObjectOutputStream getOutputStream(final OutputStream outputStream, boolean bl) throws IOException {
        final boolean bl2 = bl;
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new EJBObjectOutputStream(outputStream, bl2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return objectOutputStream;
    }

    public static final ObjectInputStream getInputStream(final InputStream inputStream, final ClassLoader classLoader, boolean bl, final boolean bl2) throws IOException {
        final boolean bl3 = bl;
        ObjectInputStream objectInputStream = null;
        if (classLoader != null) {
            try {
                objectInputStream = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        EJBObjectInputStream eJBObjectInputStream = new EJBObjectInputStream(inputStream, classLoader, bl3);
                        eJBObjectInputStream.failStatefulSession = bl2;
                        return eJBObjectInputStream;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
        } else {
            objectInputStream = new ObjectInputStream(inputStream);
        }
        return objectInputStream;
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

