/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.SerializableHome;
import com.sun.ejb.SerializableJNDIContext;
import com.sun.ejb.SerializableRemote;
import com.sun.ejb.containers.EJBLocalHomeImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.Context;

final class EJBObjectOutputStream
extends ObjectOutputStream {
    private ProtocolManager protocolMgr;
    private static Logger _logger = null;

    EJBObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
        this.protocolMgr = Switch.getSwitch().getProtocolManager();
    }

    EJBObjectOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        super(outputStream);
        if (bl) {
            this.enableReplaceObject(bl);
        }
        this.protocolMgr = Switch.getSwitch().getProtocolManager();
    }

    protected Object replaceObject(Object object) throws IOException {
        try {
            if (object instanceof EJBObject) {
                Serializable serializable = this.protocolMgr.getSerializableLocalObject((Remote)object);
                if (serializable == null) {
                    _logger.log(Level.WARNING, "EJBObjectOutputStream:replaceObject, EJBObject is null");
                    return null;
                }
                return new SerializableRemote(serializable);
            }
            if (object instanceof EJBHome) {
                Serializable serializable = this.protocolMgr.getSerializableLocalObject((Remote)object);
                if (serializable == null) {
                    _logger.log(Level.WARNING, "EJBObjectOutputStream:replaceObject, EJBHome is null");
                    return null;
                }
                return new SerializableHome(serializable);
            }
            if (object instanceof Serializable) {
                return object;
            }
            if (object instanceof EJBLocalHomeImpl) {
                return ((EJBLocalHomeImpl)object).getSerializableObject();
            }
            if (object instanceof EJBLocalObjectImpl) {
                return ((EJBLocalObjectImpl)object).getSerializableObject();
            }
            if (object instanceof Context) {
                SerializableJNDIContext serializableJNDIContext = new SerializableJNDIContext();
                serializableJNDIContext.name = ((Context)object).getNameInNamespace();
                return serializableJNDIContext;
            }
            return object;
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.getMessage()).initCause(new NotSerializableException(exception.getMessage()).initCause(exception));
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

