/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb;

import com.sun.ejb.SerializableHome;
import com.sun.ejb.SerializableJNDIContext;
import com.sun.ejb.SerializableRemote;
import com.sun.ejb.containers.EJBLocalHomeImpl;
import com.sun.ejb.containers.EJBLocalObjectImpl;
import com.sun.enterprise.ProtocolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.ObjectInputStreamWithLoader;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import org.omg.CORBA.OBJECT_NOT_EXIST;

final class EJBObjectInputStream
extends ObjectInputStreamWithLoader {
    private static Logger _logger = null;
    private ProtocolManager protocolMgr;
    boolean failStatefulSession;

    public EJBObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream, classLoader);
        this.enableResolveObject(true);
        this.protocolMgr = Switch.getSwitch().getProtocolManager();
    }

    public EJBObjectInputStream(InputStream inputStream, ClassLoader classLoader, boolean bl) throws IOException, StreamCorruptedException {
        super(inputStream, classLoader);
        if (bl) {
            this.enableResolveObject(bl);
        }
        this.protocolMgr = Switch.getSwitch().getProtocolManager();
    }

    protected Object resolveObject(Object object) throws IOException {
        try {
            if (object instanceof Remote) {
                this.protocolMgr.connectObject((Remote)object);
                return object;
            }
            if (object instanceof EJBLocalHomeImpl.SerializableLocalHome) {
                return EJBLocalHomeImpl.getLocalHome((EJBLocalHomeImpl.SerializableLocalHome)object);
            }
            if (object instanceof EJBLocalObjectImpl.SerializableLocalObject) {
                return EJBLocalObjectImpl.getLocalObject((EJBLocalObjectImpl.SerializableLocalObject)object, this.failStatefulSession);
            }
            if (object instanceof SerializableHome) {
                SerializableHome serializableHome = (SerializableHome)object;
                return this.protocolMgr.getHomeRefFromLocalObject(serializableHome.obj);
            }
            if (object instanceof SerializableRemote) {
                SerializableRemote serializableRemote = (SerializableRemote)object;
                return this.protocolMgr.getRemoteRefFromLocalObject(serializableRemote.obj, this.failStatefulSession);
            }
            if (object instanceof SerializableJNDIContext) {
                SerializableJNDIContext serializableJNDIContext = (SerializableJNDIContext)object;
                String string = serializableJNDIContext.name;
                InitialContext initialContext = new InitialContext();
                if (string == null || string.length() == 0) {
                    return initialContext;
                }
                return initialContext.lookup(((SerializableJNDIContext)object).name);
            }
            return object;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            _logger.log(Level.WARNING, "ejb.resolve_object_exception");
            return null;
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "ejb.resolve_object_exception");
            throw (IOException)new IOException(exception.toString()).initCause(exception);
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    }
}

