/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.javax.rmi.CORBA;

import com.sun.corba.se.internal.util.Utility;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA_2_3.portable.ObjectImpl;

public class StubDelegateImpl
implements StubDelegate {
    private int hashCode = 0;
    private int typeLength;
    private byte[] typeData;
    private int numProfiles = 0;
    private int[] profileTags;
    private byte[][] profileData;

    private void init(Stub stub) {
        if (this.numProfiles == 0) {
            OutputStream outputStream = stub._orb().create_output_stream();
            outputStream.write_Object((Object)stub);
            InputStream inputStream = outputStream.create_input_stream();
            this.typeLength = inputStream.read_long();
            this.typeData = new byte[this.typeLength];
            inputStream.read_octet_array(this.typeData, 0, this.typeLength);
            this.numProfiles = inputStream.read_long();
            this.profileTags = new int[this.numProfiles];
            this.profileData = new byte[this.numProfiles][];
            for (int i = 0; i < this.numProfiles; ++i) {
                this.profileTags[i] = inputStream.read_long();
                this.profileData[i] = new byte[inputStream.read_long()];
                inputStream.read_octet_array(this.profileData[i], 0, this.profileData[i].length);
            }
        }
    }

    public int hashCode(Stub stub) {
        this.init(stub);
        if (this.hashCode == 0) {
            int n;
            for (n = 0; n < this.typeLength; ++n) {
                this.hashCode = this.hashCode * 37 + this.typeData[n];
            }
            for (n = 0; n < this.numProfiles; ++n) {
                this.hashCode = this.hashCode * 37 + this.profileTags[n];
                for (int i = 0; i < this.profileData[n].length; ++i) {
                    this.hashCode = this.hashCode * 37 + this.profileData[n][i];
                }
            }
        }
        return this.hashCode;
    }

    public boolean equals(Stub stub, java.lang.Object object) {
        if (stub == object) {
            return true;
        }
        if (!(object instanceof Stub)) {
            return false;
        }
        Stub stub2 = (Stub)object;
        if (stub2.hashCode() != stub.hashCode()) {
            return false;
        }
        return stub.toString().equals(stub2.toString());
    }

    public String toString(Stub stub) {
        try {
            return stub._orb().object_to_string((Object)stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            return null;
        }
    }

    public void connect(Stub stub, ORB oRB) throws RemoteException {
        boolean bl;
        block13: {
            bl = false;
            try {
                Delegate delegate = stub._get_delegate();
                if (delegate.orb((Object)stub) != oRB) {
                    bl = true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                if (this.numProfiles == 0) {
                    Tie tie = Utility.getAndForgetTie(stub);
                    if (tie == null) {
                        bl = true;
                    }
                    try {
                        ORB oRB2 = tie.orb();
                        if (oRB2 != oRB) {
                            bl = true;
                        }
                    }
                    catch (BAD_OPERATION bAD_OPERATION2) {
                        if (tie instanceof ObjectImpl) {
                            tie.orb(oRB);
                            stub._set_delegate(((ObjectImpl)tie)._get_delegate());
                            break block13;
                        }
                        bl = true;
                    }
                }
                try {
                    OutputStream outputStream = oRB.create_output_stream();
                    outputStream.write_long(this.typeLength);
                    outputStream.write_octet_array(this.typeData, 0, this.typeLength);
                    outputStream.write_long(this.numProfiles);
                    for (int i = 0; i < this.numProfiles; ++i) {
                        outputStream.write_long(this.profileTags[i]);
                        outputStream.write_long(this.profileData[i].length);
                        outputStream.write_octet_array(this.profileData[i], 0, this.profileData[i].length);
                    }
                    ObjectImpl objectImpl = (ObjectImpl)outputStream.create_input_stream().read_Object();
                    stub._set_delegate(objectImpl._get_delegate());
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
        }
        if (bl) {
            throw new RemoteException("CORBA BAD_OPERATION 0");
        }
    }

    public void readObject(Stub stub, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.typeLength = objectInputStream.readInt();
        this.typeData = new byte[this.typeLength];
        objectInputStream.readFully(this.typeData);
        this.numProfiles = objectInputStream.readInt();
        this.profileTags = new int[this.numProfiles];
        this.profileData = new byte[this.numProfiles][];
        for (int i = 0; i < this.numProfiles; ++i) {
            this.profileTags[i] = objectInputStream.readInt();
            this.profileData[i] = new byte[objectInputStream.readInt()];
            objectInputStream.readFully(this.profileData[i]);
        }
    }

    public void writeObject(Stub stub, ObjectOutputStream objectOutputStream) throws IOException {
        this.init(stub);
        objectOutputStream.writeInt(this.typeLength);
        objectOutputStream.write(this.typeData);
        objectOutputStream.writeInt(this.numProfiles);
        for (int i = 0; i < this.numProfiles; ++i) {
            objectOutputStream.writeInt(this.profileTags[i]);
            objectOutputStream.writeInt(this.profileData[i].length);
            objectOutputStream.write(this.profileData[i]);
        }
    }
}

