/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.OutputStreamHook;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.util.Stack;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPOutputStream
extends OutputStreamHook {
    private static final byte kFormatVersionOne = 1;
    private OutputStream orbStream;
    private java.lang.Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack classDescStack = new Stack();
    private java.lang.Object[] writeObjectArglist = new java.lang.Object[]{this};

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
    }

    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final void writeObjectDelegate(java.lang.Object object) {
        Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (java.lang.Object)object);
    }

    public final void writeObjectOverride(java.lang.Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleWriteObject(java.lang.Object object) {
        java.lang.Object object2 = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleWriteDepth;
        try {
            try {
                this.outputObject(object);
            }
            catch (IOException iOException) {
                if (this.abortIOException == null) {
                    this.abortIOException = iOException;
                }
                java.lang.Object var6_5 = null;
                --this.simpleWriteDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
            }
            java.lang.Object var6_4 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            throw throwable;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleWriteDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            IIOPOutputStream.throwExceptionType(IOException.class, iOException.getMessage());
        }
    }

    ObjectStreamField[] getFieldsNoCopy() {
        return this.currentClassDesc.getFieldsNoCopy();
    }

    public final void defaultWriteObjectDelegate() {
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultWriteObjectDelegate");
            }
            ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
            if (objectStreamFieldArray.length > 0) {
                this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            }
        }
        catch (IOException iOException) {
            IIOPOutputStream.throwExceptionType(IOException.class, iOException.getMessage());
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean bl) {
        return false;
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    public final void close() throws IOException {
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    protected final java.lang.Object replaceObject(java.lang.Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.orbStream.write_octet_array(byArray, n, n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n) throws IOException {
        try {
            this.orbStream.write_octet((byte)(n & 0xFF));
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl) throws IOException {
        try {
            this.orbStream.write_boolean(bl);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n) throws IOException {
        try {
            this.orbStream.write_octet((byte)n);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBytes(String string) throws IOException {
        try {
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n) throws IOException {
        try {
            this.orbStream.write_wchar((char)n);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        try {
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeDouble(double d) throws IOException {
        try {
            this.orbStream.write_double(d);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f) throws IOException {
        try {
            this.orbStream.write_float(f);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n) throws IOException {
        try {
            this.orbStream.write_long(n);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l) throws IOException {
        try {
            this.orbStream.write_longlong(l);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n) throws IOException {
        try {
            this.orbStream.write_short((short)n);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream outputStream, String string) {
        outputStream.write_wstring(string);
    }

    public final void writeUTF(String string) throws IOException {
        try {
            this.internalWriteUTF(this.orbStream, string);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    private boolean checkSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof String) {
            this.orbStream.write_value((Serializable)object);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputObject(java.lang.Object object) throws IOException {
        this.currentObject = object;
        Class<?> clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            this.writeByte(1);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
        } else {
            int n = this.classDescStack.size();
            try {
                ObjectStreamClass objectStreamClass;
                while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = objectStreamClass;
                }
                do {
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.invokeObjectWriter(object, this.currentClassDesc.forClass());
                        continue;
                    }
                    this.defaultWriteObjectDelegate();
                } while (this.classDescStack.size() > n && (this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
            }
            finally {
                this.classDescStack.setSize(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeObjectWriter(java.lang.Object object, Class clazz) throws IOException {
        try {
            this.writeByte(1);
            this.writeBoolean(true);
            IIOPOutputStream.writeObject(object, clazz, this);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("invokeObjectWriter interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
    }

    void writeField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                if (object == null) {
                    this.orbStream.write_octet((byte)0);
                    break;
                }
                this.orbStream.write_octet((Byte)object);
                break;
            }
            case 'C': {
                if (object == null) {
                    this.orbStream.write_wchar('\u0000');
                    break;
                }
                this.orbStream.write_wchar(((Character)object).charValue());
                break;
            }
            case 'F': {
                if (object == null) {
                    this.orbStream.write_float(0.0f);
                    break;
                }
                this.orbStream.write_float(((Float)object).floatValue());
                break;
            }
            case 'D': {
                if (object == null) {
                    this.orbStream.write_double(0.0);
                    break;
                }
                this.orbStream.write_double((Double)object);
                break;
            }
            case 'I': {
                if (object == null) {
                    this.orbStream.write_long(0);
                    break;
                }
                this.orbStream.write_long((Integer)object);
                break;
            }
            case 'J': {
                if (object == null) {
                    this.orbStream.write_longlong(0L);
                    break;
                }
                this.orbStream.write_longlong((Long)object);
                break;
            }
            case 'S': {
                if (object == null) {
                    this.orbStream.write_short((short)0);
                    break;
                }
                this.orbStream.write_short((Short)object);
                break;
            }
            case 'Z': {
                if (object == null) {
                    this.orbStream.write_boolean(false);
                    break;
                }
                this.orbStream.write_boolean((Boolean)object);
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectField(objectStreamField, object);
                break;
            }
            default: {
                throw new InvalidClassException(this.currentClassDesc.getName());
            }
        }
    }

    private void writeObjectField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            Util.writeAny((org.omg.CORBA.portable.OutputStream)this.orbStream, (java.lang.Object)object);
        } else {
            Class clazz = objectStreamField.getType();
            int n = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if (Remote.class.isAssignableFrom(clazz)) {
                    n = 0;
                } else if (Object.class.isAssignableFrom(clazz)) {
                    n = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n = 1;
                }
            }
            switch (n) {
                case 0: {
                    Util.writeRemoteObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (java.lang.Object)object);
                    break;
                }
                case 1: {
                    Util.writeAbstractObject((org.omg.CORBA.portable.OutputStream)this.orbStream, (java.lang.Object)object);
                    break;
                }
                case 2: {
                    try {
                        this.orbStream.write_value((Serializable)object, clazz);
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        if (object instanceof Serializable) {
                            throw classCastException;
                        }
                        Utility.throwNotSerializableForCorba(object.getClass().getName());
                    }
                }
            }
        }
    }

    private void outputClassFields(java.lang.Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        block11: for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            if (objectStreamFieldArray[i].getField() == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[i].getName());
            }
            switch (objectStreamFieldArray[i].getTypeCode()) {
                case 'B': {
                    byte by = IIOPOutputStream.getByteFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_octet(by);
                    continue block11;
                }
                case 'C': {
                    char c = IIOPOutputStream.getCharFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_wchar(c);
                    continue block11;
                }
                case 'F': {
                    float f = IIOPOutputStream.getFloatFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_float(f);
                    continue block11;
                }
                case 'D': {
                    double d = IIOPOutputStream.getDoubleFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_double(d);
                    continue block11;
                }
                case 'I': {
                    int n = IIOPOutputStream.getIntFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_long(n);
                    continue block11;
                }
                case 'J': {
                    long l = IIOPOutputStream.getLongFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_longlong(l);
                    continue block11;
                }
                case 'S': {
                    short s = IIOPOutputStream.getShortFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_short(s);
                    continue block11;
                }
                case 'Z': {
                    boolean bl = IIOPOutputStream.getBooleanFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.orbStream.write_boolean(bl);
                    continue block11;
                }
                case 'L': 
                case '[': {
                    java.lang.Object object2 = IIOPOutputStream.getObjectFieldOpt(object, objectStreamFieldArray[i].getFieldID(clazz));
                    this.writeObjectField(objectStreamFieldArray[i], object2);
                    continue block11;
                }
                default: {
                    throw new InvalidClassException(clazz.getName());
                }
            }
        }
    }

    private static native void throwExceptionType(Class var0, String var1);

    private static native java.lang.Object getObjectFieldOpt(java.lang.Object var0, long var1);

    private static native boolean getBooleanFieldOpt(java.lang.Object var0, long var1);

    private static native byte getByteFieldOpt(java.lang.Object var0, long var1);

    private static native char getCharFieldOpt(java.lang.Object var0, long var1);

    private static native short getShortFieldOpt(java.lang.Object var0, long var1);

    private static native int getIntFieldOpt(java.lang.Object var0, long var1);

    private static native long getLongFieldOpt(java.lang.Object var0, long var1);

    private static native float getFloatFieldOpt(java.lang.Object var0, long var1);

    private static native double getDoubleFieldOpt(java.lang.Object var0, long var1);

    private static native void writeObject(java.lang.Object var0, Class var1, java.lang.Object var2) throws InvocationTargetException, IllegalAccessException;
}

