/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.orbutil;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.ORBVersion;
import com.sun.corba.ee.internal.core.ORBVersionImpl;
import com.sun.corba.ee.internal.orbutil.ORBClassLoader;
import com.sun.corba.ee.internal.orbutil.ValueHandlerImpl_1_3;
import com.sun.corba.ee.internal.orbutil.ValueHandlerImpl_1_3_1;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.logging.Level;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ORBUtility {
    private static StructMember[] members = null;
    private static final Hashtable exceptionClassNames = new Hashtable();
    private static final Hashtable exceptionRepositoryIds = new Hashtable();

    private ORBUtility() {
    }

    private static StructMember[] systemExceptionMembers(ORB oRB) {
        if (members == null) {
            members = new StructMember[3];
            ORBUtility.members[0] = new StructMember("id", oRB.create_string_tc(0), null);
            ORBUtility.members[1] = new StructMember("minor", oRB.get_primitive_tc(TCKind.tk_long), null);
            ORBUtility.members[2] = new StructMember("completed", oRB.get_primitive_tc(TCKind.tk_long), null);
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypeCode getSystemExceptionTypeCode(ORB oRB, String string, String string2) {
        Class clazz = TypeCode.class;
        synchronized (clazz) {
            return oRB.create_exception_tc(string, string2, ORBUtility.systemExceptionMembers(oRB));
        }
    }

    private static boolean isSystemExceptionTypeCode(TypeCode typeCode, ORB oRB) {
        StructMember[] structMemberArray = ORBUtility.systemExceptionMembers(oRB);
        try {
            return typeCode.kind().value() == 22 && typeCode.member_count() == 3 && typeCode.member_type(0).equal(structMemberArray[0].type) && typeCode.member_type(1).equal(structMemberArray[1].type) && typeCode.member_type(2).equal(structMemberArray[2].type);
        }
        catch (BadKind badKind) {
            LogWrap.logger.log(Level.FINE, "", badKind);
            return false;
        }
        catch (Bounds bounds) {
            LogWrap.logger.log(Level.FINE, "", bounds);
            return false;
        }
    }

    public static void insertSystemException(SystemException systemException, Any any) {
        OutputStream outputStream = any.create_output_stream();
        ORB oRB = outputStream.orb();
        String string = systemException.getClass().getName();
        String string2 = ORBUtility.repositoryIdOf(string);
        outputStream.write_string(string2);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
        any.read_value(outputStream.create_input_stream(), ORBUtility.getSystemExceptionTypeCode(oRB, string2, string));
    }

    public static SystemException extractSystemException(Any any) {
        InputStream inputStream = any.create_input_stream();
        ORB oRB = inputStream.orb();
        if (!ORBUtility.isSystemExceptionTypeCode(any.type(), oRB)) {
            return new UNKNOWN(1398079692, CompletionStatus.COMPLETED_MAYBE);
        }
        return ORBUtility.readSystemException(inputStream);
    }

    public static ValueHandler createValueHandler(com.sun.corba.ee.internal.corba.ORB oRB) {
        if (oRB == null) {
            return Util.createValueHandler();
        }
        ORBVersion oRBVersion = oRB.getORBVersion();
        if (oRBVersion == null) {
            return Util.createValueHandler();
        }
        if (oRBVersion.equals(ORBVersionImpl.OLD)) {
            return new ValueHandlerImpl_1_3();
        }
        if (oRBVersion.equals(ORBVersionImpl.NEW)) {
            return new ValueHandlerImpl_1_3_1();
        }
        return Util.createValueHandler();
    }

    public static boolean isLegacyORB(com.sun.corba.ee.internal.corba.ORB oRB) {
        try {
            ORBVersion oRBVersion = oRB.getORBVersion();
            return oRBVersion.equals(ORBVersionImpl.OLD);
        }
        catch (SecurityException securityException) {
            LogWrap.logger.log(Level.FINE, "", securityException);
            return false;
        }
    }

    public static boolean isForeignORB(com.sun.corba.ee.internal.corba.ORB oRB) {
        if (oRB == null) {
            return false;
        }
        try {
            return oRB.getORBVersion().equals(ORBVersionImpl.FOREIGN);
        }
        catch (SecurityException securityException) {
            LogWrap.logger.log(Level.FINE, "", securityException);
            return false;
        }
    }

    public static int bytesToInt(byte[] byArray, int n) {
        int n2 = byArray[n++] << 24 & 0xFF000000;
        int n3 = byArray[n++] << 16 & 0xFF0000;
        int n4 = byArray[n++] << 8 & 0xFF00;
        int n5 = byArray[n++] << 0 & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24 & 0xFF);
        byArray[n2++] = (byte)(n >>> 16 & 0xFF);
        byArray[n2++] = (byte)(n >>> 8 & 0xFF);
        byArray[n2++] = (byte)(n >>> 0 & 0xFF);
    }

    public static int hexOf(char c) {
        int n = c - 48;
        if (n >= 0 && n <= 9) {
            return n;
        }
        n = c - 97 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        n = c - 65 + 10;
        if (n >= 10 && n <= 15) {
            return n;
        }
        throw new DATA_CONVERSION(1398079693, CompletionStatus.COMPLETED_NO);
    }

    public static void writeSystemException(SystemException systemException, OutputStream outputStream) {
        String string = ORBUtility.repositoryIdOf(systemException.getClass().getName());
        outputStream.write_string(string);
        outputStream.write_long(systemException.minor);
        outputStream.write_long(systemException.completed.value());
    }

    public static SystemException readSystemException(InputStream inputStream) {
        try {
            String string = ORBUtility.classNameOf(inputStream.read_string());
            SystemException systemException = (SystemException)ORBClassLoader.loadClass(string).newInstance();
            systemException.minor = inputStream.read_long();
            systemException.completed = CompletionStatus.from_int(inputStream.read_long());
            return systemException;
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
            return new UNKNOWN(1398079693, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public static String classNameOf(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        if (string2 == null) {
            string2 = "org.omg.CORBA.UNKNOWN";
        }
        return string2;
    }

    public static boolean isSystemException(String string) {
        String string2 = null;
        string2 = (String)exceptionClassNames.get(string);
        return string2 != null;
    }

    public static String repositoryIdOf(String string) {
        String string2 = (String)exceptionRepositoryIds.get(string);
        if (string2 == null) {
            string2 = "IDL:omg.org/CORBA/UNKNOWN:1.0";
        }
        return string2;
    }

    public static int[] parseVersion(String string) {
        int n;
        int n2;
        if (string == null) {
            return new int[0];
        }
        char[] cArray = string.toCharArray();
        for (n2 = 0; n2 < cArray.length && (cArray[n2] < '0' || cArray[n2] > '9'); ++n2) {
            if (n2 != cArray.length) continue;
            return new int[0];
        }
        int n3 = 1;
        for (n = n2 + 1; n < cArray.length; ++n) {
            if (cArray[n] == '.') {
                ++n3;
                continue;
            }
            if (cArray[n] < '0' || cArray[n] > '9') break;
        }
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            int n4 = string.indexOf(46, n2);
            if (n4 == -1 || n4 > n) {
                n4 = n;
            }
            nArray[i] = n2 >= n4 ? 0 : Integer.parseInt(string.substring(n2, n4));
            n2 = n4 + 1;
        }
        return nArray;
    }

    public static int compareVersion(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (i >= nArray2.length || nArray[i] > nArray2[i]) {
                return 1;
            }
            if (nArray[i] >= nArray2[i]) continue;
            return -1;
        }
        return nArray.length == nArray2.length ? 0 : -1;
    }

    public static int compareVersion(String string, String string2) {
        return ORBUtility.compareVersion(ORBUtility.parseVersion(string), ORBUtility.parseVersion(string2));
    }

    public static String objectToString(Object object) {
        if (object == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = clazz.getComponentType();
        if (object instanceof Properties) {
            Properties properties = (Properties)object;
            stringBuffer.append(clazz.getName());
            stringBuffer.append("(");
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append("=");
                stringBuffer.append(string2);
            }
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }
        try {
            clazz.getDeclaredMethod("toString", null);
            return object.toString();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.FINE, "", exception);
            if (clazz2 == null) {
                Field[] fieldArray;
                try {
                    fieldArray = clazz.getFields();
                }
                catch (SecurityException securityException) {
                    LogWrap.logger.log(Level.FINE, "", securityException);
                    return object.toString();
                }
                stringBuffer.append(clazz.getName());
                stringBuffer.append("(");
                for (int i = 0; i < fieldArray.length; ++i) {
                    Field field = fieldArray[i];
                    stringBuffer.append(" ");
                    stringBuffer.append(field.getName());
                    stringBuffer.append("=");
                    try {
                        Object object2 = field.get(object);
                        stringBuffer.append(ORBUtility.objectToString(object2));
                        continue;
                    }
                    catch (Exception exception2) {
                        LogWrap.logger.log(Level.FINE, "", exception2);
                        stringBuffer.append("???");
                    }
                }
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }
            stringBuffer.append(clazz2.getName());
            stringBuffer.append("[");
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                stringBuffer.append(blArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < blArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(blArray[i]);
                }
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                stringBuffer.append(byArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(byArray[i]);
                }
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])object;
                stringBuffer.append(sArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < sArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(sArray[i]);
                }
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])object;
                stringBuffer.append(nArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(nArray[i]);
                }
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])object;
                stringBuffer.append(lArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < lArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(lArray[i]);
                }
            } else if (clazz2 == Character.TYPE) {
                char[] cArray = (char[])object;
                stringBuffer.append(cArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < cArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(cArray[i]);
                }
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])object;
                stringBuffer.append(fArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(fArray[i]);
                }
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])object;
                stringBuffer.append(dArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < dArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(dArray[i]);
                }
            } else {
                Object[] objectArray = (Object[])object;
                stringBuffer.append(objectArray.length);
                stringBuffer.append("](");
                for (int i = 0; i < objectArray.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(ORBUtility.objectToString(objectArray[i]));
                }
            }
            stringBuffer.append(" ]");
            return stringBuffer.toString();
        }
    }

    public static void dprint(Object object, String string) {
        System.out.println(object.getClass().getName() + "(" + Thread.currentThread() + "): " + string);
    }

    public static void dprint(String string, String string2) {
        System.out.println(string + "(" + Thread.currentThread() + "): " + string2);
    }

    public void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void dprint(Object object, String string, Throwable throwable) {
        System.out.println(object.getClass().getName() + '(' + Thread.currentThread() + "): " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static String[] concatenateStringArrays(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n + stringArray.length] = stringArray2[n];
        }
        return stringArray3;
    }

    public static void throwNotSerializableForCorba(String string) {
        throw new BAD_PARAM(string, 1330446342, CompletionStatus.COMPLETED_MAYBE);
    }

    static {
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_CONTEXT:1.0", "org.omg.CORBA.BAD_CONTEXT");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_INV_ORDER:1.0", "org.omg.CORBA.BAD_INV_ORDER");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_OPERATION:1.0", "org.omg.CORBA.BAD_OPERATION");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_PARAM:1.0", "org.omg.CORBA.BAD_PARAM");
        exceptionClassNames.put("IDL:omg.org/CORBA/BAD_TYPECODE:1.0", "org.omg.CORBA.BAD_TYPECODE");
        exceptionClassNames.put("IDL:omg.org/CORBA/COMM_FAILURE:1.0", "org.omg.CORBA.COMM_FAILURE");
        exceptionClassNames.put("IDL:omg.org/CORBA/DATA_CONVERSION:1.0", "org.omg.CORBA.DATA_CONVERSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/IMP_LIMIT:1.0", "org.omg.CORBA.IMP_LIMIT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTF_REPOS:1.0", "org.omg.CORBA.INTF_REPOS");
        exceptionClassNames.put("IDL:omg.org/CORBA/INTERNAL:1.0", "org.omg.CORBA.INTERNAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_FLAG:1.0", "org.omg.CORBA.INV_FLAG");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_IDENT:1.0", "org.omg.CORBA.INV_IDENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_OBJREF:1.0", "org.omg.CORBA.INV_OBJREF");
        exceptionClassNames.put("IDL:omg.org/CORBA/MARSHAL:1.0", "org.omg.CORBA.MARSHAL");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_MEMORY:1.0", "org.omg.CORBA.NO_MEMORY");
        exceptionClassNames.put("IDL:omg.org/CORBA/FREE_MEM:1.0", "org.omg.CORBA.FREE_MEM");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_IMPLEMENT:1.0", "org.omg.CORBA.NO_IMPLEMENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_PERMISSION:1.0", "org.omg.CORBA.NO_PERMISSION");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESOURCES:1.0", "org.omg.CORBA.NO_RESOURCES");
        exceptionClassNames.put("IDL:omg.org/CORBA/NO_RESPONSE:1.0", "org.omg.CORBA.NO_RESPONSE");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJ_ADAPTER:1.0", "org.omg.CORBA.OBJ_ADAPTER");
        exceptionClassNames.put("IDL:omg.org/CORBA/INITIALIZE:1.0", "org.omg.CORBA.INITIALIZE");
        exceptionClassNames.put("IDL:omg.org/CORBA/PERSIST_STORE:1.0", "org.omg.CORBA.PERSIST_STORE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSIENT:1.0", "org.omg.CORBA.TRANSIENT");
        exceptionClassNames.put("IDL:omg.org/CORBA/UNKNOWN:1.0", "org.omg.CORBA.UNKNOWN");
        exceptionClassNames.put("IDL:omg.org/CORBA/OBJECT_NOT_EXIST:1.0", "org.omg.CORBA.OBJECT_NOT_EXIST");
        exceptionClassNames.put("IDL:omg.org/CORBA/INVALID_TRANSACTION:1.0", "org.omg.CORBA.INVALID_TRANSACTION");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_REQUIRED:1.0", "org.omg.CORBA.TRANSACTION_REQUIRED");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_ROLLEDBACK:1.0", "org.omg.CORBA.TRANSACTION_ROLLEDBACK");
        exceptionClassNames.put("IDL:omg.org/CORBA/INV_POLICY:1.0", "org.omg.CORBA.INV_POLICY");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_UNAVAILABLE:1.0", "org.omg.CORBA.TRANSACTION_UNAVAILABLE");
        exceptionClassNames.put("IDL:omg.org/CORBA/TRANSACTION_MODE:1.0", "org.omg.CORBA.TRANSACTION_MODE");
        Enumeration enumeration = exceptionClassNames.keys();
        try {
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                String string = (String)k;
                String string2 = (String)exceptionClassNames.get(string);
                exceptionRepositoryIds.put(string2, string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            LogWrap.logger.log(Level.FINE, "", noSuchElementException);
        }
    }
}

