/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.orbutil;

import com.sun.corba.ee.internal.orbutil.Collision;

class FastCacheTable {
    static final int kGrowthRate = 101;
    static final int kMaxCacheSize = 30;
    static final int kKeysPos = 0;
    static final int kValsPos = 1;
    static final int kHashCodesPos = 2;
    static final int kCollisionsPos = 3;
    static final Object[][] cache = new Object[31][4];
    static int cacheIndex = -1;
    Object[] keys = null;
    int[] vals;
    int[] hashCodes;
    Collision[] collisions;
    int count;
    int threshold;

    public final void put(Object object, int n) {
        this.checkForGrowth();
        int n2 = System.identityHashCode(object);
        int n3 = (n2 & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n3] == null) {
            this.keys[n3] = object;
            this.vals[n3] = n;
            this.hashCodes[n3] = n2;
            if (this.collisions != null) {
                this.collisions[n3] = null;
            }
        } else {
            Collision collision = new Collision();
            collision.key = object;
            collision.val = n;
            collision.hash = n2;
            if (this.collisions == null) {
                this.collisions = new Collision[this.keys.length];
            }
            collision.next = this.collisions[n3];
            this.collisions[n3] = collision;
        }
        ++this.count;
    }

    public final boolean containsKey(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return false;
        }
        if (this.keys[n2] == object) {
            return true;
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return false;
        }
        do {
            if (collision.key != object) continue;
            return true;
        } while ((collision = collision.next) != null);
        return false;
    }

    public final int getVal(Object object) {
        Collision collision;
        int n = System.identityHashCode(object);
        int n2 = (n & Integer.MAX_VALUE) % this.keys.length;
        if (this.keys[n2] == null) {
            return -1;
        }
        if (this.keys[n2] == object) {
            return this.vals[n2];
        }
        Collision collision2 = collision = this.collisions == null ? null : this.collisions[n2];
        if (collision == null) {
            return -1;
        }
        do {
            if (collision.key != object) continue;
            return collision.val;
        } while ((collision = collision.next) != null);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        Object[][] objectArray = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keys = null;
            this.vals = null;
            this.hashCodes = null;
            this.collisions = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            this.count = 0;
            Object[][] objectArray = cache;
            synchronized (cache) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    this.hashCodes = (int[])cache[cacheIndex][2];
                    this.collisions = (Collision[])cache[cacheIndex][3];
                    for (int i = this.keys.length; i > 0; --i) {
                        this.keys[i - 1] = null;
                    }
                    --cacheIndex;
                    this.threshold = 3 * this.keys.length / 4;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.keys = new Object[101];
                this.vals = new int[101];
                this.hashCodes = new int[101];
                this.collisions = null;
                this.threshold = 3 * this.keys.length / 4;
                return;
            }
        }
        if (this.threshold != this.count) return;
        int n = this.keys.length;
        int n2 = n + 101;
        Object[] objectArray = new Object[n2];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        Collision[] collisionArray = null;
        for (int i = 0; i < n; ++i) {
            Collision collision;
            if (this.keys[i] == null) continue;
            int n3 = this.hashCodes[i];
            int n4 = (n3 & Integer.MAX_VALUE) % n2;
            if (objectArray[n4] == null) {
                objectArray[n4] = this.keys[i];
                nArray[n4] = this.vals[i];
                nArray2[n4] = n3;
                if (collisionArray != null) {
                    collisionArray[n4] = null;
                }
            } else {
                collision = new Collision();
                collision.key = this.keys[i];
                collision.val = this.vals[i];
                collision.hash = n3;
                if (collisionArray == null) {
                    collisionArray = new Collision[n2];
                }
                collision.next = collisionArray[n4];
                collisionArray[n4] = collision;
            }
            if (this.collisions == null) continue;
            collision = this.collisions[i];
            while (collision != null) {
                n3 = collision.hash;
                n4 = (n3 & Integer.MAX_VALUE) % n2;
                if (objectArray[n4] == null) {
                    objectArray[n4] = collision.key;
                    nArray[n4] = collision.val;
                    nArray2[n4] = n3;
                    if (collisionArray != null) {
                        collisionArray[n4] = null;
                    }
                } else {
                    Collision collision2 = new Collision();
                    collision2.key = collision.key;
                    collision2.val = collision.val;
                    collision2.hash = n3;
                    if (collisionArray == null) {
                        collisionArray = new Collision[n2];
                    }
                    collision2.next = collisionArray[n4];
                    collisionArray[n4] = collision2;
                }
                collision = collision.next;
            }
        }
        Object[][] objectArray2 = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                FastCacheTable.cache[++FastCacheTable.cacheIndex][0] = this.keys;
                FastCacheTable.cache[FastCacheTable.cacheIndex][1] = this.vals;
                FastCacheTable.cache[FastCacheTable.cacheIndex][2] = this.hashCodes;
                FastCacheTable.cache[FastCacheTable.cacheIndex][3] = this.collisions;
            }
            // ** MonitorExit[var7_11] (shouldn't be in output)
            this.keys = objectArray;
            this.vals = nArray;
            this.hashCodes = nArray2;
            this.collisions = collisionArray;
            this.threshold = 3 * this.keys.length / 4;
            return;
        }
    }
}

