/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.orbutil;

import com.sun.corba.ee.internal.orbutil.FastCacheTable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class CacheTable {
    private static final int kGrowthRate = 10;
    private static final int kMaxCacheSize = 30;
    private static final int kKeysPos = 0;
    private static final int kValsPos = 1;
    private static final Object[][] cache = new Object[31][2];
    private static int cacheIndex = -1;
    private Object[] keys = null;
    private int[] vals = null;
    private int index = 0;
    private int lastFoundIndex = 0;
    private FastCacheTable hashedTable = null;

    private CacheTable() {
    }

    public CacheTable(boolean bl) {
        if (bl) {
            this.hashedTable = new FastCacheTable();
        }
    }

    public final void put(Object object, int n) {
        if (this.hashedTable != null) {
            this.hashedTable.put(object, n);
            return;
        }
        if (object == null) {
            return;
        }
        if (!this.containsKey(object)) {
            this.checkForGrowth();
            this.keys[this.index] = object;
            this.vals[this.index] = n;
            ++this.index;
        } else {
            int n2 = this.getVal(object);
            if (n2 != n) {
                throw new INTERNAL(1398079695, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public final boolean containsKey(Object object) {
        int n;
        if (this.hashedTable != null) {
            return this.hashedTable.containsKey(object);
        }
        for (n = this.lastFoundIndex; n < this.index; ++n) {
            if (this.keys[n] != object) continue;
            this.lastFoundIndex = n;
            return true;
        }
        for (n = 0; n < this.lastFoundIndex; ++n) {
            if (this.keys[n] != object) continue;
            this.lastFoundIndex = n;
            return true;
        }
        return false;
    }

    public final int getVal(Object object) {
        int n;
        if (this.hashedTable != null) {
            return this.hashedTable.getVal(object);
        }
        for (n = this.lastFoundIndex; n < this.index; ++n) {
            if (this.keys[n] != object) continue;
            this.lastFoundIndex = n;
            return this.vals[n];
        }
        for (n = 0; n < this.lastFoundIndex; ++n) {
            if (this.keys[n] != object) continue;
            this.lastFoundIndex = n;
            return this.vals[n];
        }
        return -1;
    }

    public final boolean containsVal(int n) {
        int n2;
        for (n2 = this.lastFoundIndex; n2 < this.index; ++n2) {
            if (this.vals[n2] != n) continue;
            this.lastFoundIndex = n2;
            return true;
        }
        for (n2 = 0; n2 < this.lastFoundIndex; ++n2) {
            if (this.vals[n2] != n) continue;
            this.lastFoundIndex = n2;
            return true;
        }
        return false;
    }

    public final boolean containsOrderedVal(int n) {
        int n2 = 0;
        int n3 = this.index;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.vals[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            this.lastFoundIndex = n4;
            return true;
        }
        return false;
    }

    public final Object getKey(int n) {
        int n2;
        for (n2 = this.lastFoundIndex; n2 < this.index; ++n2) {
            if (this.vals[n2] != n) continue;
            this.lastFoundIndex = n2;
            return this.keys[n2];
        }
        for (n2 = 0; n2 < this.lastFoundIndex; ++n2) {
            if (this.vals[n2] != n) continue;
            this.lastFoundIndex = n2;
            return this.keys[n2];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        if (this.hashedTable != null) {
            this.hashedTable.done();
            return;
        }
        Object[][] objectArray = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.keys = null;
            this.vals = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkForGrowth() {
        if (this.keys == null) {
            Object[][] objectArray = cache;
            synchronized (cache) {
                if (cacheIndex > -1) {
                    this.keys = (Object[])cache[cacheIndex][0];
                    this.vals = (int[])cache[cacheIndex][1];
                    --cacheIndex;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.keys = new Object[10];
                this.vals = new int[10];
                return;
            }
        }
        if (this.keys.length != this.index) return;
        Object[] objectArray = new Object[this.index + 10];
        int[] nArray = new int[this.index + 10];
        System.arraycopy(this.keys, 0, objectArray, 0, this.index);
        System.arraycopy(this.vals, 0, nArray, 0, this.index);
        Object[][] objectArray2 = cache;
        synchronized (cache) {
            if (cacheIndex < 30) {
                CacheTable.cache[++CacheTable.cacheIndex][0] = this.keys;
                CacheTable.cache[CacheTable.cacheIndex][1] = this.vals;
            }
            // ** MonitorExit[var3_5] (shouldn't be in output)
            this.keys = objectArray;
            this.vals = nArray;
            return;
        }
    }
}

