/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.ior;

public class ByteBuffer {
    protected byte[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public ByteBuffer(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new byte[n];
        this.capacityIncrement = n2;
    }

    public ByteBuffer(int n) {
        this(n, 0);
    }

    public ByteBuffer() {
        this(200);
    }

    public void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            byte[] byArray = this.elementData;
            this.elementData = new byte[this.elementCount];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    private void ensureCapacityHelper(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            byte[] byArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new byte[n3];
            System.arraycopy(byArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public int capacity() {
        return this.elementData.length;
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public void append(byte by) {
        this.ensureCapacityHelper(this.elementCount + 1);
        this.elementData[this.elementCount++] = by;
    }

    public void append(int n) {
        this.ensureCapacityHelper(this.elementCount + 4);
        this.doAppend(n);
    }

    private void doAppend(int n) {
        int n2 = n;
        for (int i = 0; i < 4; ++i) {
            this.elementData[this.elementCount + i] = (byte)(n2 & 0xFF);
            n2 >>= 8;
        }
        this.elementCount += 4;
    }

    public void append(String string) {
        byte[] byArray = string.getBytes();
        this.ensureCapacityHelper(this.elementCount + byArray.length + 4);
        this.doAppend(byArray.length);
        System.arraycopy(byArray, 0, this.elementData, this.elementCount, byArray.length);
        this.elementCount += byArray.length;
    }

    public void append(byte[] byArray) {
        this.ensureCapacityHelper(this.elementCount + byArray.length + 4);
        this.doAppend(byArray.length);
        System.arraycopy(byArray, 0, this.elementData, this.elementCount, byArray.length);
        this.elementCount += byArray.length;
    }

    public byte[] toArray() {
        return this.elementData;
    }
}

