/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.CachedCodeBase;
import com.sun.corba.ee.internal.iiop.ClientResponseImpl;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.ConnectionTable;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.IIOPOutputStream;
import com.sun.corba.ee.internal.iiop.MessageMediator;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.ReaderThread;
import com.sun.corba.ee.internal.iiop.ServerRequestImpl;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage;
import com.sun.corba.ee.internal.iiop.messages.Message;
import com.sun.corba.ee.internal.iiop.messages.MessageBase;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;

public final class IIOPConnection
extends Connection {
    private static final int OPENING = 1;
    private static final int ESTABLISHED = 2;
    private static final int CLOSE_SENT = 3;
    private static final int CLOSE_RECVD = 4;
    private static final int ABORT = 5;
    Hashtable out_calls = null;
    ClientResponseImpl theOnly1_1ClientResponseImpl = null;
    Map clientReplyMap = null;
    Hashtable idToFragmentedOutputStream;
    private MessageMediator mediator;
    private String threadName;
    protected EndPoint endpoint;
    protected int requestCount = 0;
    private ServerGIOP server;
    Map serverRequestMap = null;
    ServerRequestImpl theOnly1_1ServerRequestImpl = null;
    private boolean postInitialContexts = false;
    private IOR codeBaseServerIOR;
    private CachedCodeBase cachedCodeBase = new CachedCodeBase(this);
    private com.iplanet.ias.cis.connection.Connection connection;
    Thread reader;
    int state;
    private Object stateEvent = new Object();
    private Object writeEvent = new Object();
    private boolean writeLocked;
    InputStream inputStream;
    OutputStream outputStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStateString(int n) {
        Object object = this.stateEvent;
        synchronized (object) {
            switch (n) {
                case 1: {
                    return "OPENING";
                }
                case 2: {
                    return "ESTABLISHED";
                }
                case 3: {
                    return "CLOSE_SENT";
                }
                case 4: {
                    return "CLOSE_RECVD";
                }
                case 5: {
                    return "ABORT";
                }
            }
            return "???";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.stateEvent;
        synchronized (object) {
            return "Connection[type=" + this.endpoint.getType() + " remote_host=" + this.endpoint.getHostName() + " remote_port=" + this.endpoint.getPort() + " state=" + this.getStateString(this.state) + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, ConnectionTable connectionTable, EndPoint endPoint, String string) {
        this.orb = oRB;
        this.server = serverGIOP;
        this.connectionTable = connectionTable;
        this.endpoint = endPoint;
        this.codeBaseServerIOR = null;
        this.threadName = string == null ? "ORB Client-side Reader, conn to " + this.endpoint.getHostName() + ":" + this.endpoint.getPort() : string;
        this.mediator = new MessageMediator(this);
        this.clientReplyMap = new HashMap();
        this.out_calls = new Hashtable();
        this.idToFragmentedOutputStream = new Hashtable();
        final ThreadGroup threadGroup = oRB.threadGroup;
        final String string2 = this.threadName;
        final IIOPConnection iIOPConnection = this;
        final boolean bl = oRB.transportDebugFlag;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader = new ReaderThread(threadGroup, iIOPConnection, string2, bl);
                    return null;
                }
            });
        }
        catch (SecurityException securityException) {
            LogWrap.logger.log(Level.FINE, "", securityException);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader = new ReaderThread(iIOPConnection, string2, bl);
                    return null;
                }
            });
        }
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 1;
        }
    }

    public IIOPConnection(ORB oRB, ServerGIOP serverGIOP, EndPoint endPoint, com.iplanet.ias.cis.connection.Connection connection, InputStream inputStream, OutputStream outputStream, ConnectionTable connectionTable, boolean bl) {
        this(oRB, serverGIOP, connectionTable, endPoint, "ORB Server-side Reader, conn from " + endPoint.getHostName() + ":" + endPoint.getPort());
        this.mediator = new MessageMediator(this);
        this.connection = connection;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.connectionTable = connectionTable;
        this.isDisabled = bl;
        this.isServer = true;
        this.serverRequestMap = Collections.synchronizedMap(new HashMap());
        this.idToFragmentedOutputStream = new Hashtable();
        this.state = 2;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    IIOPConnection.this.reader.setDaemon(true);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        this.reader.start();
    }

    public synchronized boolean isPostInitialContexts() {
        return this.postInitialContexts;
    }

    public synchronized void setPostInitialContexts() {
        this.postInitialContexts = true;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public ServerGIOP getServerGIOP() {
        return this.server;
    }

    String getHost() {
        return this.endpoint.getHostName();
    }

    int getPort() {
        return this.endpoint.getPort();
    }

    EndPoint getEndpoint() {
        return this.endpoint;
    }

    public final void processInput() throws Exception {
        this.mediator.processRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalReplyReceived(int n, IIOPInputStream iIOPInputStream) {
        Integer n2 = new Integer(n);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
        if (outCallDesc == null) {
            return;
        }
        Object object = outCallDesc.done;
        synchronized (object) {
            outCallDesc.s = iIOPInputStream;
            outCallDesc.done.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purge_calls(int n, boolean bl, boolean bl2) {
        Object object;
        block20: {
            if (this.orb.transportDebugFlag) {
                this.dprint("purge_calls: starting: code = " + n + " die = " + bl);
            }
            object = this.stateEvent;
            synchronized (object) {
                if (this.state == 5 || this.state == 4) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("purge_calls: exiting duplicate invocation");
                    }
                    return;
                }
            }
            try {
                if (!bl2) {
                    this.writeLock();
                }
            }
            catch (SystemException systemException) {
                LogWrap.logger.log(Level.FINE, "", systemException);
                if (!this.orb.transportDebugFlag) break block20;
                this.dprint("purge_calls: caught exception " + systemException + "; continuing");
            }
        }
        Object object2 = this.stateEvent;
        synchronized (object2) {
            if (n == 1398079697) {
                this.state = 4;
                object = CompletionStatus.COMPLETED_NO;
            } else {
                this.state = 5;
                object = CompletionStatus.COMPLETED_MAYBE;
            }
            this.stateEvent.notifyAll();
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
        object2 = new COMM_FAILURE(n, (CompletionStatus)object);
        Enumeration enumeration = this.out_calls.elements();
        while (enumeration.hasMoreElements()) {
            OutCallDesc outCallDesc = (OutCallDesc)enumeration.nextElement();
            Object object3 = outCallDesc.done;
            synchronized (object3) {
                outCallDesc.s = null;
                outCallDesc.exc = object2;
                outCallDesc.done.notify();
            }
        }
        this.connectionTable.deleteConn(this.endpoint);
        this.writeUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnection(com.iplanet.ias.cis.connection.Connection connection, ConnectionTable connectionTable) throws Exception {
        this.connection = connection;
        this.inputStream = connection.getInputStream();
        this.outputStream = connection.getOutputStream();
        this.connectionTable = connectionTable;
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 2;
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        IIOPConnection.this.reader.setDaemon(true);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.WARNING, "", exception);
            }
            this.reader.start();
            this.stateEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortConnection() {
        Object object = this.stateEvent;
        synchronized (object) {
            this.state = 5;
            ((ReaderThread)this.reader).shutdown();
            this.stateEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeLock() {
        block25: while (true) {
            int n;
            Object object = this.stateEvent;
            synchronized (object) {
                n = this.state;
            }
            switch (n) {
                case 1: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.state != 1) {
                            continue block25;
                        }
                        try {
                            this.stateEvent.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            LogWrap.logger.log(Level.WARNING, "", interruptedException);
                        }
                        continue block25;
                    }
                }
                case 2: {
                    object = this.writeEvent;
                    synchronized (object) {
                        if (!this.writeLocked) {
                            this.writeLocked = true;
                            return true;
                        }
                        try {
                            while (this.state == 2 && this.writeLocked) {
                                this.writeEvent.wait(100L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            LogWrap.logger.log(Level.WARNING, "", interruptedException);
                        }
                        continue block25;
                    }
                }
                case 5: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.state != 5) {
                            continue block25;
                        }
                        throw new COMM_FAILURE(1398079691, CompletionStatus.COMPLETED_NO);
                    }
                }
                case 4: {
                    object = this.stateEvent;
                    synchronized (object) {
                        if (this.state != 4) {
                            // MONITOREXIT @DISABLED, blocks:[16, 6, 25, 11, 12, 28] lbl65 : MonitorExitStatement: MONITOREXIT : var2_2
                            continue block25;
                        }
                        throw new COMM_FAILURE(1398079690, CompletionStatus.COMPLETED_NO);
                    }
                }
            }
            break;
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Connection:writeLock: weird state");
        }
        this.delete(1398079696);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeUnlock() {
        Object object = this.writeEvent;
        synchronized (object) {
            this.writeLocked = false;
            this.writeEvent.notify();
        }
    }

    public void delete() {
        this.delete(1398079696);
    }

    void delete(int n) {
    }

    public IIOPInputStream invoke(IIOPOutputStream iIOPOutputStream) throws SystemException {
        return this.send(iIOPOutputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IIOPInputStream getResponse(boolean bl, int n) {
        IIOPInputStream iIOPInputStream = null;
        Integer n2 = new Integer(n);
        OutCallDesc outCallDesc = (OutCallDesc)this.out_calls.get(n2);
        if (bl) {
            this.out_calls.remove(n2);
            return null;
        }
        if (outCallDesc == null) {
            throw new INTERNAL(1398079712, CompletionStatus.COMPLETED_MAYBE);
        }
        Object object = outCallDesc.done;
        synchronized (object) {
            while (outCallDesc.s == null && outCallDesc.exc == null) {
                try {
                    outCallDesc.done.wait();
                }
                catch (InterruptedException interruptedException) {
                    LogWrap.logger.log(Level.WARNING, "", interruptedException);
                }
            }
            this.out_calls.remove(n2);
            if (outCallDesc.exc != null) {
                throw outCallDesc.exc;
            }
            iIOPInputStream = outCallDesc.s;
        }
        if (iIOPInputStream != null) {
            iIOPInputStream.unmarshalHeader();
        }
        return iIOPInputStream;
    }

    void createOutCallDescriptor(int n) {
        if (!this.isServer) {
            Integer n2 = new Integer(n);
            OutCallDesc outCallDesc = new OutCallDesc();
            outCallDesc.thd = Thread.currentThread();
            this.out_calls.put(n2, outCallDesc);
        }
    }

    public void removeOutCallDescriptor(int n) {
        if (!this.isServer) {
            Integer n2 = new Integer(n);
            this.out_calls.remove(n2);
        }
    }

    void sendWithoutLock(IIOPOutputStream iIOPOutputStream) {
        try {
            iIOPOutputStream.writeTo(this.outputStream);
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            LogWrap.logger.log(Level.WARNING, "", iOException);
            Message message = iIOPOutputStream.getMessage();
            if (message.getType() == 0 || message.getType() == 3) {
                GIOPVersion gIOPVersion = message.getGIOPVersion();
                int n = MessageBase.getRequestId(message);
                try {
                    this.sendCancelRequest(gIOPVersion, n);
                }
                catch (IOException iOException2) {
                    LogWrap.logger.log(Level.WARNING, "", iOException2);
                }
            }
            throw new COMM_FAILURE(1398079691, CompletionStatus.COMPLETED_NO);
        }
    }

    public IIOPInputStream send(IIOPOutputStream iIOPOutputStream, boolean bl) {
        iIOPOutputStream.finishSendingMessage();
        return this.getResponse(bl, MessageBase.getRequestId(iIOPOutputStream.getMessage()));
    }

    public void sendReply(IIOPOutputStream iIOPOutputStream) throws Exception {
        iIOPOutputStream.finishSendingMessage();
    }

    public void sendCancelRequest(GIOPVersion gIOPVersion, int n) throws IOException {
        CancelRequestMessage cancelRequestMessage = MessageBase.createCancelRequest(gIOPVersion, n);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(cancelRequestMessage);
        cancelRequestMessage.write(iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCancelRequestWithLock(GIOPVersion gIOPVersion, int n) throws IOException {
        this.writeLock();
        try {
            this.sendCancelRequest(gIOPVersion, n);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void sendCloseConnection(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createCloseConnection(gIOPVersion);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(message);
        message.write(iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    public void sendMessageError(GIOPVersion gIOPVersion) throws IOException {
        Message message = MessageBase.createMessageError(gIOPVersion);
        IIOPOutputStream iIOPOutputStream = new IIOPOutputStream(gIOPVersion, this.orb, this);
        iIOPOutputStream.setMessage(message);
        message.write(iIOPOutputStream);
        iIOPOutputStream.writeTo(this.outputStream);
        this.outputStream.flush();
    }

    public boolean isBusy() {
        return this.requestCount > 0 || this.out_calls.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanUp() throws Exception {
        this.writeLock();
        if (this.requestCount > 0 || this.out_calls.size() > 0) {
            this.writeUnlock();
            throw new Exception();
        }
        try {
            this.sendCloseConnection(GIOPVersion.V1_0);
            Object object = this.stateEvent;
            synchronized (object) {
                this.state = 3;
                this.stateEvent.notifyAll();
            }
            this.purge_calls(1398079697, false, true);
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
        }
    }

    public synchronized void requestBegins() {
        ++this.requestCount;
    }

    public synchronized void requestEnds(IIOPInputStream iIOPInputStream) {
        if (iIOPInputStream.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            this.serverRequestMap.remove(new Integer(MessageBase.getRequestId(iIOPInputStream.getMessage())));
        }
        if (iIOPInputStream.getGIOPVersion().equals(GIOPVersion.V1_1)) {
            this.theOnly1_1ServerRequestImpl = null;
        }
        --this.requestCount;
    }

    void shutdown() {
        try {
            ((ReaderThread)this.reader).shutdown();
            this.connection.close();
        }
        catch (ConnectException connectException) {
            LogWrap.logger.log(Level.WARNING, "", connectException);
        }
    }

    public Socket getSocket() {
        if (this.connection != null) {
            return this.connection.getSocket();
        }
        return null;
    }

    public void print() {
        System.out.println("Connection for " + this.endpoint.getHostName() + " @ " + this.endpoint.getPort());
        System.out.println("    Time stamp = " + this.timeStamp);
        boolean bl = this.reader.isAlive();
        if (bl) {
            System.out.println(" Reader is Alive");
        } else {
            System.out.println(" Reader is not Alive");
        }
    }

    public final void setCodeBaseIOR(IOR iOR) {
        this.codeBaseServerIOR = iOR;
    }

    final IOR getCodeBaseIOR() {
        return this.codeBaseServerIOR;
    }

    final CodeBase getCodeBase() {
        return this.cachedCodeBase;
    }

    final void createIdToFragmentedOutputStreamEntry(int n, IIOPOutputStream iIOPOutputStream) {
        this.idToFragmentedOutputStream.put(new Integer(n), iIOPOutputStream);
    }

    public final IIOPOutputStream getIdToFragmentedOutputStreamEntry(int n) {
        return (IIOPOutputStream)this.idToFragmentedOutputStream.get(new Integer(n));
    }

    public final void removeIdToFragmentedOutputStreamEntry(int n) {
        this.idToFragmentedOutputStream.remove(new Integer(n));
    }

    static final class DeleteConn
    extends Throwable {
        int minorCode;

        DeleteConn(int n) {
            this.minorCode = n;
        }
    }

    static final class OutCallDesc {
        Object done = new Object();
        Thread thd;
        SystemException exc;
        IIOPInputStream s;

        OutCallDesc() {
        }
    }
}

