/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.cis.connection.CISConnectionException;
import com.iplanet.ias.cis.connection.ConnectException;
import com.iplanet.ias.cis.connection.ConnectionInputStream;
import com.iplanet.ias.cis.connection.ConnectionOutputStream;
import com.iplanet.ias.cis.connection.CryptoManager;
import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.iplanet.ias.util.MonitorTask;
import com.sun.corba.ee.connection.EndPointInfo;
import com.sun.corba.ee.connection.GetEndPointInfoAgainException;
import com.sun.corba.ee.connection.ORBSocketFactory;
import com.sun.corba.ee.internal.core.EndPoint;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ServerGIOP;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.EndPointImpl;
import com.sun.corba.ee.internal.iiop.IIOPConnection;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.enterprise.iiop.EEIIOPSocketFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

public class ConnectionTable {
    protected ORB orb;
    protected Hashtable connectionCache = new Hashtable();
    protected long globalCounter = 0L;
    private int MAX_SOCKET_RETRIES = 5;
    protected ServerGIOP server;
    private int inboundConnectionCount = 0;

    public ConnectionTable(ORB oRB, ServerGIOP serverGIOP) {
        this.orb = oRB;
        this.server = serverGIOP;
        MonitorTask.addORBMonitorable(this);
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public Connection getConnection(IOR iOR) {
        return this.getConnection(iOR, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(IOR iOR, EndPointInfo endPointInfo) {
        LogWrap.logger.log(Level.FINEST, "Connection Table GetConnection Called");
        Vector vector = new Vector(10, 5);
        boolean bl = true;
        Connection connection = null;
        ORBSocketFactory oRBSocketFactory = this.orb.getSocketFactory();
        LogWrap.logger.log(Level.FINEST, "Before GetEndPoint In ConnTable");
        endPointInfo = oRBSocketFactory instanceof EEIIOPSocketFactory ? ((EEIIOPSocketFactory)oRBSocketFactory).getEndPointInfo(this.orb, iOR, endPointInfo, vector) : oRBSocketFactory.getEndPointInfo(this.orb, iOR, endPointInfo);
        LogWrap.logger.log(Level.FINEST, "After GetEndPoint In ConnTable");
        block11: while (bl) {
            EndPointImpl endPointImpl = endPointInfo instanceof EndPointImpl ? (EndPointImpl)endPointInfo : new EndPointImpl(endPointInfo.getType(), endPointInfo.getPort(), endPointInfo.getHost());
            if (this.orb.transportDebugFlag) {
                this.dprint("Client get called: host = " + endPointImpl.getHostName() + " port = " + endPointImpl.getPort());
            }
            connection = null;
            ConnectionTable connectionTable = this;
            synchronized (connectionTable) {
                connection = (Connection)this.connectionCache.get(endPointImpl);
                if (connection != null) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Returning connection " + connection + " from table");
                    }
                    return connection;
                }
            }
            int n = 0;
            while (true) {
                try {
                    if (this.orb.getCertDBPath() != null || this.orb.getCertDBPassword() != null) {
                        CryptoManager.initialize(this.orb.getCertDBPath(), this.orb.getCertDBPassword());
                    }
                    com.iplanet.ias.cis.connection.EndPoint endPoint = com.iplanet.ias.cis.connection.EndPoint.getEndPoint(endPointInfo.getType(), endPointInfo.getHost(), endPointInfo.getPort());
                    com.iplanet.ias.cis.connection.Connection connection2 = null;
                    connection2 = endPointInfo.getType().indexOf("SSL") != -1 ? new com.iplanet.ias.cis.connection.Connection(endPoint, this.orb.getCertNickname(), this.orb.getSslVersion(), this.orb.getSsl2Ciphers(), this.orb.getSsl3Ciphers(), this.orb.getTlsRollback()) : new com.iplanet.ias.cis.connection.Connection(null, endPoint);
                    connection2.setTcpNoDelay(true);
                    ConnectionTable connectionTable2 = this;
                    synchronized (connectionTable2) {
                        connection = new IIOPConnection(this.orb, this.server, this, endPointImpl, null);
                        this.stampTime(connection);
                        this.connectionCache.put(endPointImpl, connection);
                        ((IIOPConnection)connection).setConnection(connection2, this);
                        if (this.orb.transportDebugFlag) {
                            this.dprint("Creating new connection " + connection);
                        }
                    }
                    this.checkConnectionTable();
                    bl = false;
                    continue block11;
                }
                catch (GetEndPointInfoAgainException getEndPointInfoAgainException) {
                    if (connection != null) {
                        connection.abortConnection();
                    }
                    LogWrap.logger.log(Level.WARNING, "", getEndPointInfoAgainException);
                    this.deleteConn(endPointImpl);
                    return this.getConnection(iOR, getEndPointInfoAgainException.getEndPointInfo());
                }
                catch (CISConnectionException cISConnectionException) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("ConnectException " + cISConnectionException + " while creating new Connection");
                    }
                    LogWrap.logger.log(Level.WARNING, "", cISConnectionException);
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Attempting resource cleanup and retry on socket creation");
                    }
                    if (n == this.MAX_SOCKET_RETRIES || !this.cleanUp()) {
                        if (this.orb.transportDebugFlag) {
                            this.dprint("Out of resources: aborting connection");
                        }
                        throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                    }
                    ++n;
                    continue;
                }
                catch (ConnectException connectException) {
                    LogWrap.logger.log(Level.FINE, "Connection Error on GetConnection");
                    if (connection != null) {
                        connection.abortConnection();
                    }
                    this.deleteConn(endPointImpl);
                    if (oRBSocketFactory instanceof EEIIOPSocketFactory) {
                        if (connectException.getMessage().indexOf("NewTCPSocket") != -1) {
                            if (n == this.MAX_SOCKET_RETRIES || !this.cleanUp()) {
                                if (this.orb.transportDebugFlag) {
                                    this.dprint("Out of resources: aborting connection");
                                }
                                throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                            }
                            LogWrap.logger.log(Level.FINE, "Retrying NewTCPSocket Creation" + ++n);
                            continue;
                        }
                        LogWrap.logger.log(Level.FINE, "Error in TCP Connect, Trying ALTERNATE_ENDPOINT");
                        endPointInfo = ((EEIIOPSocketFactory)oRBSocketFactory).getEndPointInfo(this.orb, iOR, endPointInfo, vector);
                        if (endPointInfo == null) {
                            throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                        }
                        LogWrap.logger.log(Level.FINE, "Retrying TCP Connection with ALTERNATE_ENDPOINT" + endPointInfo);
                        continue block11;
                    }
                    throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                }
                catch (Exception exception) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint("Exception " + exception + " while creating socket for new connection: aborting connection");
                    }
                    if (connection != null) {
                        connection.abortConnection();
                    }
                    this.deleteConn(endPointImpl);
                    LogWrap.logger.log(Level.WARNING, "", exception);
                    throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
                }
                break;
            }
        }
        if (this.orb.transportDebugFlag) {
            this.dprint("Succesfully created socket for new connection");
        }
        vector = null;
        return connection;
    }

    public synchronized Connection getConnection(com.iplanet.ias.cis.connection.Connection connection, String string, boolean bl) {
        try {
            if (this.orb.transportDebugFlag) {
                this.dprint("Server getConnection(" + connection + ", " + string + ")");
            }
            ConnectionInputStream connectionInputStream = null;
            ConnectionOutputStream connectionOutputStream = null;
            try {
                connectionInputStream = connection.getInputStream();
                connectionOutputStream = connection.getOutputStream();
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.WARNING, "", exception);
                throw new COMM_FAILURE(1398079689, CompletionStatus.COMPLETED_NO);
            }
            String string2 = connection.getPeerEndPoint().getHostName();
            int n = connection.getPeerEndPoint().getPort();
            EndPointImpl endPointImpl = new EndPointImpl(string, n, string2);
            if (this.orb.transportDebugFlag) {
                this.dprint("host = " + string2 + " port = " + n);
            }
            IIOPConnection iIOPConnection = new IIOPConnection(this.orb, this.server, endPointImpl, connection, connectionInputStream, connectionOutputStream, this, bl);
            this.connectionCache.put(endPointImpl, iIOPConnection);
            ++this.inboundConnectionCount;
            this.stampTime(iIOPConnection);
            if (this.orb.transportDebugFlag) {
                this.dprint("Created connection " + iIOPConnection);
            }
            return iIOPConnection;
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
            if (this.orb.transportDebugFlag) {
                this.dprint("Exception " + exception + " on creating connection");
            }
            try {
                connection.close();
            }
            catch (Exception exception2) {
                LogWrap.logger.log(Level.FINE, "", exception2);
            }
            return null;
        }
    }

    public synchronized void deleteConn(EndPoint endPoint) {
        if (this.orb.transportDebugFlag) {
            this.dprint("DeleteConn called: host = " + endPoint.getHostName() + " port = " + endPoint.getPort());
        }
        if (this.connectionCache.containsKey(endPoint) && ((Connection)this.connectionCache.get((Object)endPoint)).isServer) {
            --this.inboundConnectionCount;
        }
        this.connectionCache.remove(endPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanUp() {
        if (this.orb.transportDebugFlag) {
            this.dprint("Cleanup called");
        }
        if (this.connectionCache.size() < this.orb.getLowWaterMark()) {
            if (this.orb.transportDebugFlag) {
                this.dprint("Cleanup returns false: not enough connections open to start cleanup");
            }
            return false;
        }
        for (int i = 0; i < this.orb.getNumberToReclaim(); ++i) {
            Connection connection = null;
            long l = Long.MAX_VALUE;
            ConnectionTable connectionTable = this;
            synchronized (connectionTable) {
                Enumeration enumeration = this.connectionCache.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection2 = (Connection)enumeration.nextElement();
                    if (connection2.isBusy() || connection2.timeStamp >= l) continue;
                    connection = connection2;
                    l = connection2.timeStamp;
                }
            }
            if (connection == null) {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup returns false: all connections busy");
                }
                return false;
            }
            try {
                if (this.orb.transportDebugFlag) {
                    this.dprint("Cleanup is cleaning connection " + connection);
                }
                connection.cleanUp();
                continue;
            }
            catch (Exception exception) {
                LogWrap.logger.log(Level.FINE, "", exception);
            }
        }
        return true;
    }

    public void checkConnectionTable() {
        if (this.connectionCache.size() > this.orb.getHighWaterMark()) {
            this.cleanUp();
        }
    }

    public synchronized void stampTime(Connection connection) {
        connection.timeStamp = this.globalCounter++;
    }

    void destroyConnections() {
        Enumeration enumeration = this.connectionCache.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = (Connection)enumeration.nextElement();
            connection.shutdown();
        }
    }

    public synchronized void print() {
        System.out.println("***ConnectionTable***");
        int n = this.connectionCache.size();
        System.out.println("  SIZE=" + n);
        if (n < 10) {
            Enumeration enumeration = this.connectionCache.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.print();
            }
        }
    }

    public int getInboundConnectionCount() {
        return this.inboundConnectionCount;
    }

    public int getOutboundConnectionCount() {
        return this.connectionCache.size() - this.inboundConnectionCount;
    }

    public synchronized int[] getMonitoredValues() {
        int[] nArray = new int[]{this.inboundConnectionCount, this.connectionCache.size() - this.inboundConnectionCount};
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ConnectionTable [inbound=").append(this.inboundConnectionCount);
        stringBuffer.append(", outbound=");
        stringBuffer.append(this.connectionCache.size() - this.inboundConnectionCount);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

