/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.corba.TypeCodeImpl;
import com.sun.corba.ee.internal.core.ClientSubcontract;
import com.sun.corba.ee.internal.core.CodeSetConversion;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ORBVersionImpl;
import com.sun.corba.ee.internal.iiop.BufferManagerWrite;
import com.sun.corba.ee.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.ee.internal.iiop.CDROutputStreamBase;
import com.sun.corba.ee.internal.orbutil.CacheTable;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.corba.ee.internal.orbutil.RepositoryIdFactory;
import com.sun.corba.ee.internal.orbutil.RepositoryIdStrings;
import com.sun.corba.ee.internal.orbutil.RepositoryIdUtility;
import com.sun.corba.se.internal.util.Utility;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    protected boolean littleEndian;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBufferWithInfo bbwi;
    protected com.sun.corba.ee.internal.corba.ORB orb;
    protected boolean debug = false;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};

    protected void init(ORB oRB, boolean bl, int n, BufferManagerWrite bufferManagerWrite) {
        this.orb = (com.sun.corba.ee.internal.corba.ORB)oRB;
        if (this.orb != null) {
            this.debug = this.orb.transportDebugFlag;
        }
        this.littleEndian = bl;
        this.bufferManagerWrite = bufferManagerWrite;
        this.bbwi = this.bufferManagerWrite.getInitialBuffer(n);
        this.createRepositoryIdHandlers();
    }

    private final void createRepositoryIdHandlers() {
        if (this.orb != null) {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility(this.orb);
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory(this.orb);
        } else {
            this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
            this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
        }
    }

    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.bbwi.index];
        System.arraycopy(this.bbwi.buf, 0, byArray, 0, this.bbwi.index);
        return byArray;
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    protected void handleSpecialChunkBegin(int n) {
    }

    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment(int n) {
        int n2;
        if (n > 1 && (n2 = this.bbwi.index & n - 1) != 0) {
            return n - n2;
        }
        return 0;
    }

    protected void alignAndReserve(int n, int n2) {
        this.bbwi.index += this.computeAlignment(n);
        if (this.bbwi.index + n2 > this.bbwi.buflen) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        this.bbwi.needed = n2;
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    public final void write_longdouble(double d) {
        throw new NO_IMPLEMENT(1398079692, CompletionStatus.COMPLETED_MAYBE);
    }

    public void write_octet(byte by) {
        if (this.bbwi.index + 1 > this.bbwi.buflen) {
            this.alignAndReserve(1, 1);
        }
        this.bbwi.buf[this.bbwi.index++] = by;
    }

    public final void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    public void write_char(char c) {
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(c);
        if (cTBConverter.getNumBytes() > 1) {
            throw new DATA_CONVERSION(1398079697, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_octet(cTBConverter.getBytes()[0]);
    }

    private final void writeLittleEndianWchar(char c) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(c & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(c >>> 8 & 0xFF);
    }

    private final void writeBigEndianWchar(char c) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(c >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(c & 0xFF);
    }

    private final void writeLittleEndianShort(short s) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(s & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(s >>> 8 & 0xFF);
    }

    private final void writeBigEndianShort(short s) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(s >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(s & 0xFF);
    }

    private final void writeLittleEndianLong(int n) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(n & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 16 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 24 & 0xFF);
    }

    private final void writeBigEndianLong(int n) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 24 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 16 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n >>> 8 & 0xFF);
        this.bbwi.buf[this.bbwi.index++] = (byte)(n & 0xFF);
    }

    private final void writeLittleEndianLongLong(long l) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(l & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 8 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 16 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 24 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 32 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 40 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 48 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 56 & 0xFFL);
    }

    private final void writeBigEndianLongLong(long l) {
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 56 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 48 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 40 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 32 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 24 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 16 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l >>> 8 & 0xFFL);
        this.bbwi.buf[this.bbwi.index++] = (byte)(l & 0xFFL);
    }

    public void write_wchar(char c) {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(c);
        } else {
            this.writeBigEndianWchar(c);
        }
    }

    public void write_short(short s) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s);
        } else {
            this.writeBigEndianShort(s);
        }
    }

    public final void write_ushort(short s) {
        this.write_short(s);
    }

    public void write_long(int n) {
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    public final void write_ulong(int n) {
        this.write_long(n);
    }

    public void write_longlong(long l) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l);
        } else {
            this.writeBigEndianLongLong(l);
        }
    }

    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    public void write_string(String string) {
        if (string == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(string);
        int n = cTBConverter.getNumBytes() + 1;
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + n);
        this.write_long(n);
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.write_octet((byte)0);
        this.handleSpecialChunkEnd();
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw new MARSHAL(1398079705, CompletionStatus.COMPLETED_MAYBE);
        }
        int n = string.length() + 1;
        this.handleSpecialChunkBegin(4 + n * 2 + this.computeAlignment(4));
        this.write_long(n);
        for (int i = 0; i < n - 1; ++i) {
            this.write_wchar(string.charAt(i));
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] byArray, int n, int n2) {
        int n3;
        for (int i = n; i < n2 + n; i += n3) {
            int n4;
            int n5;
            if (this.bbwi.index + 1 > this.bbwi.buflen) {
                this.alignAndReserve(1, 1);
            }
            n3 = (n5 = n2 + n - i) < (n4 = this.bbwi.buf.length - this.bbwi.index) ? n5 : n4;
            System.arraycopy(byArray, i, this.bbwi.buf, this.bbwi.index, n3);
            this.bbwi.index += n3;
        }
    }

    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        this.internalWriteOctetArray(byArray, n, n2);
        this.handleSpecialChunkEnd();
    }

    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this.parent);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl((ORB)this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    public void write_Object(Object object) {
        if (object == null) {
            IOR.NULL.write(this.parent);
            return;
        }
        ObjectImpl objectImpl = (ObjectImpl)object;
        ClientSubcontract clientSubcontract = null;
        try {
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            LogWrap.logger.log(Level.WARNING, "", bAD_OPERATION);
            this.debugPrintThrowable(bAD_OPERATION);
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            LogWrap.logger.log(Level.WARNING, "", bAD_INV_ORDER);
            this.debugPrintThrowable(bAD_INV_ORDER);
        }
        if (clientSubcontract == null) {
            if (object instanceof Stub) {
                try {
                    ((Stub)object).connect((ORB)this.orb);
                }
                catch (RemoteException remoteException) {
                    LogWrap.logger.log(Level.WARNING, "", remoteException);
                    this.debugPrintThrowable(remoteException);
                    throw new MARSHAL("Error connecting servant: " + remoteException.getMessage(), 1398079709, CompletionStatus.COMPLETED_MAYBE);
                }
            } else {
                this.orb.connect(object);
            }
            clientSubcontract = (ClientSubcontract)((java.lang.Object)objectImpl._get_delegate());
        }
        IOR iOR = clientSubcontract.marshal();
        iOR.write(this.parent);
    }

    public void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                LogWrap.logger.log(Level.FINE, "", classCastException);
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<?> clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string2 = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string2);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeIDLValue(serializable, string2);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(string, (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.writeIndirection(-1, this.valueCache.getVal(serializable));
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.start_block();
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<?> clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        } else if (serializable instanceof ValueBase) {
            this.mustChunk = true;
            int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
            String string = ((ValueBase)serializable)._truncatable_ids()[0];
            this.write_repositoryId(string);
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeIDLValue(serializable, string);
            this.end_block();
            this.writeEndTag(true);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, null);
                this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
                this.updateIndirectionTable(n, serializable, serializable);
                --this.end_flag;
                this.write_wstring((String)((java.lang.Object)serializable));
                this.writeEndTag(false);
            }
        } else if (serializable instanceof Class) {
            this.writeClass(this.repIdStrs.getClassDescValueRepId(), (Class)serializable);
        } else {
            Serializable serializable2;
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler(this.orb);
            }
            if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
                this.write_long(0);
                return;
            }
            if (serializable != serializable2) {
                if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                    this.writeIndirection(-1, this.valueCache.getVal(serializable));
                    return;
                }
                clazz = serializable.getClass();
            }
            if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
                this.mustChunk = true;
                int n = this.writeValueTag(true, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                --this.chunkedValueNestingLevel;
                this.start_block();
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.end_block();
                this.writeEndTag(true);
            } else {
                int n = this.writeValueTag(false, false, Util.getCodebase(clazz));
                this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
                this.updateIndirectionTable(n, serializable, serializable2);
                --this.end_flag;
                this.valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this.parent, serializable);
                this.writeEndTag(false);
            }
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        int n;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        if (boxedValueHelper instanceof ValueHelper) {
            try {
                n = ((ValueHelper)boxedValueHelper).get_type().type_modifier();
            }
            catch (BadKind badKind) {
                LogWrap.logger.log(Level.FINE, "", badKind);
                n = 0;
            }
            if (serializable instanceof CustomMarshal && n == 1) {
                bl2 = true;
                this.mustChunk = true;
            }
            if (n == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            n = this.writeValueTag(true, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            if (bl2) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            n = this.writeValueTag(false, false, Util.getCodebase(serializable.getClass()));
            this.write_repositoryId(boxedValueHelper.get_id());
            this.updateIndirectionTable(n, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value(this.parent, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.bbwi.index;
    }

    public void start_block() {
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0 start_block, index" + this.bbwi.index);
        }
        this.write_long(0);
        this.inBlock = true;
        this.blockSizePosition = this.get_offset();
        this.blockSizeIndex = this.bbwi.index;
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0 start_block, blockSizeIndex " + this.blockSizeIndex);
        }
    }

    protected void writeLongWithoutAlign(int n) {
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    public void end_block() {
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0.java end_block");
        }
        if (!this.inBlock) {
            return;
        }
        if (this.debug) {
            this.debugPrintMessage("CDROutputStream_1_0.java end_block, in a block");
        }
        this.inBlock = false;
        if (this.get_offset() == this.blockSizePosition) {
            this.bbwi.index -= 4;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            return;
        }
        int n = this.bbwi.index;
        this.bbwi.index = this.blockSizeIndex - 4;
        this.writeLongWithoutAlign(n - this.blockSizeIndex);
        this.bbwi.index = n;
        this.blockSizeIndex = -1;
        this.blockSizePosition = -1;
    }

    public ORB orb() {
        return this.orb;
    }

    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        for (int i = 0; i < n2; ++i) {
            this.write_boolean(blArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        for (int i = 0; i < n2; ++i) {
            this.write_char(cArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n2 * 2);
        for (int i = 0; i < n2; ++i) {
            this.write_wchar(cArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n2 * 2);
        for (int i = 0; i < n2; ++i) {
            this.write_short(sArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    public final void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n2 * 4);
        for (int i = 0; i < n2; ++i) {
            this.write_long(nArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n2 * 8);
        for (int i = 0; i < n2; ++i) {
            this.write_longlong(lArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    public final void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n2 * 4);
        for (int i = 0; i < n2; ++i) {
            this.write_float(fArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public final void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n2 * 8);
        for (int i = 0; i < n2; ++i) {
            this.write_double(dArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_string(stringArray[n + i]);
        }
    }

    public void write_wstring_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM(1398079689, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_wstring(stringArray[n + i]);
        }
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[n + i]);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bbwi.buf, 0, this.bbwi.index);
    }

    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        outputStream.write_long(this.bbwi.index);
        outputStream.write_octet_array(this.bbwi.buf, 0, this.bbwi.index);
    }

    public final int getSize() {
        return this.bbwi.index;
    }

    public int getIndex() {
        return this.bbwi.index;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public void setIndex(int n) {
        this.bbwi.index = n;
    }

    public ByteBufferWithInfo getByteBufferWithInfo() {
        return this.bbwi;
    }

    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    public byte[] getByteBuffer() {
        return this.bbwi.buf;
    }

    public void setByteBuffer(byte[] byArray) {
        this.bbwi.buf = byArray;
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(true);
        }
        this.valueCache.put(object, n);
        if (object2 != object) {
            this.valueCache.put(object2, n);
        }
    }

    private final void write_repositoryId(String string) {
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.writeIndirection(-1, this.repositoryIdCache.getVal(string));
            return;
        }
        this.write_string(string);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.writeIndirection(-1, this.codebaseCache.getVal(string));
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(true);
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, String string) {
        int n = 0;
        if (bl && bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
            n = this.get_offset() - 4;
        } else {
            this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
            n = this.get_offset() - 4;
            this.write_codebase(string, this.get_offset());
        }
        return n;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this.parent);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl = false;
            if (boxedValueHelper instanceof ValueHelper && serializable instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)boxedValueHelper).get_type().type_modifier() == 1) {
                        bl = true;
                    }
                }
                catch (BadKind badKind) {
                    LogWrap.logger.log(Level.WARNING, "", badKind);
                    this.debugPrintThrowable(badKind);
                    throw new MARSHAL();
                }
            }
            if (bl) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.get_offset() == this.end_flag_position && this.bbwi.index == this.end_flag_index) {
                this.bbwi.index -= 4;
            }
            this.writeNestingLevel();
            this.end_flag_index = this.bbwi.index;
            this.end_flag_position = this.get_offset();
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(this.repIdStrs.getClassDescValueRepId());
            }
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.writeClassBody(clazz);
            this.end_block();
            this.writeEndTag(true);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.write_repositoryId(string);
            } else {
                this.write_repositoryId(this.repIdStrs.getClassDescValueRepId());
            }
            --this.end_flag;
            this.writeClassBody(clazz);
            this.writeEndTag(false);
        }
    }

    private void writeClassBody(Class clazz) {
        if (this.orb == null || ORBVersionImpl.FOREIGN.equals(this.orb.getORBVersion()) || ORBVersionImpl.NEWER.compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase((Class)clazz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase((Class)clazz)));
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = this.repIdStrs.createForJavaType(iDLEntity);
        Class<?> clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, string2);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz2.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogWrap.logger.log(Level.FINE, "", classNotFoundException);
            this.debugPrintThrowable(classNotFoundException);
            throw new MARSHAL(classNotFoundException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LogWrap.logger.log(Level.WARNING, "", noSuchMethodException);
            this.debugPrintThrowable(noSuchMethodException);
            throw new MARSHAL(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            LogWrap.logger.log(Level.WARNING, "", illegalAccessException);
            this.debugPrintThrowable(illegalAccessException);
            throw new MARSHAL(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            LogWrap.logger.log(Level.WARNING, "", invocationTargetException);
            this.debugPrintThrowable(invocationTargetException);
            throw new MARSHAL(invocationTargetException.getMessage());
        }
        this.end_block();
        this.writeEndTag(true);
    }

    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string;
        String string2;
        int n;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        byte by = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            byte by2 = (byte)Character.digit(c, 10);
            if (by2 == -1) {
                this.debugPrintMessage("Digit is -1, throwing MARSHAL");
                throw new MARSHAL();
            }
            if (n4 % 2 == 0) {
                by = (byte)(by | by2);
                this.write_octet(by);
                by = 0;
            } else {
                by = (byte)(by | by2 << 4);
            }
            --n4;
        }
        by = n == -1 ? (byte)((byte)(by | 0xD)) : (byte)((byte)(by | 0xC));
        this.write_octet(by);
    }

    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    public void printBuffer() {
        CDROutputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("+++++++ Output Buffer ++++++++");
        System.out.println();
        System.out.println("Current index: " + byteBufferWithInfo.index);
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        char[] cArray = new char[16];
        try {
            for (int i = 0; i < byteBufferWithInfo.index; i += 16) {
                int n;
                int n2;
                for (n2 = 0; n2 < 16 && n2 + i < byteBufferWithInfo.index; ++n2) {
                    String string;
                    n = byteBufferWithInfo.buf[i + n2];
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((string = Integer.toHexString(n)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n2 < 16) {
                    System.out.print("   ");
                    ++n2;
                }
                for (n = 0; n < 16 && n + i < byteBufferWithInfo.index; ++n) {
                    cArray[n] = Character.isLetterOrDigit((char)byteBufferWithInfo.buf[i + n]) ? (int)byteBufferWithInfo.buf[i + n] : 46;
                }
                System.out.println(new String(cArray, 0, n));
            }
        }
        catch (Throwable throwable) {
            LogWrap.logger.log(Level.WARNING, "", throwable);
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    public void writeIndirection(int n, int n2) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(n);
        this.write_long(n2 - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    protected void debugPrintThrowable(Throwable throwable) {
        if (this.debug && throwable != null) {
            throwable.printStackTrace();
        }
    }

    protected void debugPrintMessage(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    void alignOnBoundary(int n) {
        this.alignAndReserve(n, 0);
    }
}

