/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.corba.INSSubcontract;
import com.sun.corba.ee.internal.core.ClientSubcontract;
import com.sun.corba.ee.internal.core.INSObjectKeyEntry;
import com.sun.corba.ee.internal.core.INSObjectKeyMap;
import com.sun.corba.ee.internal.core.ServerSubcontract;
import com.sun.corba.ee.internal.ior.IIOPProfileTemplate;
import com.sun.corba.ee.internal.ior.IORTemplate;
import com.sun.corba.ee.internal.ior.ObjectKey;
import com.sun.corba.ee.internal.ior.ObjectKeyTemplate;
import com.sun.corba.ee.internal.ior.WireObjectKeyTemplate;
import java.util.Iterator;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;

public class SubcontractRegistry {
    protected ORB orb;
    protected int size;
    protected ServerSubcontract[] serverRegistry;
    protected Class[] clientFactory;
    protected int defaultId;
    private INSSubcontract insSubcontract = null;
    protected ServerSubcontract bootstrapServer = null;

    public void dumpServers() {
        System.out.println("Dump of registered server subcontracts:");
        for (int i = 0; i < this.serverRegistry.length; ++i) {
            ServerSubcontract serverSubcontract = this.serverRegistry[i];
            if (serverSubcontract == null) continue;
            System.out.println("serverRegistry[" + i + "] = " + serverSubcontract);
        }
    }

    public SubcontractRegistry(ORB oRB, int n) {
        this(oRB, n, 256);
    }

    public SubcontractRegistry(ORB oRB, int n, int n2) {
        this.orb = oRB;
        this.size = n2;
        this.defaultId = n;
        this.serverRegistry = new ServerSubcontract[n2];
        this.clientFactory = new Class[n2];
    }

    public synchronized boolean registerClient(Class clazz, int n) {
        if (n < this.size) {
            this.clientFactory[n] = clazz;
            return true;
        }
        return false;
    }

    public synchronized boolean registerServer(ServerSubcontract serverSubcontract, int n) {
        if (n < this.size) {
            this.serverRegistry[n] = serverSubcontract;
            return true;
        }
        return false;
    }

    public void registerBootstrapServer(ServerSubcontract serverSubcontract) {
        this.bootstrapServer = serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(int n) {
        ServerSubcontract serverSubcontract = null;
        if (n >= 0 && n < this.size) {
            serverSubcontract = this.serverRegistry[n];
        }
        if (serverSubcontract == null) {
            return this.serverRegistry[this.defaultId];
        }
        return serverSubcontract;
    }

    public ServerSubcontract getServerSubcontract(ObjectKey objectKey) {
        ObjectKeyTemplate objectKeyTemplate = objectKey.getTemplate();
        if (objectKeyTemplate instanceof WireObjectKeyTemplate) {
            String string = new String(objectKey.getBytes(this.orb));
            if (string.equals("INIT") || string.equals("TINI")) {
                return this.bootstrapServer;
            }
            INSObjectKeyEntry iNSObjectKeyEntry = INSObjectKeyMap.getInstance().getEntry(string);
            if (iNSObjectKeyEntry != null) {
                return this.getINSSubcontract();
            }
        } else {
            int n = objectKeyTemplate.getSubcontractId();
            return this.getServerSubcontract(n);
        }
        throw new INTERNAL(1398079690, CompletionStatus.COMPLETED_NO);
    }

    private synchronized INSSubcontract getINSSubcontract() {
        if (this.insSubcontract == null) {
            this.insSubcontract = new INSSubcontract(this.orb);
        }
        return this.insSubcontract;
    }

    public ClientSubcontract getClientSubcontract(ObjectKey objectKey) {
        return this.getClientSubcontract(objectKey.getTemplate());
    }

    public ClientSubcontract getClientSubcontract(IORTemplate iORTemplate) {
        if (iORTemplate.size() != 1) {
            throw new INTERNAL(1398079691, CompletionStatus.COMPLETED_NO);
        }
        Iterator iterator = iORTemplate.iteratorById(0);
        Object e = iterator.next();
        if (!(e instanceof IIOPProfileTemplate)) {
            throw new INTERNAL(1398079693, CompletionStatus.COMPLETED_NO);
        }
        IIOPProfileTemplate iIOPProfileTemplate = (IIOPProfileTemplate)e;
        return this.getClientSubcontract(iIOPProfileTemplate.getObjectKeyTemplate());
    }

    public ClientSubcontract getClientSubcontract(ObjectKeyTemplate objectKeyTemplate) {
        int n = objectKeyTemplate.getSubcontractId();
        return this.getClientSubcontract(n);
    }

    public ClientSubcontract getClientSubcontract(int n) {
        Class clazz = null;
        ClientSubcontract clientSubcontract = null;
        if (n >= 0 && n < this.size) {
            clazz = this.clientFactory[n];
        }
        if (clazz == null) {
            n = this.defaultId;
            clazz = this.clientFactory[n];
        }
        try {
            clientSubcontract = (ClientSubcontract)clazz.newInstance();
        }
        catch (Exception exception) {
            LogWrap.logger.log(Level.WARNING, "", exception);
            throw new INTERNAL(1398079692, CompletionStatus.COMPLETED_NO);
        }
        clientSubcontract.setId(n);
        return clientSubcontract;
    }
}

