/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.core.DuplicateServiceContext;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.NoSuchServiceContext;
import com.sun.corba.ee.internal.core.ServiceContext;
import com.sun.corba.ee.internal.core.ServiceContextData;
import com.sun.corba.ee.internal.core.ServiceContextEnumeration;
import com.sun.corba.ee.internal.core.ServiceContextRegistry;
import com.sun.corba.ee.internal.core.UnknownServiceContext;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.corba.se.internal.util.Utility;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Vector scList;
    private int numValid;
    private boolean addAlignmentOnWrite;

    private static boolean isDebugging(OutputStream outputStream) {
        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
        ORB oRB = (ORB)cDROutputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream inputStream) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        ORB oRB = (ORB)cDRInputStream.orb();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            ORBUtility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }

    public ServiceContexts(InputStream inputStream, GIOPVersion gIOPVersion) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        this.orb = (ORB)cDRInputStream.orb();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        this.numValid = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + this.numValid);
        }
        this.scList = new Vector(this.numValid);
        this.addAlignmentOnWrite = false;
        for (int i = 0; i < this.numValid; ++i) {
            int n = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Read service context id " + n);
            }
            ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n);
            ServiceContext serviceContext = null;
            if (serviceContextData == null) {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint("Could not find ServiceContextData: using UnknownServiceContext");
                }
                serviceContext = new UnknownServiceContext(n, inputStream);
            } else {
                if (this.orb.serviceContextDebugFlag) {
                    this.dprint("Found " + serviceContextData);
                }
                try {
                    serviceContext = serviceContextData.makeServiceContext(inputStream, gIOPVersion);
                }
                catch (NoSuchServiceContext noSuchServiceContext) {
                    throw new INTERNAL();
                }
            }
            this.scList.addElement(serviceContext);
        }
    }

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.numValid = 0;
        this.scList = new Vector();
        this.addAlignmentOnWrite = false;
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void write(OutputStream outputStream, GIOPVersion gIOPVersion) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n = this.numValid;
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n + " components");
        }
        outputStream.write_long(n);
        Enumeration enumeration = this.scList.elements();
        while (enumeration.hasMoreElements()) {
            ServiceContext serviceContext = (ServiceContext)enumeration.nextElement();
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream, gIOPVersion);
        }
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    public void put(ServiceContext serviceContext) throws DuplicateServiceContext {
        int n = this.findServiceContextIndex(serviceContext.getId());
        if (n >= 0) {
            throw new DuplicateServiceContext();
        }
        n = this.findFirstNullIndex();
        if (n < 0) {
            this.scList.addElement(serviceContext);
        } else {
            this.scList.setElementAt(serviceContext, n);
        }
        ++this.numValid;
    }

    public void delete(int n) throws NoSuchServiceContext {
        int n2 = this.findServiceContextIndex(n);
        if (n2 < 0) {
            throw new NoSuchServiceContext();
        }
        this.scList.setElementAt(null, n2);
        --this.numValid;
    }

    public ServiceContext get(int n) {
        int n2 = this.findServiceContextIndex(n);
        if (n2 < 0) {
            return null;
        }
        return (ServiceContext)this.scList.elementAt(n2);
    }

    public Enumeration list() {
        return new ServiceContextEnumeration(this.scList);
    }

    private int findFirstNullIndex() {
        for (int i = 0; i < this.scList.size(); ++i) {
            if (this.scList.elementAt(i) != null) continue;
            return i;
        }
        return -1;
    }

    private int findServiceContextIndex(int n) {
        for (int i = 0; i < this.scList.size(); ++i) {
            ServiceContext serviceContext;
            Object e = this.scList.elementAt(i);
            if (e == null || (serviceContext = (ServiceContext)e).getId() != n) continue;
            return i;
        }
        return -1;
    }
}

