/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.core.GIOPVersion;
import com.sun.corba.ee.internal.core.NoSuchServiceContext;
import com.sun.corba.ee.internal.core.ServiceContext;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import org.omg.CORBA_2_3.portable.InputStream;

public class ServiceContextData {
    private Class scClass;
    private Constructor scConstructor;
    private int scId;

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public ServiceContextData(Class clazz) throws NoSuchServiceContext {
        if (ORB.ORBInitDebug) {
            this.dprint("ServiceContextData constructor called for class " + clazz);
        }
        this.scClass = clazz;
        try {
            int n;
            Field field;
            if (ORB.ORBInitDebug) {
                this.dprint("Finding constructor for " + clazz);
            }
            Class[] classArray = new Class[]{InputStream.class, GIOPVersion.class};
            try {
                this.scConstructor = clazz.getConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LogWrap.logger.log(Level.WARNING, "", noSuchMethodException);
                throw new NoSuchServiceContext("Class does not have an InputStream constructor");
            }
            if (ORB.ORBInitDebug) {
                this.dprint("Finding SERVICE_CONTEXT_ID field in " + clazz);
            }
            try {
                field = clazz.getField("SERVICE_CONTEXT_ID");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LogWrap.logger.log(Level.WARNING, "", noSuchFieldException);
                throw new NoSuchServiceContext("Class does not have a SERVICE_CONTEXT_ID member");
            }
            catch (SecurityException securityException) {
                LogWrap.logger.log(Level.WARNING, "", securityException);
                throw new NoSuchServiceContext("Could not access SERVICE_CONTEXT_ID member");
            }
            if (ORB.ORBInitDebug) {
                this.dprint("Checking modifiers of SERVICE_CONTEXT_ID field in " + clazz);
            }
            if (!(Modifier.isPublic(n = field.getModifiers()) && Modifier.isStatic(n) && Modifier.isFinal(n))) {
                throw new NoSuchServiceContext("SERVICE_CONTEXT_ID field is not public static final");
            }
            if (ORB.ORBInitDebug) {
                this.dprint("Getting value of SERVICE_CONTEXT_ID in " + clazz);
            }
            try {
                this.scId = field.getInt(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogWrap.logger.log(Level.WARNING, "", illegalArgumentException);
                throw new NoSuchServiceContext("SERVICE_CONTEXT_ID not convertible to int");
            }
            catch (IllegalAccessException illegalAccessException) {
                LogWrap.logger.log(Level.WARNING, "", illegalAccessException);
                throw new NoSuchServiceContext("Could not access value of SERVICE_CONTEXT_ID");
            }
        }
        catch (NoSuchServiceContext noSuchServiceContext) {
            if (ORB.ORBInitDebug) {
                this.dprint("Exception in ServiceContextData constructor: " + noSuchServiceContext);
            }
            throw noSuchServiceContext;
        }
        catch (Throwable throwable) {
            if (ORB.ORBInitDebug) {
                this.dprint("Unexpected Exception in ServiceContextData constructor: " + throwable);
            }
            LogWrap.logger.log(Level.WARNING, "", throwable);
        }
        if (ORB.ORBInitDebug) {
            this.dprint("ServiceContextData constructor completed");
        }
    }

    public ServiceContext makeServiceContext(InputStream inputStream, GIOPVersion gIOPVersion) throws NoSuchServiceContext {
        Object[] objectArray = new Object[]{inputStream, gIOPVersion};
        ServiceContext serviceContext = null;
        try {
            serviceContext = (ServiceContext)this.scConstructor.newInstance(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogWrap.logger.log(Level.WARNING, "", illegalArgumentException);
            throw new NoSuchServiceContext("InputStream constructor argument error");
        }
        catch (IllegalAccessException illegalAccessException) {
            LogWrap.logger.log(Level.WARNING, "", illegalAccessException);
            throw new NoSuchServiceContext("InputStream constructor argument error");
        }
        catch (InstantiationException instantiationException) {
            LogWrap.logger.log(Level.WARNING, "", instantiationException);
            throw new NoSuchServiceContext("InputStream constructor called for abstract class");
        }
        catch (InvocationTargetException invocationTargetException) {
            LogWrap.logger.log(Level.WARNING, "", invocationTargetException);
            throw new NoSuchServiceContext("InputStream constructor threw exception " + invocationTargetException.getTargetException());
        }
        return serviceContext;
    }

    int getId() {
        return this.scId;
    }

    public String toString() {
        return "ServiceContextData[ scClass=" + this.scClass + " scConstructor=" + this.scConstructor + " scId=" + this.scId + " ]";
    }
}

