/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.sun.corba.ee.internal.core.MarshalInputStream;
import com.sun.corba.ee.internal.core.MarshalOutputStream;
import com.sun.corba.ee.internal.core.OSFCodeSetRegistry;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import org.omg.CORBA.INITIALIZE;

public final class CodeSetComponentInfo {
    private CodeSetComponent forCharData;
    private CodeSetComponent forWCharData;
    public static final CodeSetComponentInfo JAVASOFT_DEFAULT_CODESETS;
    public static final CodeSetContext LOCAL_CODE_SETS;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CodeSetComponentInfo: ");
        stringBuffer.append("char data ");
        stringBuffer.append(this.forCharData.toString());
        stringBuffer.append("wchar data ");
        stringBuffer.append(this.forWCharData.toString());
        return stringBuffer.toString();
    }

    public CodeSetComponentInfo() {
        this.forCharData = CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.forCharData;
        this.forWCharData = CodeSetComponentInfo.JAVASOFT_DEFAULT_CODESETS.forWCharData;
    }

    public CodeSetComponentInfo(CodeSetComponent codeSetComponent, CodeSetComponent codeSetComponent2) {
        this.forCharData = codeSetComponent;
        this.forWCharData = codeSetComponent2;
    }

    public void read(MarshalInputStream marshalInputStream) {
        this.forCharData = new CodeSetComponent();
        this.forCharData.read(marshalInputStream);
        this.forWCharData = new CodeSetComponent();
        this.forWCharData.read(marshalInputStream);
    }

    public void write(MarshalOutputStream marshalOutputStream) {
        this.forCharData.write(marshalOutputStream);
        this.forWCharData.write(marshalOutputStream);
    }

    public CodeSetComponent getCharComponent() {
        return this.forCharData;
    }

    public CodeSetComponent getWCharComponent() {
        return this.forWCharData;
    }

    public static CodeSetComponent createFromString(String string) {
        if (string == null || string.length() == 0) {
            throw new INITIALIZE("Empty or null code set String");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        Vector<Integer> vector = new Vector<Integer>(8);
        int n = 0;
        int[] nArray = null;
        try {
            String string2 = (String)stringTokenizer.nextElement();
            n = string2.startsWith("0x") || string2.startsWith("0X") ? Integer.parseInt(string2.substring(2), 16) : Integer.parseInt(string2);
            if (OSFCodeSetRegistry.lookupEntry(n) == null) {
                throw new INITIALIZE("Unknown native code set: " + n);
            }
            while (stringTokenizer.hasMoreElements()) {
                vector.add(Integer.valueOf((String)stringTokenizer.nextElement()));
            }
            nArray = new int[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                nArray[i] = (Integer)vector.elementAt(i);
                if (OSFCodeSetRegistry.lookupEntry(nArray[i]) != null) continue;
                throw new INITIALIZE("Unknown conversion code set: " + nArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LogWrap.logger.log(Level.WARNING, "", numberFormatException);
            throw new INITIALIZE("Invalid code set number: " + numberFormatException.getMessage());
        }
        if (n == 0) {
            throw new INITIALIZE("Invalid code set String " + string + ": Requires at least a native code set");
        }
        return new CodeSetComponent(n, nArray);
    }

    static {
        CodeSetComponent codeSetComponent = new CodeSetComponent(OSFCodeSetRegistry.ISO_8859_1.getNumber(), new int[]{OSFCodeSetRegistry.UTF_8.getNumber(), OSFCodeSetRegistry.ISO_646.getNumber()});
        CodeSetComponent codeSetComponent2 = new CodeSetComponent(OSFCodeSetRegistry.UTF_16.getNumber(), new int[]{OSFCodeSetRegistry.UCS_2.getNumber()});
        JAVASOFT_DEFAULT_CODESETS = new CodeSetComponentInfo(codeSetComponent, codeSetComponent2);
        LOCAL_CODE_SETS = new CodeSetContext(OSFCodeSetRegistry.ISO_8859_1.getNumber(), OSFCodeSetRegistry.UTF_16.getNumber());
    }

    public static final class CodeSetContext {
        private int char_data;
        private int wchar_data;

        public CodeSetContext() {
        }

        public CodeSetContext(int n, int n2) {
            this.char_data = n;
            this.wchar_data = n2;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.char_data = marshalInputStream.read_ulong();
            this.wchar_data = marshalInputStream.read_ulong();
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.char_data);
            marshalOutputStream.write_ulong(this.wchar_data);
        }

        public int getCharCodeSet() {
            return this.char_data;
        }

        public int getWCharCodeSet() {
            return this.wchar_data;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CodeSetContext char set: ");
            stringBuffer.append(Integer.toHexString(this.char_data));
            stringBuffer.append(" wchar set: ");
            stringBuffer.append(Integer.toHexString(this.wchar_data));
            return stringBuffer.toString();
        }
    }

    public static final class CodeSetComponent {
        int nativeCodeSet;
        int[] conversionCodeSets;

        public CodeSetComponent() {
        }

        public CodeSetComponent(int n, int[] nArray) {
            this.nativeCodeSet = n;
            this.conversionCodeSets = nArray == null ? new int[0] : nArray;
        }

        public void read(MarshalInputStream marshalInputStream) {
            this.nativeCodeSet = marshalInputStream.read_ulong();
            int n = marshalInputStream.read_long();
            this.conversionCodeSets = new int[n];
            marshalInputStream.read_ulong_array(this.conversionCodeSets, 0, n);
        }

        public void write(MarshalOutputStream marshalOutputStream) {
            marshalOutputStream.write_ulong(this.nativeCodeSet);
            marshalOutputStream.write_long(this.conversionCodeSets.length);
            marshalOutputStream.write_ulong_array(this.conversionCodeSets, 0, this.conversionCodeSets.length);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CodeSetComponent: ");
            stringBuffer.append("native: ");
            stringBuffer.append(Integer.toHexString(this.nativeCodeSet));
            stringBuffer.append(" conversion: ");
            if (this.conversionCodeSets == null) {
                stringBuffer.append("null");
            } else {
                for (int i = 0; i < this.conversionCodeSets.length; ++i) {
                    stringBuffer.append(Integer.toHexString(this.conversionCodeSets[i]));
                }
            }
            return stringBuffer.toString();
        }
    }
}

